/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SoftwareUpdateStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    SUCCEEDED("Succeeded"),
    FAILED("Failed"),
    ROLLBACK_IN_PROGRESS("RollbackInProgress"),
    ROLLBACK_COMPLETE("RollbackComplete"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SoftwareUpdateStatus> VALUE_MAP;
    private final String value;

    private SoftwareUpdateStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SoftwareUpdateStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SoftwareUpdateStatus> knownValues() {
        EnumSet<SoftwareUpdateStatus> knownValues = EnumSet.allOf(SoftwareUpdateStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SoftwareUpdateStatus.class, SoftwareUpdateStatus::toString);
    }
}

