/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AssignedGroupPatternsListCopier;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppAdminUserListCopier;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppArgumentsCopier;
import software.amazon.awssdk.services.sagemaker.model.RoleGroupAssignment;
import software.amazon.awssdk.services.sagemaker.model.RoleGroupAssignmentsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartnerAppConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartnerAppConfig> {
    private static final SdkField<List<String>> ADMIN_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdminUsers").getter(PartnerAppConfig.getter(PartnerAppConfig::adminUsers)).setter(PartnerAppConfig.setter(Builder::adminUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Arguments").getter(PartnerAppConfig.getter(PartnerAppConfig::arguments)).setter(PartnerAppConfig.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSIGNED_GROUP_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssignedGroupPatterns").getter(PartnerAppConfig.getter(PartnerAppConfig::assignedGroupPatterns)).setter(PartnerAppConfig.setter(Builder::assignedGroupPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedGroupPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RoleGroupAssignment>> ROLE_GROUP_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoleGroupAssignments").getter(PartnerAppConfig.getter(PartnerAppConfig::roleGroupAssignments)).setter(PartnerAppConfig.setter(Builder::roleGroupAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleGroupAssignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoleGroupAssignment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USERS_FIELD, ARGUMENTS_FIELD, ASSIGNED_GROUP_PATTERNS_FIELD, ROLE_GROUP_ASSIGNMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PartnerAppConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> adminUsers;
    private final Map<String, String> arguments;
    private final List<String> assignedGroupPatterns;
    private final List<RoleGroupAssignment> roleGroupAssignments;

    private PartnerAppConfig(BuilderImpl builder) {
        this.adminUsers = builder.adminUsers;
        this.arguments = builder.arguments;
        this.assignedGroupPatterns = builder.assignedGroupPatterns;
        this.roleGroupAssignments = builder.roleGroupAssignments;
    }

    public final boolean hasAdminUsers() {
        return this.adminUsers != null && !(this.adminUsers instanceof SdkAutoConstructList);
    }

    public final List<String> adminUsers() {
        return this.adminUsers;
    }

    public final boolean hasArguments() {
        return this.arguments != null && !(this.arguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> arguments() {
        return this.arguments;
    }

    public final boolean hasAssignedGroupPatterns() {
        return this.assignedGroupPatterns != null && !(this.assignedGroupPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> assignedGroupPatterns() {
        return this.assignedGroupPatterns;
    }

    public final boolean hasRoleGroupAssignments() {
        return this.roleGroupAssignments != null && !(this.roleGroupAssignments instanceof SdkAutoConstructList);
    }

    public final List<RoleGroupAssignment> roleGroupAssignments() {
        return this.roleGroupAssignments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdminUsers() ? this.adminUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArguments() ? this.arguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssignedGroupPatterns() ? this.assignedGroupPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleGroupAssignments() ? this.roleGroupAssignments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerAppConfig)) {
            return false;
        }
        PartnerAppConfig other = (PartnerAppConfig)obj;
        return this.hasAdminUsers() == other.hasAdminUsers() && Objects.equals(this.adminUsers(), other.adminUsers()) && this.hasArguments() == other.hasArguments() && Objects.equals(this.arguments(), other.arguments()) && this.hasAssignedGroupPatterns() == other.hasAssignedGroupPatterns() && Objects.equals(this.assignedGroupPatterns(), other.assignedGroupPatterns()) && this.hasRoleGroupAssignments() == other.hasRoleGroupAssignments() && Objects.equals(this.roleGroupAssignments(), other.roleGroupAssignments());
    }

    public final String toString() {
        return ToString.builder((String)"PartnerAppConfig").add("AdminUsers", this.hasAdminUsers() ? this.adminUsers() : null).add("Arguments", this.hasArguments() ? this.arguments() : null).add("AssignedGroupPatterns", this.hasAssignedGroupPatterns() ? this.assignedGroupPatterns() : null).add("RoleGroupAssignments", this.hasRoleGroupAssignments() ? this.roleGroupAssignments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminUsers": {
                return Optional.ofNullable(clazz.cast(this.adminUsers()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
            case "AssignedGroupPatterns": {
                return Optional.ofNullable(clazz.cast(this.assignedGroupPatterns()));
            }
            case "RoleGroupAssignments": {
                return Optional.ofNullable(clazz.cast(this.roleGroupAssignments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AdminUsers", ADMIN_USERS_FIELD);
        map.put("Arguments", ARGUMENTS_FIELD);
        map.put("AssignedGroupPatterns", ASSIGNED_GROUP_PATTERNS_FIELD);
        map.put("RoleGroupAssignments", ROLE_GROUP_ASSIGNMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartnerAppConfig, T> g) {
        return obj -> g.apply((PartnerAppConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> adminUsers = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();
        private List<String> assignedGroupPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<RoleGroupAssignment> roleGroupAssignments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerAppConfig model) {
            this.adminUsers(model.adminUsers);
            this.arguments(model.arguments);
            this.assignedGroupPatterns(model.assignedGroupPatterns);
            this.roleGroupAssignments(model.roleGroupAssignments);
        }

        public final Collection<String> getAdminUsers() {
            if (this.adminUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adminUsers;
        }

        public final void setAdminUsers(Collection<String> adminUsers) {
            this.adminUsers = PartnerAppAdminUserListCopier.copy(adminUsers);
        }

        @Override
        public final Builder adminUsers(Collection<String> adminUsers) {
            this.adminUsers = PartnerAppAdminUserListCopier.copy(adminUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminUsers(String ... adminUsers) {
            this.adminUsers(Arrays.asList(adminUsers));
            return this;
        }

        public final Map<String, String> getArguments() {
            if (this.arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = PartnerAppArgumentsCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = PartnerAppArgumentsCopier.copy(arguments);
            return this;
        }

        public final Collection<String> getAssignedGroupPatterns() {
            if (this.assignedGroupPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assignedGroupPatterns;
        }

        public final void setAssignedGroupPatterns(Collection<String> assignedGroupPatterns) {
            this.assignedGroupPatterns = AssignedGroupPatternsListCopier.copy(assignedGroupPatterns);
        }

        @Override
        public final Builder assignedGroupPatterns(Collection<String> assignedGroupPatterns) {
            this.assignedGroupPatterns = AssignedGroupPatternsListCopier.copy(assignedGroupPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedGroupPatterns(String ... assignedGroupPatterns) {
            this.assignedGroupPatterns(Arrays.asList(assignedGroupPatterns));
            return this;
        }

        public final List<RoleGroupAssignment.Builder> getRoleGroupAssignments() {
            List<RoleGroupAssignment.Builder> result = RoleGroupAssignmentsListCopier.copyToBuilder(this.roleGroupAssignments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoleGroupAssignments(Collection<RoleGroupAssignment.BuilderImpl> roleGroupAssignments) {
            this.roleGroupAssignments = RoleGroupAssignmentsListCopier.copyFromBuilder(roleGroupAssignments);
        }

        @Override
        public final Builder roleGroupAssignments(Collection<RoleGroupAssignment> roleGroupAssignments) {
            this.roleGroupAssignments = RoleGroupAssignmentsListCopier.copy(roleGroupAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleGroupAssignments(RoleGroupAssignment ... roleGroupAssignments) {
            this.roleGroupAssignments(Arrays.asList(roleGroupAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleGroupAssignments(Consumer<RoleGroupAssignment.Builder> ... roleGroupAssignments) {
            this.roleGroupAssignments(Stream.of(roleGroupAssignments).map(c -> (RoleGroupAssignment)((RoleGroupAssignment.Builder)RoleGroupAssignment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PartnerAppConfig build() {
            return new PartnerAppConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartnerAppConfig> {
        public Builder adminUsers(Collection<String> var1);

        public Builder adminUsers(String ... var1);

        public Builder arguments(Map<String, String> var1);

        public Builder assignedGroupPatterns(Collection<String> var1);

        public Builder assignedGroupPatterns(String ... var1);

        public Builder roleGroupAssignments(Collection<RoleGroupAssignment> var1);

        public Builder roleGroupAssignments(RoleGroupAssignment ... var1);

        public Builder roleGroupAssignments(Consumer<RoleGroupAssignment.Builder> ... var1);
    }
}

