/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelSpeculativeDecodingTechnique;
import software.amazon.awssdk.services.sagemaker.model.ModelSpeculativeDecodingTrainingDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelSpeculativeDecodingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelSpeculativeDecodingConfig> {
    private static final SdkField<String> TECHNIQUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Technique").getter(ModelSpeculativeDecodingConfig.getter(ModelSpeculativeDecodingConfig::techniqueAsString)).setter(ModelSpeculativeDecodingConfig.setter(Builder::technique)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Technique").build()}).build();
    private static final SdkField<ModelSpeculativeDecodingTrainingDataSource> TRAINING_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingDataSource").getter(ModelSpeculativeDecodingConfig.getter(ModelSpeculativeDecodingConfig::trainingDataSource)).setter(ModelSpeculativeDecodingConfig.setter(Builder::trainingDataSource)).constructor(ModelSpeculativeDecodingTrainingDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TECHNIQUE_FIELD, TRAINING_DATA_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelSpeculativeDecodingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String technique;
    private final ModelSpeculativeDecodingTrainingDataSource trainingDataSource;

    private ModelSpeculativeDecodingConfig(BuilderImpl builder) {
        this.technique = builder.technique;
        this.trainingDataSource = builder.trainingDataSource;
    }

    public final ModelSpeculativeDecodingTechnique technique() {
        return ModelSpeculativeDecodingTechnique.fromValue(this.technique);
    }

    public final String techniqueAsString() {
        return this.technique;
    }

    public final ModelSpeculativeDecodingTrainingDataSource trainingDataSource() {
        return this.trainingDataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.techniqueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelSpeculativeDecodingConfig)) {
            return false;
        }
        ModelSpeculativeDecodingConfig other = (ModelSpeculativeDecodingConfig)obj;
        return Objects.equals(this.techniqueAsString(), other.techniqueAsString()) && Objects.equals(this.trainingDataSource(), other.trainingDataSource());
    }

    public final String toString() {
        return ToString.builder((String)"ModelSpeculativeDecodingConfig").add("Technique", (Object)this.techniqueAsString()).add("TrainingDataSource", (Object)this.trainingDataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Technique": {
                return Optional.ofNullable(clazz.cast(this.techniqueAsString()));
            }
            case "TrainingDataSource": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Technique", TECHNIQUE_FIELD);
        map.put("TrainingDataSource", TRAINING_DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelSpeculativeDecodingConfig, T> g) {
        return obj -> g.apply((ModelSpeculativeDecodingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String technique;
        private ModelSpeculativeDecodingTrainingDataSource trainingDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelSpeculativeDecodingConfig model) {
            this.technique(model.technique);
            this.trainingDataSource(model.trainingDataSource);
        }

        public final String getTechnique() {
            return this.technique;
        }

        public final void setTechnique(String technique) {
            this.technique = technique;
        }

        @Override
        public final Builder technique(String technique) {
            this.technique = technique;
            return this;
        }

        @Override
        public final Builder technique(ModelSpeculativeDecodingTechnique technique) {
            this.technique(technique == null ? null : technique.toString());
            return this;
        }

        public final ModelSpeculativeDecodingTrainingDataSource.Builder getTrainingDataSource() {
            return this.trainingDataSource != null ? this.trainingDataSource.toBuilder() : null;
        }

        public final void setTrainingDataSource(ModelSpeculativeDecodingTrainingDataSource.BuilderImpl trainingDataSource) {
            this.trainingDataSource = trainingDataSource != null ? trainingDataSource.build() : null;
        }

        @Override
        public final Builder trainingDataSource(ModelSpeculativeDecodingTrainingDataSource trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        public ModelSpeculativeDecodingConfig build() {
            return new ModelSpeculativeDecodingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelSpeculativeDecodingConfig> {
        public Builder technique(String var1);

        public Builder technique(ModelSpeculativeDecodingTechnique var1);

        public Builder trainingDataSource(ModelSpeculativeDecodingTrainingDataSource var1);

        default public Builder trainingDataSource(Consumer<ModelSpeculativeDecodingTrainingDataSource.Builder> trainingDataSource) {
            return this.trainingDataSource((ModelSpeculativeDecodingTrainingDataSource)((ModelSpeculativeDecodingTrainingDataSource.Builder)ModelSpeculativeDecodingTrainingDataSource.builder().applyMutation(trainingDataSource)).build());
        }
    }
}

