/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterOnDemandOptions;
import software.amazon.awssdk.services.sagemaker.model.ClusterSpotOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterCapacityRequirements
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterCapacityRequirements> {
    private static final SdkField<ClusterSpotOptions> SPOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Spot").getter(ClusterCapacityRequirements.getter(ClusterCapacityRequirements::spot)).setter(ClusterCapacityRequirements.setter(Builder::spot)).constructor(ClusterSpotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spot").build()}).build();
    private static final SdkField<ClusterOnDemandOptions> ON_DEMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemand").getter(ClusterCapacityRequirements.getter(ClusterCapacityRequirements::onDemand)).setter(ClusterCapacityRequirements.setter(Builder::onDemand)).constructor(ClusterOnDemandOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemand").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_FIELD, ON_DEMAND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterCapacityRequirements.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ClusterSpotOptions spot;
    private final ClusterOnDemandOptions onDemand;

    private ClusterCapacityRequirements(BuilderImpl builder) {
        this.spot = builder.spot;
        this.onDemand = builder.onDemand;
    }

    public final ClusterSpotOptions spot() {
        return this.spot;
    }

    public final ClusterOnDemandOptions onDemand() {
        return this.onDemand;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spot());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemand());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterCapacityRequirements)) {
            return false;
        }
        ClusterCapacityRequirements other = (ClusterCapacityRequirements)obj;
        return Objects.equals(this.spot(), other.spot()) && Objects.equals(this.onDemand(), other.onDemand());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterCapacityRequirements").add("Spot", (Object)this.spot()).add("OnDemand", (Object)this.onDemand()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Spot": {
                return Optional.ofNullable(clazz.cast(this.spot()));
            }
            case "OnDemand": {
                return Optional.ofNullable(clazz.cast(this.onDemand()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Spot", SPOT_FIELD);
        map.put("OnDemand", ON_DEMAND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterCapacityRequirements, T> g) {
        return obj -> g.apply((ClusterCapacityRequirements)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ClusterSpotOptions spot;
        private ClusterOnDemandOptions onDemand;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterCapacityRequirements model) {
            this.spot(model.spot);
            this.onDemand(model.onDemand);
        }

        public final ClusterSpotOptions.Builder getSpot() {
            return this.spot != null ? this.spot.toBuilder() : null;
        }

        public final void setSpot(ClusterSpotOptions.BuilderImpl spot) {
            this.spot = spot != null ? spot.build() : null;
        }

        @Override
        public final Builder spot(ClusterSpotOptions spot) {
            this.spot = spot;
            return this;
        }

        public final ClusterOnDemandOptions.Builder getOnDemand() {
            return this.onDemand != null ? this.onDemand.toBuilder() : null;
        }

        public final void setOnDemand(ClusterOnDemandOptions.BuilderImpl onDemand) {
            this.onDemand = onDemand != null ? onDemand.build() : null;
        }

        @Override
        public final Builder onDemand(ClusterOnDemandOptions onDemand) {
            this.onDemand = onDemand;
            return this;
        }

        public ClusterCapacityRequirements build() {
            return new ClusterCapacityRequirements(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterCapacityRequirements> {
        public Builder spot(ClusterSpotOptions var1);

        default public Builder spot(Consumer<ClusterSpotOptions.Builder> spot) {
            return this.spot((ClusterSpotOptions)((ClusterSpotOptions.Builder)ClusterSpotOptions.builder().applyMutation(spot)).build());
        }

        public Builder onDemand(ClusterOnDemandOptions var1);

        default public Builder onDemand(Consumer<ClusterOnDemandOptions.Builder> onDemand) {
            return this.onDemand((ClusterOnDemandOptions)((ClusterOnDemandOptions.Builder)ClusterOnDemandOptions.builder().applyMutation(onDemand)).build());
        }
    }
}

