/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.Parameter;

public class ListPipelineParametersForExecutionPublisher
implements SdkPublisher<ListPipelineParametersForExecutionResponse> {
    private final SageMakerAsyncClient client;
    private final ListPipelineParametersForExecutionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelineParametersForExecutionPublisher(SageMakerAsyncClient client, ListPipelineParametersForExecutionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelineParametersForExecutionPublisher(SageMakerAsyncClient client, ListPipelineParametersForExecutionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelineParametersForExecutionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelineParametersForExecutionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Parameter> pipelineParameters() {
        Function<ListPipelineParametersForExecutionResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineParameters() != null) {
                return response.pipelineParameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipelineParametersForExecutionResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPipelineParametersForExecutionResponseFetcher
    implements AsyncPageFetcher<ListPipelineParametersForExecutionResponse> {
        private ListPipelineParametersForExecutionResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineParametersForExecutionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipelineParametersForExecutionResponse> nextPage(ListPipelineParametersForExecutionResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineParametersForExecutionPublisher.this.client.listPipelineParametersForExecution(ListPipelineParametersForExecutionPublisher.this.firstRequest);
            }
            return ListPipelineParametersForExecutionPublisher.this.client.listPipelineParametersForExecution((ListPipelineParametersForExecutionRequest)((Object)ListPipelineParametersForExecutionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

