/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProblemType {
    BINARY_CLASSIFICATION("BinaryClassification"),
    MULTICLASS_CLASSIFICATION("MulticlassClassification"),
    REGRESSION("Regression"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProblemType> VALUE_MAP;
    private final String value;

    private ProblemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProblemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProblemType> knownValues() {
        EnumSet<ProblemType> knownValues = EnumSet.allOf(ProblemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProblemType.class, ProblemType::toString);
    }
}

