/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataDistributionType {
    FULLY_REPLICATED("FullyReplicated"),
    SHARDED_BY_S3_KEY("ShardedByS3Key"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataDistributionType> VALUE_MAP;
    private final String value;

    private DataDistributionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataDistributionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataDistributionType> knownValues() {
        EnumSet<DataDistributionType> knownValues = EnumSet.allOf(DataDistributionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataDistributionType.class, DataDistributionType::toString);
    }
}

