/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppLifecycleManagement;
import software.amazon.awssdk.services.sagemaker.model.CustomImage;
import software.amazon.awssdk.services.sagemaker.model.CustomImagesCopier;
import software.amazon.awssdk.services.sagemaker.model.LifecycleConfigArnsCopier;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeEditorAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeEditorAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultResourceSpec").getter(CodeEditorAppSettings.getter(CodeEditorAppSettings::defaultResourceSpec)).setter(CodeEditorAppSettings.setter(Builder::defaultResourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build()}).build();
    private static final SdkField<List<CustomImage>> CUSTOM_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomImages").getter(CodeEditorAppSettings.getter(CodeEditorAppSettings::customImages)).setter(CodeEditorAppSettings.setter(Builder::customImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIFECYCLE_CONFIG_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifecycleConfigArns").getter(CodeEditorAppSettings.getter(CodeEditorAppSettings::lifecycleConfigArns)).setter(CodeEditorAppSettings.setter(Builder::lifecycleConfigArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AppLifecycleManagement> APP_LIFECYCLE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppLifecycleManagement").getter(CodeEditorAppSettings.getter(CodeEditorAppSettings::appLifecycleManagement)).setter(CodeEditorAppSettings.setter(Builder::appLifecycleManagement)).constructor(AppLifecycleManagement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLifecycleManagement").build()}).build();
    private static final SdkField<String> BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuiltInLifecycleConfigArn").getter(CodeEditorAppSettings.getter(CodeEditorAppSettings::builtInLifecycleConfigArn)).setter(CodeEditorAppSettings.setter(Builder::builtInLifecycleConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuiltInLifecycleConfigArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD, CUSTOM_IMAGES_FIELD, LIFECYCLE_CONFIG_ARNS_FIELD, APP_LIFECYCLE_MANAGEMENT_FIELD, BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeEditorAppSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ResourceSpec defaultResourceSpec;
    private final List<CustomImage> customImages;
    private final List<String> lifecycleConfigArns;
    private final AppLifecycleManagement appLifecycleManagement;
    private final String builtInLifecycleConfigArn;

    private CodeEditorAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.customImages = builder.customImages;
        this.lifecycleConfigArns = builder.lifecycleConfigArns;
        this.appLifecycleManagement = builder.appLifecycleManagement;
        this.builtInLifecycleConfigArn = builder.builtInLifecycleConfigArn;
    }

    public final ResourceSpec defaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public final boolean hasCustomImages() {
        return this.customImages != null && !(this.customImages instanceof SdkAutoConstructList);
    }

    public final List<CustomImage> customImages() {
        return this.customImages;
    }

    public final boolean hasLifecycleConfigArns() {
        return this.lifecycleConfigArns != null && !(this.lifecycleConfigArns instanceof SdkAutoConstructList);
    }

    public final List<String> lifecycleConfigArns() {
        return this.lifecycleConfigArns;
    }

    public final AppLifecycleManagement appLifecycleManagement() {
        return this.appLifecycleManagement;
    }

    public final String builtInLifecycleConfigArn() {
        return this.builtInLifecycleConfigArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomImages() ? this.customImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleConfigArns() ? this.lifecycleConfigArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appLifecycleManagement());
        hashCode = 31 * hashCode + Objects.hashCode(this.builtInLifecycleConfigArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeEditorAppSettings)) {
            return false;
        }
        CodeEditorAppSettings other = (CodeEditorAppSettings)obj;
        return Objects.equals(this.defaultResourceSpec(), other.defaultResourceSpec()) && this.hasCustomImages() == other.hasCustomImages() && Objects.equals(this.customImages(), other.customImages()) && this.hasLifecycleConfigArns() == other.hasLifecycleConfigArns() && Objects.equals(this.lifecycleConfigArns(), other.lifecycleConfigArns()) && Objects.equals(this.appLifecycleManagement(), other.appLifecycleManagement()) && Objects.equals(this.builtInLifecycleConfigArn(), other.builtInLifecycleConfigArn());
    }

    public final String toString() {
        return ToString.builder((String)"CodeEditorAppSettings").add("DefaultResourceSpec", (Object)this.defaultResourceSpec()).add("CustomImages", this.hasCustomImages() ? this.customImages() : null).add("LifecycleConfigArns", this.hasLifecycleConfigArns() ? this.lifecycleConfigArns() : null).add("AppLifecycleManagement", (Object)this.appLifecycleManagement()).add("BuiltInLifecycleConfigArn", (Object)this.builtInLifecycleConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceSpec()));
            }
            case "CustomImages": {
                return Optional.ofNullable(clazz.cast(this.customImages()));
            }
            case "LifecycleConfigArns": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfigArns()));
            }
            case "AppLifecycleManagement": {
                return Optional.ofNullable(clazz.cast(this.appLifecycleManagement()));
            }
            case "BuiltInLifecycleConfigArn": {
                return Optional.ofNullable(clazz.cast(this.builtInLifecycleConfigArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultResourceSpec", DEFAULT_RESOURCE_SPEC_FIELD);
        map.put("CustomImages", CUSTOM_IMAGES_FIELD);
        map.put("LifecycleConfigArns", LIFECYCLE_CONFIG_ARNS_FIELD);
        map.put("AppLifecycleManagement", APP_LIFECYCLE_MANAGEMENT_FIELD);
        map.put("BuiltInLifecycleConfigArn", BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeEditorAppSettings, T> g) {
        return obj -> g.apply((CodeEditorAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceSpec defaultResourceSpec;
        private List<CustomImage> customImages = DefaultSdkAutoConstructList.getInstance();
        private List<String> lifecycleConfigArns = DefaultSdkAutoConstructList.getInstance();
        private AppLifecycleManagement appLifecycleManagement;
        private String builtInLifecycleConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeEditorAppSettings model) {
            this.defaultResourceSpec(model.defaultResourceSpec);
            this.customImages(model.customImages);
            this.lifecycleConfigArns(model.lifecycleConfigArns);
            this.appLifecycleManagement(model.appLifecycleManagement);
            this.builtInLifecycleConfigArn(model.builtInLifecycleConfigArn);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return this.defaultResourceSpec != null ? this.defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final List<CustomImage.Builder> getCustomImages() {
            List<CustomImage.Builder> result = CustomImagesCopier.copyToBuilder(this.customImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomImages(Collection<CustomImage.BuilderImpl> customImages) {
            this.customImages = CustomImagesCopier.copyFromBuilder(customImages);
        }

        @Override
        public final Builder customImages(Collection<CustomImage> customImages) {
            this.customImages = CustomImagesCopier.copy(customImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(CustomImage ... customImages) {
            this.customImages(Arrays.asList(customImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(Consumer<CustomImage.Builder> ... customImages) {
            this.customImages(Stream.of(customImages).map(c -> (CustomImage)((CustomImage.Builder)CustomImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getLifecycleConfigArns() {
            if (this.lifecycleConfigArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifecycleConfigArns;
        }

        public final void setLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
        }

        @Override
        public final Builder lifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleConfigArns(String ... lifecycleConfigArns) {
            this.lifecycleConfigArns(Arrays.asList(lifecycleConfigArns));
            return this;
        }

        public final AppLifecycleManagement.Builder getAppLifecycleManagement() {
            return this.appLifecycleManagement != null ? this.appLifecycleManagement.toBuilder() : null;
        }

        public final void setAppLifecycleManagement(AppLifecycleManagement.BuilderImpl appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement != null ? appLifecycleManagement.build() : null;
        }

        @Override
        public final Builder appLifecycleManagement(AppLifecycleManagement appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement;
            return this;
        }

        public final String getBuiltInLifecycleConfigArn() {
            return this.builtInLifecycleConfigArn;
        }

        public final void setBuiltInLifecycleConfigArn(String builtInLifecycleConfigArn) {
            this.builtInLifecycleConfigArn = builtInLifecycleConfigArn;
        }

        @Override
        public final Builder builtInLifecycleConfigArn(String builtInLifecycleConfigArn) {
            this.builtInLifecycleConfigArn = builtInLifecycleConfigArn;
            return this;
        }

        public CodeEditorAppSettings build() {
            return new CodeEditorAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeEditorAppSettings> {
        public Builder defaultResourceSpec(ResourceSpec var1);

        default public Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return this.defaultResourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(defaultResourceSpec)).build());
        }

        public Builder customImages(Collection<CustomImage> var1);

        public Builder customImages(CustomImage ... var1);

        public Builder customImages(Consumer<CustomImage.Builder> ... var1);

        public Builder lifecycleConfigArns(Collection<String> var1);

        public Builder lifecycleConfigArns(String ... var1);

        public Builder appLifecycleManagement(AppLifecycleManagement var1);

        default public Builder appLifecycleManagement(Consumer<AppLifecycleManagement.Builder> appLifecycleManagement) {
            return this.appLifecycleManagement((AppLifecycleManagement)((AppLifecycleManagement.Builder)AppLifecycleManagement.builder().applyMutation(appLifecycleManagement)).build());
        }

        public Builder builtInLifecycleConfigArn(String var1);
    }
}

