/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CaptureMode {
    INPUT("Input"),
    OUTPUT("Output"),
    INPUT_AND_OUTPUT("InputAndOutput"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CaptureMode> VALUE_MAP;
    private final String value;

    private CaptureMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CaptureMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CaptureMode> knownValues() {
        EnumSet<CaptureMode> knownValues = EnumSet.allOf(CaptureMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CaptureMode.class, CaptureMode::toString);
    }
}

