/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLJobStatus {
    COMPLETED("Completed"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    STOPPED("Stopped"),
    STOPPING("Stopping"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLJobStatus> VALUE_MAP;
    private final String value;

    private AutoMLJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLJobStatus> knownValues() {
        EnumSet<AutoMLJobStatus> knownValues = EnumSet.allOf(AutoMLJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLJobStatus.class, AutoMLJobStatus::toString);
    }
}

