/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AsyncInferenceOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AsyncInferenceOutputConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AsyncInferenceOutputConfig.getter(AsyncInferenceOutputConfig::kmsKeyId)).setter(AsyncInferenceOutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(AsyncInferenceOutputConfig.getter(AsyncInferenceOutputConfig::s3OutputPath)).setter(AsyncInferenceOutputConfig.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<AsyncInferenceNotificationConfig> NOTIFICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfig").getter(AsyncInferenceOutputConfig.getter(AsyncInferenceOutputConfig::notificationConfig)).setter(AsyncInferenceOutputConfig.setter(Builder::notificationConfig)).constructor(AsyncInferenceNotificationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfig").build()}).build();
    private static final SdkField<String> S3_FAILURE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3FailurePath").getter(AsyncInferenceOutputConfig.getter(AsyncInferenceOutputConfig::s3FailurePath)).setter(AsyncInferenceOutputConfig.setter(Builder::s3FailurePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3FailurePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, S3_OUTPUT_PATH_FIELD, NOTIFICATION_CONFIG_FIELD, S3_FAILURE_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AsyncInferenceOutputConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String s3OutputPath;
    private final AsyncInferenceNotificationConfig notificationConfig;
    private final String s3FailurePath;

    private AsyncInferenceOutputConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.s3OutputPath = builder.s3OutputPath;
        this.notificationConfig = builder.notificationConfig;
        this.s3FailurePath = builder.s3FailurePath;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String s3OutputPath() {
        return this.s3OutputPath;
    }

    public final AsyncInferenceNotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public final String s3FailurePath() {
        return this.s3FailurePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3FailurePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceOutputConfig)) {
            return false;
        }
        AsyncInferenceOutputConfig other = (AsyncInferenceOutputConfig)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.notificationConfig(), other.notificationConfig()) && Objects.equals(this.s3FailurePath(), other.s3FailurePath());
    }

    public final String toString() {
        return ToString.builder((String)"AsyncInferenceOutputConfig").add("KmsKeyId", (Object)this.kmsKeyId()).add("S3OutputPath", (Object)this.s3OutputPath()).add("NotificationConfig", (Object)this.notificationConfig()).add("S3FailurePath", (Object)this.s3FailurePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "NotificationConfig": {
                return Optional.ofNullable(clazz.cast(this.notificationConfig()));
            }
            case "S3FailurePath": {
                return Optional.ofNullable(clazz.cast(this.s3FailurePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("S3OutputPath", S3_OUTPUT_PATH_FIELD);
        map.put("NotificationConfig", NOTIFICATION_CONFIG_FIELD);
        map.put("S3FailurePath", S3_FAILURE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceOutputConfig, T> g) {
        return obj -> g.apply((AsyncInferenceOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String s3OutputPath;
        private AsyncInferenceNotificationConfig notificationConfig;
        private String s3FailurePath;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceOutputConfig model) {
            this.kmsKeyId(model.kmsKeyId);
            this.s3OutputPath(model.s3OutputPath);
            this.notificationConfig(model.notificationConfig);
            this.s3FailurePath(model.s3FailurePath);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final AsyncInferenceNotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        public final void setNotificationConfig(AsyncInferenceNotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        @Override
        public final Builder notificationConfig(AsyncInferenceNotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final String getS3FailurePath() {
            return this.s3FailurePath;
        }

        public final void setS3FailurePath(String s3FailurePath) {
            this.s3FailurePath = s3FailurePath;
        }

        @Override
        public final Builder s3FailurePath(String s3FailurePath) {
            this.s3FailurePath = s3FailurePath;
            return this;
        }

        public AsyncInferenceOutputConfig build() {
            return new AsyncInferenceOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AsyncInferenceOutputConfig> {
        public Builder kmsKeyId(String var1);

        public Builder s3OutputPath(String var1);

        public Builder notificationConfig(AsyncInferenceNotificationConfig var1);

        default public Builder notificationConfig(Consumer<AsyncInferenceNotificationConfig.Builder> notificationConfig) {
            return this.notificationConfig((AsyncInferenceNotificationConfig)((AsyncInferenceNotificationConfig.Builder)AsyncInferenceNotificationConfig.builder().applyMutation(notificationConfig)).build());
        }

        public Builder s3FailurePath(String var1);
    }
}

