/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanSummary;

public class ListTrainingPlansPublisher
implements SdkPublisher<ListTrainingPlansResponse> {
    private final SageMakerAsyncClient client;
    private final ListTrainingPlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrainingPlansPublisher(SageMakerAsyncClient client, ListTrainingPlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrainingPlansPublisher(SageMakerAsyncClient client, ListTrainingPlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrainingPlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrainingPlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrainingPlanSummary> trainingPlanSummaries() {
        Function<ListTrainingPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainingPlanSummaries() != null) {
                return response.trainingPlanSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrainingPlansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrainingPlansResponseFetcher
    implements AsyncPageFetcher<ListTrainingPlansResponse> {
        private ListTrainingPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrainingPlansResponse> nextPage(ListTrainingPlansResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingPlansPublisher.this.client.listTrainingPlans(ListTrainingPlansPublisher.this.firstRequest);
            }
            return ListTrainingPlansPublisher.this.client.listTrainingPlans((ListTrainingPlansRequest)((Object)ListTrainingPlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

