/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3ModelDataType {
    S3_PREFIX("S3Prefix"),
    S3_OBJECT("S3Object"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3ModelDataType> VALUE_MAP;
    private final String value;

    private S3ModelDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3ModelDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3ModelDataType> knownValues() {
        EnumSet<S3ModelDataType> knownValues = EnumSet.allOf(S3ModelDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3ModelDataType.class, S3ModelDataType::toString);
    }
}

