/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FeatureType {
    INTEGRAL("Integral"),
    FRACTIONAL("Fractional"),
    STRING("String"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FeatureType> VALUE_MAP;
    private final String value;

    private FeatureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FeatureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FeatureType> knownValues() {
        EnumSet<FeatureType> knownValues = EnumSet.allOf(FeatureType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FeatureType.class, FeatureType::toString);
    }
}

