/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceDeploymentStatus {
    READYTODEPLOY("READYTODEPLOY"),
    INPROGRESS("INPROGRESS"),
    DEPLOYED("DEPLOYED"),
    FAILED("FAILED"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceDeploymentStatus> VALUE_MAP;
    private final String value;

    private DeviceDeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceDeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceDeploymentStatus> knownValues() {
        EnumSet<DeviceDeploymentStatus> knownValues = EnumSet.allOf(DeviceDeploymentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceDeploymentStatus.class, DeviceDeploymentStatus::toString);
    }
}

