/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppInstanceType;
import software.amazon.awssdk.services.sagemaker.model.AppType;
import software.amazon.awssdk.services.sagemaker.model.HiddenAppTypesListCopier;
import software.amazon.awssdk.services.sagemaker.model.HiddenInstanceTypesListCopier;
import software.amazon.awssdk.services.sagemaker.model.HiddenMlToolsListCopier;
import software.amazon.awssdk.services.sagemaker.model.HiddenSageMakerImage;
import software.amazon.awssdk.services.sagemaker.model.HiddenSageMakerImageVersionAliasesListCopier;
import software.amazon.awssdk.services.sagemaker.model.MlTools;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StudioWebPortalSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StudioWebPortalSettings> {
    private static final SdkField<List<String>> HIDDEN_ML_TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HiddenMlTools").getter(StudioWebPortalSettings.getter(StudioWebPortalSettings::hiddenMlToolsAsStrings)).setter(StudioWebPortalSettings.setter(Builder::hiddenMlToolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenMlTools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HIDDEN_APP_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HiddenAppTypes").getter(StudioWebPortalSettings.getter(StudioWebPortalSettings::hiddenAppTypesAsStrings)).setter(StudioWebPortalSettings.setter(Builder::hiddenAppTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenAppTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HIDDEN_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HiddenInstanceTypes").getter(StudioWebPortalSettings.getter(StudioWebPortalSettings::hiddenInstanceTypesAsStrings)).setter(StudioWebPortalSettings.setter(Builder::hiddenInstanceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HiddenSageMakerImage>> HIDDEN_SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HiddenSageMakerImageVersionAliases").getter(StudioWebPortalSettings.getter(StudioWebPortalSettings::hiddenSageMakerImageVersionAliases)).setter(StudioWebPortalSettings.setter(Builder::hiddenSageMakerImageVersionAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenSageMakerImageVersionAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HiddenSageMakerImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIDDEN_ML_TOOLS_FIELD, HIDDEN_APP_TYPES_FIELD, HIDDEN_INSTANCE_TYPES_FIELD, HIDDEN_SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StudioWebPortalSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> hiddenMlTools;
    private final List<String> hiddenAppTypes;
    private final List<String> hiddenInstanceTypes;
    private final List<HiddenSageMakerImage> hiddenSageMakerImageVersionAliases;

    private StudioWebPortalSettings(BuilderImpl builder) {
        this.hiddenMlTools = builder.hiddenMlTools;
        this.hiddenAppTypes = builder.hiddenAppTypes;
        this.hiddenInstanceTypes = builder.hiddenInstanceTypes;
        this.hiddenSageMakerImageVersionAliases = builder.hiddenSageMakerImageVersionAliases;
    }

    public final List<MlTools> hiddenMlTools() {
        return HiddenMlToolsListCopier.copyStringToEnum(this.hiddenMlTools);
    }

    public final boolean hasHiddenMlTools() {
        return this.hiddenMlTools != null && !(this.hiddenMlTools instanceof SdkAutoConstructList);
    }

    public final List<String> hiddenMlToolsAsStrings() {
        return this.hiddenMlTools;
    }

    public final List<AppType> hiddenAppTypes() {
        return HiddenAppTypesListCopier.copyStringToEnum(this.hiddenAppTypes);
    }

    public final boolean hasHiddenAppTypes() {
        return this.hiddenAppTypes != null && !(this.hiddenAppTypes instanceof SdkAutoConstructList);
    }

    public final List<String> hiddenAppTypesAsStrings() {
        return this.hiddenAppTypes;
    }

    public final List<AppInstanceType> hiddenInstanceTypes() {
        return HiddenInstanceTypesListCopier.copyStringToEnum(this.hiddenInstanceTypes);
    }

    public final boolean hasHiddenInstanceTypes() {
        return this.hiddenInstanceTypes != null && !(this.hiddenInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> hiddenInstanceTypesAsStrings() {
        return this.hiddenInstanceTypes;
    }

    public final boolean hasHiddenSageMakerImageVersionAliases() {
        return this.hiddenSageMakerImageVersionAliases != null && !(this.hiddenSageMakerImageVersionAliases instanceof SdkAutoConstructList);
    }

    public final List<HiddenSageMakerImage> hiddenSageMakerImageVersionAliases() {
        return this.hiddenSageMakerImageVersionAliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiddenMlTools() ? this.hiddenMlToolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiddenAppTypes() ? this.hiddenAppTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiddenInstanceTypes() ? this.hiddenInstanceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiddenSageMakerImageVersionAliases() ? this.hiddenSageMakerImageVersionAliases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioWebPortalSettings)) {
            return false;
        }
        StudioWebPortalSettings other = (StudioWebPortalSettings)obj;
        return this.hasHiddenMlTools() == other.hasHiddenMlTools() && Objects.equals(this.hiddenMlToolsAsStrings(), other.hiddenMlToolsAsStrings()) && this.hasHiddenAppTypes() == other.hasHiddenAppTypes() && Objects.equals(this.hiddenAppTypesAsStrings(), other.hiddenAppTypesAsStrings()) && this.hasHiddenInstanceTypes() == other.hasHiddenInstanceTypes() && Objects.equals(this.hiddenInstanceTypesAsStrings(), other.hiddenInstanceTypesAsStrings()) && this.hasHiddenSageMakerImageVersionAliases() == other.hasHiddenSageMakerImageVersionAliases() && Objects.equals(this.hiddenSageMakerImageVersionAliases(), other.hiddenSageMakerImageVersionAliases());
    }

    public final String toString() {
        return ToString.builder((String)"StudioWebPortalSettings").add("HiddenMlTools", this.hasHiddenMlTools() ? this.hiddenMlToolsAsStrings() : null).add("HiddenAppTypes", this.hasHiddenAppTypes() ? this.hiddenAppTypesAsStrings() : null).add("HiddenInstanceTypes", this.hasHiddenInstanceTypes() ? this.hiddenInstanceTypesAsStrings() : null).add("HiddenSageMakerImageVersionAliases", this.hasHiddenSageMakerImageVersionAliases() ? this.hiddenSageMakerImageVersionAliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HiddenMlTools": {
                return Optional.ofNullable(clazz.cast(this.hiddenMlToolsAsStrings()));
            }
            case "HiddenAppTypes": {
                return Optional.ofNullable(clazz.cast(this.hiddenAppTypesAsStrings()));
            }
            case "HiddenInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.hiddenInstanceTypesAsStrings()));
            }
            case "HiddenSageMakerImageVersionAliases": {
                return Optional.ofNullable(clazz.cast(this.hiddenSageMakerImageVersionAliases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HiddenMlTools", HIDDEN_ML_TOOLS_FIELD);
        map.put("HiddenAppTypes", HIDDEN_APP_TYPES_FIELD);
        map.put("HiddenInstanceTypes", HIDDEN_INSTANCE_TYPES_FIELD);
        map.put("HiddenSageMakerImageVersionAliases", HIDDEN_SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StudioWebPortalSettings, T> g) {
        return obj -> g.apply((StudioWebPortalSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> hiddenMlTools = DefaultSdkAutoConstructList.getInstance();
        private List<String> hiddenAppTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> hiddenInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<HiddenSageMakerImage> hiddenSageMakerImageVersionAliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StudioWebPortalSettings model) {
            this.hiddenMlToolsWithStrings(model.hiddenMlTools);
            this.hiddenAppTypesWithStrings(model.hiddenAppTypes);
            this.hiddenInstanceTypesWithStrings(model.hiddenInstanceTypes);
            this.hiddenSageMakerImageVersionAliases(model.hiddenSageMakerImageVersionAliases);
        }

        public final Collection<String> getHiddenMlTools() {
            if (this.hiddenMlTools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hiddenMlTools;
        }

        public final void setHiddenMlTools(Collection<String> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copy(hiddenMlTools);
        }

        @Override
        public final Builder hiddenMlToolsWithStrings(Collection<String> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copy(hiddenMlTools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenMlToolsWithStrings(String ... hiddenMlTools) {
            this.hiddenMlToolsWithStrings(Arrays.asList(hiddenMlTools));
            return this;
        }

        @Override
        public final Builder hiddenMlTools(Collection<MlTools> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copyEnumToString(hiddenMlTools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenMlTools(MlTools ... hiddenMlTools) {
            this.hiddenMlTools(Arrays.asList(hiddenMlTools));
            return this;
        }

        public final Collection<String> getHiddenAppTypes() {
            if (this.hiddenAppTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hiddenAppTypes;
        }

        public final void setHiddenAppTypes(Collection<String> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copy(hiddenAppTypes);
        }

        @Override
        public final Builder hiddenAppTypesWithStrings(Collection<String> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copy(hiddenAppTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenAppTypesWithStrings(String ... hiddenAppTypes) {
            this.hiddenAppTypesWithStrings(Arrays.asList(hiddenAppTypes));
            return this;
        }

        @Override
        public final Builder hiddenAppTypes(Collection<AppType> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copyEnumToString(hiddenAppTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenAppTypes(AppType ... hiddenAppTypes) {
            this.hiddenAppTypes(Arrays.asList(hiddenAppTypes));
            return this;
        }

        public final Collection<String> getHiddenInstanceTypes() {
            if (this.hiddenInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hiddenInstanceTypes;
        }

        public final void setHiddenInstanceTypes(Collection<String> hiddenInstanceTypes) {
            this.hiddenInstanceTypes = HiddenInstanceTypesListCopier.copy(hiddenInstanceTypes);
        }

        @Override
        public final Builder hiddenInstanceTypesWithStrings(Collection<String> hiddenInstanceTypes) {
            this.hiddenInstanceTypes = HiddenInstanceTypesListCopier.copy(hiddenInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenInstanceTypesWithStrings(String ... hiddenInstanceTypes) {
            this.hiddenInstanceTypesWithStrings(Arrays.asList(hiddenInstanceTypes));
            return this;
        }

        @Override
        public final Builder hiddenInstanceTypes(Collection<AppInstanceType> hiddenInstanceTypes) {
            this.hiddenInstanceTypes = HiddenInstanceTypesListCopier.copyEnumToString(hiddenInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenInstanceTypes(AppInstanceType ... hiddenInstanceTypes) {
            this.hiddenInstanceTypes(Arrays.asList(hiddenInstanceTypes));
            return this;
        }

        public final List<HiddenSageMakerImage.Builder> getHiddenSageMakerImageVersionAliases() {
            List<HiddenSageMakerImage.Builder> result = HiddenSageMakerImageVersionAliasesListCopier.copyToBuilder(this.hiddenSageMakerImageVersionAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHiddenSageMakerImageVersionAliases(Collection<HiddenSageMakerImage.BuilderImpl> hiddenSageMakerImageVersionAliases) {
            this.hiddenSageMakerImageVersionAliases = HiddenSageMakerImageVersionAliasesListCopier.copyFromBuilder(hiddenSageMakerImageVersionAliases);
        }

        @Override
        public final Builder hiddenSageMakerImageVersionAliases(Collection<HiddenSageMakerImage> hiddenSageMakerImageVersionAliases) {
            this.hiddenSageMakerImageVersionAliases = HiddenSageMakerImageVersionAliasesListCopier.copy(hiddenSageMakerImageVersionAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenSageMakerImageVersionAliases(HiddenSageMakerImage ... hiddenSageMakerImageVersionAliases) {
            this.hiddenSageMakerImageVersionAliases(Arrays.asList(hiddenSageMakerImageVersionAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenSageMakerImageVersionAliases(Consumer<HiddenSageMakerImage.Builder> ... hiddenSageMakerImageVersionAliases) {
            this.hiddenSageMakerImageVersionAliases(Stream.of(hiddenSageMakerImageVersionAliases).map(c -> (HiddenSageMakerImage)((HiddenSageMakerImage.Builder)HiddenSageMakerImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StudioWebPortalSettings build() {
            return new StudioWebPortalSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StudioWebPortalSettings> {
        public Builder hiddenMlToolsWithStrings(Collection<String> var1);

        public Builder hiddenMlToolsWithStrings(String ... var1);

        public Builder hiddenMlTools(Collection<MlTools> var1);

        public Builder hiddenMlTools(MlTools ... var1);

        public Builder hiddenAppTypesWithStrings(Collection<String> var1);

        public Builder hiddenAppTypesWithStrings(String ... var1);

        public Builder hiddenAppTypes(Collection<AppType> var1);

        public Builder hiddenAppTypes(AppType ... var1);

        public Builder hiddenInstanceTypesWithStrings(Collection<String> var1);

        public Builder hiddenInstanceTypesWithStrings(String ... var1);

        public Builder hiddenInstanceTypes(Collection<AppInstanceType> var1);

        public Builder hiddenInstanceTypes(AppInstanceType ... var1);

        public Builder hiddenSageMakerImageVersionAliases(Collection<HiddenSageMakerImage> var1);

        public Builder hiddenSageMakerImageVersionAliases(HiddenSageMakerImage ... var1);

        public Builder hiddenSageMakerImageVersionAliases(Consumer<HiddenSageMakerImage.Builder> ... var1);
    }
}

