/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ModelCompilationConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelQuantizationConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelShardingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptimizationConfig> {
    private static final SdkField<ModelQuantizationConfig> MODEL_QUANTIZATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQuantizationConfig").getter(OptimizationConfig.getter(OptimizationConfig::modelQuantizationConfig)).setter(OptimizationConfig.setter(Builder::modelQuantizationConfig)).constructor(ModelQuantizationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuantizationConfig").build()}).build();
    private static final SdkField<ModelCompilationConfig> MODEL_COMPILATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelCompilationConfig").getter(OptimizationConfig.getter(OptimizationConfig::modelCompilationConfig)).setter(OptimizationConfig.setter(Builder::modelCompilationConfig)).constructor(ModelCompilationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCompilationConfig").build()}).build();
    private static final SdkField<ModelShardingConfig> MODEL_SHARDING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelShardingConfig").getter(OptimizationConfig.getter(OptimizationConfig::modelShardingConfig)).setter(OptimizationConfig.setter(Builder::modelShardingConfig)).constructor(ModelShardingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelShardingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_QUANTIZATION_CONFIG_FIELD, MODEL_COMPILATION_CONFIG_FIELD, MODEL_SHARDING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ModelQuantizationConfig modelQuantizationConfig;
    private final ModelCompilationConfig modelCompilationConfig;
    private final ModelShardingConfig modelShardingConfig;
    private final Type type;

    private OptimizationConfig(BuilderImpl builder) {
        this.modelQuantizationConfig = builder.modelQuantizationConfig;
        this.modelCompilationConfig = builder.modelCompilationConfig;
        this.modelShardingConfig = builder.modelShardingConfig;
        this.type = builder.type;
    }

    public final ModelQuantizationConfig modelQuantizationConfig() {
        return this.modelQuantizationConfig;
    }

    public final ModelCompilationConfig modelCompilationConfig() {
        return this.modelCompilationConfig;
    }

    public final ModelShardingConfig modelShardingConfig() {
        return this.modelShardingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQuantizationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCompilationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelShardingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationConfig)) {
            return false;
        }
        OptimizationConfig other = (OptimizationConfig)obj;
        return Objects.equals(this.modelQuantizationConfig(), other.modelQuantizationConfig()) && Objects.equals(this.modelCompilationConfig(), other.modelCompilationConfig()) && Objects.equals(this.modelShardingConfig(), other.modelShardingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizationConfig").add("ModelQuantizationConfig", (Object)this.modelQuantizationConfig()).add("ModelCompilationConfig", (Object)this.modelCompilationConfig()).add("ModelShardingConfig", (Object)this.modelShardingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelQuantizationConfig": {
                return Optional.ofNullable(clazz.cast(this.modelQuantizationConfig()));
            }
            case "ModelCompilationConfig": {
                return Optional.ofNullable(clazz.cast(this.modelCompilationConfig()));
            }
            case "ModelShardingConfig": {
                return Optional.ofNullable(clazz.cast(this.modelShardingConfig()));
            }
        }
        return Optional.empty();
    }

    public static OptimizationConfig fromModelQuantizationConfig(ModelQuantizationConfig modelQuantizationConfig) {
        return (OptimizationConfig)OptimizationConfig.builder().modelQuantizationConfig(modelQuantizationConfig).build();
    }

    public static OptimizationConfig fromModelQuantizationConfig(Consumer<ModelQuantizationConfig.Builder> modelQuantizationConfig) {
        ModelQuantizationConfig.Builder builder = ModelQuantizationConfig.builder();
        modelQuantizationConfig.accept(builder);
        return OptimizationConfig.fromModelQuantizationConfig((ModelQuantizationConfig)builder.build());
    }

    public static OptimizationConfig fromModelCompilationConfig(ModelCompilationConfig modelCompilationConfig) {
        return (OptimizationConfig)OptimizationConfig.builder().modelCompilationConfig(modelCompilationConfig).build();
    }

    public static OptimizationConfig fromModelCompilationConfig(Consumer<ModelCompilationConfig.Builder> modelCompilationConfig) {
        ModelCompilationConfig.Builder builder = ModelCompilationConfig.builder();
        modelCompilationConfig.accept(builder);
        return OptimizationConfig.fromModelCompilationConfig((ModelCompilationConfig)builder.build());
    }

    public static OptimizationConfig fromModelShardingConfig(ModelShardingConfig modelShardingConfig) {
        return (OptimizationConfig)OptimizationConfig.builder().modelShardingConfig(modelShardingConfig).build();
    }

    public static OptimizationConfig fromModelShardingConfig(Consumer<ModelShardingConfig.Builder> modelShardingConfig) {
        ModelShardingConfig.Builder builder = ModelShardingConfig.builder();
        modelShardingConfig.accept(builder);
        return OptimizationConfig.fromModelShardingConfig((ModelShardingConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelQuantizationConfig", MODEL_QUANTIZATION_CONFIG_FIELD);
        map.put("ModelCompilationConfig", MODEL_COMPILATION_CONFIG_FIELD);
        map.put("ModelShardingConfig", MODEL_SHARDING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizationConfig, T> g) {
        return obj -> g.apply((OptimizationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        MODEL_QUANTIZATION_CONFIG,
        MODEL_COMPILATION_CONFIG,
        MODEL_SHARDING_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ModelQuantizationConfig modelQuantizationConfig;
        private ModelCompilationConfig modelCompilationConfig;
        private ModelShardingConfig modelShardingConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationConfig model) {
            this.modelQuantizationConfig(model.modelQuantizationConfig);
            this.modelCompilationConfig(model.modelCompilationConfig);
            this.modelShardingConfig(model.modelShardingConfig);
        }

        public final ModelQuantizationConfig.Builder getModelQuantizationConfig() {
            return this.modelQuantizationConfig != null ? this.modelQuantizationConfig.toBuilder() : null;
        }

        public final void setModelQuantizationConfig(ModelQuantizationConfig.BuilderImpl modelQuantizationConfig) {
            ModelQuantizationConfig oldValue = this.modelQuantizationConfig;
            this.modelQuantizationConfig = modelQuantizationConfig != null ? modelQuantizationConfig.build() : null;
            this.handleUnionValueChange(Type.MODEL_QUANTIZATION_CONFIG, oldValue, this.modelQuantizationConfig);
        }

        @Override
        public final Builder modelQuantizationConfig(ModelQuantizationConfig modelQuantizationConfig) {
            ModelQuantizationConfig oldValue = this.modelQuantizationConfig;
            this.modelQuantizationConfig = modelQuantizationConfig;
            this.handleUnionValueChange(Type.MODEL_QUANTIZATION_CONFIG, oldValue, this.modelQuantizationConfig);
            return this;
        }

        public final ModelCompilationConfig.Builder getModelCompilationConfig() {
            return this.modelCompilationConfig != null ? this.modelCompilationConfig.toBuilder() : null;
        }

        public final void setModelCompilationConfig(ModelCompilationConfig.BuilderImpl modelCompilationConfig) {
            ModelCompilationConfig oldValue = this.modelCompilationConfig;
            this.modelCompilationConfig = modelCompilationConfig != null ? modelCompilationConfig.build() : null;
            this.handleUnionValueChange(Type.MODEL_COMPILATION_CONFIG, oldValue, this.modelCompilationConfig);
        }

        @Override
        public final Builder modelCompilationConfig(ModelCompilationConfig modelCompilationConfig) {
            ModelCompilationConfig oldValue = this.modelCompilationConfig;
            this.modelCompilationConfig = modelCompilationConfig;
            this.handleUnionValueChange(Type.MODEL_COMPILATION_CONFIG, oldValue, this.modelCompilationConfig);
            return this;
        }

        public final ModelShardingConfig.Builder getModelShardingConfig() {
            return this.modelShardingConfig != null ? this.modelShardingConfig.toBuilder() : null;
        }

        public final void setModelShardingConfig(ModelShardingConfig.BuilderImpl modelShardingConfig) {
            ModelShardingConfig oldValue = this.modelShardingConfig;
            this.modelShardingConfig = modelShardingConfig != null ? modelShardingConfig.build() : null;
            this.handleUnionValueChange(Type.MODEL_SHARDING_CONFIG, oldValue, this.modelShardingConfig);
        }

        @Override
        public final Builder modelShardingConfig(ModelShardingConfig modelShardingConfig) {
            ModelShardingConfig oldValue = this.modelShardingConfig;
            this.modelShardingConfig = modelShardingConfig;
            this.handleUnionValueChange(Type.MODEL_SHARDING_CONFIG, oldValue, this.modelShardingConfig);
            return this;
        }

        public OptimizationConfig build() {
            return new OptimizationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptimizationConfig> {
        public Builder modelQuantizationConfig(ModelQuantizationConfig var1);

        default public Builder modelQuantizationConfig(Consumer<ModelQuantizationConfig.Builder> modelQuantizationConfig) {
            return this.modelQuantizationConfig((ModelQuantizationConfig)((ModelQuantizationConfig.Builder)ModelQuantizationConfig.builder().applyMutation(modelQuantizationConfig)).build());
        }

        public Builder modelCompilationConfig(ModelCompilationConfig var1);

        default public Builder modelCompilationConfig(Consumer<ModelCompilationConfig.Builder> modelCompilationConfig) {
            return this.modelCompilationConfig((ModelCompilationConfig)((ModelCompilationConfig.Builder)ModelCompilationConfig.builder().applyMutation(modelCompilationConfig)).build());
        }

        public Builder modelShardingConfig(ModelShardingConfig var1);

        default public Builder modelShardingConfig(Consumer<ModelShardingConfig.Builder> modelShardingConfig) {
            return this.modelShardingConfig((ModelShardingConfig)((ModelShardingConfig.Builder)ModelShardingConfig.builder().applyMutation(modelShardingConfig)).build());
        }
    }
}

