/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EdgeModel;
import software.amazon.awssdk.services.sagemaker.model.EdgeModelsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeDeviceResponse> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceArn").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceArn)).setter(DescribeDeviceResponse.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceName)).setter(DescribeDeviceResponse.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::description)).setter(DescribeDeviceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceFleetName)).setter(DescribeDeviceResponse.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<String> IOT_THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IotThingName").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::iotThingName)).setter(DescribeDeviceResponse.setter(Builder::iotThingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotThingName").build()}).build();
    private static final SdkField<Instant> REGISTRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RegistrationTime").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::registrationTime)).setter(DescribeDeviceResponse.setter(Builder::registrationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationTime").build()}).build();
    private static final SdkField<Instant> LATEST_HEARTBEAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestHeartbeat").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::latestHeartbeat)).setter(DescribeDeviceResponse.setter(Builder::latestHeartbeat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestHeartbeat").build()}).build();
    private static final SdkField<List<EdgeModel>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Models").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::models)).setter(DescribeDeviceResponse.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxModels").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::maxModels)).setter(DescribeDeviceResponse.setter(Builder::maxModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxModels").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::nextToken)).setter(DescribeDeviceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentVersion").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::agentVersion)).setter(DescribeDeviceResponse.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD, DEVICE_NAME_FIELD, DESCRIPTION_FIELD, DEVICE_FLEET_NAME_FIELD, IOT_THING_NAME_FIELD, REGISTRATION_TIME_FIELD, LATEST_HEARTBEAT_FIELD, MODELS_FIELD, MAX_MODELS_FIELD, NEXT_TOKEN_FIELD, AGENT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDeviceResponse.memberNameToFieldInitializer();
    private final String deviceArn;
    private final String deviceName;
    private final String description;
    private final String deviceFleetName;
    private final String iotThingName;
    private final Instant registrationTime;
    private final Instant latestHeartbeat;
    private final List<EdgeModel> models;
    private final Integer maxModels;
    private final String nextToken;
    private final String agentVersion;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.deviceName = builder.deviceName;
        this.description = builder.description;
        this.deviceFleetName = builder.deviceFleetName;
        this.iotThingName = builder.iotThingName;
        this.registrationTime = builder.registrationTime;
        this.latestHeartbeat = builder.latestHeartbeat;
        this.models = builder.models;
        this.maxModels = builder.maxModels;
        this.nextToken = builder.nextToken;
        this.agentVersion = builder.agentVersion;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final String description() {
        return this.description;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final String iotThingName() {
        return this.iotThingName;
    }

    public final Instant registrationTime() {
        return this.registrationTime;
    }

    public final Instant latestHeartbeat() {
        return this.latestHeartbeat;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<EdgeModel> models() {
        return this.models;
    }

    public final Integer maxModels() {
        return this.maxModels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotThingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestHeartbeat());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxModels());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse)((Object)obj);
        return Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && Objects.equals(this.iotThingName(), other.iotThingName()) && Objects.equals(this.registrationTime(), other.registrationTime()) && Objects.equals(this.latestHeartbeat(), other.latestHeartbeat()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && Objects.equals(this.maxModels(), other.maxModels()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.agentVersion(), other.agentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceResponse").add("DeviceArn", (Object)this.deviceArn()).add("DeviceName", (Object)this.deviceName()).add("Description", (Object)this.description()).add("DeviceFleetName", (Object)this.deviceFleetName()).add("IotThingName", (Object)this.iotThingName()).add("RegistrationTime", (Object)this.registrationTime()).add("LatestHeartbeat", (Object)this.latestHeartbeat()).add("Models", this.hasModels() ? this.models() : null).add("MaxModels", (Object)this.maxModels()).add("NextToken", (Object)this.nextToken()).add("AgentVersion", (Object)this.agentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "IotThingName": {
                return Optional.ofNullable(clazz.cast(this.iotThingName()));
            }
            case "RegistrationTime": {
                return Optional.ofNullable(clazz.cast(this.registrationTime()));
            }
            case "LatestHeartbeat": {
                return Optional.ofNullable(clazz.cast(this.latestHeartbeat()));
            }
            case "Models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "MaxModels": {
                return Optional.ofNullable(clazz.cast(this.maxModels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AgentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceArn", DEVICE_ARN_FIELD);
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeviceFleetName", DEVICE_FLEET_NAME_FIELD);
        map.put("IotThingName", IOT_THING_NAME_FIELD);
        map.put("RegistrationTime", REGISTRATION_TIME_FIELD);
        map.put("LatestHeartbeat", LATEST_HEARTBEAT_FIELD);
        map.put("Models", MODELS_FIELD);
        map.put("MaxModels", MAX_MODELS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AgentVersion", AGENT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String deviceArn;
        private String deviceName;
        private String description;
        private String deviceFleetName;
        private String iotThingName;
        private Instant registrationTime;
        private Instant latestHeartbeat;
        private List<EdgeModel> models = DefaultSdkAutoConstructList.getInstance();
        private Integer maxModels;
        private String nextToken;
        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            this.deviceArn(model.deviceArn);
            this.deviceName(model.deviceName);
            this.description(model.description);
            this.deviceFleetName(model.deviceFleetName);
            this.iotThingName(model.iotThingName);
            this.registrationTime(model.registrationTime);
            this.latestHeartbeat(model.latestHeartbeat);
            this.models(model.models);
            this.maxModels(model.maxModels);
            this.nextToken(model.nextToken);
            this.agentVersion(model.agentVersion);
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final String getIotThingName() {
            return this.iotThingName;
        }

        public final void setIotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
        }

        @Override
        public final Builder iotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
            return this;
        }

        public final Instant getRegistrationTime() {
            return this.registrationTime;
        }

        public final void setRegistrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
        }

        @Override
        public final Builder registrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
            return this;
        }

        public final Instant getLatestHeartbeat() {
            return this.latestHeartbeat;
        }

        public final void setLatestHeartbeat(Instant latestHeartbeat) {
            this.latestHeartbeat = latestHeartbeat;
        }

        @Override
        public final Builder latestHeartbeat(Instant latestHeartbeat) {
            this.latestHeartbeat = latestHeartbeat;
            return this;
        }

        public final List<EdgeModel.Builder> getModels() {
            List<EdgeModel.Builder> result = EdgeModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<EdgeModel.BuilderImpl> models) {
            this.models = EdgeModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<EdgeModel> models) {
            this.models = EdgeModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(EdgeModel ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<EdgeModel.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (EdgeModel)((EdgeModel.Builder)EdgeModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxModels() {
            return this.maxModels;
        }

        public final void setMaxModels(Integer maxModels) {
            this.maxModels = maxModels;
        }

        @Override
        public final Builder maxModels(Integer maxModels) {
            this.maxModels = maxModels;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceResponse> {
        public Builder deviceArn(String var1);

        public Builder deviceName(String var1);

        public Builder description(String var1);

        public Builder deviceFleetName(String var1);

        public Builder iotThingName(String var1);

        public Builder registrationTime(Instant var1);

        public Builder latestHeartbeat(Instant var1);

        public Builder models(Collection<EdgeModel> var1);

        public Builder models(EdgeModel ... var1);

        public Builder models(Consumer<EdgeModel.Builder> ... var1);

        public Builder maxModels(Integer var1);

        public Builder nextToken(String var1);

        public Builder agentVersion(String var1);
    }
}

