/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType;
import software.amazon.awssdk.services.sagemaker.model.AutoMLDataSource;
import software.amazon.awssdk.services.sagemaker.model.CompressionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLJobChannel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLJobChannel> {
    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelType").getter(AutoMLJobChannel.getter(AutoMLJobChannel::channelTypeAsString)).setter(AutoMLJobChannel.setter(Builder::channelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(AutoMLJobChannel.getter(AutoMLJobChannel::contentType)).setter(AutoMLJobChannel.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionType").getter(AutoMLJobChannel.getter(AutoMLJobChannel::compressionTypeAsString)).setter(AutoMLJobChannel.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final SdkField<AutoMLDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(AutoMLJobChannel.getter(AutoMLJobChannel::dataSource)).setter(AutoMLJobChannel.setter(Builder::dataSource)).constructor(AutoMLDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_TYPE_FIELD, CONTENT_TYPE_FIELD, COMPRESSION_TYPE_FIELD, DATA_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoMLJobChannel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channelType;
    private final String contentType;
    private final String compressionType;
    private final AutoMLDataSource dataSource;

    private AutoMLJobChannel(BuilderImpl builder) {
        this.channelType = builder.channelType;
        this.contentType = builder.contentType;
        this.compressionType = builder.compressionType;
        this.dataSource = builder.dataSource;
    }

    public final AutoMLChannelType channelType() {
        return AutoMLChannelType.fromValue(this.channelType);
    }

    public final String channelTypeAsString() {
        return this.channelType;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final CompressionType compressionType() {
        return CompressionType.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public final AutoMLDataSource dataSource() {
        return this.dataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobChannel)) {
            return false;
        }
        AutoMLJobChannel other = (AutoMLJobChannel)obj;
        return Objects.equals(this.channelTypeAsString(), other.channelTypeAsString()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && Objects.equals(this.dataSource(), other.dataSource());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLJobChannel").add("ChannelType", (Object)this.channelTypeAsString()).add("ContentType", (Object)this.contentType()).add("CompressionType", (Object)this.compressionTypeAsString()).add("DataSource", (Object)this.dataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelType": {
                return Optional.ofNullable(clazz.cast(this.channelTypeAsString()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelType", CHANNEL_TYPE_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("CompressionType", COMPRESSION_TYPE_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobChannel, T> g) {
        return obj -> g.apply((AutoMLJobChannel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelType;
        private String contentType;
        private String compressionType;
        private AutoMLDataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobChannel model) {
            this.channelType(model.channelType);
            this.contentType(model.contentType);
            this.compressionType(model.compressionType);
            this.dataSource(model.dataSource);
        }

        public final String getChannelType() {
            return this.channelType;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(AutoMLChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final AutoMLDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(AutoMLDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(AutoMLDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public AutoMLJobChannel build() {
            return new AutoMLJobChannel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLJobChannel> {
        public Builder channelType(String var1);

        public Builder channelType(AutoMLChannelType var1);

        public Builder contentType(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionType var1);

        public Builder dataSource(AutoMLDataSource var1);

        default public Builder dataSource(Consumer<AutoMLDataSource.Builder> dataSource) {
            return this.dataSource((AutoMLDataSource)((AutoMLDataSource.Builder)AutoMLDataSource.builder().applyMutation(dataSource)).build());
        }
    }
}

