/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3vectors.S3VectorsAsyncClient;
import software.amazon.awssdk.services.s3vectors.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3vectors.model.ListOutputVector;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse;

public class ListVectorsPublisher
implements SdkPublisher<ListVectorsResponse> {
    private final S3VectorsAsyncClient client;
    private final ListVectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVectorsPublisher(S3VectorsAsyncClient client, ListVectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVectorsPublisher(S3VectorsAsyncClient client, ListVectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListOutputVector> vectors() {
        return this.flatMapIterable(response -> response.vectors());
    }

    private class ListVectorsResponseFetcher
    implements AsyncPageFetcher<ListVectorsResponse> {
        private ListVectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListVectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVectorsResponse> nextPage(ListVectorsResponse previousPage) {
            if (previousPage == null) {
                return ListVectorsPublisher.this.client.listVectors(ListVectorsPublisher.this.firstRequest);
            }
            return ListVectorsPublisher.this.client.listVectors((ListVectorsRequest)((Object)ListVectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

