/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3vectors.S3VectorsClient;
import software.amazon.awssdk.services.s3vectors.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3vectors.model.ListOutputVector;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse;

public class ListVectorsIterable
implements SdkIterable<ListVectorsResponse> {
    private final S3VectorsClient client;
    private final ListVectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVectorsIterable(S3VectorsClient client, ListVectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVectorsResponseFetcher();
    }

    public Iterator<ListVectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListOutputVector> vectors() {
        Function<ListVectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vectors() != null) {
                return response.vectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVectorsResponseFetcher
    implements SyncPageFetcher<ListVectorsResponse> {
        private ListVectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListVectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVectorsResponse nextPage(ListVectorsResponse previousPage) {
            if (previousPage == null) {
                return ListVectorsIterable.this.client.listVectors(ListVectorsIterable.this.firstRequest);
            }
            return ListVectorsIterable.this.client.listVectors((ListVectorsRequest)((Object)ListVectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

