/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3vectors.model.NonFilterableMetadataKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataConfiguration> {
    private static final SdkField<List<String>> NON_FILTERABLE_METADATA_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nonFilterableMetadataKeys").getter(MetadataConfiguration.getter(MetadataConfiguration::nonFilterableMetadataKeys)).setter(MetadataConfiguration.setter(Builder::nonFilterableMetadataKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonFilterableMetadataKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_FILTERABLE_METADATA_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetadataConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> nonFilterableMetadataKeys;

    private MetadataConfiguration(BuilderImpl builder) {
        this.nonFilterableMetadataKeys = builder.nonFilterableMetadataKeys;
    }

    public final boolean hasNonFilterableMetadataKeys() {
        return this.nonFilterableMetadataKeys != null && !(this.nonFilterableMetadataKeys instanceof SdkAutoConstructList);
    }

    public final List<String> nonFilterableMetadataKeys() {
        return this.nonFilterableMetadataKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonFilterableMetadataKeys() ? this.nonFilterableMetadataKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfiguration)) {
            return false;
        }
        MetadataConfiguration other = (MetadataConfiguration)obj;
        return this.hasNonFilterableMetadataKeys() == other.hasNonFilterableMetadataKeys() && Objects.equals(this.nonFilterableMetadataKeys(), other.nonFilterableMetadataKeys());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataConfiguration").add("NonFilterableMetadataKeys", this.hasNonFilterableMetadataKeys() ? this.nonFilterableMetadataKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nonFilterableMetadataKeys": {
                return Optional.ofNullable(clazz.cast(this.nonFilterableMetadataKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("nonFilterableMetadataKeys", NON_FILTERABLE_METADATA_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfiguration, T> g) {
        return obj -> g.apply((MetadataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> nonFilterableMetadataKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfiguration model) {
            this.nonFilterableMetadataKeys(model.nonFilterableMetadataKeys);
        }

        public final Collection<String> getNonFilterableMetadataKeys() {
            if (this.nonFilterableMetadataKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nonFilterableMetadataKeys;
        }

        public final void setNonFilterableMetadataKeys(Collection<String> nonFilterableMetadataKeys) {
            this.nonFilterableMetadataKeys = NonFilterableMetadataKeysCopier.copy(nonFilterableMetadataKeys);
        }

        @Override
        public final Builder nonFilterableMetadataKeys(Collection<String> nonFilterableMetadataKeys) {
            this.nonFilterableMetadataKeys = NonFilterableMetadataKeysCopier.copy(nonFilterableMetadataKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonFilterableMetadataKeys(String ... nonFilterableMetadataKeys) {
            this.nonFilterableMetadataKeys(Arrays.asList(nonFilterableMetadataKeys));
            return this;
        }

        public MetadataConfiguration build() {
            return new MetadataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataConfiguration> {
        public Builder nonFilterableMetadataKeys(Collection<String> var1);

        public Builder nonFilterableMetadataKeys(String ... var1);
    }
}

