/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndexSummary> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketName").getter(IndexSummary.getter(IndexSummary::vectorBucketName)).setter(IndexSummary.setter(Builder::vectorBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(IndexSummary.getter(IndexSummary::indexName)).setter(IndexSummary.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexArn").getter(IndexSummary.getter(IndexSummary::indexArn)).setter(IndexSummary.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(IndexSummary.getter(IndexSummary::creationTime)).setter(IndexSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD, INDEX_NAME_FIELD, INDEX_ARN_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IndexSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vectorBucketName;
    private final String indexName;
    private final String indexArn;
    private final Instant creationTime;

    private IndexSummary(BuilderImpl builder) {
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.creationTime = builder.creationTime;
    }

    public final String vectorBucketName() {
        return this.vectorBucketName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexSummary)) {
            return false;
        }
        IndexSummary other = (IndexSummary)obj;
        return Objects.equals(this.vectorBucketName(), other.vectorBucketName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"IndexSummary").add("VectorBucketName", (Object)this.vectorBucketName()).add("IndexName", (Object)this.indexName()).add("IndexArn", (Object)this.indexArn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vectorBucketName": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketName()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "indexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexSummary, T> g) {
        return obj -> g.apply((IndexSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vectorBucketName;
        private String indexName;
        private String indexArn;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexSummary model) {
            this.vectorBucketName(model.vectorBucketName);
            this.indexName(model.indexName);
            this.indexArn(model.indexArn);
            this.creationTime(model.creationTime);
        }

        public final String getVectorBucketName() {
            return this.vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public IndexSummary build() {
            return new IndexSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndexSummary> {
        public Builder vectorBucketName(String var1);

        public Builder indexName(String var1);

        public Builder indexArn(String var1);

        public Builder creationTime(Instant var1);
    }
}

