/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsInputListCopier;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVectorsRequest
extends S3VectorsRequest
implements ToCopyableBuilder<Builder, DeleteVectorsRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketName").getter(DeleteVectorsRequest.getter(DeleteVectorsRequest::vectorBucketName)).setter(DeleteVectorsRequest.setter(Builder::vectorBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(DeleteVectorsRequest.getter(DeleteVectorsRequest::indexName)).setter(DeleteVectorsRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexArn").getter(DeleteVectorsRequest.getter(DeleteVectorsRequest::indexArn)).setter(DeleteVectorsRequest.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()}).build();
    private static final SdkField<List<String>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keys").getter(DeleteVectorsRequest.getter(DeleteVectorsRequest::keys)).setter(DeleteVectorsRequest.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD, INDEX_NAME_FIELD, INDEX_ARN_FIELD, KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteVectorsRequest.memberNameToFieldInitializer();
    private final String vectorBucketName;
    private final String indexName;
    private final String indexArn;
    private final List<String> keys;

    private DeleteVectorsRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.keys = builder.keys;
    }

    public final String vectorBucketName() {
        return this.vectorBucketName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public final List<String> keys() {
        return this.keys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVectorsRequest)) {
            return false;
        }
        DeleteVectorsRequest other = (DeleteVectorsRequest)((Object)obj);
        return Objects.equals(this.vectorBucketName(), other.vectorBucketName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexArn(), other.indexArn()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteVectorsRequest").add("VectorBucketName", (Object)this.vectorBucketName()).add("IndexName", (Object)this.indexName()).add("IndexArn", (Object)this.indexArn()).add("Keys", this.hasKeys() ? this.keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vectorBucketName": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketName()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "indexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("keys", KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVectorsRequest, T> g) {
        return obj -> g.apply((DeleteVectorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3VectorsRequest.BuilderImpl
    implements Builder {
        private String vectorBucketName;
        private String indexName;
        private String indexArn;
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVectorsRequest model) {
            super(model);
            this.vectorBucketName(model.vectorBucketName);
            this.indexName(model.indexName);
            this.indexArn(model.indexArn);
            this.keys(model.keys);
        }

        public final String getVectorBucketName() {
            return this.vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Collection<String> getKeys() {
            if (this.keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = DeleteVectorsInputListCopier.copy(keys);
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = DeleteVectorsInputListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVectorsRequest build() {
            return new DeleteVectorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3VectorsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteVectorsRequest> {
        public Builder vectorBucketName(String var1);

        public Builder indexName(String var1);

        public Builder indexArn(String var1);

        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

