/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.services.s3tables.model.TableRecordExpirationJobMetrics;
import software.amazon.awssdk.services.s3tables.model.TableRecordExpirationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableRecordExpirationJobStatusResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, GetTableRecordExpirationJobStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTableRecordExpirationJobStatusResponse.getter(GetTableRecordExpirationJobStatusResponse::statusAsString)).setter(GetTableRecordExpirationJobStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_RUN_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRunTimestamp").getter(GetTableRecordExpirationJobStatusResponse.getter(GetTableRecordExpirationJobStatusResponse::lastRunTimestamp)).setter(GetTableRecordExpirationJobStatusResponse.setter(Builder::lastRunTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(GetTableRecordExpirationJobStatusResponse.getter(GetTableRecordExpirationJobStatusResponse::failureMessage)).setter(GetTableRecordExpirationJobStatusResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<TableRecordExpirationJobMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metrics").getter(GetTableRecordExpirationJobStatusResponse.getter(GetTableRecordExpirationJobStatusResponse::metrics)).setter(GetTableRecordExpirationJobStatusResponse.setter(Builder::metrics)).constructor(TableRecordExpirationJobMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LAST_RUN_TIMESTAMP_FIELD, FAILURE_MESSAGE_FIELD, METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTableRecordExpirationJobStatusResponse.memberNameToFieldInitializer();
    private final String status;
    private final Instant lastRunTimestamp;
    private final String failureMessage;
    private final TableRecordExpirationJobMetrics metrics;

    private GetTableRecordExpirationJobStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.lastRunTimestamp = builder.lastRunTimestamp;
        this.failureMessage = builder.failureMessage;
        this.metrics = builder.metrics;
    }

    public final TableRecordExpirationJobStatus status() {
        return TableRecordExpirationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastRunTimestamp() {
        return this.lastRunTimestamp;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final TableRecordExpirationJobMetrics metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableRecordExpirationJobStatusResponse)) {
            return false;
        }
        GetTableRecordExpirationJobStatusResponse other = (GetTableRecordExpirationJobStatusResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastRunTimestamp(), other.lastRunTimestamp()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.metrics(), other.metrics());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableRecordExpirationJobStatusResponse").add("Status", (Object)this.statusAsString()).add("LastRunTimestamp", (Object)this.lastRunTimestamp()).add("FailureMessage", (Object)this.failureMessage()).add("Metrics", (Object)this.metrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastRunTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRunTimestamp()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("lastRunTimestamp", LAST_RUN_TIMESTAMP_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableRecordExpirationJobStatusResponse, T> g) {
        return obj -> g.apply((GetTableRecordExpirationJobStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String status;
        private Instant lastRunTimestamp;
        private String failureMessage;
        private TableRecordExpirationJobMetrics metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableRecordExpirationJobStatusResponse model) {
            super(model);
            this.status(model.status);
            this.lastRunTimestamp(model.lastRunTimestamp);
            this.failureMessage(model.failureMessage);
            this.metrics(model.metrics);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableRecordExpirationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastRunTimestamp() {
            return this.lastRunTimestamp;
        }

        public final void setLastRunTimestamp(Instant lastRunTimestamp) {
            this.lastRunTimestamp = lastRunTimestamp;
        }

        @Override
        public final Builder lastRunTimestamp(Instant lastRunTimestamp) {
            this.lastRunTimestamp = lastRunTimestamp;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final TableRecordExpirationJobMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(TableRecordExpirationJobMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(TableRecordExpirationJobMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        @Override
        public GetTableRecordExpirationJobStatusResponse build() {
            return new GetTableRecordExpirationJobStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableRecordExpirationJobStatusResponse> {
        public Builder status(String var1);

        public Builder status(TableRecordExpirationJobStatus var1);

        public Builder lastRunTimestamp(Instant var1);

        public Builder failureMessage(String var1);

        public Builder metrics(TableRecordExpirationJobMetrics var1);

        default public Builder metrics(Consumer<TableRecordExpirationJobMetrics.Builder> metrics) {
            return this.metrics((TableRecordExpirationJobMetrics)((TableRecordExpirationJobMetrics.Builder)TableRecordExpirationJobMetrics.builder().applyMutation(metrics)).build());
        }
    }
}

