/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3tables.model.ReplicationDestinationStatusModel;
import software.amazon.awssdk.services.s3tables.model.ReplicationDestinationStatusesCopier;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableReplicationStatusResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, GetTableReplicationStatusResponse> {
    private static final SdkField<String> SOURCE_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceTableArn").getter(GetTableReplicationStatusResponse.getter(GetTableReplicationStatusResponse::sourceTableArn)).setter(GetTableReplicationStatusResponse.setter(Builder::sourceTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTableArn").build()}).build();
    private static final SdkField<List<ReplicationDestinationStatusModel>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinations").getter(GetTableReplicationStatusResponse.getter(GetTableReplicationStatusResponse::destinations)).setter(GetTableReplicationStatusResponse.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationDestinationStatusModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TABLE_ARN_FIELD, DESTINATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTableReplicationStatusResponse.memberNameToFieldInitializer();
    private final String sourceTableArn;
    private final List<ReplicationDestinationStatusModel> destinations;

    private GetTableReplicationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.sourceTableArn = builder.sourceTableArn;
        this.destinations = builder.destinations;
    }

    public final String sourceTableArn() {
        return this.sourceTableArn;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<ReplicationDestinationStatusModel> destinations() {
        return this.destinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableReplicationStatusResponse)) {
            return false;
        }
        GetTableReplicationStatusResponse other = (GetTableReplicationStatusResponse)((Object)obj);
        return Objects.equals(this.sourceTableArn(), other.sourceTableArn()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableReplicationStatusResponse").add("SourceTableArn", (Object)this.sourceTableArn()).add("Destinations", this.hasDestinations() ? this.destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceTableArn": {
                return Optional.ofNullable(clazz.cast(this.sourceTableArn()));
            }
            case "destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceTableArn", SOURCE_TABLE_ARN_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableReplicationStatusResponse, T> g) {
        return obj -> g.apply((GetTableReplicationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String sourceTableArn;
        private List<ReplicationDestinationStatusModel> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableReplicationStatusResponse model) {
            super(model);
            this.sourceTableArn(model.sourceTableArn);
            this.destinations(model.destinations);
        }

        public final String getSourceTableArn() {
            return this.sourceTableArn;
        }

        public final void setSourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
        }

        @Override
        public final Builder sourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
            return this;
        }

        public final List<ReplicationDestinationStatusModel.Builder> getDestinations() {
            List<ReplicationDestinationStatusModel.Builder> result = ReplicationDestinationStatusesCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<ReplicationDestinationStatusModel.BuilderImpl> destinations) {
            this.destinations = ReplicationDestinationStatusesCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<ReplicationDestinationStatusModel> destinations) {
            this.destinations = ReplicationDestinationStatusesCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(ReplicationDestinationStatusModel ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<ReplicationDestinationStatusModel.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (ReplicationDestinationStatusModel)((ReplicationDestinationStatusModel.Builder)ReplicationDestinationStatusModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTableReplicationStatusResponse build() {
            return new GetTableReplicationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableReplicationStatusResponse> {
        public Builder sourceTableArn(String var1);

        public Builder destinations(Collection<ReplicationDestinationStatusModel> var1);

        public Builder destinations(ReplicationDestinationStatusModel ... var1);

        public Builder destinations(Consumer<ReplicationDestinationStatusModel.Builder> ... var1);
    }
}

