/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergUnreferencedFileRemovalSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergUnreferencedFileRemovalSettings> {
    private static final SdkField<Integer> UNREFERENCED_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("unreferencedDays").getter(IcebergUnreferencedFileRemovalSettings.getter(IcebergUnreferencedFileRemovalSettings::unreferencedDays)).setter(IcebergUnreferencedFileRemovalSettings.setter(Builder::unreferencedDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unreferencedDays").build()}).build();
    private static final SdkField<Integer> NON_CURRENT_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nonCurrentDays").getter(IcebergUnreferencedFileRemovalSettings.getter(IcebergUnreferencedFileRemovalSettings::nonCurrentDays)).setter(IcebergUnreferencedFileRemovalSettings.setter(Builder::nonCurrentDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonCurrentDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNREFERENCED_DAYS_FIELD, NON_CURRENT_DAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergUnreferencedFileRemovalSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer unreferencedDays;
    private final Integer nonCurrentDays;

    private IcebergUnreferencedFileRemovalSettings(BuilderImpl builder) {
        this.unreferencedDays = builder.unreferencedDays;
        this.nonCurrentDays = builder.nonCurrentDays;
    }

    public final Integer unreferencedDays() {
        return this.unreferencedDays;
    }

    public final Integer nonCurrentDays() {
        return this.nonCurrentDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unreferencedDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCurrentDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergUnreferencedFileRemovalSettings)) {
            return false;
        }
        IcebergUnreferencedFileRemovalSettings other = (IcebergUnreferencedFileRemovalSettings)obj;
        return Objects.equals(this.unreferencedDays(), other.unreferencedDays()) && Objects.equals(this.nonCurrentDays(), other.nonCurrentDays());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergUnreferencedFileRemovalSettings").add("UnreferencedDays", (Object)this.unreferencedDays()).add("NonCurrentDays", (Object)this.nonCurrentDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "unreferencedDays": {
                return Optional.ofNullable(clazz.cast(this.unreferencedDays()));
            }
            case "nonCurrentDays": {
                return Optional.ofNullable(clazz.cast(this.nonCurrentDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("unreferencedDays", UNREFERENCED_DAYS_FIELD);
        map.put("nonCurrentDays", NON_CURRENT_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergUnreferencedFileRemovalSettings, T> g) {
        return obj -> g.apply((IcebergUnreferencedFileRemovalSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer unreferencedDays;
        private Integer nonCurrentDays;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergUnreferencedFileRemovalSettings model) {
            this.unreferencedDays(model.unreferencedDays);
            this.nonCurrentDays(model.nonCurrentDays);
        }

        public final Integer getUnreferencedDays() {
            return this.unreferencedDays;
        }

        public final void setUnreferencedDays(Integer unreferencedDays) {
            this.unreferencedDays = unreferencedDays;
        }

        @Override
        public final Builder unreferencedDays(Integer unreferencedDays) {
            this.unreferencedDays = unreferencedDays;
            return this;
        }

        public final Integer getNonCurrentDays() {
            return this.nonCurrentDays;
        }

        public final void setNonCurrentDays(Integer nonCurrentDays) {
            this.nonCurrentDays = nonCurrentDays;
        }

        @Override
        public final Builder nonCurrentDays(Integer nonCurrentDays) {
            this.nonCurrentDays = nonCurrentDays;
            return this;
        }

        public IcebergUnreferencedFileRemovalSettings build() {
            return new IcebergUnreferencedFileRemovalSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergUnreferencedFileRemovalSettings> {
        public Builder unreferencedDays(Integer var1);

        public Builder nonCurrentDays(Integer var1);
    }
}

