/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableMaintenanceJobStatusValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableMaintenanceJobStatusValue> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TableMaintenanceJobStatusValue.getter(TableMaintenanceJobStatusValue::statusAsString)).setter(TableMaintenanceJobStatusValue.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_RUN_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRunTimestamp").getter(TableMaintenanceJobStatusValue.getter(TableMaintenanceJobStatusValue::lastRunTimestamp)).setter(TableMaintenanceJobStatusValue.setter(Builder::lastRunTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(TableMaintenanceJobStatusValue.getter(TableMaintenanceJobStatusValue::failureMessage)).setter(TableMaintenanceJobStatusValue.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LAST_RUN_TIMESTAMP_FIELD, FAILURE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableMaintenanceJobStatusValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant lastRunTimestamp;
    private final String failureMessage;

    private TableMaintenanceJobStatusValue(BuilderImpl builder) {
        this.status = builder.status;
        this.lastRunTimestamp = builder.lastRunTimestamp;
        this.failureMessage = builder.failureMessage;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastRunTimestamp() {
        return this.lastRunTimestamp;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMaintenanceJobStatusValue)) {
            return false;
        }
        TableMaintenanceJobStatusValue other = (TableMaintenanceJobStatusValue)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastRunTimestamp(), other.lastRunTimestamp()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"TableMaintenanceJobStatusValue").add("Status", (Object)this.statusAsString()).add("LastRunTimestamp", (Object)this.lastRunTimestamp()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastRunTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRunTimestamp()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("lastRunTimestamp", LAST_RUN_TIMESTAMP_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableMaintenanceJobStatusValue, T> g) {
        return obj -> g.apply((TableMaintenanceJobStatusValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant lastRunTimestamp;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TableMaintenanceJobStatusValue model) {
            this.status(model.status);
            this.lastRunTimestamp(model.lastRunTimestamp);
            this.failureMessage(model.failureMessage);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastRunTimestamp() {
            return this.lastRunTimestamp;
        }

        public final void setLastRunTimestamp(Instant lastRunTimestamp) {
            this.lastRunTimestamp = lastRunTimestamp;
        }

        @Override
        public final Builder lastRunTimestamp(Instant lastRunTimestamp) {
            this.lastRunTimestamp = lastRunTimestamp;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public TableMaintenanceJobStatusValue build() {
            return new TableMaintenanceJobStatusValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableMaintenanceJobStatusValue> {
        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder lastRunTimestamp(Instant var1);

        public Builder failureMessage(String var1);
    }
}

