/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableMetadataLocationRequest extends S3TablesRequest implements
        ToCopyableBuilder<UpdateTableMetadataLocationRequest.Builder, UpdateTableMetadataLocationRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableBucketARN").getter(getter(UpdateTableMetadataLocationRequest::tableBucketARN))
            .setter(setter(Builder::tableBucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(UpdateTableMetadataLocationRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateTableMetadataLocationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionToken").getter(getter(UpdateTableMetadataLocationRequest::versionToken))
            .setter(setter(Builder::versionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()).build();

    private static final SdkField<String> METADATA_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataLocation").getter(getter(UpdateTableMetadataLocationRequest::metadataLocation))
            .setter(setter(Builder::metadataLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD,
            NAMESPACE_FIELD, NAME_FIELD, VERSION_TOKEN_FIELD, METADATA_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
                    put("namespace", NAMESPACE_FIELD);
                    put("name", NAME_FIELD);
                    put("versionToken", VERSION_TOKEN_FIELD);
                    put("metadataLocation", METADATA_LOCATION_FIELD);
                }
            });

    private final String tableBucketARN;

    private final String namespace;

    private final String name;

    private final String versionToken;

    private final String metadataLocation;

    private UpdateTableMetadataLocationRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.versionToken = builder.versionToken;
        this.metadataLocation = builder.metadataLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table bucket.
     */
    public final String tableBucketARN() {
        return tableBucketARN;
    }

    /**
     * <p>
     * The namespace of the table.
     * </p>
     * 
     * @return The namespace of the table.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version token of the table.
     * </p>
     * 
     * @return The version token of the table.
     */
    public final String versionToken() {
        return versionToken;
    }

    /**
     * <p>
     * The new metadata location for the table.
     * </p>
     * 
     * @return The new metadata location for the table.
     */
    public final String metadataLocation() {
        return metadataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionToken());
        hashCode = 31 * hashCode + Objects.hashCode(metadataLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableMetadataLocationRequest)) {
            return false;
        }
        UpdateTableMetadataLocationRequest other = (UpdateTableMetadataLocationRequest) obj;
        return Objects.equals(tableBucketARN(), other.tableBucketARN()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(name(), other.name()) && Objects.equals(versionToken(), other.versionToken())
                && Objects.equals(metadataLocation(), other.metadataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableMetadataLocationRequest").add("TableBucketARN", tableBucketARN())
                .add("Namespace", namespace()).add("Name", name()).add("VersionToken", versionToken())
                .add("MetadataLocation", metadataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableBucketARN":
            return Optional.ofNullable(clazz.cast(tableBucketARN()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "versionToken":
            return Optional.ofNullable(clazz.cast(versionToken()));
        case "metadataLocation":
            return Optional.ofNullable(clazz.cast(metadataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableMetadataLocationRequest, T> g) {
        return obj -> g.apply((UpdateTableMetadataLocationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTableMetadataLocationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table bucket.
         * </p>
         * 
         * @param tableBucketARN
         *        The Amazon Resource Name (ARN) of the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBucketARN(String tableBucketARN);

        /**
         * <p>
         * The namespace of the table.
         * </p>
         * 
         * @param namespace
         *        The namespace of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param name
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version token of the table.
         * </p>
         * 
         * @param versionToken
         *        The version token of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionToken(String versionToken);

        /**
         * <p>
         * The new metadata location for the table.
         * </p>
         * 
         * @param metadataLocation
         *        The new metadata location for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataLocation(String metadataLocation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3TablesRequest.BuilderImpl implements Builder {
        private String tableBucketARN;

        private String namespace;

        private String name;

        private String versionToken;

        private String metadataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableMetadataLocationRequest model) {
            super(model);
            tableBucketARN(model.tableBucketARN);
            namespace(model.namespace);
            name(model.name);
            versionToken(model.versionToken);
            metadataLocation(model.metadataLocation);
        }

        public final String getTableBucketARN() {
            return tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionToken() {
            return versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public final String getMetadataLocation() {
            return metadataLocation;
        }

        public final void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @Override
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableMetadataLocationRequest build() {
            return new UpdateTableMetadataLocationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
