/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the status of a maintenance job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableMaintenanceJobStatusValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TableMaintenanceJobStatusValue.Builder, TableMaintenanceJobStatusValue> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TableMaintenanceJobStatusValue::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_RUN_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastRunTimestamp")
            .getter(getter(TableMaintenanceJobStatusValue::lastRunTimestamp))
            .setter(setter(Builder::lastRunTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(TableMaintenanceJobStatusValue::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            LAST_RUN_TIMESTAMP_FIELD, FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("status", STATUS_FIELD);
                    put("lastRunTimestamp", LAST_RUN_TIMESTAMP_FIELD);
                    put("failureMessage", FAILURE_MESSAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant lastRunTimestamp;

    private final String failureMessage;

    private TableMaintenanceJobStatusValue(BuilderImpl builder) {
        this.status = builder.status;
        this.lastRunTimestamp = builder.lastRunTimestamp;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the maintenance job was last run.
     * </p>
     * 
     * @return The date and time that the maintenance job was last run.
     */
    public final Instant lastRunTimestamp() {
        return lastRunTimestamp;
    }

    /**
     * <p>
     * The failure message of a failed job.
     * </p>
     * 
     * @return The failure message of a failed job.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMaintenanceJobStatusValue)) {
            return false;
        }
        TableMaintenanceJobStatusValue other = (TableMaintenanceJobStatusValue) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastRunTimestamp(), other.lastRunTimestamp())
                && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableMaintenanceJobStatusValue").add("Status", statusAsString())
                .add("LastRunTimestamp", lastRunTimestamp()).add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastRunTimestamp":
            return Optional.ofNullable(clazz.cast(lastRunTimestamp()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableMaintenanceJobStatusValue, T> g) {
        return obj -> g.apply((TableMaintenanceJobStatusValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableMaintenanceJobStatusValue> {
        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param status
         *        The status of the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param status
         *        The status of the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * The date and time that the maintenance job was last run.
         * </p>
         * 
         * @param lastRunTimestamp
         *        The date and time that the maintenance job was last run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunTimestamp(Instant lastRunTimestamp);

        /**
         * <p>
         * The failure message of a failed job.
         * </p>
         * 
         * @param failureMessage
         *        The failure message of a failed job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant lastRunTimestamp;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TableMaintenanceJobStatusValue model) {
            status(model.status);
            lastRunTimestamp(model.lastRunTimestamp);
            failureMessage(model.failureMessage);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastRunTimestamp() {
            return lastRunTimestamp;
        }

        public final void setLastRunTimestamp(Instant lastRunTimestamp) {
            this.lastRunTimestamp = lastRunTimestamp;
        }

        @Override
        public final Builder lastRunTimestamp(Instant lastRunTimestamp) {
            this.lastRunTimestamp = lastRunTimestamp;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public TableMaintenanceJobStatusValue build() {
            return new TableMaintenanceJobStatusValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
