/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the values that define the maintenance configuration for a table bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableBucketMaintenanceConfigurationValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TableBucketMaintenanceConfigurationValue.Builder, TableBucketMaintenanceConfigurationValue> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TableBucketMaintenanceConfigurationValue::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<TableBucketMaintenanceSettings> SETTINGS_FIELD = SdkField
            .<TableBucketMaintenanceSettings> builder(MarshallingType.SDK_POJO).memberName("settings")
            .getter(getter(TableBucketMaintenanceConfigurationValue::settings)).setter(setter(Builder::settings))
            .constructor(TableBucketMaintenanceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("status", STATUS_FIELD);
                    put("settings", SETTINGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String status;

    private final TableBucketMaintenanceSettings settings;

    private TableBucketMaintenanceConfigurationValue(BuilderImpl builder) {
        this.status = builder.status;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The status of the maintenance configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the maintenance configuration.
     * @see MaintenanceStatus
     */
    public final MaintenanceStatus status() {
        return MaintenanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the maintenance configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the maintenance configuration.
     * @see MaintenanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Contains details about the settings of the maintenance configuration.
     * </p>
     * 
     * @return Contains details about the settings of the maintenance configuration.
     */
    public final TableBucketMaintenanceSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableBucketMaintenanceConfigurationValue)) {
            return false;
        }
        TableBucketMaintenanceConfigurationValue other = (TableBucketMaintenanceConfigurationValue) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableBucketMaintenanceConfigurationValue").add("Status", statusAsString())
                .add("Settings", settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableBucketMaintenanceConfigurationValue, T> g) {
        return obj -> g.apply((TableBucketMaintenanceConfigurationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableBucketMaintenanceConfigurationValue> {
        /**
         * <p>
         * The status of the maintenance configuration.
         * </p>
         * 
         * @param status
         *        The status of the maintenance configuration.
         * @see MaintenanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the maintenance configuration.
         * </p>
         * 
         * @param status
         *        The status of the maintenance configuration.
         * @see MaintenanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceStatus
         */
        Builder status(MaintenanceStatus status);

        /**
         * <p>
         * Contains details about the settings of the maintenance configuration.
         * </p>
         * 
         * @param settings
         *        Contains details about the settings of the maintenance configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(TableBucketMaintenanceSettings settings);

        /**
         * <p>
         * Contains details about the settings of the maintenance configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableBucketMaintenanceSettings.Builder}
         * avoiding the need to create one manually via {@link TableBucketMaintenanceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBucketMaintenanceSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #settings(TableBucketMaintenanceSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link TableBucketMaintenanceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(TableBucketMaintenanceSettings)
         */
        default Builder settings(Consumer<TableBucketMaintenanceSettings.Builder> settings) {
            return settings(TableBucketMaintenanceSettings.builder().applyMutation(settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private TableBucketMaintenanceSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(TableBucketMaintenanceConfigurationValue model) {
            status(model.status);
            settings(model.settings);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TableBucketMaintenanceSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(TableBucketMaintenanceSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(TableBucketMaintenanceSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public TableBucketMaintenanceConfigurationValue build() {
            return new TableBucketMaintenanceConfigurationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
