/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTableBucketsResponse extends S3TablesResponse implements
        ToCopyableBuilder<ListTableBucketsResponse.Builder, ListTableBucketsResponse> {
    private static final SdkField<List<TableBucketSummary>> TABLE_BUCKETS_FIELD = SdkField
            .<List<TableBucketSummary>> builder(MarshallingType.LIST)
            .memberName("tableBuckets")
            .getter(getter(ListTableBucketsResponse::tableBuckets))
            .setter(setter(Builder::tableBuckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableBuckets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableBucketSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableBucketSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("continuationToken").getter(getter(ListTableBucketsResponse::continuationToken))
            .setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKETS_FIELD,
            CONTINUATION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("tableBuckets", TABLE_BUCKETS_FIELD);
                    put("continuationToken", CONTINUATION_TOKEN_FIELD);
                }
            });

    private final List<TableBucketSummary> tableBuckets;

    private final String continuationToken;

    private ListTableBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.tableBuckets = builder.tableBuckets;
        this.continuationToken = builder.continuationToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableBuckets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTableBuckets() {
        return tableBuckets != null && !(tableBuckets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of table buckets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableBuckets} method.
     * </p>
     * 
     * @return A list of table buckets.
     */
    public final List<TableBucketSummary> tableBuckets() {
        return tableBuckets;
    }

    /**
     * <p>
     * You can use this <code>ContinuationToken</code> for pagination of the list results.
     * </p>
     * 
     * @return You can use this <code>ContinuationToken</code> for pagination of the list results.
     */
    public final String continuationToken() {
        return continuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTableBuckets() ? tableBuckets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableBucketsResponse)) {
            return false;
        }
        ListTableBucketsResponse other = (ListTableBucketsResponse) obj;
        return hasTableBuckets() == other.hasTableBuckets() && Objects.equals(tableBuckets(), other.tableBuckets())
                && Objects.equals(continuationToken(), other.continuationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTableBucketsResponse").add("TableBuckets", hasTableBuckets() ? tableBuckets() : null)
                .add("ContinuationToken", continuationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableBuckets":
            return Optional.ofNullable(clazz.cast(tableBuckets()));
        case "continuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTableBucketsResponse, T> g) {
        return obj -> g.apply((ListTableBucketsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTableBucketsResponse> {
        /**
         * <p>
         * A list of table buckets.
         * </p>
         * 
         * @param tableBuckets
         *        A list of table buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBuckets(Collection<TableBucketSummary> tableBuckets);

        /**
         * <p>
         * A list of table buckets.
         * </p>
         * 
         * @param tableBuckets
         *        A list of table buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBuckets(TableBucketSummary... tableBuckets);

        /**
         * <p>
         * A list of table buckets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3tables.model.TableBucketSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.s3tables.model.TableBucketSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3tables.model.TableBucketSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #tableBuckets(List<TableBucketSummary>)}.
         * 
         * @param tableBuckets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3tables.model.TableBucketSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableBuckets(java.util.Collection<TableBucketSummary>)
         */
        Builder tableBuckets(Consumer<TableBucketSummary.Builder>... tableBuckets);

        /**
         * <p>
         * You can use this <code>ContinuationToken</code> for pagination of the list results.
         * </p>
         * 
         * @param continuationToken
         *        You can use this <code>ContinuationToken</code> for pagination of the list results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);
    }

    static final class BuilderImpl extends S3TablesResponse.BuilderImpl implements Builder {
        private List<TableBucketSummary> tableBuckets = DefaultSdkAutoConstructList.getInstance();

        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableBucketsResponse model) {
            super(model);
            tableBuckets(model.tableBuckets);
            continuationToken(model.continuationToken);
        }

        public final List<TableBucketSummary.Builder> getTableBuckets() {
            List<TableBucketSummary.Builder> result = TableBucketSummaryListCopier.copyToBuilder(this.tableBuckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableBuckets(Collection<TableBucketSummary.BuilderImpl> tableBuckets) {
            this.tableBuckets = TableBucketSummaryListCopier.copyFromBuilder(tableBuckets);
        }

        @Override
        public final Builder tableBuckets(Collection<TableBucketSummary> tableBuckets) {
            this.tableBuckets = TableBucketSummaryListCopier.copy(tableBuckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableBuckets(TableBucketSummary... tableBuckets) {
            tableBuckets(Arrays.asList(tableBuckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableBuckets(Consumer<TableBucketSummary.Builder>... tableBuckets) {
            tableBuckets(Stream.of(tableBuckets).map(c -> TableBucketSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        @Override
        public ListTableBucketsResponse build() {
            return new ListTableBucketsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
