/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the snapshot management settings for an Iceberg table. The oldest snapshot expires when its
 * age exceeds the <code>maxSnapshotAgeHours</code> and the total number of snapshots exceeds the value for the minimum
 * number of snapshots to keep <code>minSnapshotsToKeep</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergSnapshotManagementSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergSnapshotManagementSettings.Builder, IcebergSnapshotManagementSettings> {
    private static final SdkField<Integer> MIN_SNAPSHOTS_TO_KEEP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minSnapshotsToKeep").getter(getter(IcebergSnapshotManagementSettings::minSnapshotsToKeep))
            .setter(setter(Builder::minSnapshotsToKeep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSnapshotsToKeep").build())
            .build();

    private static final SdkField<Integer> MAX_SNAPSHOT_AGE_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxSnapshotAgeHours").getter(getter(IcebergSnapshotManagementSettings::maxSnapshotAgeHours))
            .setter(setter(Builder::maxSnapshotAgeHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSnapshotAgeHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_SNAPSHOTS_TO_KEEP_FIELD,
            MAX_SNAPSHOT_AGE_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("minSnapshotsToKeep", MIN_SNAPSHOTS_TO_KEEP_FIELD);
                    put("maxSnapshotAgeHours", MAX_SNAPSHOT_AGE_HOURS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer minSnapshotsToKeep;

    private final Integer maxSnapshotAgeHours;

    private IcebergSnapshotManagementSettings(BuilderImpl builder) {
        this.minSnapshotsToKeep = builder.minSnapshotsToKeep;
        this.maxSnapshotAgeHours = builder.maxSnapshotAgeHours;
    }

    /**
     * <p>
     * The minimum number of snapshots to keep.
     * </p>
     * 
     * @return The minimum number of snapshots to keep.
     */
    public final Integer minSnapshotsToKeep() {
        return minSnapshotsToKeep;
    }

    /**
     * <p>
     * The maximum age of a snapshot before it can be expired.
     * </p>
     * 
     * @return The maximum age of a snapshot before it can be expired.
     */
    public final Integer maxSnapshotAgeHours() {
        return maxSnapshotAgeHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minSnapshotsToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(maxSnapshotAgeHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergSnapshotManagementSettings)) {
            return false;
        }
        IcebergSnapshotManagementSettings other = (IcebergSnapshotManagementSettings) obj;
        return Objects.equals(minSnapshotsToKeep(), other.minSnapshotsToKeep())
                && Objects.equals(maxSnapshotAgeHours(), other.maxSnapshotAgeHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergSnapshotManagementSettings").add("MinSnapshotsToKeep", minSnapshotsToKeep())
                .add("MaxSnapshotAgeHours", maxSnapshotAgeHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minSnapshotsToKeep":
            return Optional.ofNullable(clazz.cast(minSnapshotsToKeep()));
        case "maxSnapshotAgeHours":
            return Optional.ofNullable(clazz.cast(maxSnapshotAgeHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IcebergSnapshotManagementSettings, T> g) {
        return obj -> g.apply((IcebergSnapshotManagementSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergSnapshotManagementSettings> {
        /**
         * <p>
         * The minimum number of snapshots to keep.
         * </p>
         * 
         * @param minSnapshotsToKeep
         *        The minimum number of snapshots to keep.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSnapshotsToKeep(Integer minSnapshotsToKeep);

        /**
         * <p>
         * The maximum age of a snapshot before it can be expired.
         * </p>
         * 
         * @param maxSnapshotAgeHours
         *        The maximum age of a snapshot before it can be expired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSnapshotAgeHours(Integer maxSnapshotAgeHours);
    }

    static final class BuilderImpl implements Builder {
        private Integer minSnapshotsToKeep;

        private Integer maxSnapshotAgeHours;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergSnapshotManagementSettings model) {
            minSnapshotsToKeep(model.minSnapshotsToKeep);
            maxSnapshotAgeHours(model.maxSnapshotAgeHours);
        }

        public final Integer getMinSnapshotsToKeep() {
            return minSnapshotsToKeep;
        }

        public final void setMinSnapshotsToKeep(Integer minSnapshotsToKeep) {
            this.minSnapshotsToKeep = minSnapshotsToKeep;
        }

        @Override
        public final Builder minSnapshotsToKeep(Integer minSnapshotsToKeep) {
            this.minSnapshotsToKeep = minSnapshotsToKeep;
            return this;
        }

        public final Integer getMaxSnapshotAgeHours() {
            return maxSnapshotAgeHours;
        }

        public final void setMaxSnapshotAgeHours(Integer maxSnapshotAgeHours) {
            this.maxSnapshotAgeHours = maxSnapshotAgeHours;
        }

        @Override
        public final Builder maxSnapshotAgeHours(Integer maxSnapshotAgeHours) {
            this.maxSnapshotAgeHours = maxSnapshotAgeHours;
            return this;
        }

        @Override
        public IcebergSnapshotManagementSettings build() {
            return new IcebergSnapshotManagementSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
