/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableMaintenanceConfigurationResponse extends S3TablesResponse implements
        ToCopyableBuilder<GetTableMaintenanceConfigurationResponse.Builder, GetTableMaintenanceConfigurationResponse> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableARN").getter(getter(GetTableMaintenanceConfigurationResponse::tableARN))
            .setter(setter(Builder::tableARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()).build();

    private static final SdkField<Map<String, TableMaintenanceConfigurationValue>> CONFIGURATION_FIELD = SdkField
            .<Map<String, TableMaintenanceConfigurationValue>> builder(MarshallingType.MAP)
            .memberName("configuration")
            .getter(getter(GetTableMaintenanceConfigurationResponse::configurationAsStrings))
            .setter(setter(Builder::configurationWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TableMaintenanceConfigurationValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableMaintenanceConfigurationValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD,
            CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("tableARN", TABLE_ARN_FIELD);
                    put("configuration", CONFIGURATION_FIELD);
                }
            });

    private final String tableARN;

    private final Map<String, TableMaintenanceConfigurationValue> configuration;

    private GetTableMaintenanceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.tableARN = builder.tableARN;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table.
     */
    public final String tableARN() {
        return tableARN;
    }

    /**
     * <p>
     * Details about the maintenance configuration for the table bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguration} method.
     * </p>
     * 
     * @return Details about the maintenance configuration for the table bucket.
     */
    public final Map<TableMaintenanceType, TableMaintenanceConfigurationValue> configuration() {
        return TableMaintenanceConfigurationCopier.copyStringToEnum(configuration);
    }

    /**
     * For responses, this returns true if the service returned a value for the Configuration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfiguration() {
        return configuration != null && !(configuration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details about the maintenance configuration for the table bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguration} method.
     * </p>
     * 
     * @return Details about the maintenance configuration for the table bucket.
     */
    public final Map<String, TableMaintenanceConfigurationValue> configurationAsStrings() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfiguration() ? configurationAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMaintenanceConfigurationResponse)) {
            return false;
        }
        GetTableMaintenanceConfigurationResponse other = (GetTableMaintenanceConfigurationResponse) obj;
        return Objects.equals(tableARN(), other.tableARN()) && hasConfiguration() == other.hasConfiguration()
                && Objects.equals(configurationAsStrings(), other.configurationAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableMaintenanceConfigurationResponse").add("TableARN", tableARN())
                .add("Configuration", hasConfiguration() ? configurationAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableARN":
            return Optional.ofNullable(clazz.cast(tableARN()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configurationAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTableMaintenanceConfigurationResponse, T> g) {
        return obj -> g.apply((GetTableMaintenanceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTableMaintenanceConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table.
         * </p>
         * 
         * @param tableARN
         *        The Amazon Resource Name (ARN) of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableARN(String tableARN);

        /**
         * <p>
         * Details about the maintenance configuration for the table bucket.
         * </p>
         * 
         * @param configuration
         *        Details about the maintenance configuration for the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationWithStrings(Map<String, TableMaintenanceConfigurationValue> configuration);

        /**
         * <p>
         * Details about the maintenance configuration for the table bucket.
         * </p>
         * 
         * @param configuration
         *        Details about the maintenance configuration for the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Map<TableMaintenanceType, TableMaintenanceConfigurationValue> configuration);
    }

    static final class BuilderImpl extends S3TablesResponse.BuilderImpl implements Builder {
        private String tableARN;

        private Map<String, TableMaintenanceConfigurationValue> configuration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMaintenanceConfigurationResponse model) {
            super(model);
            tableARN(model.tableARN);
            configurationWithStrings(model.configuration);
        }

        public final String getTableARN() {
            return tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final Map<String, TableMaintenanceConfigurationValue.Builder> getConfiguration() {
            Map<String, TableMaintenanceConfigurationValue.Builder> result = TableMaintenanceConfigurationCopier
                    .copyToBuilder(this.configuration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfiguration(Map<String, TableMaintenanceConfigurationValue.BuilderImpl> configuration) {
            this.configuration = TableMaintenanceConfigurationCopier.copyFromBuilder(configuration);
        }

        @Override
        public final Builder configurationWithStrings(Map<String, TableMaintenanceConfigurationValue> configuration) {
            this.configuration = TableMaintenanceConfigurationCopier.copy(configuration);
            return this;
        }

        @Override
        public final Builder configuration(Map<TableMaintenanceType, TableMaintenanceConfigurationValue> configuration) {
            this.configuration = TableMaintenanceConfigurationCopier.copyEnumToString(configuration);
            return this;
        }

        @Override
        public GetTableMaintenanceConfigurationResponse build() {
            return new GetTableMaintenanceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
