/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTableResponse extends S3TablesResponse implements
        ToCopyableBuilder<CreateTableResponse.Builder, CreateTableResponse> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableARN").getter(getter(CreateTableResponse::tableARN)).setter(setter(Builder::tableARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()).build();

    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionToken").getter(getter(CreateTableResponse::versionToken)).setter(setter(Builder::versionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD,
            VERSION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("tableARN", TABLE_ARN_FIELD);
                    put("versionToken", VERSION_TOKEN_FIELD);
                }
            });

    private final String tableARN;

    private final String versionToken;

    private CreateTableResponse(BuilderImpl builder) {
        super(builder);
        this.tableARN = builder.tableARN;
        this.versionToken = builder.versionToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table.
     */
    public final String tableARN() {
        return tableARN;
    }

    /**
     * <p>
     * The version token of the table.
     * </p>
     * 
     * @return The version token of the table.
     */
    public final String versionToken() {
        return versionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(versionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableResponse)) {
            return false;
        }
        CreateTableResponse other = (CreateTableResponse) obj;
        return Objects.equals(tableARN(), other.tableARN()) && Objects.equals(versionToken(), other.versionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTableResponse").add("TableARN", tableARN()).add("VersionToken", versionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableARN":
            return Optional.ofNullable(clazz.cast(tableARN()));
        case "versionToken":
            return Optional.ofNullable(clazz.cast(versionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTableResponse, T> g) {
        return obj -> g.apply((CreateTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTableResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table.
         * </p>
         * 
         * @param tableARN
         *        The Amazon Resource Name (ARN) of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableARN(String tableARN);

        /**
         * <p>
         * The version token of the table.
         * </p>
         * 
         * @param versionToken
         *        The version token of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionToken(String versionToken);
    }

    static final class BuilderImpl extends S3TablesResponse.BuilderImpl implements Builder {
        private String tableARN;

        private String versionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableResponse model) {
            super(model);
            tableARN(model.tableARN);
            versionToken(model.versionToken);
        }

        public final String getTableARN() {
            return tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final String getVersionToken() {
            return versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        @Override
        public CreateTableResponse build() {
            return new CreateTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
