/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.s3tables.auth.scheme.S3TablesAuthSchemeProvider;
import software.amazon.awssdk.services.s3tables.endpoints.S3TablesEndpointProvider;

/**
 * This includes configuration specific to Amazon S3 Tables that is supported by both {@link S3TablesClientBuilder} and
 * {@link S3TablesAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface S3TablesBaseClientBuilder<B extends S3TablesBaseClientBuilder<B, C>, C> extends AwsClientBuilder<B, C> {
    /**
     * Set the {@link S3TablesEndpointProvider} implementation that will be used by the client to determine the endpoint
     * for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B endpointProvider(S3TablesEndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the {@link S3TablesAuthSchemeProvider} implementation that will be used by the client to resolve the auth
     * scheme for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B authSchemeProvider(S3TablesAuthSchemeProvider authSchemeProvider) {
        throw new UnsupportedOperationException();
    }
}
