/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.s3tables.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.s3tables.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.s3tables.model.CreateTableBucketRequest;
import software.amazon.awssdk.services.s3tables.model.CreateTableBucketResponse;
import software.amazon.awssdk.services.s3tables.model.CreateTableRequest;
import software.amazon.awssdk.services.s3tables.model.CreateTableResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketPolicyRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketPolicyResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTablePolicyRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTablePolicyResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTableRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTableResponse;
import software.amazon.awssdk.services.s3tables.model.GetNamespaceRequest;
import software.amazon.awssdk.services.s3tables.model.GetNamespaceResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketPolicyRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketPolicyResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceJobStatusRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceJobStatusResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableMetadataLocationRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableMetadataLocationResponse;
import software.amazon.awssdk.services.s3tables.model.GetTablePolicyRequest;
import software.amazon.awssdk.services.s3tables.model.GetTablePolicyResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableResponse;
import software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest;
import software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse;
import software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest;
import software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse;
import software.amazon.awssdk.services.s3tables.model.ListTablesRequest;
import software.amazon.awssdk.services.s3tables.model.ListTablesResponse;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketPolicyRequest;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketPolicyResponse;
import software.amazon.awssdk.services.s3tables.model.PutTableMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.s3tables.model.PutTableMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.s3tables.model.PutTablePolicyRequest;
import software.amazon.awssdk.services.s3tables.model.PutTablePolicyResponse;
import software.amazon.awssdk.services.s3tables.model.RenameTableRequest;
import software.amazon.awssdk.services.s3tables.model.RenameTableResponse;
import software.amazon.awssdk.services.s3tables.model.UpdateTableMetadataLocationRequest;
import software.amazon.awssdk.services.s3tables.model.UpdateTableMetadataLocationResponse;
import software.amazon.awssdk.services.s3tables.paginators.ListNamespacesPublisher;
import software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsPublisher;
import software.amazon.awssdk.services.s3tables.paginators.ListTablesPublisher;

/**
 * Service client for accessing Amazon S3 Tables asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * An Amazon S3 table represents a structured dataset consisting of tabular data in <a
 * href="https://parquet.apache.org/docs/">Apache Parquet</a> format and related metadata. This data is stored inside an
 * S3 table as a subresource. All tables in a table bucket are stored in the <a
 * href="https://iceberg.apache.org/docs/latest/">Apache Iceberg</a> table format. Through integration with the <a
 * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/glue/latest/dg/catalog-and-crawler.html">AWS Glue Data
 * Catalog</a> you can interact with your tables using AWS analytics services, such as <a
 * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/athena/">Amazon Athena</a> and <a
 * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/redshift/">Amazon Redshift</a>. Amazon S3 manages
 * maintenance of your tables through automatic file compaction and snapshot management. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets.html">Amazon S3 table buckets</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface S3TablesAsyncClient extends AwsClient {
    String SERVICE_NAME = "s3tables";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "s3tables";

    /**
     * <p>
     * Creates a namespace. A namespace is a logical grouping of tables within your table bucket, which you can use to
     * organize tables. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html">Table namespaces</a>.
     * </p>
     *
     * @param createNamespaceRequest
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest createNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a namespace. A namespace is a logical grouping of tables within your table bucket, which you can use to
     * organize tables. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html">Table namespaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNamespaceRequest#builder()}
     * </p>
     *
     * @param createNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.CreateNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNamespaceResponse> createNamespace(
            Consumer<CreateNamespaceRequest.Builder> createNamespaceRequest) {
        return createNamespace(CreateNamespaceRequest.builder().applyMutation(createNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates a new table associated with the given namespace in a table bucket.
     * </p>
     *
     * @param createTableRequest
     * @return A Java Future containing the result of the CreateTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new table associated with the given namespace in a table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTableRequest#builder()}
     * </p>
     *
     * @param createTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.CreateTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTableResponse> createTable(Consumer<CreateTableRequest.Builder> createTableRequest) {
        return createTable(CreateTableRequest.builder().applyMutation(createTableRequest).build());
    }

    /**
     * <p>
     * Creates a table bucket.
     * </p>
     *
     * @param createTableBucketRequest
     * @return A Java Future containing the result of the CreateTableBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.CreateTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateTableBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTableBucketResponse> createTableBucket(CreateTableBucketRequest createTableBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableBucketRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTableBucketRequest#builder()}
     * </p>
     *
     * @param createTableBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.CreateTableBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTableBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.CreateTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateTableBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTableBucketResponse> createTableBucket(
            Consumer<CreateTableBucketRequest.Builder> createTableBucketRequest) {
        return createTableBucket(CreateTableBucketRequest.builder().applyMutation(createTableBucketRequest).build());
    }

    /**
     * <p>
     * Deletes a namespace.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(
            Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest) {
        return deleteNamespace(DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes a table.
     * </p>
     *
     * @param deleteTableRequest
     * @return A Java Future containing the result of the DeleteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTableRequest#builder()}
     * </p>
     *
     * @param deleteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTableResponse> deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest) {
        return deleteTable(DeleteTableRequest.builder().applyMutation(deleteTableRequest).build());
    }

    /**
     * <p>
     * Deletes a table bucket.
     * </p>
     *
     * @param deleteTableBucketRequest
     * @return A Java Future containing the result of the DeleteTableBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTableBucketResponse> deleteTableBucket(DeleteTableBucketRequest deleteTableBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableBucketRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTableBucketRequest#builder()}
     * </p>
     *
     * @param deleteTableBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTableBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTableBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTableBucketResponse> deleteTableBucket(
            Consumer<DeleteTableBucketRequest.Builder> deleteTableBucketRequest) {
        return deleteTableBucket(DeleteTableBucketRequest.builder().applyMutation(deleteTableBucketRequest).build());
    }

    /**
     * <p>
     * Deletes a table bucket policy.
     * </p>
     *
     * @param deleteTableBucketPolicyRequest
     * @return A Java Future containing the result of the DeleteTableBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTableBucketPolicyResponse> deleteTableBucketPolicy(
            DeleteTableBucketPolicyRequest deleteTableBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a table bucket policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableBucketPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTableBucketPolicyRequest#builder()}
     * </p>
     *
     * @param deleteTableBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTableBucketPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTableBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTableBucketPolicyResponse> deleteTableBucketPolicy(
            Consumer<DeleteTableBucketPolicyRequest.Builder> deleteTableBucketPolicyRequest) {
        return deleteTableBucketPolicy(DeleteTableBucketPolicyRequest.builder().applyMutation(deleteTableBucketPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a table policy.
     * </p>
     *
     * @param deleteTablePolicyRequest
     * @return A Java Future containing the result of the DeleteTablePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTablePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTablePolicyResponse> deleteTablePolicy(DeleteTablePolicyRequest deleteTablePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a table policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTablePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTablePolicyRequest#builder()}
     * </p>
     *
     * @param deleteTablePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTablePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTablePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.DeleteTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTablePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTablePolicyResponse> deleteTablePolicy(
            Consumer<DeleteTablePolicyRequest.Builder> deleteTablePolicyRequest) {
        return deleteTablePolicy(DeleteTablePolicyRequest.builder().applyMutation(deleteTablePolicyRequest).build());
    }

    /**
     * <p>
     * Gets details about a namespace.
     * </p>
     *
     * @param getNamespaceRequest
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest getNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNamespaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetNamespaceRequest#builder()}
     * </p>
     *
     * @param getNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetNamespaceResponse> getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest) {
        return getNamespace(GetNamespaceRequest.builder().applyMutation(getNamespaceRequest).build());
    }

    /**
     * <p>
     * Gets details about a table.
     * </p>
     *
     * @param getTableRequest
     * @return A Java Future containing the result of the GetTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableResponse> getTable(GetTableRequest getTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableRequest.Builder} avoiding the need to
     * create one manually via {@link GetTableRequest#builder()}
     * </p>
     *
     * @param getTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableResponse> getTable(Consumer<GetTableRequest.Builder> getTableRequest) {
        return getTable(GetTableRequest.builder().applyMutation(getTableRequest).build());
    }

    /**
     * <p>
     * Gets details on a table bucket.
     * </p>
     *
     * @param getTableBucketRequest
     * @return A Java Future containing the result of the GetTableBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucket" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableBucketResponse> getTableBucket(GetTableBucketRequest getTableBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details on a table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableBucketRequest.Builder} avoiding the need to
     * create one manually via {@link GetTableBucketRequest#builder()}
     * </p>
     *
     * @param getTableBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableBucketRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTableBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucket" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableBucketResponse> getTableBucket(Consumer<GetTableBucketRequest.Builder> getTableBucketRequest) {
        return getTableBucket(GetTableBucketRequest.builder().applyMutation(getTableBucketRequest).build());
    }

    /**
     * <p>
     * Gets details about a maintenance configuration for a given table bucket.
     * </p>
     *
     * @param getTableBucketMaintenanceConfigurationRequest
     * @return A Java Future containing the result of the GetTableBucketMaintenanceConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableBucketMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableBucketMaintenanceConfigurationResponse> getTableBucketMaintenanceConfiguration(
            GetTableBucketMaintenanceConfigurationRequest getTableBucketMaintenanceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a maintenance configuration for a given table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTableBucketMaintenanceConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetTableBucketMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param getTableBucketMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableBucketMaintenanceConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetTableBucketMaintenanceConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableBucketMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableBucketMaintenanceConfigurationResponse> getTableBucketMaintenanceConfiguration(
            Consumer<GetTableBucketMaintenanceConfigurationRequest.Builder> getTableBucketMaintenanceConfigurationRequest) {
        return getTableBucketMaintenanceConfiguration(GetTableBucketMaintenanceConfigurationRequest.builder()
                .applyMutation(getTableBucketMaintenanceConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets details about a table bucket policy.
     * </p>
     *
     * @param getTableBucketPolicyRequest
     * @return A Java Future containing the result of the GetTableBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTableBucketPolicyResponse> getTableBucketPolicy(
            GetTableBucketPolicyRequest getTableBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a table bucket policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetTableBucketPolicyRequest#builder()}
     * </p>
     *
     * @param getTableBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableBucketPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTableBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTableBucketPolicyResponse> getTableBucketPolicy(
            Consumer<GetTableBucketPolicyRequest.Builder> getTableBucketPolicyRequest) {
        return getTableBucketPolicy(GetTableBucketPolicyRequest.builder().applyMutation(getTableBucketPolicyRequest).build());
    }

    /**
     * <p>
     * Gets details about the maintenance configuration of a table.
     * </p>
     *
     * @param getTableMaintenanceConfigurationRequest
     * @return A Java Future containing the result of the GetTableMaintenanceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableMaintenanceConfigurationResponse> getTableMaintenanceConfiguration(
            GetTableMaintenanceConfigurationRequest getTableMaintenanceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about the maintenance configuration of a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableMaintenanceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetTableMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param getTableMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTableMaintenanceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableMaintenanceConfigurationResponse> getTableMaintenanceConfiguration(
            Consumer<GetTableMaintenanceConfigurationRequest.Builder> getTableMaintenanceConfigurationRequest) {
        return getTableMaintenanceConfiguration(GetTableMaintenanceConfigurationRequest.builder()
                .applyMutation(getTableMaintenanceConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the status of a maintenance job for a table.
     * </p>
     *
     * @param getTableMaintenanceJobStatusRequest
     * @return A Java Future containing the result of the GetTableMaintenanceJobStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableMaintenanceJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMaintenanceJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableMaintenanceJobStatusResponse> getTableMaintenanceJobStatus(
            GetTableMaintenanceJobStatusRequest getTableMaintenanceJobStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a maintenance job for a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableMaintenanceJobStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetTableMaintenanceJobStatusRequest#builder()}
     * </p>
     *
     * @param getTableMaintenanceJobStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceJobStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTableMaintenanceJobStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableMaintenanceJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMaintenanceJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableMaintenanceJobStatusResponse> getTableMaintenanceJobStatus(
            Consumer<GetTableMaintenanceJobStatusRequest.Builder> getTableMaintenanceJobStatusRequest) {
        return getTableMaintenanceJobStatus(GetTableMaintenanceJobStatusRequest.builder()
                .applyMutation(getTableMaintenanceJobStatusRequest).build());
    }

    /**
     * <p>
     * Gets the location of the table metadata.
     * </p>
     *
     * @param getTableMetadataLocationRequest
     * @return A Java Future containing the result of the GetTableMetadataLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableMetadataLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMetadataLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableMetadataLocationResponse> getTableMetadataLocation(
            GetTableMetadataLocationRequest getTableMetadataLocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the location of the table metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableMetadataLocationRequest.Builder} avoiding
     * the need to create one manually via {@link GetTableMetadataLocationRequest#builder()}
     * </p>
     *
     * @param getTableMetadataLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableMetadataLocationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTableMetadataLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTableMetadataLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMetadataLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableMetadataLocationResponse> getTableMetadataLocation(
            Consumer<GetTableMetadataLocationRequest.Builder> getTableMetadataLocationRequest) {
        return getTableMetadataLocation(GetTableMetadataLocationRequest.builder().applyMutation(getTableMetadataLocationRequest)
                .build());
    }

    /**
     * <p>
     * Gets details about a table policy.
     * </p>
     *
     * @param getTablePolicyRequest
     * @return A Java Future containing the result of the GetTablePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTablePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTablePolicyResponse> getTablePolicy(GetTablePolicyRequest getTablePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a table policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTablePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetTablePolicyRequest#builder()}
     * </p>
     *
     * @param getTablePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTablePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTablePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.GetTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTablePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTablePolicyResponse> getTablePolicy(Consumer<GetTablePolicyRequest.Builder> getTablePolicyRequest) {
        return getTablePolicy(GetTablePolicyRequest.builder().applyMutation(getTablePolicyRequest).build());
    }

    /**
     * <p>
     * Lists the namespaces within a table bucket.
     * </p>
     *
     * @param listNamespacesRequest
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces(ListNamespacesRequest listNamespacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the namespaces within a table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) {
        return listNamespaces(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxNamespaces won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest)} operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesPublisher listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest) {
        return new ListNamespacesPublisher(this, listNamespacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxNamespaces won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesPublisher listNamespacesPaginator(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) {
        return listNamespacesPaginator(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Lists table buckets for your account.
     * </p>
     *
     * @param listTableBucketsRequest
     * @return A Java Future containing the result of the ListTableBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListTableBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTableBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTableBucketsResponse> listTableBuckets(ListTableBucketsRequest listTableBucketsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists table buckets for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableBucketsRequest#builder()}
     * </p>
     *
     * @param listTableBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTableBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListTableBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTableBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTableBucketsResponse> listTableBuckets(
            Consumer<ListTableBucketsRequest.Builder> listTableBucketsRequest) {
        return listTableBuckets(ListTableBucketsRequest.builder().applyMutation(listTableBucketsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTableBuckets(software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsPublisher publisher = client.listTableBucketsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsPublisher publisher = client.listTableBucketsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableBuckets(software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest)} operation.</b>
     * </p>
     *
     * @param listTableBucketsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListTableBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTableBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableBucketsPublisher listTableBucketsPaginator(ListTableBucketsRequest listTableBucketsRequest) {
        return new ListTableBucketsPublisher(this, listTableBucketsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTableBuckets(software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsPublisher publisher = client.listTableBucketsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsPublisher publisher = client.listTableBucketsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableBuckets(software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableBucketsRequest#builder()}
     * </p>
     *
     * @param listTableBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>AccessDeniedException The action cannot be performed because you do not have the required permission.
     *         </li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListTableBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTableBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableBucketsPublisher listTableBucketsPaginator(Consumer<ListTableBucketsRequest.Builder> listTableBucketsRequest) {
        return listTableBucketsPaginator(ListTableBucketsRequest.builder().applyMutation(listTableBucketsRequest).build());
    }

    /**
     * <p>
     * List tables in the given table bucket.
     * </p>
     *
     * @param listTablesRequest
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tables in the given table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListTablesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTablesResponse> listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return listTables(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.s3tables.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3tables.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3tables.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxTables won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.s3tables.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @param listTablesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesPublisher listTablesPaginator(ListTablesRequest listTablesRequest) {
        return new ListTablesPublisher(this, listTablesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.s3tables.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3tables.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3tables.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxTables won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.s3tables.model.ListTablesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListTablesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesPublisher listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return listTablesPaginator(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing maintenance configuration for a table bucket.
     * </p>
     *
     * @param putTableBucketMaintenanceConfigurationRequest
     * @return A Java Future containing the result of the PutTableBucketMaintenanceConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.PutTableBucketMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutTableBucketMaintenanceConfigurationResponse> putTableBucketMaintenanceConfiguration(
            PutTableBucketMaintenanceConfigurationRequest putTableBucketMaintenanceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing maintenance configuration for a table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutTableBucketMaintenanceConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutTableBucketMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param putTableBucketMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTableBucketMaintenanceConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutTableBucketMaintenanceConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.PutTableBucketMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutTableBucketMaintenanceConfigurationResponse> putTableBucketMaintenanceConfiguration(
            Consumer<PutTableBucketMaintenanceConfigurationRequest.Builder> putTableBucketMaintenanceConfigurationRequest) {
        return putTableBucketMaintenanceConfiguration(PutTableBucketMaintenanceConfigurationRequest.builder()
                .applyMutation(putTableBucketMaintenanceConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing table bucket policy for a table bucket.
     * </p>
     *
     * @param putTableBucketPolicyRequest
     * @return A Java Future containing the result of the PutTableBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.PutTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutTableBucketPolicyResponse> putTableBucketPolicy(
            PutTableBucketPolicyRequest putTableBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing table bucket policy for a table bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTableBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutTableBucketPolicyRequest#builder()}
     * </p>
     *
     * @param putTableBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTableBucketPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutTableBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.PutTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutTableBucketPolicyResponse> putTableBucketPolicy(
            Consumer<PutTableBucketPolicyRequest.Builder> putTableBucketPolicyRequest) {
        return putTableBucketPolicy(PutTableBucketPolicyRequest.builder().applyMutation(putTableBucketPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing maintenance configuration for a table.
     * </p>
     *
     * @param putTableMaintenanceConfigurationRequest
     * @return A Java Future containing the result of the PutTableMaintenanceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.PutTableMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutTableMaintenanceConfigurationResponse> putTableMaintenanceConfiguration(
            PutTableMaintenanceConfigurationRequest putTableMaintenanceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing maintenance configuration for a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTableMaintenanceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutTableMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param putTableMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTableMaintenanceConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutTableMaintenanceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.PutTableMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutTableMaintenanceConfigurationResponse> putTableMaintenanceConfiguration(
            Consumer<PutTableMaintenanceConfigurationRequest.Builder> putTableMaintenanceConfigurationRequest) {
        return putTableMaintenanceConfiguration(PutTableMaintenanceConfigurationRequest.builder()
                .applyMutation(putTableMaintenanceConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing table policy for a table.
     * </p>
     *
     * @param putTablePolicyRequest
     * @return A Java Future containing the result of the PutTablePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.PutTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTablePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutTablePolicyResponse> putTablePolicy(PutTablePolicyRequest putTablePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing table policy for a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTablePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutTablePolicyRequest#builder()}
     * </p>
     *
     * @param putTablePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTablePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutTablePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.PutTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTablePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutTablePolicyResponse> putTablePolicy(Consumer<PutTablePolicyRequest.Builder> putTablePolicyRequest) {
        return putTablePolicy(PutTablePolicyRequest.builder().applyMutation(putTablePolicyRequest).build());
    }

    /**
     * <p>
     * Renames a table or a namespace.
     * </p>
     *
     * @param renameTableRequest
     * @return A Java Future containing the result of the RenameTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.RenameTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/RenameTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RenameTableResponse> renameTable(RenameTableRequest renameTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Renames a table or a namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RenameTableRequest.Builder} avoiding the need to
     * create one manually via {@link RenameTableRequest#builder()}
     * </p>
     *
     * @param renameTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.RenameTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RenameTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.RenameTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/RenameTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RenameTableResponse> renameTable(Consumer<RenameTableRequest.Builder> renameTableRequest) {
        return renameTable(RenameTableRequest.builder().applyMutation(renameTableRequest).build());
    }

    /**
     * <p>
     * Updates the metadata location for a table.
     * </p>
     *
     * @param updateTableMetadataLocationRequest
     * @return A Java Future containing the result of the UpdateTableMetadataLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.UpdateTableMetadataLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/UpdateTableMetadataLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTableMetadataLocationResponse> updateTableMetadataLocation(
            UpdateTableMetadataLocationRequest updateTableMetadataLocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata location for a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTableMetadataLocationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTableMetadataLocationRequest#builder()}
     * </p>
     *
     * @param updateTableMetadataLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.UpdateTableMetadataLocationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateTableMetadataLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException The request failed due to an internal server error.</li>
     *         <li>ForbiddenException The caller isn't authorized to make the request.</li>
     *         <li>NotFoundException The request was rejected because the specified resource could not be found.</li>
     *         <li>TooManyRequestsException The limit on the number of requests per second was exceeded.</li>
     *         <li>ConflictException The request failed because there is a conflict with a previous write. You can retry
     *         the request.</li>
     *         <li>BadRequestException The request is invalid or malformed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3TablesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3TablesAsyncClient.UpdateTableMetadataLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/UpdateTableMetadataLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTableMetadataLocationResponse> updateTableMetadataLocation(
            Consumer<UpdateTableMetadataLocationRequest.Builder> updateTableMetadataLocationRequest) {
        return updateTableMetadataLocation(UpdateTableMetadataLocationRequest.builder()
                .applyMutation(updateTableMetadataLocationRequest).build());
    }

    @Override
    default S3TablesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link S3TablesAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static S3TablesAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link S3TablesAsyncClient}.
     */
    static S3TablesAsyncClientBuilder builder() {
        return new DefaultS3TablesAsyncClientBuilder();
    }
}
