/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Outpost
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Outpost> {
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(Outpost.getter(Outpost::outpostArn)).setter(Outpost.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()}).build();
    private static final SdkField<String> S3_OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutpostArn").getter(Outpost.getter(Outpost::s3OutpostArn)).setter(Outpost.setter(Builder::s3OutpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutpostArn").build()}).build();
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(Outpost.getter(Outpost::outpostId)).setter(Outpost.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(Outpost.getter(Outpost::ownerId)).setter(Outpost.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<Long> CAPACITY_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CapacityInBytes").getter(Outpost.getter(Outpost::capacityInBytes)).setter(Outpost.setter(Builder::capacityInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ARN_FIELD, S3_OUTPOST_ARN_FIELD, OUTPOST_ID_FIELD, OWNER_ID_FIELD, CAPACITY_IN_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Outpost.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outpostArn;
    private final String s3OutpostArn;
    private final String outpostId;
    private final String ownerId;
    private final Long capacityInBytes;

    private Outpost(BuilderImpl builder) {
        this.outpostArn = builder.outpostArn;
        this.s3OutpostArn = builder.s3OutpostArn;
        this.outpostId = builder.outpostId;
        this.ownerId = builder.ownerId;
        this.capacityInBytes = builder.capacityInBytes;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String s3OutpostArn() {
        return this.s3OutpostArn;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final Long capacityInBytes() {
        return this.capacityInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Outpost)) {
            return false;
        }
        Outpost other = (Outpost)obj;
        return Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.s3OutpostArn(), other.s3OutpostArn()) && Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.capacityInBytes(), other.capacityInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"Outpost").add("OutpostArn", (Object)this.outpostArn()).add("S3OutpostArn", (Object)this.s3OutpostArn()).add("OutpostId", (Object)this.outpostId()).add("OwnerId", (Object)this.ownerId()).add("CapacityInBytes", (Object)this.capacityInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "S3OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.s3OutpostArn()));
            }
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CapacityInBytes": {
                return Optional.ofNullable(clazz.cast(this.capacityInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("S3OutpostArn", S3_OUTPOST_ARN_FIELD);
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("CapacityInBytes", CAPACITY_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Outpost, T> g) {
        return obj -> g.apply((Outpost)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outpostArn;
        private String s3OutpostArn;
        private String outpostId;
        private String ownerId;
        private Long capacityInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(Outpost model) {
            this.outpostArn(model.outpostArn);
            this.s3OutpostArn(model.s3OutpostArn);
            this.outpostId(model.outpostId);
            this.ownerId(model.ownerId);
            this.capacityInBytes(model.capacityInBytes);
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getS3OutpostArn() {
            return this.s3OutpostArn;
        }

        public final void setS3OutpostArn(String s3OutpostArn) {
            this.s3OutpostArn = s3OutpostArn;
        }

        @Override
        public final Builder s3OutpostArn(String s3OutpostArn) {
            this.s3OutpostArn = s3OutpostArn;
            return this;
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Long getCapacityInBytes() {
            return this.capacityInBytes;
        }

        public final void setCapacityInBytes(Long capacityInBytes) {
            this.capacityInBytes = capacityInBytes;
        }

        @Override
        public final Builder capacityInBytes(Long capacityInBytes) {
            this.capacityInBytes = capacityInBytes;
            return this;
        }

        public Outpost build() {
            return new Outpost(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Outpost> {
        public Builder outpostArn(String var1);

        public Builder s3OutpostArn(String var1);

        public Builder outpostId(String var1);

        public Builder ownerId(String var1);

        public Builder capacityInBytes(Long var1);
    }
}

