/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.MatchAnyPrefixCopier;
import software.amazon.awssdk.services.s3control.model.MatchAnySuffixCopier;
import software.amazon.awssdk.services.s3control.model.MatchAnyTagCopier;
import software.amazon.awssdk.services.s3control.model.MatchObjectAge;
import software.amazon.awssdk.services.s3control.model.MatchObjectSize;
import software.amazon.awssdk.services.s3control.model.S3Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageLensGroupAndOperator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageLensGroupAndOperator> {
    private static final SdkField<List<String>> MATCH_ANY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchAnyPrefix").getter(StorageLensGroupAndOperator.getter(StorageLensGroupAndOperator::matchAnyPrefix)).setter(StorageLensGroupAndOperator.setter(Builder::matchAnyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnyPrefix").unmarshallLocationName("MatchAnyPrefix").build(), ListTrait.builder().memberLocationName("Prefix").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("Prefix").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MATCH_ANY_SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchAnySuffix").getter(StorageLensGroupAndOperator.getter(StorageLensGroupAndOperator::matchAnySuffix)).setter(StorageLensGroupAndOperator.setter(Builder::matchAnySuffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnySuffix").unmarshallLocationName("MatchAnySuffix").build(), ListTrait.builder().memberLocationName("Suffix").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suffix").unmarshallLocationName("Suffix").build()}).build()).build()}).build();
    private static final SdkField<List<S3Tag>> MATCH_ANY_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchAnyTag").getter(StorageLensGroupAndOperator.getter(StorageLensGroupAndOperator::matchAnyTag)).setter(StorageLensGroupAndOperator.setter(Builder::matchAnyTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnyTag").unmarshallLocationName("MatchAnyTag").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<MatchObjectAge> MATCH_OBJECT_AGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MatchObjectAge").getter(StorageLensGroupAndOperator.getter(StorageLensGroupAndOperator::matchObjectAge)).setter(StorageLensGroupAndOperator.setter(Builder::matchObjectAge)).constructor(MatchObjectAge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchObjectAge").unmarshallLocationName("MatchObjectAge").build()}).build();
    private static final SdkField<MatchObjectSize> MATCH_OBJECT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MatchObjectSize").getter(StorageLensGroupAndOperator.getter(StorageLensGroupAndOperator::matchObjectSize)).setter(StorageLensGroupAndOperator.setter(Builder::matchObjectSize)).constructor(MatchObjectSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchObjectSize").unmarshallLocationName("MatchObjectSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ANY_PREFIX_FIELD, MATCH_ANY_SUFFIX_FIELD, MATCH_ANY_TAG_FIELD, MATCH_OBJECT_AGE_FIELD, MATCH_OBJECT_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StorageLensGroupAndOperator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> matchAnyPrefix;
    private final List<String> matchAnySuffix;
    private final List<S3Tag> matchAnyTag;
    private final MatchObjectAge matchObjectAge;
    private final MatchObjectSize matchObjectSize;

    private StorageLensGroupAndOperator(BuilderImpl builder) {
        this.matchAnyPrefix = builder.matchAnyPrefix;
        this.matchAnySuffix = builder.matchAnySuffix;
        this.matchAnyTag = builder.matchAnyTag;
        this.matchObjectAge = builder.matchObjectAge;
        this.matchObjectSize = builder.matchObjectSize;
    }

    public final boolean hasMatchAnyPrefix() {
        return this.matchAnyPrefix != null && !(this.matchAnyPrefix instanceof SdkAutoConstructList);
    }

    public final List<String> matchAnyPrefix() {
        return this.matchAnyPrefix;
    }

    public final boolean hasMatchAnySuffix() {
        return this.matchAnySuffix != null && !(this.matchAnySuffix instanceof SdkAutoConstructList);
    }

    public final List<String> matchAnySuffix() {
        return this.matchAnySuffix;
    }

    public final boolean hasMatchAnyTag() {
        return this.matchAnyTag != null && !(this.matchAnyTag instanceof SdkAutoConstructList);
    }

    public final List<S3Tag> matchAnyTag() {
        return this.matchAnyTag;
    }

    public final MatchObjectAge matchObjectAge() {
        return this.matchObjectAge;
    }

    public final MatchObjectSize matchObjectSize() {
        return this.matchObjectSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchAnyPrefix() ? this.matchAnyPrefix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchAnySuffix() ? this.matchAnySuffix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchAnyTag() ? this.matchAnyTag() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.matchObjectAge());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchObjectSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensGroupAndOperator)) {
            return false;
        }
        StorageLensGroupAndOperator other = (StorageLensGroupAndOperator)obj;
        return this.hasMatchAnyPrefix() == other.hasMatchAnyPrefix() && Objects.equals(this.matchAnyPrefix(), other.matchAnyPrefix()) && this.hasMatchAnySuffix() == other.hasMatchAnySuffix() && Objects.equals(this.matchAnySuffix(), other.matchAnySuffix()) && this.hasMatchAnyTag() == other.hasMatchAnyTag() && Objects.equals(this.matchAnyTag(), other.matchAnyTag()) && Objects.equals(this.matchObjectAge(), other.matchObjectAge()) && Objects.equals(this.matchObjectSize(), other.matchObjectSize());
    }

    public final String toString() {
        return ToString.builder((String)"StorageLensGroupAndOperator").add("MatchAnyPrefix", this.hasMatchAnyPrefix() ? this.matchAnyPrefix() : null).add("MatchAnySuffix", this.hasMatchAnySuffix() ? this.matchAnySuffix() : null).add("MatchAnyTag", this.hasMatchAnyTag() ? this.matchAnyTag() : null).add("MatchObjectAge", (Object)this.matchObjectAge()).add("MatchObjectSize", (Object)this.matchObjectSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchAnyPrefix": {
                return Optional.ofNullable(clazz.cast(this.matchAnyPrefix()));
            }
            case "MatchAnySuffix": {
                return Optional.ofNullable(clazz.cast(this.matchAnySuffix()));
            }
            case "MatchAnyTag": {
                return Optional.ofNullable(clazz.cast(this.matchAnyTag()));
            }
            case "MatchObjectAge": {
                return Optional.ofNullable(clazz.cast(this.matchObjectAge()));
            }
            case "MatchObjectSize": {
                return Optional.ofNullable(clazz.cast(this.matchObjectSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MatchAnyPrefix", MATCH_ANY_PREFIX_FIELD);
        map.put("MatchAnySuffix", MATCH_ANY_SUFFIX_FIELD);
        map.put("MatchAnyTag", MATCH_ANY_TAG_FIELD);
        map.put("MatchObjectAge", MATCH_OBJECT_AGE_FIELD);
        map.put("MatchObjectSize", MATCH_OBJECT_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageLensGroupAndOperator, T> g) {
        return obj -> g.apply((StorageLensGroupAndOperator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> matchAnyPrefix = DefaultSdkAutoConstructList.getInstance();
        private List<String> matchAnySuffix = DefaultSdkAutoConstructList.getInstance();
        private List<S3Tag> matchAnyTag = DefaultSdkAutoConstructList.getInstance();
        private MatchObjectAge matchObjectAge;
        private MatchObjectSize matchObjectSize;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensGroupAndOperator model) {
            this.matchAnyPrefix(model.matchAnyPrefix);
            this.matchAnySuffix(model.matchAnySuffix);
            this.matchAnyTag(model.matchAnyTag);
            this.matchObjectAge(model.matchObjectAge);
            this.matchObjectSize(model.matchObjectSize);
        }

        public final Collection<String> getMatchAnyPrefix() {
            if (this.matchAnyPrefix instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchAnyPrefix;
        }

        public final void setMatchAnyPrefix(Collection<String> matchAnyPrefix) {
            this.matchAnyPrefix = MatchAnyPrefixCopier.copy(matchAnyPrefix);
        }

        @Override
        public final Builder matchAnyPrefix(Collection<String> matchAnyPrefix) {
            this.matchAnyPrefix = MatchAnyPrefixCopier.copy(matchAnyPrefix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnyPrefix(String ... matchAnyPrefix) {
            this.matchAnyPrefix(Arrays.asList(matchAnyPrefix));
            return this;
        }

        public final Collection<String> getMatchAnySuffix() {
            if (this.matchAnySuffix instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchAnySuffix;
        }

        public final void setMatchAnySuffix(Collection<String> matchAnySuffix) {
            this.matchAnySuffix = MatchAnySuffixCopier.copy(matchAnySuffix);
        }

        @Override
        public final Builder matchAnySuffix(Collection<String> matchAnySuffix) {
            this.matchAnySuffix = MatchAnySuffixCopier.copy(matchAnySuffix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnySuffix(String ... matchAnySuffix) {
            this.matchAnySuffix(Arrays.asList(matchAnySuffix));
            return this;
        }

        public final List<S3Tag.Builder> getMatchAnyTag() {
            List<S3Tag.Builder> result = MatchAnyTagCopier.copyToBuilder(this.matchAnyTag);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchAnyTag(Collection<S3Tag.BuilderImpl> matchAnyTag) {
            this.matchAnyTag = MatchAnyTagCopier.copyFromBuilder(matchAnyTag);
        }

        @Override
        public final Builder matchAnyTag(Collection<S3Tag> matchAnyTag) {
            this.matchAnyTag = MatchAnyTagCopier.copy(matchAnyTag);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnyTag(S3Tag ... matchAnyTag) {
            this.matchAnyTag(Arrays.asList(matchAnyTag));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnyTag(Consumer<S3Tag.Builder> ... matchAnyTag) {
            this.matchAnyTag(Stream.of(matchAnyTag).map(c -> (S3Tag)((S3Tag.Builder)S3Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MatchObjectAge.Builder getMatchObjectAge() {
            return this.matchObjectAge != null ? this.matchObjectAge.toBuilder() : null;
        }

        public final void setMatchObjectAge(MatchObjectAge.BuilderImpl matchObjectAge) {
            this.matchObjectAge = matchObjectAge != null ? matchObjectAge.build() : null;
        }

        @Override
        public final Builder matchObjectAge(MatchObjectAge matchObjectAge) {
            this.matchObjectAge = matchObjectAge;
            return this;
        }

        public final MatchObjectSize.Builder getMatchObjectSize() {
            return this.matchObjectSize != null ? this.matchObjectSize.toBuilder() : null;
        }

        public final void setMatchObjectSize(MatchObjectSize.BuilderImpl matchObjectSize) {
            this.matchObjectSize = matchObjectSize != null ? matchObjectSize.build() : null;
        }

        @Override
        public final Builder matchObjectSize(MatchObjectSize matchObjectSize) {
            this.matchObjectSize = matchObjectSize;
            return this;
        }

        public StorageLensGroupAndOperator build() {
            return new StorageLensGroupAndOperator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageLensGroupAndOperator> {
        public Builder matchAnyPrefix(Collection<String> var1);

        public Builder matchAnyPrefix(String ... var1);

        public Builder matchAnySuffix(Collection<String> var1);

        public Builder matchAnySuffix(String ... var1);

        public Builder matchAnyTag(Collection<S3Tag> var1);

        public Builder matchAnyTag(S3Tag ... var1);

        public Builder matchAnyTag(Consumer<S3Tag.Builder> ... var1);

        public Builder matchObjectAge(MatchObjectAge var1);

        default public Builder matchObjectAge(Consumer<MatchObjectAge.Builder> matchObjectAge) {
            return this.matchObjectAge((MatchObjectAge)((MatchObjectAge.Builder)MatchObjectAge.builder().applyMutation(matchObjectAge)).build());
        }

        public Builder matchObjectSize(MatchObjectSize var1);

        default public Builder matchObjectSize(Consumer<MatchObjectSize.Builder> matchObjectSize) {
            return this.matchObjectSize((MatchObjectSize)((MatchObjectSize.Builder)MatchObjectSize.builder().applyMutation(matchObjectSize)).build());
        }
    }
}

