/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationName {
    LAMBDA_INVOKE("LambdaInvoke"),
    S3_PUT_OBJECT_COPY("S3PutObjectCopy"),
    S3_PUT_OBJECT_ACL("S3PutObjectAcl"),
    S3_PUT_OBJECT_TAGGING("S3PutObjectTagging"),
    S3_DELETE_OBJECT_TAGGING("S3DeleteObjectTagging"),
    S3_INITIATE_RESTORE_OBJECT("S3InitiateRestoreObject"),
    S3_PUT_OBJECT_LEGAL_HOLD("S3PutObjectLegalHold"),
    S3_PUT_OBJECT_RETENTION("S3PutObjectRetention"),
    S3_REPLICATE_OBJECT("S3ReplicateObject"),
    S3_COMPUTE_OBJECT_CHECKSUM("S3ComputeObjectChecksum"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationName> VALUE_MAP;
    private final String value;

    private OperationName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationName> knownValues() {
        EnumSet<OperationName> knownValues = EnumSet.allOf(OperationName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationName.class, OperationName::toString);
    }
}

