/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InventoryFormat {
    CSV("CSV"),
    ORC("ORC"),
    PARQUET("Parquet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InventoryFormat> VALUE_MAP;
    private final String value;

    private InventoryFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InventoryFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InventoryFormat> knownValues() {
        EnumSet<InventoryFormat> knownValues = EnumSet.allOf(InventoryFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InventoryFormat.class, InventoryFormat::toString);
    }
}

