/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CreateSessionRequest;
import software.amazon.awssdk.services.s3.model.CreateSessionResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.EncryptionTypeMismatchException;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.InvalidObjectStateException;
import software.amazon.awssdk.services.s3.model.InvalidRequestException;
import software.amazon.awssdk.services.s3.model.InvalidWriteOffsetException;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListDirectoryBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.NoSuchUploadException;
import software.amazon.awssdk.services.s3.model.ObjectAlreadyInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.ObjectNotInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAclRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAclResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.PutBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest;
import software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.TooManyPartsException;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest;
import software.amazon.awssdk.services.s3.model.WriteGetObjectResponseResponse;
import software.amazon.awssdk.services.s3.paginators.ListBucketsIterable;
import software.amazon.awssdk.services.s3.paginators.ListDirectoryBucketsIterable;
import software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable;
import software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.services.s3.paginators.ListPartsIterable;
import software.amazon.awssdk.services.s3.waiters.S3Waiter;

/**
 * Service client for accessing Amazon S3. This can be created using the static {@link #builder()} method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface S3Client extends AwsClient {
    String SERVICE_NAME = "s3";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "s3";

    /**
     * <p>
     * This operation aborts a multipart upload. After a multipart upload is aborted, no additional parts can be
     * uploaded using that upload ID. The storage consumed by any previously uploaded parts will be freed. However, if
     * any part uploads are currently in progress, those part uploads might or might not succeed. As a result, it might
     * be necessary to abort a given multipart upload multiple times in order to completely free all storage consumed by
     * all parts.
     * </p>
     * <p>
     * To verify that all parts have been removed and prevent getting charged for the part storage, you should call the
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a> API operation and
     * ensure that the parts list is empty.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets</b> - If multipart uploads in a directory bucket are in progress, you can't delete the
     * bucket until all the in-progress multipart uploads are aborted or completed. To delete these in-progress
     * multipart uploads, use the <code>ListMultipartUploads</code> operation to list the in-progress multipart uploads
     * in the bucket and use the <code>AbortMultipartUpload</code> operation to abort all the in-progress multipart
     * uploads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - For information about permissions required to use the multipart
     * upload, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload and
     * Permissions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>AbortMultipartUpload</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param abortMultipartUploadRequest
     * @return Result of the AbortMultipartUpload operation returned by the service.
     * @throws NoSuchUploadException
     *         The specified multipart upload does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.AbortMultipartUpload
     */
    default AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest)
            throws NoSuchUploadException, AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation aborts a multipart upload. After a multipart upload is aborted, no additional parts can be
     * uploaded using that upload ID. The storage consumed by any previously uploaded parts will be freed. However, if
     * any part uploads are currently in progress, those part uploads might or might not succeed. As a result, it might
     * be necessary to abort a given multipart upload multiple times in order to completely free all storage consumed by
     * all parts.
     * </p>
     * <p>
     * To verify that all parts have been removed and prevent getting charged for the part storage, you should call the
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a> API operation and
     * ensure that the parts list is empty.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets</b> - If multipart uploads in a directory bucket are in progress, you can't delete the
     * bucket until all the in-progress multipart uploads are aborted or completed. To delete these in-progress
     * multipart uploads, use the <code>ListMultipartUploads</code> operation to list the in-progress multipart uploads
     * in the bucket and use the <code>AbortMultipartUpload</code> operation to abort all the in-progress multipart
     * uploads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - For information about permissions required to use the multipart
     * upload, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload and
     * Permissions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>AbortMultipartUpload</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AbortMultipartUploadRequest.Builder} avoiding the
     * need to create one manually via {@link AbortMultipartUploadRequest#builder()}
     * </p>
     *
     * @param abortMultipartUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest.Builder} to create a request.
     * @return Result of the AbortMultipartUpload operation returned by the service.
     * @throws NoSuchUploadException
     *         The specified multipart upload does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.AbortMultipartUpload
     */
    default AbortMultipartUploadResponse abortMultipartUpload(
            Consumer<AbortMultipartUploadRequest.Builder> abortMultipartUploadRequest) throws NoSuchUploadException,
            AwsServiceException, SdkClientException, S3Exception {
        return abortMultipartUpload(AbortMultipartUploadRequest.builder().applyMutation(abortMultipartUploadRequest).build());
    }

    /**
     * <p>
     * Completes a multipart upload by assembling previously uploaded parts.
     * </p>
     * <p>
     * You first initiate the multipart upload and then upload all parts using the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> operation or the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> operation.
     * After successfully uploading all relevant parts of an upload, you call this <code>CompleteMultipartUpload</code>
     * operation to complete the upload. Upon receiving this request, Amazon S3 concatenates all the parts in ascending
     * order by part number to create a new object. In the CompleteMultipartUpload request, you must provide the parts
     * list and ensure that the parts list is complete. The CompleteMultipartUpload API operation concatenates the parts
     * that you provide in the list. For each part in the list, you must provide the <code>PartNumber</code> value and
     * the <code>ETag</code> value that are returned after that part was uploaded.
     * </p>
     * <p>
     * The processing of a CompleteMultipartUpload request could take several minutes to finalize. After Amazon S3
     * begins processing the request, it sends an HTTP response header that specifies a <code>200 OK</code> response.
     * While processing is in progress, Amazon S3 periodically sends white space characters to keep the connection from
     * timing out. A request could fail after the initial <code>200 OK</code> response has been sent. This means that a
     * <code>200 OK</code> response can contain either a success or an error. The error response might be embedded in
     * the <code>200 OK</code> response. If you call this API operation directly, make sure to design your application
     * to parse the contents of the response and handle it appropriately. If you use Amazon Web Services SDKs, SDKs
     * handle this condition. The SDKs detect the embedded error and apply error handling per your configuration
     * settings (including automatically retrying the request as appropriate). If the condition persists, the SDKs throw
     * an exception (or, for the SDKs that don't use exceptions, they return an error).
     * </p>
     * <p>
     * Note that if <code>CompleteMultipartUpload</code> fails, applications should be prepared to retry any failed
     * requests (including 500 error responses). For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ErrorBestPractices.html">Amazon S3 Error Best
     * Practices</a>.
     * </p>
     * <important>
     * <p>
     * You can't use <code>Content-Type: application/x-www-form-urlencoded</code> for the CompleteMultipartUpload
     * requests. Also, if you don't provide a <code>Content-Type</code> header, <code>CompleteMultipartUpload</code> can
     * still return a <code>200 OK</code> response.
     * </p>
     * </important>
     * <p>
     * For more information about multipart uploads, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart
     * Upload</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - For information about permissions required to use the multipart
     * upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload
     * and Permissions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you provide an <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_Checksum.html">additional checksum
     * value</a> in your <code>MultipartUpload</code> requests and the object is encrypted with Key Management Service,
     * you must have permission to use the <code>kms:Decrypt</code> action for the <code>CompleteMultipartUpload</code>
     * request to succeed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Special errors</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * Error Code: <code>EntityTooSmall</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: Your proposed upload is smaller than the minimum allowed object size. Each part must be at least 5
     * MB in size, except the last part.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 400 Bad Request
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error Code: <code>InvalidPart</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: One or more of the specified parts could not be found. The part might not have been uploaded, or the
     * specified ETag might not have matched the uploaded part's ETag.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 400 Bad Request
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error Code: <code>InvalidPartOrder</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The list of parts was not in ascending order. The parts list must be specified in order by part
     * number.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 400 Bad Request
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error Code: <code>NoSuchUpload</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The specified multipart upload does not exist. The upload ID might be invalid, or the multipart
     * upload might have been aborted or completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 404 Not Found
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>CompleteMultipartUpload</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param completeMultipartUploadRequest
     * @return Result of the CompleteMultipartUpload operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CompleteMultipartUpload
     */
    default CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Completes a multipart upload by assembling previously uploaded parts.
     * </p>
     * <p>
     * You first initiate the multipart upload and then upload all parts using the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> operation or the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> operation.
     * After successfully uploading all relevant parts of an upload, you call this <code>CompleteMultipartUpload</code>
     * operation to complete the upload. Upon receiving this request, Amazon S3 concatenates all the parts in ascending
     * order by part number to create a new object. In the CompleteMultipartUpload request, you must provide the parts
     * list and ensure that the parts list is complete. The CompleteMultipartUpload API operation concatenates the parts
     * that you provide in the list. For each part in the list, you must provide the <code>PartNumber</code> value and
     * the <code>ETag</code> value that are returned after that part was uploaded.
     * </p>
     * <p>
     * The processing of a CompleteMultipartUpload request could take several minutes to finalize. After Amazon S3
     * begins processing the request, it sends an HTTP response header that specifies a <code>200 OK</code> response.
     * While processing is in progress, Amazon S3 periodically sends white space characters to keep the connection from
     * timing out. A request could fail after the initial <code>200 OK</code> response has been sent. This means that a
     * <code>200 OK</code> response can contain either a success or an error. The error response might be embedded in
     * the <code>200 OK</code> response. If you call this API operation directly, make sure to design your application
     * to parse the contents of the response and handle it appropriately. If you use Amazon Web Services SDKs, SDKs
     * handle this condition. The SDKs detect the embedded error and apply error handling per your configuration
     * settings (including automatically retrying the request as appropriate). If the condition persists, the SDKs throw
     * an exception (or, for the SDKs that don't use exceptions, they return an error).
     * </p>
     * <p>
     * Note that if <code>CompleteMultipartUpload</code> fails, applications should be prepared to retry any failed
     * requests (including 500 error responses). For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ErrorBestPractices.html">Amazon S3 Error Best
     * Practices</a>.
     * </p>
     * <important>
     * <p>
     * You can't use <code>Content-Type: application/x-www-form-urlencoded</code> for the CompleteMultipartUpload
     * requests. Also, if you don't provide a <code>Content-Type</code> header, <code>CompleteMultipartUpload</code> can
     * still return a <code>200 OK</code> response.
     * </p>
     * </important>
     * <p>
     * For more information about multipart uploads, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart
     * Upload</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - For information about permissions required to use the multipart
     * upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload
     * and Permissions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you provide an <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_Checksum.html">additional checksum
     * value</a> in your <code>MultipartUpload</code> requests and the object is encrypted with Key Management Service,
     * you must have permission to use the <code>kms:Decrypt</code> action for the <code>CompleteMultipartUpload</code>
     * request to succeed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Special errors</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * Error Code: <code>EntityTooSmall</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: Your proposed upload is smaller than the minimum allowed object size. Each part must be at least 5
     * MB in size, except the last part.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 400 Bad Request
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error Code: <code>InvalidPart</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: One or more of the specified parts could not be found. The part might not have been uploaded, or the
     * specified ETag might not have matched the uploaded part's ETag.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 400 Bad Request
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error Code: <code>InvalidPartOrder</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The list of parts was not in ascending order. The parts list must be specified in order by part
     * number.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 400 Bad Request
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error Code: <code>NoSuchUpload</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The specified multipart upload does not exist. The upload ID might be invalid, or the multipart
     * upload might have been aborted or completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 404 Not Found
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>CompleteMultipartUpload</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteMultipartUploadRequest.Builder} avoiding
     * the need to create one manually via {@link CompleteMultipartUploadRequest#builder()}
     * </p>
     *
     * @param completeMultipartUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest.Builder} to create a
     *        request.
     * @return Result of the CompleteMultipartUpload operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CompleteMultipartUpload
     */
    default CompleteMultipartUploadResponse completeMultipartUpload(
            Consumer<CompleteMultipartUploadRequest.Builder> completeMultipartUploadRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return completeMultipartUpload(CompleteMultipartUploadRequest.builder().applyMutation(completeMultipartUploadRequest)
                .build());
    }

    /**
     * <p>
     * Creates a copy of an object that is already stored in Amazon S3.
     * </p>
     * <note>
     * <p>
     * You can store individual objects of up to 5 TB in Amazon S3. You create a copy of your object up to 5 GB in size
     * in a single atomic action using this API. However, to copy an object greater than 5 GB, you must use the
     * multipart upload Upload Part - Copy (UploadPartCopy) API. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjctsUsingRESTMPUapi.html">Copy Object Using the
     * REST Multipart Upload API</a>.
     * </p>
     * </note>
     * <p>
     * You can copy individual objects between general purpose buckets, between directory buckets, and between general
     * purpose buckets and directory buckets.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Amazon S3 supports copy operations using Multi-Region Access Points only as a destination when using the
     * Multi-Region Access Point ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * VPC endpoints don't support cross-Region requests (including copies). If you're using VPC endpoints, your source
     * and destination buckets should be in the same Amazon Web Services Region as your VPC endpoint.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Both the Region that you want to copy the object from and the Region that you want to copy the object to must be
     * enabled for your account. For more information about how to enable a Region for your account, see <a href=
     * "https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html#manage-acct-regions-enable-standalone"
     * >Enable or disable a Region for standalone accounts</a> in the <i>Amazon Web Services Account Management
     * Guide</i>.
     * </p>
     * <important>
     * <p>
     * Amazon S3 transfer acceleration does not support cross-Region copies. If you request a cross-Region copy using a
     * transfer acceleration endpoint, you get a <code>400 Bad Request</code> error. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a>.
     * </p>
     * </important>
     * <dl>
     * <dt>Authentication and authorization</dt>
     * <dd>
     * <p>
     * All <code>CopyObject</code> requests must be authenticated and signed by using IAM credentials (access key ID and
     * secret access key for the IAM identities). All headers with the <code>x-amz-</code> prefix, including
     * <code>x-amz-copy-source</code>, must be signed. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - You must use the IAM credentials to authenticate and authorize your access to the
     * <code>CopyObject</code> API operation, instead of using the temporary security credentials through the
     * <code>CreateSession</code> API operation.
     * </p>
     * <p>
     * Amazon Web Services CLI or SDKs handles authentication and authorization on your behalf.
     * </p>
     * </dd>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have <i>read</i> access to the source object and <i>write</i> access to the destination bucket.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have permissions in an IAM policy based on the source and
     * destination bucket types in a <code>CopyObject</code> operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source object is in a general purpose bucket, you must have <b> <code>s3:GetObject</code> </b> permission
     * to read the source object that is being copied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the destination bucket is a general purpose bucket, you must have <b> <code>s3:PutObject</code> </b>
     * permission to write the object copy to the destination bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have permissions in a bucket policy or an IAM identity-based
     * policy based on the source and destination bucket types in a <code>CopyObject</code> operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source object that you want to copy is in a directory bucket, you must have the <b>
     * <code>s3express:CreateSession</code> </b> permission in the <code>Action</code> element of a policy to read the
     * object. By default, the session is in the <code>ReadWrite</code> mode. If you want to restrict the access, you
     * can explicitly set the <code>s3express:SessionMode</code> condition key to <code>ReadOnly</code> on the copy
     * source bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the copy destination is a directory bucket, you must have the <b> <code>s3express:CreateSession</code> </b>
     * permission in the <code>Action</code> element of a policy to write the object to the destination. The
     * <code>s3express:SessionMode</code> condition key can't be set to <code>ReadOnly</code> on the copy destination
     * bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * <p>
     * For example policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-identity-policies.html"
     * >Amazon Web Services Identity and Access Management (IAM) identity-based policies for S3 Express One Zone</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Response and special errors</dt>
     * <dd>
     * <p>
     * When the request is an HTTP 1.1 request, the response is chunk encoded. When the request is not an HTTP 1.1
     * request, the response would not contain the <code>Content-Length</code>. You always need to read the entire
     * response body to check if the copy succeeds.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the copy is successful, you receive a response with information about the copied object.
     * </p>
     * </li>
     * <li>
     * <p>
     * A copy request might return an error when Amazon S3 receives the copy request or while Amazon S3 is copying the
     * files. A <code>200 OK</code> response can contain either a success or an error.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the error occurs before the copy action starts, you receive a standard Amazon S3 error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the error occurs during the copy operation, the error response is embedded in the <code>200 OK</code>
     * response. For example, in a cross-region copy, you may encounter throttling and receive a <code>200 OK</code>
     * response. For more information, see <a
     * href="https://repost.aws/knowledge-center/s3-resolve-200-internalerror">Resolve the Error 200 response when
     * copying objects to Amazon S3</a>. The <code>200 OK</code> status code means the copy was accepted, but it doesn't
     * mean the copy is complete. Another example is when you disconnect from Amazon S3 before the copy is complete,
     * Amazon S3 might cancel the copy and you may receive a <code>200 OK</code> response. You must stay connected to
     * Amazon S3 until the entire response is successfully received and processed.
     * </p>
     * <p>
     * If you call this API operation directly, make sure to design your application to parse the content of the
     * response and handle it appropriately. If you use Amazon Web Services SDKs, SDKs handle this condition. The SDKs
     * detect the embedded error and apply error handling per your configuration settings (including automatically
     * retrying the request as appropriate). If the condition persists, the SDKs throw an exception (or, for the SDKs
     * that don't use exceptions, they return an error).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Charge</dt>
     * <dd>
     * <p>
     * The copy request charge is based on the storage class and Region that you specify for the destination object. The
     * request can also result in a data retrieval charge for the source if the source storage class bills for data
     * retrieval. If the copy source is in a different region, the data transfer is billed to the copy source account.
     * For pricing information, see <a href="http://aws.amazon.com/s3/pricing/">Amazon S3 pricing</a>.
     * </p>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>CopyObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param copyObjectRequest
     * @return Result of the CopyObject operation returned by the service.
     * @throws ObjectNotInActiveTierErrorException
     *         The source object of the COPY action is not in the active tier and is only stored in Amazon S3 Glacier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CopyObject
     */
    default CopyObjectResponse copyObject(CopyObjectRequest copyObjectRequest) throws ObjectNotInActiveTierErrorException,
            AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a copy of an object that is already stored in Amazon S3.
     * </p>
     * <note>
     * <p>
     * You can store individual objects of up to 5 TB in Amazon S3. You create a copy of your object up to 5 GB in size
     * in a single atomic action using this API. However, to copy an object greater than 5 GB, you must use the
     * multipart upload Upload Part - Copy (UploadPartCopy) API. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjctsUsingRESTMPUapi.html">Copy Object Using the
     * REST Multipart Upload API</a>.
     * </p>
     * </note>
     * <p>
     * You can copy individual objects between general purpose buckets, between directory buckets, and between general
     * purpose buckets and directory buckets.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Amazon S3 supports copy operations using Multi-Region Access Points only as a destination when using the
     * Multi-Region Access Point ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * VPC endpoints don't support cross-Region requests (including copies). If you're using VPC endpoints, your source
     * and destination buckets should be in the same Amazon Web Services Region as your VPC endpoint.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Both the Region that you want to copy the object from and the Region that you want to copy the object to must be
     * enabled for your account. For more information about how to enable a Region for your account, see <a href=
     * "https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html#manage-acct-regions-enable-standalone"
     * >Enable or disable a Region for standalone accounts</a> in the <i>Amazon Web Services Account Management
     * Guide</i>.
     * </p>
     * <important>
     * <p>
     * Amazon S3 transfer acceleration does not support cross-Region copies. If you request a cross-Region copy using a
     * transfer acceleration endpoint, you get a <code>400 Bad Request</code> error. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a>.
     * </p>
     * </important>
     * <dl>
     * <dt>Authentication and authorization</dt>
     * <dd>
     * <p>
     * All <code>CopyObject</code> requests must be authenticated and signed by using IAM credentials (access key ID and
     * secret access key for the IAM identities). All headers with the <code>x-amz-</code> prefix, including
     * <code>x-amz-copy-source</code>, must be signed. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - You must use the IAM credentials to authenticate and authorize your access to the
     * <code>CopyObject</code> API operation, instead of using the temporary security credentials through the
     * <code>CreateSession</code> API operation.
     * </p>
     * <p>
     * Amazon Web Services CLI or SDKs handles authentication and authorization on your behalf.
     * </p>
     * </dd>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have <i>read</i> access to the source object and <i>write</i> access to the destination bucket.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have permissions in an IAM policy based on the source and
     * destination bucket types in a <code>CopyObject</code> operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source object is in a general purpose bucket, you must have <b> <code>s3:GetObject</code> </b> permission
     * to read the source object that is being copied.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the destination bucket is a general purpose bucket, you must have <b> <code>s3:PutObject</code> </b>
     * permission to write the object copy to the destination bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have permissions in a bucket policy or an IAM identity-based
     * policy based on the source and destination bucket types in a <code>CopyObject</code> operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source object that you want to copy is in a directory bucket, you must have the <b>
     * <code>s3express:CreateSession</code> </b> permission in the <code>Action</code> element of a policy to read the
     * object. By default, the session is in the <code>ReadWrite</code> mode. If you want to restrict the access, you
     * can explicitly set the <code>s3express:SessionMode</code> condition key to <code>ReadOnly</code> on the copy
     * source bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the copy destination is a directory bucket, you must have the <b> <code>s3express:CreateSession</code> </b>
     * permission in the <code>Action</code> element of a policy to write the object to the destination. The
     * <code>s3express:SessionMode</code> condition key can't be set to <code>ReadOnly</code> on the copy destination
     * bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * <p>
     * For example policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-identity-policies.html"
     * >Amazon Web Services Identity and Access Management (IAM) identity-based policies for S3 Express One Zone</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Response and special errors</dt>
     * <dd>
     * <p>
     * When the request is an HTTP 1.1 request, the response is chunk encoded. When the request is not an HTTP 1.1
     * request, the response would not contain the <code>Content-Length</code>. You always need to read the entire
     * response body to check if the copy succeeds.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the copy is successful, you receive a response with information about the copied object.
     * </p>
     * </li>
     * <li>
     * <p>
     * A copy request might return an error when Amazon S3 receives the copy request or while Amazon S3 is copying the
     * files. A <code>200 OK</code> response can contain either a success or an error.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the error occurs before the copy action starts, you receive a standard Amazon S3 error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the error occurs during the copy operation, the error response is embedded in the <code>200 OK</code>
     * response. For example, in a cross-region copy, you may encounter throttling and receive a <code>200 OK</code>
     * response. For more information, see <a
     * href="https://repost.aws/knowledge-center/s3-resolve-200-internalerror">Resolve the Error 200 response when
     * copying objects to Amazon S3</a>. The <code>200 OK</code> status code means the copy was accepted, but it doesn't
     * mean the copy is complete. Another example is when you disconnect from Amazon S3 before the copy is complete,
     * Amazon S3 might cancel the copy and you may receive a <code>200 OK</code> response. You must stay connected to
     * Amazon S3 until the entire response is successfully received and processed.
     * </p>
     * <p>
     * If you call this API operation directly, make sure to design your application to parse the content of the
     * response and handle it appropriately. If you use Amazon Web Services SDKs, SDKs handle this condition. The SDKs
     * detect the embedded error and apply error handling per your configuration settings (including automatically
     * retrying the request as appropriate). If the condition persists, the SDKs throw an exception (or, for the SDKs
     * that don't use exceptions, they return an error).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Charge</dt>
     * <dd>
     * <p>
     * The copy request charge is based on the storage class and Region that you specify for the destination object. The
     * request can also result in a data retrieval charge for the source if the source storage class bills for data
     * retrieval. If the copy source is in a different region, the data transfer is billed to the copy source account.
     * For pricing information, see <a href="http://aws.amazon.com/s3/pricing/">Amazon S3 pricing</a>.
     * </p>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>CopyObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyObjectRequest.Builder} avoiding the need to
     * create one manually via {@link CopyObjectRequest#builder()}
     * </p>
     *
     * @param copyObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.CopyObjectRequest.Builder} to create a request.
     * @return Result of the CopyObject operation returned by the service.
     * @throws ObjectNotInActiveTierErrorException
     *         The source object of the COPY action is not in the active tier and is only stored in Amazon S3 Glacier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CopyObject
     */
    default CopyObjectResponse copyObject(Consumer<CopyObjectRequest.Builder> copyObjectRequest)
            throws ObjectNotInActiveTierErrorException, AwsServiceException, SdkClientException, S3Exception {
        return copyObject(CopyObjectRequest.builder().applyMutation(copyObjectRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action creates an Amazon S3 bucket. To create an Amazon S3 on Outposts bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html"> <code>CreateBucket</code>
     * </a>.
     * </p>
     * </note>
     * <p>
     * Creates a new S3 bucket. To create a bucket, you must set up Amazon S3 and have a valid Amazon Web Services
     * Access Key ID to authenticate requests. Anonymous requests are never allowed to create buckets. By creating the
     * bucket, you become the bucket owner.
     * </p>
     * <p>
     * There are two types of buckets: general purpose buckets and directory buckets. For more information about these
     * bucket types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and
     * working with Amazon S3 buckets</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b> - If you send your <code>CreateBucket</code> request to the
     * <code>s3.amazonaws.com</code> global endpoint, the request goes to the <code>us-east-1</code> Region. So the
     * signature calculations in Signature Version 4 must use <code>us-east-1</code> as the Region, even if the location
     * constraint in the request specifies another Region where the bucket is to be created. If you create a bucket in a
     * Region other than US East (N. Virginia), your application must be able to handle 307 redirect. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html">Virtual hosting of
     * buckets</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - In addition to the <code>s3:CreateBucket</code> permission, the
     * following permissions are required in a policy when your <code>CreateBucket</code> request includes specific
     * headers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Access control lists (ACLs)</b> - In your <code>CreateBucket</code> request, if you specify an access control
     * list (ACL) and set it to <code>public-read</code>, <code>public-read-write</code>,
     * <code>authenticated-read</code>, or if you explicitly specify any other custom ACLs, both
     * <code>s3:CreateBucket</code> and <code>s3:PutBucketAcl</code> permissions are required. In your
     * <code>CreateBucket</code> request, if you set the ACL to <code>private</code>, or if you don't specify any ACLs,
     * only the <code>s3:CreateBucket</code> permission is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Object Lock</b> - In your <code>CreateBucket</code> request, if you set
     * <code>x-amz-bucket-object-lock-enabled</code> to true, the <code>s3:PutBucketObjectLockConfiguration</code> and
     * <code>s3:PutBucketVersioning</code> permissions are required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>S3 Object Ownership</b> - If your <code>CreateBucket</code> request includes the
     * <code>x-amz-object-ownership</code> header, then the <code>s3:PutBucketOwnershipControls</code> permission is
     * required.
     * </p>
     * <important>
     * <p>
     * To set an ACL on a bucket as part of a <code>CreateBucket</code> request, you must explicitly set S3 Object
     * Ownership for the bucket to a different value than the default, <code>BucketOwnerEnforced</code>. Additionally,
     * if your desired bucket ACL grants public access, you must first create the bucket (without the bucket ACL) and
     * then explicitly disable Block Public Access on the bucket before using <code>PutBucketAcl</code> to set the ACL.
     * If you try to create a bucket with a public ACL, the request will fail.
     * </p>
     * <p>
     * For the majority of modern use cases in S3, we recommend that you keep all Block Public Access settings enabled
     * and keep ACLs disabled. If you would like to share data with users outside of your account, you can use bucket
     * policies as needed. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of
     * objects and disabling ACLs for your bucket </a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html">Blocking
     * public access to your Amazon S3 storage </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>S3 Block Public Access</b> - If your specific use case requires granting public access to your S3 resources,
     * you can disable Block Public Access. Specifically, you can create a new bucket with Block Public Access enabled,
     * then separately call the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html">
     * <code>DeletePublicAccessBlock</code> </a> API. To use this operation, you must have the
     * <code>s3:PutBucketPublicAccessBlock</code> permission. For more information about S3 Block Public Access, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html">Blocking
     * public access to your Amazon S3 storage </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:CreateBucket</code> permission in an IAM
     * identity-based policy instead of a bucket policy. Cross-account access to this API operation isn't supported.
     * This operation can only be performed by the Amazon Web Services account that owns the resource. For more
     * information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The permissions for ACLs, Object Lock, S3 Object Ownership, and S3 Block Public Access are not supported for
     * directory buckets. For directory buckets, all Block Public Access settings are enabled at the bucket level and S3
     * Object Ownership is set to Bucket owner enforced (ACLs disabled). These settings can't be modified.
     * </p>
     * <p>
     * For more information about permissions for creating and working with directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
     * buckets</a> in the <i>Amazon S3 User Guide</i>. For more information about supported S3 features for directory
     * buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-one-zone.html#s3-express-features"
     * >Features of S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important></li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>CreateBucket</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createBucketRequest
     * @return Result of the CreateBucket operation returned by the service.
     * @throws BucketAlreadyExistsException
     *         The requested bucket name is not available. The bucket namespace is shared by all users of the system.
     *         Select a different name and try again.
     * @throws BucketAlreadyOwnedByYouException
     *         The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all Amazon
     *         Web Services Regions except in the North Virginia Region. For legacy compatibility, if you re-create an
     *         existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets
     *         the bucket access control lists (ACLs).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateBucket
     */
    default CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws BucketAlreadyExistsException,
            BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action creates an Amazon S3 bucket. To create an Amazon S3 on Outposts bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html"> <code>CreateBucket</code>
     * </a>.
     * </p>
     * </note>
     * <p>
     * Creates a new S3 bucket. To create a bucket, you must set up Amazon S3 and have a valid Amazon Web Services
     * Access Key ID to authenticate requests. Anonymous requests are never allowed to create buckets. By creating the
     * bucket, you become the bucket owner.
     * </p>
     * <p>
     * There are two types of buckets: general purpose buckets and directory buckets. For more information about these
     * bucket types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and
     * working with Amazon S3 buckets</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b> - If you send your <code>CreateBucket</code> request to the
     * <code>s3.amazonaws.com</code> global endpoint, the request goes to the <code>us-east-1</code> Region. So the
     * signature calculations in Signature Version 4 must use <code>us-east-1</code> as the Region, even if the location
     * constraint in the request specifies another Region where the bucket is to be created. If you create a bucket in a
     * Region other than US East (N. Virginia), your application must be able to handle 307 redirect. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html">Virtual hosting of
     * buckets</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - In addition to the <code>s3:CreateBucket</code> permission, the
     * following permissions are required in a policy when your <code>CreateBucket</code> request includes specific
     * headers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Access control lists (ACLs)</b> - In your <code>CreateBucket</code> request, if you specify an access control
     * list (ACL) and set it to <code>public-read</code>, <code>public-read-write</code>,
     * <code>authenticated-read</code>, or if you explicitly specify any other custom ACLs, both
     * <code>s3:CreateBucket</code> and <code>s3:PutBucketAcl</code> permissions are required. In your
     * <code>CreateBucket</code> request, if you set the ACL to <code>private</code>, or if you don't specify any ACLs,
     * only the <code>s3:CreateBucket</code> permission is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Object Lock</b> - In your <code>CreateBucket</code> request, if you set
     * <code>x-amz-bucket-object-lock-enabled</code> to true, the <code>s3:PutBucketObjectLockConfiguration</code> and
     * <code>s3:PutBucketVersioning</code> permissions are required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>S3 Object Ownership</b> - If your <code>CreateBucket</code> request includes the
     * <code>x-amz-object-ownership</code> header, then the <code>s3:PutBucketOwnershipControls</code> permission is
     * required.
     * </p>
     * <important>
     * <p>
     * To set an ACL on a bucket as part of a <code>CreateBucket</code> request, you must explicitly set S3 Object
     * Ownership for the bucket to a different value than the default, <code>BucketOwnerEnforced</code>. Additionally,
     * if your desired bucket ACL grants public access, you must first create the bucket (without the bucket ACL) and
     * then explicitly disable Block Public Access on the bucket before using <code>PutBucketAcl</code> to set the ACL.
     * If you try to create a bucket with a public ACL, the request will fail.
     * </p>
     * <p>
     * For the majority of modern use cases in S3, we recommend that you keep all Block Public Access settings enabled
     * and keep ACLs disabled. If you would like to share data with users outside of your account, you can use bucket
     * policies as needed. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of
     * objects and disabling ACLs for your bucket </a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html">Blocking
     * public access to your Amazon S3 storage </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>S3 Block Public Access</b> - If your specific use case requires granting public access to your S3 resources,
     * you can disable Block Public Access. Specifically, you can create a new bucket with Block Public Access enabled,
     * then separately call the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html">
     * <code>DeletePublicAccessBlock</code> </a> API. To use this operation, you must have the
     * <code>s3:PutBucketPublicAccessBlock</code> permission. For more information about S3 Block Public Access, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html">Blocking
     * public access to your Amazon S3 storage </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:CreateBucket</code> permission in an IAM
     * identity-based policy instead of a bucket policy. Cross-account access to this API operation isn't supported.
     * This operation can only be performed by the Amazon Web Services account that owns the resource. For more
     * information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The permissions for ACLs, Object Lock, S3 Object Ownership, and S3 Block Public Access are not supported for
     * directory buckets. For directory buckets, all Block Public Access settings are enabled at the bucket level and S3
     * Object Ownership is set to Bucket owner enforced (ACLs disabled). These settings can't be modified.
     * </p>
     * <p>
     * For more information about permissions for creating and working with directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
     * buckets</a> in the <i>Amazon S3 User Guide</i>. For more information about supported S3 features for directory
     * buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-one-zone.html#s3-express-features"
     * >Features of S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important></li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>CreateBucket</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBucketRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBucketRequest#builder()}
     * </p>
     *
     * @param createBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.CreateBucketRequest.Builder} to create a request.
     * @return Result of the CreateBucket operation returned by the service.
     * @throws BucketAlreadyExistsException
     *         The requested bucket name is not available. The bucket namespace is shared by all users of the system.
     *         Select a different name and try again.
     * @throws BucketAlreadyOwnedByYouException
     *         The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all Amazon
     *         Web Services Regions except in the North Virginia Region. For legacy compatibility, if you re-create an
     *         existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets
     *         the bucket access control lists (ACLs).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateBucket
     */
    default CreateBucketResponse createBucket(Consumer<CreateBucketRequest.Builder> createBucketRequest)
            throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException,
            S3Exception {
        return createBucket(CreateBucketRequest.builder().applyMutation(createBucketRequest).build());
    }

    /**
     * <p>
     * This action initiates a multipart upload and returns an upload ID. This upload ID is used to associate all of the
     * parts in the specific multipart upload. You specify this upload ID in each of your subsequent upload part
     * requests (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>). You
     * also include this upload ID in the final request to either complete or abort the multipart upload request. For
     * more information about multipart uploads, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart Upload Overview</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * After you initiate a multipart upload and upload one or more parts, to stop being charged for storing the
     * uploaded parts, you must either complete or abort the multipart upload. Amazon S3 frees up the space used to
     * store the parts and stops charging you for storing them only after you either complete or abort a multipart
     * upload.
     * </p>
     * </note>
     * <p>
     * If you have configured a lifecycle rule to abort incomplete multipart uploads, the created multipart upload must
     * be completed within the number of days specified in the bucket lifecycle configuration. Otherwise, the incomplete
     * multipart upload becomes eligible for an abort action and Amazon S3 aborts the multipart upload. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"
     * >Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets </b> - S3 Lifecycle is not supported by directory buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Request signing</dt>
     * <dd>
     * <p>
     * For request signing, multipart upload is just a series of regular requests. You initiate a multipart upload, send
     * one or more requests to upload parts, and then complete the multipart upload process. You sign each request
     * individually. There is nothing special about signing multipart upload requests. For more information about
     * signing, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating
     * Requests (Amazon Web Services Signature Version 4)</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To perform a multipart upload with encryption using an Key Management
     * Service (KMS) KMS key, the requester must have permission to the <code>kms:Decrypt</code> and
     * <code>kms:GenerateDataKey</code> actions on the key. The requester must also have permissions for the
     * <code>kms:GenerateDataKey</code> action for the <code>CreateMultipartUpload</code> API. Then, the requester needs
     * permissions for the <code>kms:Decrypt</code> action on the <code>UploadPart</code> and
     * <code>UploadPartCopy</code> APIs. These permissions are required because Amazon S3 must decrypt and read data
     * from the encrypted file parts before it completes the multipart upload. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions">Multipart upload
     * API and permissions</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting data using
     * server-side encryption with Amazon Web Services KMS</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b> - Server-side encryption is for data encryption at rest. Amazon S3 encrypts your
     * data as it writes it to disks in its data centers and decrypts it when you access it. Amazon S3 automatically
     * encrypts all new objects that are uploaded to an S3 bucket. When doing a multipart upload, if you don't specify
     * encryption information in your request, the encryption setting of the uploaded parts is set to the default
     * encryption configuration of the destination bucket. By default, all buckets have a base level of encryption
     * configuration that uses server-side encryption with Amazon S3 managed keys (SSE-S3). If the destination bucket
     * has a default encryption configuration that uses server-side encryption with an Key Management Service (KMS) key
     * (SSE-KMS), or a customer-provided encryption key (SSE-C), Amazon S3 uses the corresponding KMS key, or a
     * customer-provided key to encrypt the uploaded parts. When you perform a CreateMultipartUpload operation, if you
     * want to use a different type of encryption setting for the uploaded parts, you can request that Amazon S3
     * encrypts the object with a different encryption key (such as an Amazon S3 managed key, a KMS key, or a
     * customer-provided key). When the encryption setting in your request is different from the default encryption
     * configuration of the destination bucket, the encryption setting in your request takes precedence. If you choose
     * to provide your own encryption key, the request headers you provide in <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> requests must
     * match the headers you used in the <code>CreateMultipartUpload</code> request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use KMS keys (SSE-KMS) that include the Amazon Web Services managed key (<code>aws/s3</code>) and KMS customer
     * managed keys stored in Key Management Service (KMS) – If you want Amazon Web Services to manage the keys used to
     * encrypt data, specify the following headers in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-aws-kms-key-id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-context</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but don't provide
     * <code>x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the Amazon Web Services managed key (
     * <code>aws/s3</code> key) in KMS to protect the data.
     * </p>
     * </li>
     * <li>
     * <p>
     * To perform a multipart upload with encryption by using an Amazon Web Services KMS key, the requester must have
     * permission to the <code>kms:Decrypt</code> and <code>kms:GenerateDataKey*</code> actions on the key. These
     * permissions are required because Amazon S3 must decrypt and read data from the encrypted file parts before it
     * completes the multipart upload. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions">Multipart upload
     * API and permissions</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting data using
     * server-side encryption with Amazon Web Services KMS</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your Identity and Access Management (IAM) user or role is in the same Amazon Web Services account as the KMS
     * key, then you must have these permissions on the key policy. If your IAM user or role is in a different account
     * from the key, then you must have the permissions on both the key policy and your IAM user or role.
     * </p>
     * </li>
     * <li>
     * <p>
     * All <code>GET</code> and <code>PUT</code> requests for an object protected by KMS fail if you don't make them by
     * using Secure Sockets Layer (SSL), Transport Layer Security (TLS), or Signature Version 4. For information about
     * configuring any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the
     * Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * For more information about server-side encryption with KMS keys (SSE-KMS), see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting Data Using
     * Server-Side Encryption with KMS keys</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use customer-provided encryption keys (SSE-C) – If you want to manage your own encryption keys, provide all the
     * following headers in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key-MD5</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about server-side encryption with customer-provided encryption keys (SSE-C), see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html"> Protecting
     * data using server-side encryption with customer-provided encryption keys (SSE-C)</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) and server-side
     * encryption with KMS keys (SSE-KMS) (<code>aws:kms</code>). We recommend that the bucket's default encryption uses
     * the desired encryption configuration and you don't override the bucket default encryption in your
     * <code>CreateSession</code> requests or <code>PUT</code> object requests. Then, new objects are automatically
     * encrypted with the desired encryption settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>. For more information about the encryption
     * overriding behaviors in directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-specifying-kms-encryption.html">Specifying
     * server-side encryption with KMS for new object uploads</a>.
     * </p>
     * <p>
     * In the Zonal endpoint API calls (except <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>) using the REST
     * API, the encryption request headers must match the encryption settings that are specified in the
     * <code>CreateSession</code> request. You can't override the values of the encryption settings (
     * <code>x-amz-server-side-encryption</code>, <code>x-amz-server-side-encryption-aws-kms-key-id</code>,
     * <code>x-amz-server-side-encryption-context</code>, and
     * <code>x-amz-server-side-encryption-bucket-key-enabled</code>) that are specified in the
     * <code>CreateSession</code> request. You don't need to explicitly specify these encryption settings values in
     * Zonal endpoint API calls, and Amazon S3 will use the encryption settings values from the
     * <code>CreateSession</code> request to protect new objects in the directory bucket.
     * </p>
     * <note>
     * <p>
     * When you use the CLI or the Amazon Web Services SDKs, for <code>CreateSession</code>, the session token refreshes
     * automatically to avoid service interruptions when a session expires. The CLI or the Amazon Web Services SDKs use
     * the bucket's default encryption configuration for the <code>CreateSession</code> request. It's not supported to
     * override the encryption settings values in the <code>CreateSession</code> request. So in the Zonal endpoint API
     * calls (except <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>), the
     * encryption request headers must match the default encryption configuration of the directory bucket.
     * </p>
     * </note> <note>
     * <p>
     * For directory buckets, when you perform a <code>CreateMultipartUpload</code> operation and an
     * <code>UploadPartCopy</code> operation, the request headers you provide in the <code>CreateMultipartUpload</code>
     * request must match the default encryption configuration of the destination bucket.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>CreateMultipartUpload</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createMultipartUploadRequest
     * @return Result of the CreateMultipartUpload operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateMultipartUpload
     */
    default CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest createMultipartUploadRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action initiates a multipart upload and returns an upload ID. This upload ID is used to associate all of the
     * parts in the specific multipart upload. You specify this upload ID in each of your subsequent upload part
     * requests (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>). You
     * also include this upload ID in the final request to either complete or abort the multipart upload request. For
     * more information about multipart uploads, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart Upload Overview</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * After you initiate a multipart upload and upload one or more parts, to stop being charged for storing the
     * uploaded parts, you must either complete or abort the multipart upload. Amazon S3 frees up the space used to
     * store the parts and stops charging you for storing them only after you either complete or abort a multipart
     * upload.
     * </p>
     * </note>
     * <p>
     * If you have configured a lifecycle rule to abort incomplete multipart uploads, the created multipart upload must
     * be completed within the number of days specified in the bucket lifecycle configuration. Otherwise, the incomplete
     * multipart upload becomes eligible for an abort action and Amazon S3 aborts the multipart upload. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"
     * >Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets </b> - S3 Lifecycle is not supported by directory buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Request signing</dt>
     * <dd>
     * <p>
     * For request signing, multipart upload is just a series of regular requests. You initiate a multipart upload, send
     * one or more requests to upload parts, and then complete the multipart upload process. You sign each request
     * individually. There is nothing special about signing multipart upload requests. For more information about
     * signing, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating
     * Requests (Amazon Web Services Signature Version 4)</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To perform a multipart upload with encryption using an Key Management
     * Service (KMS) KMS key, the requester must have permission to the <code>kms:Decrypt</code> and
     * <code>kms:GenerateDataKey</code> actions on the key. The requester must also have permissions for the
     * <code>kms:GenerateDataKey</code> action for the <code>CreateMultipartUpload</code> API. Then, the requester needs
     * permissions for the <code>kms:Decrypt</code> action on the <code>UploadPart</code> and
     * <code>UploadPartCopy</code> APIs. These permissions are required because Amazon S3 must decrypt and read data
     * from the encrypted file parts before it completes the multipart upload. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions">Multipart upload
     * API and permissions</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting data using
     * server-side encryption with Amazon Web Services KMS</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b> - Server-side encryption is for data encryption at rest. Amazon S3 encrypts your
     * data as it writes it to disks in its data centers and decrypts it when you access it. Amazon S3 automatically
     * encrypts all new objects that are uploaded to an S3 bucket. When doing a multipart upload, if you don't specify
     * encryption information in your request, the encryption setting of the uploaded parts is set to the default
     * encryption configuration of the destination bucket. By default, all buckets have a base level of encryption
     * configuration that uses server-side encryption with Amazon S3 managed keys (SSE-S3). If the destination bucket
     * has a default encryption configuration that uses server-side encryption with an Key Management Service (KMS) key
     * (SSE-KMS), or a customer-provided encryption key (SSE-C), Amazon S3 uses the corresponding KMS key, or a
     * customer-provided key to encrypt the uploaded parts. When you perform a CreateMultipartUpload operation, if you
     * want to use a different type of encryption setting for the uploaded parts, you can request that Amazon S3
     * encrypts the object with a different encryption key (such as an Amazon S3 managed key, a KMS key, or a
     * customer-provided key). When the encryption setting in your request is different from the default encryption
     * configuration of the destination bucket, the encryption setting in your request takes precedence. If you choose
     * to provide your own encryption key, the request headers you provide in <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> requests must
     * match the headers you used in the <code>CreateMultipartUpload</code> request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use KMS keys (SSE-KMS) that include the Amazon Web Services managed key (<code>aws/s3</code>) and KMS customer
     * managed keys stored in Key Management Service (KMS) – If you want Amazon Web Services to manage the keys used to
     * encrypt data, specify the following headers in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-aws-kms-key-id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-context</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but don't provide
     * <code>x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the Amazon Web Services managed key (
     * <code>aws/s3</code> key) in KMS to protect the data.
     * </p>
     * </li>
     * <li>
     * <p>
     * To perform a multipart upload with encryption by using an Amazon Web Services KMS key, the requester must have
     * permission to the <code>kms:Decrypt</code> and <code>kms:GenerateDataKey*</code> actions on the key. These
     * permissions are required because Amazon S3 must decrypt and read data from the encrypted file parts before it
     * completes the multipart upload. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions">Multipart upload
     * API and permissions</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting data using
     * server-side encryption with Amazon Web Services KMS</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your Identity and Access Management (IAM) user or role is in the same Amazon Web Services account as the KMS
     * key, then you must have these permissions on the key policy. If your IAM user or role is in a different account
     * from the key, then you must have the permissions on both the key policy and your IAM user or role.
     * </p>
     * </li>
     * <li>
     * <p>
     * All <code>GET</code> and <code>PUT</code> requests for an object protected by KMS fail if you don't make them by
     * using Secure Sockets Layer (SSL), Transport Layer Security (TLS), or Signature Version 4. For information about
     * configuring any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the
     * Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * For more information about server-side encryption with KMS keys (SSE-KMS), see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting Data Using
     * Server-Side Encryption with KMS keys</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use customer-provided encryption keys (SSE-C) – If you want to manage your own encryption keys, provide all the
     * following headers in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key-MD5</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about server-side encryption with customer-provided encryption keys (SSE-C), see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html"> Protecting
     * data using server-side encryption with customer-provided encryption keys (SSE-C)</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) and server-side
     * encryption with KMS keys (SSE-KMS) (<code>aws:kms</code>). We recommend that the bucket's default encryption uses
     * the desired encryption configuration and you don't override the bucket default encryption in your
     * <code>CreateSession</code> requests or <code>PUT</code> object requests. Then, new objects are automatically
     * encrypted with the desired encryption settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>. For more information about the encryption
     * overriding behaviors in directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-specifying-kms-encryption.html">Specifying
     * server-side encryption with KMS for new object uploads</a>.
     * </p>
     * <p>
     * In the Zonal endpoint API calls (except <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>) using the REST
     * API, the encryption request headers must match the encryption settings that are specified in the
     * <code>CreateSession</code> request. You can't override the values of the encryption settings (
     * <code>x-amz-server-side-encryption</code>, <code>x-amz-server-side-encryption-aws-kms-key-id</code>,
     * <code>x-amz-server-side-encryption-context</code>, and
     * <code>x-amz-server-side-encryption-bucket-key-enabled</code>) that are specified in the
     * <code>CreateSession</code> request. You don't need to explicitly specify these encryption settings values in
     * Zonal endpoint API calls, and Amazon S3 will use the encryption settings values from the
     * <code>CreateSession</code> request to protect new objects in the directory bucket.
     * </p>
     * <note>
     * <p>
     * When you use the CLI or the Amazon Web Services SDKs, for <code>CreateSession</code>, the session token refreshes
     * automatically to avoid service interruptions when a session expires. The CLI or the Amazon Web Services SDKs use
     * the bucket's default encryption configuration for the <code>CreateSession</code> request. It's not supported to
     * override the encryption settings values in the <code>CreateSession</code> request. So in the Zonal endpoint API
     * calls (except <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>), the
     * encryption request headers must match the default encryption configuration of the directory bucket.
     * </p>
     * </note> <note>
     * <p>
     * For directory buckets, when you perform a <code>CreateMultipartUpload</code> operation and an
     * <code>UploadPartCopy</code> operation, the request headers you provide in the <code>CreateMultipartUpload</code>
     * request must match the default encryption configuration of the destination bucket.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>CreateMultipartUpload</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultipartUploadRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMultipartUploadRequest#builder()}
     * </p>
     *
     * @param createMultipartUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest.Builder} to create a request.
     * @return Result of the CreateMultipartUpload operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateMultipartUpload
     */
    default CreateMultipartUploadResponse createMultipartUpload(
            Consumer<CreateMultipartUploadRequest.Builder> createMultipartUploadRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return createMultipartUpload(CreateMultipartUploadRequest.builder().applyMutation(createMultipartUploadRequest).build());
    }

    /**
     * <p>
     * Creates a session that establishes temporary security credentials to support fast authentication and
     * authorization for the Zonal endpoint API operations on directory buckets. For more information about Zonal
     * endpoint API operations that include the Availability Zone in the request endpoint, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-APIs.html">S3 Express One Zone APIs</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To make Zonal endpoint API requests on a directory bucket, use the <code>CreateSession</code> API operation.
     * Specifically, you grant <code>s3express:CreateSession</code> permission to a bucket in a bucket policy or an IAM
     * identity-based policy. Then, you use IAM credentials to make the <code>CreateSession</code> API request on the
     * bucket, which returns temporary security credentials that include the access key ID, secret access key, session
     * token, and expiration. These credentials have associated permissions to access the Zonal endpoint API operations.
     * After the session is created, you don’t need to use other policies to grant permissions to each Zonal endpoint
     * API individually. Instead, in your Zonal endpoint API requests, you sign your requests by applying the temporary
     * security credentials of the session to the request headers and following the SigV4 protocol for authentication.
     * You also apply the session token to the <code>x-amz-s3session-token</code> request header for authorization.
     * Temporary security credentials are scoped to the bucket and expire after 5 minutes. After the expiration time,
     * any calls that you make with those credentials will fail. You must use IAM credentials again to make a
     * <code>CreateSession</code> API request that generates a new set of temporary credentials for use. Temporary
     * credentials cannot be extended or refreshed beyond the original specified interval.
     * </p>
     * <p>
     * If you use Amazon Web Services SDKs, SDKs handle the session token refreshes automatically to avoid service
     * interruptions when a session expires. We recommend that you use the Amazon Web Services SDKs to initiate and
     * manage requests to the CreateSession API. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-optimizing-performance-guidelines-design-patterns.html#s3-express-optimizing-performance-session-authentication"
     * >Performance guidelines and design patterns</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must make requests for this API operation to the Zonal endpoint. These endpoints support virtual-hosted-style
     * requests in the format <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>
     * . Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>CopyObject</code> API operation</b> - Unlike other Zonal endpoint API operations, the
     * <code>CopyObject</code> API operation doesn't use the temporary security credentials returned from the
     * <code>CreateSession</code> API operation for authentication and authorization. For information about
     * authentication and authorization of the <code>CopyObject</code> API operation on directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HeadBucket</code> API operation</b> - Unlike other Zonal endpoint API operations, the
     * <code>HeadBucket</code> API operation doesn't use the temporary security credentials returned from the
     * <code>CreateSession</code> API operation for authentication and authorization. For information about
     * authentication and authorization of the <code>HeadBucket</code> API operation on directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_HeadBucket.html">HeadBucket</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To obtain temporary security credentials, you must create a bucket policy or an IAM identity-based policy that
     * grants <code>s3express:CreateSession</code> permission to the bucket. In a policy, you can have the
     * <code>s3express:SessionMode</code> condition key to control who can create a <code>ReadWrite</code> or
     * <code>ReadOnly</code> session. For more information about <code>ReadWrite</code> or <code>ReadOnly</code>
     * sessions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html#API_CreateSession_RequestParameters">
     * <code>x-amz-create-session-mode</code> </a>. For example policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-identity-policies.html"
     * >Amazon Web Services Identity and Access Management (IAM) identity-based policies for S3 Express One Zone</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To grant cross-account access to Zonal endpoint API operations, the bucket policy should also grant both accounts
     * the <code>s3express:CreateSession</code> permission.
     * </p>
     * <p>
     * If you want to encrypt objects with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and the
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the target KMS key.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * For directory buckets, there are only two supported options for server-side encryption: server-side encryption
     * with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) and server-side encryption with KMS keys (SSE-KMS) (
     * <code>aws:kms</code>). We recommend that the bucket's default encryption uses the desired encryption
     * configuration and you don't override the bucket default encryption in your <code>CreateSession</code> requests or
     * <code>PUT</code> object requests. Then, new objects are automatically encrypted with the desired encryption
     * settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>. For more information about the encryption
     * overriding behaviors in directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-specifying-kms-encryption.html">Specifying
     * server-side encryption with KMS for new object uploads</a>.
     * </p>
     * <p>
     * For <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-differences.html#s3-express-differences-api-operations"
     * >Zonal endpoint (object-level) API operations</a> except <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>, you
     * authenticate and authorize requests through <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">CreateSession</a> for low latency.
     * To encrypt new objects in a directory bucket with SSE-KMS, you must specify SSE-KMS as the directory bucket's
     * default encryption configuration with a KMS key (specifically, a <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed
     * key</a>). Then, when a session is created for Zonal endpoint API operations, new objects are automatically
     * encrypted and decrypted with SSE-KMS and S3 Bucket Keys during the session.
     * </p>
     * <note>
     * <p>
     * Only 1 <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer
     * managed key</a> is supported per directory bucket for the lifetime of the bucket. The <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services
     * managed key</a> (<code>aws/s3</code>) isn't supported. After you specify SSE-KMS as your bucket's default
     * encryption configuration with a customer managed key, you can't change the customer managed key for the bucket's
     * SSE-KMS configuration.
     * </p>
     * </note>
     * <p>
     * In the Zonal endpoint API calls (except <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>) using the REST
     * API, you can't override the values of the encryption settings (<code>x-amz-server-side-encryption</code>,
     * <code>x-amz-server-side-encryption-aws-kms-key-id</code>, <code>x-amz-server-side-encryption-context</code>, and
     * <code>x-amz-server-side-encryption-bucket-key-enabled</code>) from the <code>CreateSession</code> request. You
     * don't need to explicitly specify these encryption settings values in Zonal endpoint API calls, and Amazon S3 will
     * use the encryption settings values from the <code>CreateSession</code> request to protect new objects in the
     * directory bucket.
     * </p>
     * <note>
     * <p>
     * When you use the CLI or the Amazon Web Services SDKs, for <code>CreateSession</code>, the session token refreshes
     * automatically to avoid service interruptions when a session expires. The CLI or the Amazon Web Services SDKs use
     * the bucket's default encryption configuration for the <code>CreateSession</code> request. It's not supported to
     * override the encryption settings values in the <code>CreateSession</code> request. Also, in the Zonal endpoint
     * API calls (except <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>
     * and <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>), it's
     * not supported to override the values of the encryption settings from the <code>CreateSession</code> request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     *
     * @param createSessionRequest
     * @return Result of the CreateSession operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateSession
     */
    default CreateSessionResponse createSession(CreateSessionRequest createSessionRequest) throws NoSuchBucketException,
            AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a session that establishes temporary security credentials to support fast authentication and
     * authorization for the Zonal endpoint API operations on directory buckets. For more information about Zonal
     * endpoint API operations that include the Availability Zone in the request endpoint, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-APIs.html">S3 Express One Zone APIs</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To make Zonal endpoint API requests on a directory bucket, use the <code>CreateSession</code> API operation.
     * Specifically, you grant <code>s3express:CreateSession</code> permission to a bucket in a bucket policy or an IAM
     * identity-based policy. Then, you use IAM credentials to make the <code>CreateSession</code> API request on the
     * bucket, which returns temporary security credentials that include the access key ID, secret access key, session
     * token, and expiration. These credentials have associated permissions to access the Zonal endpoint API operations.
     * After the session is created, you don’t need to use other policies to grant permissions to each Zonal endpoint
     * API individually. Instead, in your Zonal endpoint API requests, you sign your requests by applying the temporary
     * security credentials of the session to the request headers and following the SigV4 protocol for authentication.
     * You also apply the session token to the <code>x-amz-s3session-token</code> request header for authorization.
     * Temporary security credentials are scoped to the bucket and expire after 5 minutes. After the expiration time,
     * any calls that you make with those credentials will fail. You must use IAM credentials again to make a
     * <code>CreateSession</code> API request that generates a new set of temporary credentials for use. Temporary
     * credentials cannot be extended or refreshed beyond the original specified interval.
     * </p>
     * <p>
     * If you use Amazon Web Services SDKs, SDKs handle the session token refreshes automatically to avoid service
     * interruptions when a session expires. We recommend that you use the Amazon Web Services SDKs to initiate and
     * manage requests to the CreateSession API. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-optimizing-performance-guidelines-design-patterns.html#s3-express-optimizing-performance-session-authentication"
     * >Performance guidelines and design patterns</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must make requests for this API operation to the Zonal endpoint. These endpoints support virtual-hosted-style
     * requests in the format <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>
     * . Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>CopyObject</code> API operation</b> - Unlike other Zonal endpoint API operations, the
     * <code>CopyObject</code> API operation doesn't use the temporary security credentials returned from the
     * <code>CreateSession</code> API operation for authentication and authorization. For information about
     * authentication and authorization of the <code>CopyObject</code> API operation on directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HeadBucket</code> API operation</b> - Unlike other Zonal endpoint API operations, the
     * <code>HeadBucket</code> API operation doesn't use the temporary security credentials returned from the
     * <code>CreateSession</code> API operation for authentication and authorization. For information about
     * authentication and authorization of the <code>HeadBucket</code> API operation on directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_HeadBucket.html">HeadBucket</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To obtain temporary security credentials, you must create a bucket policy or an IAM identity-based policy that
     * grants <code>s3express:CreateSession</code> permission to the bucket. In a policy, you can have the
     * <code>s3express:SessionMode</code> condition key to control who can create a <code>ReadWrite</code> or
     * <code>ReadOnly</code> session. For more information about <code>ReadWrite</code> or <code>ReadOnly</code>
     * sessions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html#API_CreateSession_RequestParameters">
     * <code>x-amz-create-session-mode</code> </a>. For example policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-identity-policies.html"
     * >Amazon Web Services Identity and Access Management (IAM) identity-based policies for S3 Express One Zone</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To grant cross-account access to Zonal endpoint API operations, the bucket policy should also grant both accounts
     * the <code>s3express:CreateSession</code> permission.
     * </p>
     * <p>
     * If you want to encrypt objects with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and the
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the target KMS key.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * For directory buckets, there are only two supported options for server-side encryption: server-side encryption
     * with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) and server-side encryption with KMS keys (SSE-KMS) (
     * <code>aws:kms</code>). We recommend that the bucket's default encryption uses the desired encryption
     * configuration and you don't override the bucket default encryption in your <code>CreateSession</code> requests or
     * <code>PUT</code> object requests. Then, new objects are automatically encrypted with the desired encryption
     * settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>. For more information about the encryption
     * overriding behaviors in directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-specifying-kms-encryption.html">Specifying
     * server-side encryption with KMS for new object uploads</a>.
     * </p>
     * <p>
     * For <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-differences.html#s3-express-differences-api-operations"
     * >Zonal endpoint (object-level) API operations</a> except <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>, you
     * authenticate and authorize requests through <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">CreateSession</a> for low latency.
     * To encrypt new objects in a directory bucket with SSE-KMS, you must specify SSE-KMS as the directory bucket's
     * default encryption configuration with a KMS key (specifically, a <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed
     * key</a>). Then, when a session is created for Zonal endpoint API operations, new objects are automatically
     * encrypted and decrypted with SSE-KMS and S3 Bucket Keys during the session.
     * </p>
     * <note>
     * <p>
     * Only 1 <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer
     * managed key</a> is supported per directory bucket for the lifetime of the bucket. The <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services
     * managed key</a> (<code>aws/s3</code>) isn't supported. After you specify SSE-KMS as your bucket's default
     * encryption configuration with a customer managed key, you can't change the customer managed key for the bucket's
     * SSE-KMS configuration.
     * </p>
     * </note>
     * <p>
     * In the Zonal endpoint API calls (except <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>) using the REST
     * API, you can't override the values of the encryption settings (<code>x-amz-server-side-encryption</code>,
     * <code>x-amz-server-side-encryption-aws-kms-key-id</code>, <code>x-amz-server-side-encryption-context</code>, and
     * <code>x-amz-server-side-encryption-bucket-key-enabled</code>) from the <code>CreateSession</code> request. You
     * don't need to explicitly specify these encryption settings values in Zonal endpoint API calls, and Amazon S3 will
     * use the encryption settings values from the <code>CreateSession</code> request to protect new objects in the
     * directory bucket.
     * </p>
     * <note>
     * <p>
     * When you use the CLI or the Amazon Web Services SDKs, for <code>CreateSession</code>, the session token refreshes
     * automatically to avoid service interruptions when a session expires. The CLI or the Amazon Web Services SDKs use
     * the bucket's default encryption configuration for the <code>CreateSession</code> request. It's not supported to
     * override the encryption settings values in the <code>CreateSession</code> request. Also, in the Zonal endpoint
     * API calls (except <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>
     * and <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>), it's
     * not supported to override the values of the encryption settings from the <code>CreateSession</code> request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSessionRequest#builder()}
     * </p>
     *
     * @param createSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.CreateSessionRequest.Builder} to create a request.
     * @return Result of the CreateSession operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateSession
     */
    default CreateSessionResponse createSession(Consumer<CreateSessionRequest.Builder> createSessionRequest)
            throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        return createSession(CreateSessionRequest.builder().applyMutation(createSessionRequest).build());
    }

    /**
     * <p>
     * Deletes the S3 bucket. All objects (including all object versions and delete markers) in the bucket must be
     * deleted before the bucket itself can be deleted.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets</b> - If multipart uploads in a directory bucket are in progress, you can't delete the
     * bucket until all the in-progress multipart uploads are aborted or completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the <code>s3:DeleteBucket</code> permission on the
     * specified bucket in a policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:DeleteBucket</code> permission in an IAM
     * identity-based policy instead of a bucket policy. Cross-account access to this API operation isn't supported.
     * This operation can only be performed by the Amazon Web Services account that owns the resource. For more
     * information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>DeleteBucket</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketRequest
     * @return Result of the DeleteBucket operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucket
     */
    default DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the S3 bucket. All objects (including all object versions and delete markers) in the bucket must be
     * deleted before the bucket itself can be deleted.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets</b> - If multipart uploads in a directory bucket are in progress, you can't delete the
     * bucket until all the in-progress multipart uploads are aborted or completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the <code>s3:DeleteBucket</code> permission on the
     * specified bucket in a policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:DeleteBucket</code> permission in an IAM
     * identity-based policy instead of a bucket policy. Cross-account access to this API operation isn't supported.
     * This operation can only be performed by the Amazon Web Services account that owns the resource. For more
     * information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>DeleteBucket</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBucketRequest#builder()}
     * </p>
     *
     * @param deleteBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketRequest.Builder} to create a request.
     * @return Result of the DeleteBucket operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucket
     */
    default DeleteBucketResponse deleteBucket(Consumer<DeleteBucketRequest.Builder> deleteBucketRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteBucket(DeleteBucketRequest.builder().applyMutation(deleteBucketRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes an analytics configuration for the bucket (specified by the analytics configuration ID).
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutAnalyticsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about the Amazon S3 analytics feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage
     * Class Analysis</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketAnalyticsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">
     * GetBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">
     * ListBucketAnalyticsConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">
     * PutBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketAnalyticsConfigurationRequest
     * @return Result of the DeleteBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketAnalyticsConfiguration
     */
    default DeleteBucketAnalyticsConfigurationResponse deleteBucketAnalyticsConfiguration(
            DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes an analytics configuration for the bucket (specified by the analytics configuration ID).
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutAnalyticsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about the Amazon S3 analytics feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage
     * Class Analysis</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketAnalyticsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">
     * GetBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">
     * ListBucketAnalyticsConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">
     * PutBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketAnalyticsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBucketAnalyticsConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteBucketAnalyticsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketAnalyticsConfiguration
     */
    default DeleteBucketAnalyticsConfigurationResponse deleteBucketAnalyticsConfiguration(
            Consumer<DeleteBucketAnalyticsConfigurationRequest.Builder> deleteBucketAnalyticsConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest.builder()
                .applyMutation(deleteBucketAnalyticsConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the <code>cors</code> configuration information set for the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:PutBucketCORS</code> action. The bucket
     * owner has this permission by default and can grant this permission to others.
     * </p>
     * <p>
     * For information about <code>cors</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p class="title">
     * <b>Related Resources</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html">PutBucketCors</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html">RESTOPTIONSobject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketCorsRequest
     * @return Result of the DeleteBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketCors
     */
    default DeleteBucketCorsResponse deleteBucketCors(DeleteBucketCorsRequest deleteBucketCorsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the <code>cors</code> configuration information set for the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:PutBucketCORS</code> action. The bucket
     * owner has this permission by default and can grant this permission to others.
     * </p>
     * <p>
     * For information about <code>cors</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p class="title">
     * <b>Related Resources</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html">PutBucketCors</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html">RESTOPTIONSobject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketCorsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBucketCorsRequest#builder()}
     * </p>
     *
     * @param deleteBucketCorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketCorsRequest.Builder} to create a request.
     * @return Result of the DeleteBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketCors
     */
    default DeleteBucketCorsResponse deleteBucketCors(Consumer<DeleteBucketCorsRequest.Builder> deleteBucketCorsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteBucketCors(DeleteBucketCorsRequest.builder().applyMutation(deleteBucketCorsRequest).build());
    }

    /**
     * <p>
     * This implementation of the DELETE action resets the default encryption for the bucket as server-side encryption
     * with Amazon S3 managed keys (SSE-S3).
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b> - For information about the bucket default encryption feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Bucket Default
     * Encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. For information about the default encryption configuration in directory buckets,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting
     * default server-side encryption behavior for directory buckets</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:PutEncryptionConfiguration</code> permission is required
     * in a policy. The bucket owner has this permission by default. The bucket owner can grant this permission to
     * others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:PutEncryptionConfiguration</code> permission in an IAM identity-based policy instead of a bucket
     * policy. Cross-account access to this API operation isn't supported. This operation can only be performed by the
     * Amazon Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>DeleteBucketEncryption</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html">PutBucketEncryption</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html">GetBucketEncryption</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketEncryptionRequest
     * @return Result of the DeleteBucketEncryption operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketEncryption
     */
    default DeleteBucketEncryptionResponse deleteBucketEncryption(DeleteBucketEncryptionRequest deleteBucketEncryptionRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This implementation of the DELETE action resets the default encryption for the bucket as server-side encryption
     * with Amazon S3 managed keys (SSE-S3).
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b> - For information about the bucket default encryption feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Bucket Default
     * Encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. For information about the default encryption configuration in directory buckets,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting
     * default server-side encryption behavior for directory buckets</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:PutEncryptionConfiguration</code> permission is required
     * in a policy. The bucket owner has this permission by default. The bucket owner can grant this permission to
     * others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:PutEncryptionConfiguration</code> permission in an IAM identity-based policy instead of a bucket
     * policy. Cross-account access to this API operation isn't supported. This operation can only be performed by the
     * Amazon Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>DeleteBucketEncryption</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html">PutBucketEncryption</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html">GetBucketEncryption</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketEncryptionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBucketEncryptionRequest#builder()}
     * </p>
     *
     * @param deleteBucketEncryptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBucketEncryption operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketEncryption
     */
    default DeleteBucketEncryptionResponse deleteBucketEncryption(
            Consumer<DeleteBucketEncryptionRequest.Builder> deleteBucketEncryptionRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return deleteBucketEncryption(DeleteBucketEncryptionRequest.builder().applyMutation(deleteBucketEncryptionRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the S3 Intelligent-Tiering configuration from the specified bucket.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to
     * the most cost-effective storage access tier, without performance impact or operational overhead. S3
     * Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get
     * the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional
     * archiving capabilities.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or
     * unpredictable access patterns, independent of object size or retention period. If the size of an object is less
     * than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are
     * always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage
     * class for automatically optimizing frequently and infrequently accessed objects</a>.
     * </p>
     * <p>
     * Operations related to <code>DeleteBucketIntelligentTieringConfiguration</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">
     * GetBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">
     * PutBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">
     * ListBucketIntelligentTieringConfigurations</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketIntelligentTieringConfigurationRequest
     * @return Result of the DeleteBucketIntelligentTieringConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketIntelligentTieringConfiguration
     */
    default DeleteBucketIntelligentTieringConfigurationResponse deleteBucketIntelligentTieringConfiguration(
            DeleteBucketIntelligentTieringConfigurationRequest deleteBucketIntelligentTieringConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the S3 Intelligent-Tiering configuration from the specified bucket.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to
     * the most cost-effective storage access tier, without performance impact or operational overhead. S3
     * Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get
     * the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional
     * archiving capabilities.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or
     * unpredictable access patterns, independent of object size or retention period. If the size of an object is less
     * than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are
     * always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage
     * class for automatically optimizing frequently and infrequently accessed objects</a>.
     * </p>
     * <p>
     * Operations related to <code>DeleteBucketIntelligentTieringConfiguration</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">
     * GetBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">
     * PutBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">
     * ListBucketIntelligentTieringConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteBucketIntelligentTieringConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteBucketIntelligentTieringConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteBucketIntelligentTieringConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteBucketIntelligentTieringConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketIntelligentTieringConfiguration
     */
    default DeleteBucketIntelligentTieringConfigurationResponse deleteBucketIntelligentTieringConfiguration(
            Consumer<DeleteBucketIntelligentTieringConfigurationRequest.Builder> deleteBucketIntelligentTieringConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteBucketIntelligentTieringConfiguration(DeleteBucketIntelligentTieringConfigurationRequest.builder()
                .applyMutation(deleteBucketIntelligentTieringConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes an inventory configuration (identified by the inventory ID) from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutInventoryConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about the Amazon S3 inventory feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>.
     * </p>
     * <p>
     * Operations related to <code>DeleteBucketInventoryConfiguration</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">
     * GetBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">
     * PutBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">
     * ListBucketInventoryConfigurations</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketInventoryConfigurationRequest
     * @return Result of the DeleteBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketInventoryConfiguration
     */
    default DeleteBucketInventoryConfigurationResponse deleteBucketInventoryConfiguration(
            DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes an inventory configuration (identified by the inventory ID) from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutInventoryConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about the Amazon S3 inventory feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>.
     * </p>
     * <p>
     * Operations related to <code>DeleteBucketInventoryConfiguration</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">
     * GetBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">
     * PutBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">
     * ListBucketInventoryConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketInventoryConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBucketInventoryConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteBucketInventoryConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketInventoryConfiguration
     */
    default DeleteBucketInventoryConfigurationResponse deleteBucketInventoryConfiguration(
            Consumer<DeleteBucketInventoryConfigurationRequest.Builder> deleteBucketInventoryConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest.builder()
                .applyMutation(deleteBucketInventoryConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the lifecycle configuration from the specified bucket. Amazon S3 removes all the lifecycle configuration
     * rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 no longer
     * automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - By default, all Amazon S3 resources are private, including buckets,
     * objects, and related subresources (for example, lifecycle configuration and website configuration). Only the
     * resource owner (that is, the Amazon Web Services account that created it) can access the resource. The resource
     * owner can optionally grant access permissions to others by writing an access policy. For this operation, a user
     * must have the <code>s3:PutLifecycleConfiguration</code> permission.
     * </p>
     * <p>
     * For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:PutLifecycleConfiguration</code>
     * permission in an IAM identity-based policy to use this operation. Cross-account access to this API operation
     * isn't supported. The resource owner can optionally grant access permissions to others by creating a role or user
     * for them as long as they are within the same account as the owner and resource.
     * </p>
     * <p>
     * For more information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Authorizing Regional
     * endpoint APIs with IAM</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * </dl>
     * <dl>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For more information about the object expiration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions"
     * >Elements to Describe Lifecycle Actions</a>.
     * </p>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">
     * PutBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">
     * GetBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketLifecycleRequest
     * @return Result of the DeleteBucketLifecycle operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketLifecycle
     */
    default DeleteBucketLifecycleResponse deleteBucketLifecycle(DeleteBucketLifecycleRequest deleteBucketLifecycleRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the lifecycle configuration from the specified bucket. Amazon S3 removes all the lifecycle configuration
     * rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 no longer
     * automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - By default, all Amazon S3 resources are private, including buckets,
     * objects, and related subresources (for example, lifecycle configuration and website configuration). Only the
     * resource owner (that is, the Amazon Web Services account that created it) can access the resource. The resource
     * owner can optionally grant access permissions to others by writing an access policy. For this operation, a user
     * must have the <code>s3:PutLifecycleConfiguration</code> permission.
     * </p>
     * <p>
     * For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:PutLifecycleConfiguration</code>
     * permission in an IAM identity-based policy to use this operation. Cross-account access to this API operation
     * isn't supported. The resource owner can optionally grant access permissions to others by creating a role or user
     * for them as long as they are within the same account as the owner and resource.
     * </p>
     * <p>
     * For more information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Authorizing Regional
     * endpoint APIs with IAM</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * </dl>
     * <dl>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For more information about the object expiration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions"
     * >Elements to Describe Lifecycle Actions</a>.
     * </p>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">
     * PutBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">
     * GetBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketLifecycleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBucketLifecycleRequest#builder()}
     * </p>
     *
     * @param deleteBucketLifecycleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest.Builder} to create a request.
     * @return Result of the DeleteBucketLifecycle operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketLifecycle
     */
    default DeleteBucketLifecycleResponse deleteBucketLifecycle(
            Consumer<DeleteBucketLifecycleRequest.Builder> deleteBucketLifecycleRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return deleteBucketLifecycle(DeleteBucketLifecycleRequest.builder().applyMutation(deleteBucketLifecycleRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes a metrics configuration for the Amazon CloudWatch request metrics (specified by the metrics configuration
     * ID) from the bucket. Note that this doesn't include the daily storage metrics.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutMetricsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about CloudWatch request metrics for Amazon S3, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon
     * CloudWatch</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketMetricsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">
     * GetBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">
     * PutBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">
     * ListBucketMetricsConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with
     * Amazon CloudWatch</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketMetricsConfigurationRequest
     * @return Result of the DeleteBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketMetricsConfiguration
     */
    default DeleteBucketMetricsConfigurationResponse deleteBucketMetricsConfiguration(
            DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes a metrics configuration for the Amazon CloudWatch request metrics (specified by the metrics configuration
     * ID) from the bucket. Note that this doesn't include the daily storage metrics.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutMetricsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about CloudWatch request metrics for Amazon S3, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon
     * CloudWatch</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketMetricsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">
     * GetBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">
     * PutBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">
     * ListBucketMetricsConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with
     * Amazon CloudWatch</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketMetricsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBucketMetricsConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteBucketMetricsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketMetricsConfiguration
     */
    default DeleteBucketMetricsConfigurationResponse deleteBucketMetricsConfiguration(
            Consumer<DeleteBucketMetricsConfigurationRequest.Builder> deleteBucketMetricsConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest.builder()
                .applyMutation(deleteBucketMetricsConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Removes <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have the
     * <code>s3:PutBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a
     * Policy</a>.
     * </p>
     * <p>
     * For information about Amazon S3 Object Ownership, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">Using Object Ownership</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketOwnershipControls</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GetBucketOwnershipControls</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>PutBucketOwnershipControls</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketOwnershipControlsRequest
     * @return Result of the DeleteBucketOwnershipControls operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketOwnershipControls
     */
    default DeleteBucketOwnershipControlsResponse deleteBucketOwnershipControls(
            DeleteBucketOwnershipControlsRequest deleteBucketOwnershipControlsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Removes <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have the
     * <code>s3:PutBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a
     * Policy</a>.
     * </p>
     * <p>
     * For information about Amazon S3 Object Ownership, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">Using Object Ownership</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketOwnershipControls</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GetBucketOwnershipControls</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>PutBucketOwnershipControls</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketOwnershipControlsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBucketOwnershipControlsRequest#builder()}
     * </p>
     *
     * @param deleteBucketOwnershipControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBucketOwnershipControls operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketOwnershipControls
     */
    default DeleteBucketOwnershipControlsResponse deleteBucketOwnershipControls(
            Consumer<DeleteBucketOwnershipControlsRequest.Builder> deleteBucketOwnershipControlsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteBucketOwnershipControls(DeleteBucketOwnershipControlsRequest.builder()
                .applyMutation(deleteBucketOwnershipControlsRequest).build());
    }

    /**
     * <p>
     * Deletes the policy of a specified bucket.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket,
     * the calling identity must both have the <code>DeleteBucketPolicy</code> permissions on the specified bucket and
     * belong to the bucket owner's account in order to use this operation.
     * </p>
     * <p>
     * If you don't have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code>
     * error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's
     * account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.
     * </p>
     * <important>
     * <p>
     * To ensure that bucket owners don't inadvertently lock themselves out of their own buckets, the root principal in
     * a bucket owner's Amazon Web Services account can perform the <code>GetBucketPolicy</code>,
     * <code>PutBucketPolicy</code>, and <code>DeleteBucketPolicy</code> API actions, even if their bucket policy
     * explicitly denies the root principal's access. Bucket owner root principals can only be blocked from performing
     * these API actions by VPC endpoint policies and Amazon Web Services Organizations policies.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:DeleteBucketPolicy</code> permission is required in a
     * policy. For more information about general purpose buckets bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:DeleteBucketPolicy</code> permission in an IAM identity-based policy instead of a bucket policy.
     * Cross-account access to this API operation isn't supported. This operation can only be performed by the Amazon
     * Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>DeleteBucketPolicy</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketPolicyRequest
     * @return Result of the DeleteBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketPolicy
     */
    default DeleteBucketPolicyResponse deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the policy of a specified bucket.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket,
     * the calling identity must both have the <code>DeleteBucketPolicy</code> permissions on the specified bucket and
     * belong to the bucket owner's account in order to use this operation.
     * </p>
     * <p>
     * If you don't have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code>
     * error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's
     * account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.
     * </p>
     * <important>
     * <p>
     * To ensure that bucket owners don't inadvertently lock themselves out of their own buckets, the root principal in
     * a bucket owner's Amazon Web Services account can perform the <code>GetBucketPolicy</code>,
     * <code>PutBucketPolicy</code>, and <code>DeleteBucketPolicy</code> API actions, even if their bucket policy
     * explicitly denies the root principal's access. Bucket owner root principals can only be blocked from performing
     * these API actions by VPC endpoint policies and Amazon Web Services Organizations policies.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:DeleteBucketPolicy</code> permission is required in a
     * policy. For more information about general purpose buckets bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:DeleteBucketPolicy</code> permission in an IAM identity-based policy instead of a bucket policy.
     * Cross-account access to this API operation isn't supported. This operation can only be performed by the Amazon
     * Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>DeleteBucketPolicy</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBucketPolicyRequest#builder()}
     * </p>
     *
     * @param deleteBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest.Builder} to create a request.
     * @return Result of the DeleteBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketPolicy
     */
    default DeleteBucketPolicyResponse deleteBucketPolicy(Consumer<DeleteBucketPolicyRequest.Builder> deleteBucketPolicyRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteBucketPolicy(DeleteBucketPolicyRequest.builder().applyMutation(deleteBucketPolicyRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the replication configuration from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutReplicationConfiguration</code>
     * action. The bucket owner has these permissions by default and can grant it to others. For more information about
     * permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <note>
     * <p>
     * It can take a while for the deletion of a replication configuration to fully propagate.
     * </p>
     * </note>
     * <p>
     * For information about replication configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html">PutBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html">GetBucketReplication</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketReplicationRequest
     * @return Result of the DeleteBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketReplication
     */
    default DeleteBucketReplicationResponse deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the replication configuration from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutReplicationConfiguration</code>
     * action. The bucket owner has these permissions by default and can grant it to others. For more information about
     * permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <note>
     * <p>
     * It can take a while for the deletion of a replication configuration to fully propagate.
     * </p>
     * </note>
     * <p>
     * For information about replication configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html">PutBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html">GetBucketReplication</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketReplicationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteBucketReplicationRequest#builder()}
     * </p>
     *
     * @param deleteBucketReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketReplicationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketReplication
     */
    default DeleteBucketReplicationResponse deleteBucketReplication(
            Consumer<DeleteBucketReplicationRequest.Builder> deleteBucketReplicationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return deleteBucketReplication(DeleteBucketReplicationRequest.builder().applyMutation(deleteBucketReplicationRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the tags from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:PutBucketTagging</code> action. By
     * default, the bucket owner has this permission and can grant this permission to others.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketTaggingRequest
     * @return Result of the DeleteBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketTagging
     */
    default DeleteBucketTaggingResponse deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the tags from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:PutBucketTagging</code> action. By
     * default, the bucket owner has this permission and can grant this permission to others.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketTaggingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBucketTaggingRequest#builder()}
     * </p>
     *
     * @param deleteBucketTaggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest.Builder} to create a request.
     * @return Result of the DeleteBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketTagging
     */
    default DeleteBucketTaggingResponse deleteBucketTagging(
            Consumer<DeleteBucketTaggingRequest.Builder> deleteBucketTaggingRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return deleteBucketTagging(DeleteBucketTaggingRequest.builder().applyMutation(deleteBucketTaggingRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This action removes the website configuration for a bucket. Amazon S3 returns a <code>200 OK</code> response upon
     * successfully deleting a website configuration on the specified bucket. You will get a <code>200 OK</code>
     * response if the website configuration you are trying to delete does not exist on the bucket. Amazon S3 returns a
     * <code>404</code> response if the bucket specified in the request does not exist.
     * </p>
     * <p>
     * This DELETE action requires the <code>S3:DeleteBucketWebsite</code> permission. By default, only the bucket owner
     * can delete the website configuration attached to a bucket. However, bucket owners can grant other users
     * permission to delete the website configuration by writing a bucket policy granting them the
     * <code>S3:DeleteBucketWebsite</code> permission.
     * </p>
     * <p>
     * For more information about hosting websites, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketWebsite</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketWebsite.html">GetBucketWebsite</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html">PutBucketWebsite</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketWebsiteRequest
     * @return Result of the DeleteBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketWebsite
     */
    default DeleteBucketWebsiteResponse deleteBucketWebsite(DeleteBucketWebsiteRequest deleteBucketWebsiteRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This action removes the website configuration for a bucket. Amazon S3 returns a <code>200 OK</code> response upon
     * successfully deleting a website configuration on the specified bucket. You will get a <code>200 OK</code>
     * response if the website configuration you are trying to delete does not exist on the bucket. Amazon S3 returns a
     * <code>404</code> response if the bucket specified in the request does not exist.
     * </p>
     * <p>
     * This DELETE action requires the <code>S3:DeleteBucketWebsite</code> permission. By default, only the bucket owner
     * can delete the website configuration attached to a bucket. However, bucket owners can grant other users
     * permission to delete the website configuration by writing a bucket policy granting them the
     * <code>S3:DeleteBucketWebsite</code> permission.
     * </p>
     * <p>
     * For more information about hosting websites, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketWebsite</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketWebsite.html">GetBucketWebsite</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html">PutBucketWebsite</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBucketWebsiteRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBucketWebsiteRequest#builder()}
     * </p>
     *
     * @param deleteBucketWebsiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest.Builder} to create a request.
     * @return Result of the DeleteBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketWebsite
     */
    default DeleteBucketWebsiteResponse deleteBucketWebsite(
            Consumer<DeleteBucketWebsiteRequest.Builder> deleteBucketWebsiteRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return deleteBucketWebsite(DeleteBucketWebsiteRequest.builder().applyMutation(deleteBucketWebsiteRequest).build());
    }

    /**
     * <p>
     * Removes an object from a bucket. The behavior depends on the bucket's versioning state. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeletingObjects.html#DeletingObjects-best-practices">Best
     * practices to consider before deleting an object</a>.
     * </p>
     * <p>
     * To remove a specific version, you must use the <code>versionId</code> query parameter. Using this query parameter
     * permanently deletes the version. If the object deleted is a delete marker, Amazon S3 sets the response header
     * <code>x-amz-delete-marker</code> to true. If the object you want to delete is in a bucket where the bucket
     * versioning configuration is MFA delete enabled, you must include the <code>x-amz-mfa</code> request header in the
     * DELETE <code>versionId</code> request. Requests that include <code>x-amz-mfa</code> must use HTTPS. For more
     * information about MFA delete and to see example requests, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMFADelete.html">Using MFA delete</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectDELETE.html#ExampleVersionObjectDelete">Sample
     * request</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * S3 Versioning isn't enabled and supported for directory buckets. For this API operation, only the
     * <code>null</code> value of the version ID is supported by directory buckets. You can only specify
     * <code>null</code> to the <code>versionId</code> query parameter in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * For directory buckets, you must make requests for this API operation to the Zonal endpoint. These endpoints
     * support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * MFA delete is not supported by directory buckets.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The following permissions are required in your policies when your
     * <code>DeleteObjects</code> request includes specific headers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>s3:DeleteObject</code> </b> - To delete an object from a bucket, you must always have the
     * <code>s3:DeleteObject</code> permission.
     * </p>
     * <note>
     * <p>
     * You can also use <a>PutBucketLifecycle</a> to delete objects in Amazon S3.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>s3:DeleteObjectVersion</code> </b> - To delete a specific version of an object from a
     * versioning-enabled bucket, you must have the <code>s3:DeleteObjectVersion</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to block users or accounts from removing or deleting objects from your bucket, you must deny them the
     * <code>s3:DeleteObject</code>, <code>s3:DeleteObjectVersion</code>, and <code>s3:PutLifeCycleConfiguration</code>
     * permissions.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a>CreateSession</a> API operation for session-based authorization.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following action is related to <code>DeleteObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteObjectRequest
     * @return Result of the DeleteObject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObject
     */
    default DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an object from a bucket. The behavior depends on the bucket's versioning state. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeletingObjects.html#DeletingObjects-best-practices">Best
     * practices to consider before deleting an object</a>.
     * </p>
     * <p>
     * To remove a specific version, you must use the <code>versionId</code> query parameter. Using this query parameter
     * permanently deletes the version. If the object deleted is a delete marker, Amazon S3 sets the response header
     * <code>x-amz-delete-marker</code> to true. If the object you want to delete is in a bucket where the bucket
     * versioning configuration is MFA delete enabled, you must include the <code>x-amz-mfa</code> request header in the
     * DELETE <code>versionId</code> request. Requests that include <code>x-amz-mfa</code> must use HTTPS. For more
     * information about MFA delete and to see example requests, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMFADelete.html">Using MFA delete</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectDELETE.html#ExampleVersionObjectDelete">Sample
     * request</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * S3 Versioning isn't enabled and supported for directory buckets. For this API operation, only the
     * <code>null</code> value of the version ID is supported by directory buckets. You can only specify
     * <code>null</code> to the <code>versionId</code> query parameter in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * For directory buckets, you must make requests for this API operation to the Zonal endpoint. These endpoints
     * support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * MFA delete is not supported by directory buckets.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The following permissions are required in your policies when your
     * <code>DeleteObjects</code> request includes specific headers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>s3:DeleteObject</code> </b> - To delete an object from a bucket, you must always have the
     * <code>s3:DeleteObject</code> permission.
     * </p>
     * <note>
     * <p>
     * You can also use <a>PutBucketLifecycle</a> to delete objects in Amazon S3.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>s3:DeleteObjectVersion</code> </b> - To delete a specific version of an object from a
     * versioning-enabled bucket, you must have the <code>s3:DeleteObjectVersion</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to block users or accounts from removing or deleting objects from your bucket, you must deny them the
     * <code>s3:DeleteObject</code>, <code>s3:DeleteObjectVersion</code>, and <code>s3:PutLifeCycleConfiguration</code>
     * permissions.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a>CreateSession</a> API operation for session-based authorization.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following action is related to <code>DeleteObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteObjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteObjectRequest#builder()}
     * </p>
     *
     * @param deleteObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteObjectRequest.Builder} to create a request.
     * @return Result of the DeleteObject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObject
     */
    default DeleteObjectResponse deleteObject(Consumer<DeleteObjectRequest.Builder> deleteObjectRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteObject(DeleteObjectRequest.builder().applyMutation(deleteObjectRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Removes the entire tag set from the specified object. For more information about managing object tags, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html"> Object Tagging</a>.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:DeleteObjectTagging</code> action.
     * </p>
     * <p>
     * To delete tags of a specific object version, add the <code>versionId</code> query parameter in the request. You
     * will need permission for the <code>s3:DeleteObjectVersionTagging</code> action.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteObjectTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html">PutObjectTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html">GetObjectTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteObjectTaggingRequest
     * @return Result of the DeleteObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObjectTagging
     */
    default DeleteObjectTaggingResponse deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Removes the entire tag set from the specified object. For more information about managing object tags, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html"> Object Tagging</a>.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:DeleteObjectTagging</code> action.
     * </p>
     * <p>
     * To delete tags of a specific object version, add the <code>versionId</code> query parameter in the request. You
     * will need permission for the <code>s3:DeleteObjectVersionTagging</code> action.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteObjectTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html">PutObjectTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html">GetObjectTagging</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteObjectTaggingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteObjectTaggingRequest#builder()}
     * </p>
     *
     * @param deleteObjectTaggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest.Builder} to create a request.
     * @return Result of the DeleteObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObjectTagging
     */
    default DeleteObjectTaggingResponse deleteObjectTagging(
            Consumer<DeleteObjectTaggingRequest.Builder> deleteObjectTaggingRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return deleteObjectTagging(DeleteObjectTaggingRequest.builder().applyMutation(deleteObjectTaggingRequest).build());
    }

    /**
     * <p>
     * This operation enables you to delete multiple objects from a bucket using a single HTTP request. If you know the
     * object keys that you want to delete, then this operation provides a suitable alternative to sending individual
     * delete requests, reducing per-request overhead.
     * </p>
     * <p>
     * The request can contain a list of up to 1000 keys that you want to delete. In the XML, you provide the object key
     * names, and optionally, version IDs if you want to delete a specific version of the object from a
     * versioning-enabled bucket. For each key, Amazon S3 performs a delete operation and returns the result of that
     * delete, success or failure, in the response. Note that if the object specified in the request is not found,
     * Amazon S3 returns the result as deleted.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets</b> - S3 Versioning isn't enabled and supported for directory buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * The operation supports two modes for the response: verbose and quiet. By default, the operation uses verbose mode
     * in which the response includes the result of deletion of each key in your request. In quiet mode the response
     * includes only keys where the delete operation encountered an error. For a successful deletion in a quiet mode,
     * the operation does not return any information about the delete in the response body.
     * </p>
     * <p>
     * When performing this action on an MFA Delete enabled bucket, that attempts to delete any versioned objects, you
     * must include an MFA token. If you do not provide one, the entire request will fail, even if there are
     * non-versioned objects you are trying to delete. If you provide an invalid token, whether there are versioned keys
     * in the request or not, the entire Multi-Object Delete request will fail. For information about MFA Delete, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html#MultiFactorAuthenticationDelete">MFA
     * Delete</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - MFA delete is not supported by directory buckets.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The following permissions are required in your policies when your
     * <code>DeleteObjects</code> request includes specific headers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>s3:DeleteObject</code> </b> - To delete an object from a bucket, you must always specify the
     * <code>s3:DeleteObject</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:DeleteObjectVersion</code> </b> - To delete a specific version of an object from a
     * versioning-enabled bucket, you must specify the <code>s3:DeleteObjectVersion</code> permission.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Content-MD5 request header</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - The Content-MD5 request header is required for all Multi-Object Delete requests.
     * Amazon S3 uses the header value to ensure that your request body has not been altered in transit.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - The Content-MD5 request header or a additional checksum request header (including
     * <code>x-amz-checksum-crc32</code>, <code>x-amz-checksum-crc32c</code>, <code>x-amz-checksum-sha1</code>, or
     * <code>x-amz-checksum-sha256</code>) is required for all Multi-Object Delete requests.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>DeleteObjects</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteObjectsRequest
     * @return Result of the DeleteObjects operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObjects
     */
    default DeleteObjectsResponse deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation enables you to delete multiple objects from a bucket using a single HTTP request. If you know the
     * object keys that you want to delete, then this operation provides a suitable alternative to sending individual
     * delete requests, reducing per-request overhead.
     * </p>
     * <p>
     * The request can contain a list of up to 1000 keys that you want to delete. In the XML, you provide the object key
     * names, and optionally, version IDs if you want to delete a specific version of the object from a
     * versioning-enabled bucket. For each key, Amazon S3 performs a delete operation and returns the result of that
     * delete, success or failure, in the response. Note that if the object specified in the request is not found,
     * Amazon S3 returns the result as deleted.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets</b> - S3 Versioning isn't enabled and supported for directory buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * The operation supports two modes for the response: verbose and quiet. By default, the operation uses verbose mode
     * in which the response includes the result of deletion of each key in your request. In quiet mode the response
     * includes only keys where the delete operation encountered an error. For a successful deletion in a quiet mode,
     * the operation does not return any information about the delete in the response body.
     * </p>
     * <p>
     * When performing this action on an MFA Delete enabled bucket, that attempts to delete any versioned objects, you
     * must include an MFA token. If you do not provide one, the entire request will fail, even if there are
     * non-versioned objects you are trying to delete. If you provide an invalid token, whether there are versioned keys
     * in the request or not, the entire Multi-Object Delete request will fail. For information about MFA Delete, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html#MultiFactorAuthenticationDelete">MFA
     * Delete</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - MFA delete is not supported by directory buckets.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The following permissions are required in your policies when your
     * <code>DeleteObjects</code> request includes specific headers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>s3:DeleteObject</code> </b> - To delete an object from a bucket, you must always specify the
     * <code>s3:DeleteObject</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:DeleteObjectVersion</code> </b> - To delete a specific version of an object from a
     * versioning-enabled bucket, you must specify the <code>s3:DeleteObjectVersion</code> permission.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Content-MD5 request header</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - The Content-MD5 request header is required for all Multi-Object Delete requests.
     * Amazon S3 uses the header value to ensure that your request body has not been altered in transit.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - The Content-MD5 request header or a additional checksum request header (including
     * <code>x-amz-checksum-crc32</code>, <code>x-amz-checksum-crc32c</code>, <code>x-amz-checksum-sha1</code>, or
     * <code>x-amz-checksum-sha256</code>) is required for all Multi-Object Delete requests.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>DeleteObjects</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteObjectsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteObjectsRequest#builder()}
     * </p>
     *
     * @param deleteObjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeleteObjectsRequest.Builder} to create a request.
     * @return Result of the DeleteObjects operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObjects
     */
    default DeleteObjectsResponse deleteObjects(Consumer<DeleteObjectsRequest.Builder> deleteObjectsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return deleteObjects(DeleteObjectsRequest.builder().applyMutation(deleteObjectsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Removes the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you must
     * have the <code>s3:PutBucketPublicAccessBlock</code> permission. For more information about permissions, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeletePublicAccessBlock</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3
     * Block Public Access</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html">GetBucketPolicyStatus</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deletePublicAccessBlockRequest
     * @return Result of the DeletePublicAccessBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeletePublicAccessBlock
     */
    default DeletePublicAccessBlockResponse deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Removes the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you must
     * have the <code>s3:PutBucketPublicAccessBlock</code> permission. For more information about permissions, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * The following operations are related to <code>DeletePublicAccessBlock</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3
     * Block Public Access</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html">GetBucketPolicyStatus</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublicAccessBlockRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePublicAccessBlockRequest#builder()}
     * </p>
     *
     * @param deletePublicAccessBlockRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePublicAccessBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeletePublicAccessBlock
     */
    default DeletePublicAccessBlockResponse deletePublicAccessBlock(
            Consumer<DeletePublicAccessBlockRequest.Builder> deletePublicAccessBlockRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return deletePublicAccessBlock(DeletePublicAccessBlockRequest.builder().applyMutation(deletePublicAccessBlockRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This implementation of the GET action uses the <code>accelerate</code> subresource to return the Transfer
     * Acceleration state of a bucket, which is either <code>Enabled</code> or <code>Suspended</code>. Amazon S3
     * Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to and from
     * Amazon S3.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:GetAccelerateConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * You set the Transfer Acceleration state of an existing bucket to <code>Enabled</code> or <code>Suspended</code>
     * by using the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html">
     * PutBucketAccelerateConfiguration</a> operation.
     * </p>
     * <p>
     * A GET <code>accelerate</code> request does not return a state value for a bucket that has no transfer
     * acceleration state. A bucket has no Transfer Acceleration state if a state has never been set on the bucket.
     * </p>
     * <p>
     * For more information about transfer acceleration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a> in
     * the Amazon S3 User Guide.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketAccelerateConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html">
     * PutBucketAccelerateConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketAccelerateConfigurationRequest
     * @return Result of the GetBucketAccelerateConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAccelerateConfiguration
     */
    default GetBucketAccelerateConfigurationResponse getBucketAccelerateConfiguration(
            GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This implementation of the GET action uses the <code>accelerate</code> subresource to return the Transfer
     * Acceleration state of a bucket, which is either <code>Enabled</code> or <code>Suspended</code>. Amazon S3
     * Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to and from
     * Amazon S3.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:GetAccelerateConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * You set the Transfer Acceleration state of an existing bucket to <code>Enabled</code> or <code>Suspended</code>
     * by using the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html">
     * PutBucketAccelerateConfiguration</a> operation.
     * </p>
     * <p>
     * A GET <code>accelerate</code> request does not return a state value for a bucket that has no transfer
     * acceleration state. A bucket has no Transfer Acceleration state if a state has never been set on the bucket.
     * </p>
     * <p>
     * For more information about transfer acceleration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a> in
     * the Amazon S3 User Guide.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketAccelerateConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html">
     * PutBucketAccelerateConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketAccelerateConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetBucketAccelerateConfigurationRequest#builder()}
     * </p>
     *
     * @param getBucketAccelerateConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetBucketAccelerateConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAccelerateConfiguration
     */
    default GetBucketAccelerateConfigurationResponse getBucketAccelerateConfiguration(
            Consumer<GetBucketAccelerateConfigurationRequest.Builder> getBucketAccelerateConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketAccelerateConfiguration(GetBucketAccelerateConfigurationRequest.builder()
                .applyMutation(getBucketAccelerateConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This implementation of the <code>GET</code> action uses the <code>acl</code> subresource to return the access
     * control list (ACL) of a bucket. To use <code>GET</code> to return the ACL of the bucket, you must have the
     * <code>READ_ACP</code> access to the bucket. If <code>READ_ACP</code> permission is granted to the anonymous user,
     * you can return the ACL of the bucket without using an authorization header.
     * </p>
     * <p>
     * When you use this API operation with an access point, provide the alias of the access point in place of the
     * bucket name.
     * </p>
     * <p>
     * When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access
     * point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error
     * code <code>InvalidAccessPointAliasError</code> is returned. For more information about
     * <code>InvalidAccessPointAliasError</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.
     * </p>
     * <note>
     * <p>
     * If your bucket uses the bucket owner enforced setting for S3 Object Ownership, requests to read ACLs are still
     * supported and return the <code>bucket-owner-full-control</code> ACL with the owner being the account that created
     * the bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html"> Controlling object
     * ownership and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The following operations are related to <code>GetBucketAcl</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketAclRequest
     * @return Result of the GetBucketAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAcl
     */
    default GetBucketAclResponse getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This implementation of the <code>GET</code> action uses the <code>acl</code> subresource to return the access
     * control list (ACL) of a bucket. To use <code>GET</code> to return the ACL of the bucket, you must have the
     * <code>READ_ACP</code> access to the bucket. If <code>READ_ACP</code> permission is granted to the anonymous user,
     * you can return the ACL of the bucket without using an authorization header.
     * </p>
     * <p>
     * When you use this API operation with an access point, provide the alias of the access point in place of the
     * bucket name.
     * </p>
     * <p>
     * When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access
     * point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error
     * code <code>InvalidAccessPointAliasError</code> is returned. For more information about
     * <code>InvalidAccessPointAliasError</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.
     * </p>
     * <note>
     * <p>
     * If your bucket uses the bucket owner enforced setting for S3 Object Ownership, requests to read ACLs are still
     * supported and return the <code>bucket-owner-full-control</code> ACL with the owner being the account that created
     * the bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html"> Controlling object
     * ownership and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The following operations are related to <code>GetBucketAcl</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketAclRequest.Builder} avoiding the need to
     * create one manually via {@link GetBucketAclRequest#builder()}
     * </p>
     *
     * @param getBucketAclRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketAclRequest.Builder} to create a request.
     * @return Result of the GetBucketAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAcl
     */
    default GetBucketAclResponse getBucketAcl(Consumer<GetBucketAclRequest.Builder> getBucketAclRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketAcl(GetBucketAclRequest.builder().applyMutation(getBucketAclRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This implementation of the GET action returns an analytics configuration (identified by the analytics
     * configuration ID) from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetAnalyticsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * > Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * For information about Amazon S3 analytics feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage
     * Class Analysis</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketAnalyticsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">
     * DeleteBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">
     * ListBucketAnalyticsConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">
     * PutBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketAnalyticsConfigurationRequest
     * @return Result of the GetBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAnalyticsConfiguration
     */
    default GetBucketAnalyticsConfigurationResponse getBucketAnalyticsConfiguration(
            GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This implementation of the GET action returns an analytics configuration (identified by the analytics
     * configuration ID) from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetAnalyticsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * > Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * For information about Amazon S3 analytics feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage
     * Class Analysis</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketAnalyticsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">
     * DeleteBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">
     * ListBucketAnalyticsConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">
     * PutBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketAnalyticsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetBucketAnalyticsConfigurationRequest#builder()}
     * </p>
     *
     * @param getBucketAnalyticsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAnalyticsConfiguration
     */
    default GetBucketAnalyticsConfigurationResponse getBucketAnalyticsConfiguration(
            Consumer<GetBucketAnalyticsConfigurationRequest.Builder> getBucketAnalyticsConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest.builder()
                .applyMutation(getBucketAnalyticsConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the Cross-Origin Resource Sharing (CORS) configuration information set for the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:GetBucketCORS</code> action. By default,
     * the bucket owner has this permission and can grant it to others.
     * </p>
     * <p>
     * When you use this API operation with an access point, provide the alias of the access point in place of the
     * bucket name.
     * </p>
     * <p>
     * When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access
     * point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error
     * code <code>InvalidAccessPointAliasError</code> is returned. For more information about
     * <code>InvalidAccessPointAliasError</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.
     * </p>
     * <p>
     * For more information about CORS, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">
     * Enabling Cross-Origin Resource Sharing</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketCors</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html">PutBucketCors</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html">DeleteBucketCors</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketCorsRequest
     * @return Result of the GetBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketCors
     */
    default GetBucketCorsResponse getBucketCors(GetBucketCorsRequest getBucketCorsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the Cross-Origin Resource Sharing (CORS) configuration information set for the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:GetBucketCORS</code> action. By default,
     * the bucket owner has this permission and can grant it to others.
     * </p>
     * <p>
     * When you use this API operation with an access point, provide the alias of the access point in place of the
     * bucket name.
     * </p>
     * <p>
     * When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access
     * point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error
     * code <code>InvalidAccessPointAliasError</code> is returned. For more information about
     * <code>InvalidAccessPointAliasError</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.
     * </p>
     * <p>
     * For more information about CORS, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">
     * Enabling Cross-Origin Resource Sharing</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketCors</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html">PutBucketCors</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html">DeleteBucketCors</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketCorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetBucketCorsRequest#builder()}
     * </p>
     *
     * @param getBucketCorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketCorsRequest.Builder} to create a request.
     * @return Result of the GetBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketCors
     */
    default GetBucketCorsResponse getBucketCors(Consumer<GetBucketCorsRequest.Builder> getBucketCorsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketCors(GetBucketCorsRequest.builder().applyMutation(getBucketCorsRequest).build());
    }

    /**
     * <p>
     * Returns the default encryption configuration for an Amazon S3 bucket. By default, all buckets have a default
     * encryption configuration that uses server-side encryption with Amazon S3 managed keys (SSE-S3).
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b> - For information about the bucket default encryption feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Bucket Default
     * Encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. For information about the default encryption configuration in directory buckets,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting
     * default server-side encryption behavior for directory buckets</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:GetEncryptionConfiguration</code> permission is required
     * in a policy. The bucket owner has this permission by default. The bucket owner can grant this permission to
     * others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:GetEncryptionConfiguration</code> permission in an IAM identity-based policy instead of a bucket
     * policy. Cross-account access to this API operation isn't supported. This operation can only be performed by the
     * Amazon Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetBucketEncryption</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html">PutBucketEncryption</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html">DeleteBucketEncryption</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketEncryptionRequest
     * @return Result of the GetBucketEncryption operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketEncryption
     */
    default GetBucketEncryptionResponse getBucketEncryption(GetBucketEncryptionRequest getBucketEncryptionRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default encryption configuration for an Amazon S3 bucket. By default, all buckets have a default
     * encryption configuration that uses server-side encryption with Amazon S3 managed keys (SSE-S3).
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b> - For information about the bucket default encryption feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Bucket Default
     * Encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. For information about the default encryption configuration in directory buckets,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting
     * default server-side encryption behavior for directory buckets</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:GetEncryptionConfiguration</code> permission is required
     * in a policy. The bucket owner has this permission by default. The bucket owner can grant this permission to
     * others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:GetEncryptionConfiguration</code> permission in an IAM identity-based policy instead of a bucket
     * policy. Cross-account access to this API operation isn't supported. This operation can only be performed by the
     * Amazon Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetBucketEncryption</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html">PutBucketEncryption</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html">DeleteBucketEncryption</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketEncryptionRequest.Builder} avoiding the
     * need to create one manually via {@link GetBucketEncryptionRequest#builder()}
     * </p>
     *
     * @param getBucketEncryptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketEncryptionRequest.Builder} to create a request.
     * @return Result of the GetBucketEncryption operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketEncryption
     */
    default GetBucketEncryptionResponse getBucketEncryption(
            Consumer<GetBucketEncryptionRequest.Builder> getBucketEncryptionRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getBucketEncryption(GetBucketEncryptionRequest.builder().applyMutation(getBucketEncryptionRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets the S3 Intelligent-Tiering configuration from the specified bucket.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to
     * the most cost-effective storage access tier, without performance impact or operational overhead. S3
     * Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get
     * the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional
     * archiving capabilities.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or
     * unpredictable access patterns, independent of object size or retention period. If the size of an object is less
     * than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are
     * always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage
     * class for automatically optimizing frequently and infrequently accessed objects</a>.
     * </p>
     * <p>
     * Operations related to <code>GetBucketIntelligentTieringConfiguration</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">
     * DeleteBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">
     * PutBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">
     * ListBucketIntelligentTieringConfigurations</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketIntelligentTieringConfigurationRequest
     * @return Result of the GetBucketIntelligentTieringConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketIntelligentTieringConfiguration
     */
    default GetBucketIntelligentTieringConfigurationResponse getBucketIntelligentTieringConfiguration(
            GetBucketIntelligentTieringConfigurationRequest getBucketIntelligentTieringConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets the S3 Intelligent-Tiering configuration from the specified bucket.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to
     * the most cost-effective storage access tier, without performance impact or operational overhead. S3
     * Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get
     * the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional
     * archiving capabilities.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or
     * unpredictable access patterns, independent of object size or retention period. If the size of an object is less
     * than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are
     * always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage
     * class for automatically optimizing frequently and infrequently accessed objects</a>.
     * </p>
     * <p>
     * Operations related to <code>GetBucketIntelligentTieringConfiguration</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">
     * DeleteBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">
     * PutBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">
     * ListBucketIntelligentTieringConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetBucketIntelligentTieringConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetBucketIntelligentTieringConfigurationRequest#builder()}
     * </p>
     *
     * @param getBucketIntelligentTieringConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetBucketIntelligentTieringConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketIntelligentTieringConfiguration
     */
    default GetBucketIntelligentTieringConfigurationResponse getBucketIntelligentTieringConfiguration(
            Consumer<GetBucketIntelligentTieringConfigurationRequest.Builder> getBucketIntelligentTieringConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketIntelligentTieringConfiguration(GetBucketIntelligentTieringConfigurationRequest.builder()
                .applyMutation(getBucketIntelligentTieringConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns an inventory configuration (identified by the inventory configuration ID) from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetInventoryConfiguration</code> action.
     * The bucket owner has this permission by default and can grant this permission to others. For more information
     * about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about the Amazon S3 inventory feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketInventoryConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">
     * DeleteBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">
     * ListBucketInventoryConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">
     * PutBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketInventoryConfigurationRequest
     * @return Result of the GetBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketInventoryConfiguration
     */
    default GetBucketInventoryConfigurationResponse getBucketInventoryConfiguration(
            GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns an inventory configuration (identified by the inventory configuration ID) from the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetInventoryConfiguration</code> action.
     * The bucket owner has this permission by default and can grant this permission to others. For more information
     * about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about the Amazon S3 inventory feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketInventoryConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">
     * DeleteBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">
     * ListBucketInventoryConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">
     * PutBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketInventoryConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetBucketInventoryConfigurationRequest#builder()}
     * </p>
     *
     * @param getBucketInventoryConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketInventoryConfiguration
     */
    default GetBucketInventoryConfigurationResponse getBucketInventoryConfiguration(
            Consumer<GetBucketInventoryConfigurationRequest.Builder> getBucketInventoryConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest.builder()
                .applyMutation(getBucketInventoryConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the lifecycle configuration information set on the bucket. For information about lifecycle configuration,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle
     * Management</a>.
     * </p>
     * <p>
     * Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or
     * more object tags, object size, or any combination of these. Accordingly, this section describes the latest API,
     * which is compatible with the new functionality. The previous version of the API supported filtering based only on
     * an object key name prefix, which is supported for general purpose buckets for backward compatibility. For the
     * related API description, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html">GetBucketLifecycle</a>.
     * </p>
     * <note>
     * <p>
     * Lifecyle configurations for directory buckets only support expiring objects and cancelling multipart uploads.
     * Expiring of versioned objects, transitions and tag filters are not supported.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - By default, all Amazon S3 resources are private, including buckets,
     * objects, and related subresources (for example, lifecycle configuration and website configuration). Only the
     * resource owner (that is, the Amazon Web Services account that created it) can access the resource. The resource
     * owner can optionally grant access permissions to others by writing an access policy. For this operation, a user
     * must have the <code>s3:GetLifecycleConfiguration</code> permission.
     * </p>
     * <p>
     * For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:GetLifecycleConfiguration</code>
     * permission in an IAM identity-based policy to use this operation. Cross-account access to this API operation
     * isn't supported. The resource owner can optionally grant access permissions to others by creating a role or user
     * for them as long as they are within the same account as the owner and resource.
     * </p>
     * <p>
     * For more information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Authorizing Regional
     * endpoint APIs with IAM</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <code>GetBucketLifecycleConfiguration</code> has the following special error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>NoSuchLifecycleConfiguration</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The lifecycle configuration does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 404 Not Found
     * </p>
     * </li>
     * <li>
     * <p>
     * SOAP Fault Code Prefix: Client
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following operations are related to <code>GetBucketLifecycleConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html">GetBucketLifecycle</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html">PutBucketLifecycle</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketLifecycleConfigurationRequest
     * @return Result of the GetBucketLifecycleConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLifecycleConfiguration
     */
    default GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(
            GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the lifecycle configuration information set on the bucket. For information about lifecycle configuration,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle
     * Management</a>.
     * </p>
     * <p>
     * Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or
     * more object tags, object size, or any combination of these. Accordingly, this section describes the latest API,
     * which is compatible with the new functionality. The previous version of the API supported filtering based only on
     * an object key name prefix, which is supported for general purpose buckets for backward compatibility. For the
     * related API description, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html">GetBucketLifecycle</a>.
     * </p>
     * <note>
     * <p>
     * Lifecyle configurations for directory buckets only support expiring objects and cancelling multipart uploads.
     * Expiring of versioned objects, transitions and tag filters are not supported.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - By default, all Amazon S3 resources are private, including buckets,
     * objects, and related subresources (for example, lifecycle configuration and website configuration). Only the
     * resource owner (that is, the Amazon Web Services account that created it) can access the resource. The resource
     * owner can optionally grant access permissions to others by writing an access policy. For this operation, a user
     * must have the <code>s3:GetLifecycleConfiguration</code> permission.
     * </p>
     * <p>
     * For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:GetLifecycleConfiguration</code>
     * permission in an IAM identity-based policy to use this operation. Cross-account access to this API operation
     * isn't supported. The resource owner can optionally grant access permissions to others by creating a role or user
     * for them as long as they are within the same account as the owner and resource.
     * </p>
     * <p>
     * For more information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Authorizing Regional
     * endpoint APIs with IAM</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <code>GetBucketLifecycleConfiguration</code> has the following special error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>NoSuchLifecycleConfiguration</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The lifecycle configuration does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 404 Not Found
     * </p>
     * </li>
     * <li>
     * <p>
     * SOAP Fault Code Prefix: Client
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following operations are related to <code>GetBucketLifecycleConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html">GetBucketLifecycle</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html">PutBucketLifecycle</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketLifecycleConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetBucketLifecycleConfigurationRequest#builder()}
     * </p>
     *
     * @param getBucketLifecycleConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetBucketLifecycleConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLifecycleConfiguration
     */
    default GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(
            Consumer<GetBucketLifecycleConfigurationRequest.Builder> getBucketLifecycleConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest.builder()
                .applyMutation(getBucketLifecycleConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the Region the bucket resides in. You set the bucket's Region using the <code>LocationConstraint</code>
     * request parameter in a <code>CreateBucket</code> request. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>.
     * </p>
     * <p>
     * When you use this API operation with an access point, provide the alias of the access point in place of the
     * bucket name.
     * </p>
     * <p>
     * When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access
     * point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error
     * code <code>InvalidAccessPointAliasError</code> is returned. For more information about
     * <code>InvalidAccessPointAliasError</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.
     * </p>
     * <note>
     * <p>
     * We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_HeadBucket.html">HeadBucket</a> to return the Region
     * that a bucket resides in. For backward compatibility, Amazon S3 continues to support GetBucketLocation.
     * </p>
     * </note>
     * <p>
     * The following operations are related to <code>GetBucketLocation</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketLocationRequest
     * @return Result of the GetBucketLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLocation
     */
    default GetBucketLocationResponse getBucketLocation(GetBucketLocationRequest getBucketLocationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the Region the bucket resides in. You set the bucket's Region using the <code>LocationConstraint</code>
     * request parameter in a <code>CreateBucket</code> request. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>.
     * </p>
     * <p>
     * When you use this API operation with an access point, provide the alias of the access point in place of the
     * bucket name.
     * </p>
     * <p>
     * When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access
     * point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error
     * code <code>InvalidAccessPointAliasError</code> is returned. For more information about
     * <code>InvalidAccessPointAliasError</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.
     * </p>
     * <note>
     * <p>
     * We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_HeadBucket.html">HeadBucket</a> to return the Region
     * that a bucket resides in. For backward compatibility, Amazon S3 continues to support GetBucketLocation.
     * </p>
     * </note>
     * <p>
     * The following operations are related to <code>GetBucketLocation</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketLocationRequest.Builder} avoiding the need
     * to create one manually via {@link GetBucketLocationRequest#builder()}
     * </p>
     *
     * @param getBucketLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketLocationRequest.Builder} to create a request.
     * @return Result of the GetBucketLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLocation
     */
    default GetBucketLocationResponse getBucketLocation(Consumer<GetBucketLocationRequest.Builder> getBucketLocationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketLocation(GetBucketLocationRequest.builder().applyMutation(getBucketLocationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the logging status of a bucket and the permissions users have to view and modify that status.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketLogging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLogging.html">PutBucketLogging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketLoggingRequest
     * @return Result of the GetBucketLogging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLogging
     */
    default GetBucketLoggingResponse getBucketLogging(GetBucketLoggingRequest getBucketLoggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the logging status of a bucket and the permissions users have to view and modify that status.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketLogging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLogging.html">PutBucketLogging</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketLoggingRequest.Builder} avoiding the need
     * to create one manually via {@link GetBucketLoggingRequest#builder()}
     * </p>
     *
     * @param getBucketLoggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest.Builder} to create a request.
     * @return Result of the GetBucketLogging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLogging
     */
    default GetBucketLoggingResponse getBucketLogging(Consumer<GetBucketLoggingRequest.Builder> getBucketLoggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketLogging(GetBucketLoggingRequest.builder().applyMutation(getBucketLoggingRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets a metrics configuration (specified by the metrics configuration ID) from the bucket. Note that this doesn't
     * include the daily storage metrics.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetMetricsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about CloudWatch request metrics for Amazon S3, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon
     * CloudWatch</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketMetricsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">
     * PutBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">
     * DeleteBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">
     * ListBucketMetricsConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with
     * Amazon CloudWatch</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketMetricsConfigurationRequest
     * @return Result of the GetBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketMetricsConfiguration
     */
    default GetBucketMetricsConfigurationResponse getBucketMetricsConfiguration(
            GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets a metrics configuration (specified by the metrics configuration ID) from the bucket. Note that this doesn't
     * include the daily storage metrics.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetMetricsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about CloudWatch request metrics for Amazon S3, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon
     * CloudWatch</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketMetricsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">
     * PutBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">
     * DeleteBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">
     * ListBucketMetricsConfigurations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with
     * Amazon CloudWatch</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketMetricsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetBucketMetricsConfigurationRequest#builder()}
     * </p>
     *
     * @param getBucketMetricsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketMetricsConfiguration
     */
    default GetBucketMetricsConfigurationResponse getBucketMetricsConfiguration(
            Consumer<GetBucketMetricsConfigurationRequest.Builder> getBucketMetricsConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest.builder()
                .applyMutation(getBucketMetricsConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the notification configuration of a bucket.
     * </p>
     * <p>
     * If notifications are not enabled on the bucket, the action returns an empty
     * <code>NotificationConfiguration</code> element.
     * </p>
     * <p>
     * By default, you must be the bucket owner to read the notification configuration of a bucket. However, the bucket
     * owner can use a bucket policy to grant permission to other users to read this configuration with the
     * <code>s3:GetBucketNotification</code> permission.
     * </p>
     * <p>
     * When you use this API operation with an access point, provide the alias of the access point in place of the
     * bucket name.
     * </p>
     * <p>
     * When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access
     * point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error
     * code <code>InvalidAccessPointAliasError</code> is returned. For more information about
     * <code>InvalidAccessPointAliasError</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.
     * </p>
     * <p>
     * For more information about setting and reading the notification configuration on a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Setting Up Notification of Bucket
     * Events</a>. For more information about bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies</a>.
     * </p>
     * <p>
     * The following action is related to <code>GetBucketNotification</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotification.html">PutBucketNotification</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketNotificationConfigurationRequest
     * @return Result of the GetBucketNotificationConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketNotificationConfiguration
     */
    default GetBucketNotificationConfigurationResponse getBucketNotificationConfiguration(
            GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the notification configuration of a bucket.
     * </p>
     * <p>
     * If notifications are not enabled on the bucket, the action returns an empty
     * <code>NotificationConfiguration</code> element.
     * </p>
     * <p>
     * By default, you must be the bucket owner to read the notification configuration of a bucket. However, the bucket
     * owner can use a bucket policy to grant permission to other users to read this configuration with the
     * <code>s3:GetBucketNotification</code> permission.
     * </p>
     * <p>
     * When you use this API operation with an access point, provide the alias of the access point in place of the
     * bucket name.
     * </p>
     * <p>
     * When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access
     * point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error
     * code <code>InvalidAccessPointAliasError</code> is returned. For more information about
     * <code>InvalidAccessPointAliasError</code>, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.
     * </p>
     * <p>
     * For more information about setting and reading the notification configuration on a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Setting Up Notification of Bucket
     * Events</a>. For more information about bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies</a>.
     * </p>
     * <p>
     * The following action is related to <code>GetBucketNotification</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotification.html">PutBucketNotification</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetBucketNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param getBucketNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetBucketNotificationConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketNotificationConfiguration
     */
    default GetBucketNotificationConfigurationResponse getBucketNotificationConfiguration(
            Consumer<GetBucketNotificationConfigurationRequest.Builder> getBucketNotificationConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest.builder()
                .applyMutation(getBucketNotificationConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have the
     * <code>s3:GetBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html">Specifying permissions in
     * a policy</a>.
     * </p>
     * <p>
     * For information about Amazon S3 Object Ownership, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Using Object
     * Ownership</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketOwnershipControls</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PutBucketOwnershipControls</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteBucketOwnershipControls</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketOwnershipControlsRequest
     * @return Result of the GetBucketOwnershipControls operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketOwnershipControls
     */
    default GetBucketOwnershipControlsResponse getBucketOwnershipControls(
            GetBucketOwnershipControlsRequest getBucketOwnershipControlsRequest) throws AwsServiceException, SdkClientException,
            S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have the
     * <code>s3:GetBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html">Specifying permissions in
     * a policy</a>.
     * </p>
     * <p>
     * For information about Amazon S3 Object Ownership, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Using Object
     * Ownership</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketOwnershipControls</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PutBucketOwnershipControls</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteBucketOwnershipControls</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketOwnershipControlsRequest.Builder} avoiding
     * the need to create one manually via {@link GetBucketOwnershipControlsRequest#builder()}
     * </p>
     *
     * @param getBucketOwnershipControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsRequest.Builder} to create a
     *        request.
     * @return Result of the GetBucketOwnershipControls operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketOwnershipControls
     */
    default GetBucketOwnershipControlsResponse getBucketOwnershipControls(
            Consumer<GetBucketOwnershipControlsRequest.Builder> getBucketOwnershipControlsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getBucketOwnershipControls(GetBucketOwnershipControlsRequest.builder()
                .applyMutation(getBucketOwnershipControlsRequest).build());
    }

    /**
     * <p>
     * Returns the policy of a specified bucket.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket,
     * the calling identity must both have the <code>GetBucketPolicy</code> permissions on the specified bucket and
     * belong to the bucket owner's account in order to use this operation.
     * </p>
     * <p>
     * If you don't have <code>GetBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code>
     * error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's
     * account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.
     * </p>
     * <important>
     * <p>
     * To ensure that bucket owners don't inadvertently lock themselves out of their own buckets, the root principal in
     * a bucket owner's Amazon Web Services account can perform the <code>GetBucketPolicy</code>,
     * <code>PutBucketPolicy</code>, and <code>DeleteBucketPolicy</code> API actions, even if their bucket policy
     * explicitly denies the root principal's access. Bucket owner root principals can only be blocked from performing
     * these API actions by VPC endpoint policies and Amazon Web Services Organizations policies.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:GetBucketPolicy</code> permission is required in a
     * policy. For more information about general purpose buckets bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:GetBucketPolicy</code> permission in an IAM identity-based policy instead of a bucket policy.
     * Cross-account access to this API operation isn't supported. This operation can only be performed by the Amazon
     * Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Example bucket policies</dt>
     * <dd>
     * <p>
     * <b>General purpose buckets example bucket policies</b> - See <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html">Bucket policy
     * examples</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory bucket example bucket policies</b> - See <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following action is related to <code>GetBucketPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketPolicyRequest
     * @return Result of the GetBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketPolicy
     */
    default GetBucketPolicyResponse getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the policy of a specified bucket.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket,
     * the calling identity must both have the <code>GetBucketPolicy</code> permissions on the specified bucket and
     * belong to the bucket owner's account in order to use this operation.
     * </p>
     * <p>
     * If you don't have <code>GetBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code>
     * error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's
     * account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.
     * </p>
     * <important>
     * <p>
     * To ensure that bucket owners don't inadvertently lock themselves out of their own buckets, the root principal in
     * a bucket owner's Amazon Web Services account can perform the <code>GetBucketPolicy</code>,
     * <code>PutBucketPolicy</code>, and <code>DeleteBucketPolicy</code> API actions, even if their bucket policy
     * explicitly denies the root principal's access. Bucket owner root principals can only be blocked from performing
     * these API actions by VPC endpoint policies and Amazon Web Services Organizations policies.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:GetBucketPolicy</code> permission is required in a
     * policy. For more information about general purpose buckets bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:GetBucketPolicy</code> permission in an IAM identity-based policy instead of a bucket policy.
     * Cross-account access to this API operation isn't supported. This operation can only be performed by the Amazon
     * Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Example bucket policies</dt>
     * <dd>
     * <p>
     * <b>General purpose buckets example bucket policies</b> - See <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html">Bucket policy
     * examples</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory bucket example bucket policies</b> - See <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following action is related to <code>GetBucketPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetBucketPolicyRequest#builder()}
     * </p>
     *
     * @param getBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest.Builder} to create a request.
     * @return Result of the GetBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketPolicy
     */
    default GetBucketPolicyResponse getBucketPolicy(Consumer<GetBucketPolicyRequest.Builder> getBucketPolicyRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketPolicy(GetBucketPolicyRequest.builder().applyMutation(getBucketPolicyRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves the policy status for an Amazon S3 bucket, indicating whether the bucket is public. In order to use
     * this operation, you must have the <code>s3:GetBucketPolicyStatus</code> permission. For more information about
     * Amazon S3 permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a
     * Policy</a>.
     * </p>
     * <p>
     * For more information about when Amazon S3 considers a bucket public, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status"
     * >The Meaning of "Public"</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketPolicyStatus</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3
     * Block Public Access</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html">DeletePublicAccessBlock
     * </a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketPolicyStatusRequest
     * @return Result of the GetBucketPolicyStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketPolicyStatus
     */
    default GetBucketPolicyStatusResponse getBucketPolicyStatus(GetBucketPolicyStatusRequest getBucketPolicyStatusRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves the policy status for an Amazon S3 bucket, indicating whether the bucket is public. In order to use
     * this operation, you must have the <code>s3:GetBucketPolicyStatus</code> permission. For more information about
     * Amazon S3 permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a
     * Policy</a>.
     * </p>
     * <p>
     * For more information about when Amazon S3 considers a bucket public, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status"
     * >The Meaning of "Public"</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketPolicyStatus</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3
     * Block Public Access</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html">DeletePublicAccessBlock
     * </a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketPolicyStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetBucketPolicyStatusRequest#builder()}
     * </p>
     *
     * @param getBucketPolicyStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusRequest.Builder} to create a request.
     * @return Result of the GetBucketPolicyStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketPolicyStatus
     */
    default GetBucketPolicyStatusResponse getBucketPolicyStatus(
            Consumer<GetBucketPolicyStatusRequest.Builder> getBucketPolicyStatusRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getBucketPolicyStatus(GetBucketPolicyStatusRequest.builder().applyMutation(getBucketPolicyStatusRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the replication configuration of a bucket.
     * </p>
     * <note>
     * <p>
     * It can take a while to propagate the put or delete a replication configuration to all Amazon S3 systems.
     * Therefore, a get request soon after put or delete can return a wrong result.
     * </p>
     * </note>
     * <p>
     * For information about replication configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * <p>
     * This action requires permissions for the <code>s3:GetReplicationConfiguration</code> action. For more information
     * about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using
     * Bucket Policies and User Policies</a>.
     * </p>
     * <p>
     * If you include the <code>Filter</code> element in a replication configuration, you must also include the
     * <code>DeleteMarkerReplication</code> and <code>Priority</code> elements. The response also returns those
     * elements.
     * </p>
     * <p>
     * For information about <code>GetBucketReplication</code> errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList">List of
     * replication-related error codes</a>
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html">PutBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html">DeleteBucketReplication
     * </a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketReplicationRequest
     * @return Result of the GetBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketReplication
     */
    default GetBucketReplicationResponse getBucketReplication(GetBucketReplicationRequest getBucketReplicationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the replication configuration of a bucket.
     * </p>
     * <note>
     * <p>
     * It can take a while to propagate the put or delete a replication configuration to all Amazon S3 systems.
     * Therefore, a get request soon after put or delete can return a wrong result.
     * </p>
     * </note>
     * <p>
     * For information about replication configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * <p>
     * This action requires permissions for the <code>s3:GetReplicationConfiguration</code> action. For more information
     * about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using
     * Bucket Policies and User Policies</a>.
     * </p>
     * <p>
     * If you include the <code>Filter</code> element in a replication configuration, you must also include the
     * <code>DeleteMarkerReplication</code> and <code>Priority</code> elements. The response also returns those
     * elements.
     * </p>
     * <p>
     * For information about <code>GetBucketReplication</code> errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList">List of
     * replication-related error codes</a>
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html">PutBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html">DeleteBucketReplication
     * </a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link GetBucketReplicationRequest#builder()}
     * </p>
     *
     * @param getBucketReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest.Builder} to create a request.
     * @return Result of the GetBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketReplication
     */
    default GetBucketReplicationResponse getBucketReplication(
            Consumer<GetBucketReplicationRequest.Builder> getBucketReplicationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getBucketReplication(GetBucketReplicationRequest.builder().applyMutation(getBucketReplicationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the request payment configuration of a bucket. To use this version of the operation, you must be the
     * bucket owner. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketRequestPayment</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketRequestPaymentRequest
     * @return Result of the GetBucketRequestPayment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketRequestPayment
     */
    default GetBucketRequestPaymentResponse getBucketRequestPayment(GetBucketRequestPaymentRequest getBucketRequestPaymentRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the request payment configuration of a bucket. To use this version of the operation, you must be the
     * bucket owner. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketRequestPayment</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketRequestPaymentRequest.Builder} avoiding
     * the need to create one manually via {@link GetBucketRequestPaymentRequest#builder()}
     * </p>
     *
     * @param getBucketRequestPaymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest.Builder} to create a
     *        request.
     * @return Result of the GetBucketRequestPayment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketRequestPayment
     */
    default GetBucketRequestPaymentResponse getBucketRequestPayment(
            Consumer<GetBucketRequestPaymentRequest.Builder> getBucketRequestPaymentRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getBucketRequestPayment(GetBucketRequestPaymentRequest.builder().applyMutation(getBucketRequestPaymentRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the tag set associated with the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:GetBucketTagging</code> action. By
     * default, the bucket owner has this permission and can grant this permission to others.
     * </p>
     * <p>
     * <code>GetBucketTagging</code> has the following special error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>NoSuchTagSet</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: There is no tag set associated with the bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following operations are related to <code>GetBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketTaggingRequest
     * @return Result of the GetBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketTagging
     */
    default GetBucketTaggingResponse getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the tag set associated with the bucket.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:GetBucketTagging</code> action. By
     * default, the bucket owner has this permission and can grant this permission to others.
     * </p>
     * <p>
     * <code>GetBucketTagging</code> has the following special error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>NoSuchTagSet</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: There is no tag set associated with the bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following operations are related to <code>GetBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketTaggingRequest.Builder} avoiding the need
     * to create one manually via {@link GetBucketTaggingRequest#builder()}
     * </p>
     *
     * @param getBucketTaggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest.Builder} to create a request.
     * @return Result of the GetBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketTagging
     */
    default GetBucketTaggingResponse getBucketTagging(Consumer<GetBucketTaggingRequest.Builder> getBucketTaggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketTagging(GetBucketTaggingRequest.builder().applyMutation(getBucketTaggingRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the versioning state of a bucket.
     * </p>
     * <p>
     * To retrieve the versioning state of a bucket, you must be the bucket owner.
     * </p>
     * <p>
     * This implementation also returns the MFA Delete status of the versioning state. If the MFA Delete status is
     * <code>enabled</code>, the bucket owner must use an authentication device to change the versioning state of the
     * bucket.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketVersioning</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketVersioningRequest
     * @return Result of the GetBucketVersioning operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketVersioning
     */
    default GetBucketVersioningResponse getBucketVersioning(GetBucketVersioningRequest getBucketVersioningRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the versioning state of a bucket.
     * </p>
     * <p>
     * To retrieve the versioning state of a bucket, you must be the bucket owner.
     * </p>
     * <p>
     * This implementation also returns the MFA Delete status of the versioning state. If the MFA Delete status is
     * <code>enabled</code>, the bucket owner must use an authentication device to change the versioning state of the
     * bucket.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketVersioning</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketVersioningRequest.Builder} avoiding the
     * need to create one manually via {@link GetBucketVersioningRequest#builder()}
     * </p>
     *
     * @param getBucketVersioningRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest.Builder} to create a request.
     * @return Result of the GetBucketVersioning operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketVersioning
     */
    default GetBucketVersioningResponse getBucketVersioning(
            Consumer<GetBucketVersioningRequest.Builder> getBucketVersioningRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getBucketVersioning(GetBucketVersioningRequest.builder().applyMutation(getBucketVersioningRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the website configuration for a bucket. To host website on Amazon S3, you can configure a bucket as
     * website by adding a website configuration. For more information about hosting websites, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>.
     * </p>
     * <p>
     * This GET action requires the <code>S3:GetBucketWebsite</code> permission. By default, only the bucket owner can
     * read the bucket website configuration. However, bucket owners can allow other users to read the website
     * configuration by writing a bucket policy granting them the <code>S3:GetBucketWebsite</code> permission.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketWebsite</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketWebsite.html">DeleteBucketWebsite</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html">PutBucketWebsite</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketWebsiteRequest
     * @return Result of the GetBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketWebsite
     */
    default GetBucketWebsiteResponse getBucketWebsite(GetBucketWebsiteRequest getBucketWebsiteRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the website configuration for a bucket. To host website on Amazon S3, you can configure a bucket as
     * website by adding a website configuration. For more information about hosting websites, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>.
     * </p>
     * <p>
     * This GET action requires the <code>S3:GetBucketWebsite</code> permission. By default, only the bucket owner can
     * read the bucket website configuration. However, bucket owners can allow other users to read the website
     * configuration by writing a bucket policy granting them the <code>S3:GetBucketWebsite</code> permission.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketWebsite</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketWebsite.html">DeleteBucketWebsite</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html">PutBucketWebsite</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketWebsiteRequest.Builder} avoiding the need
     * to create one manually via {@link GetBucketWebsiteRequest#builder()}
     * </p>
     *
     * @param getBucketWebsiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest.Builder} to create a request.
     * @return Result of the GetBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketWebsite
     */
    default GetBucketWebsiteResponse getBucketWebsite(Consumer<GetBucketWebsiteRequest.Builder> getBucketWebsiteRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getBucketWebsite(GetBucketWebsiteRequest.builder().applyMutation(getBucketWebsiteRequest).build());
    }

    /**
     * <p>
     * Retrieves an object from Amazon S3.
     * </p>
     * <p>
     * In the <code>GetObject</code> request, specify the full key name for the object.
     * </p>
     * <p>
     * <b>General purpose buckets</b> - Both the virtual-hosted-style requests and the path-style requests are
     * supported. For a virtual hosted-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the object
     * key name as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request
     * types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host
     * Header Bucket Specification</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - Only virtual-hosted-style requests are supported. For a virtual hosted-style request
     * example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named
     * <code>examplebucket--use1-az5--x-s3</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. Also, when you make requests to this API operation, your requests
     * are sent to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the required permissions in a policy. To use
     * <code>GetObject</code>, you must have the <code>READ</code> access to the object (or version). If you grant
     * <code>READ</code> access to the anonymous user, the <code>GetObject</code> operation returns the object without
     * using an authorization header. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying permissions in a
     * policy</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you include a <code>versionId</code> in your request header, you must have the
     * <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The
     * <code>s3:GetObject</code> permission is not required in this scenario.
     * </p>
     * <p>
     * If you request the current version of an object without a specific <code>versionId</code> in the request header,
     * only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not
     * required in this scenario.
     * </p>
     * <p>
     * If the object that you request doesn’t exist, the error that Amazon S3 returns depends on whether you also have
     * the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Access Denied</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted using SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Storage classes</dt>
     * <dd>
     * <p>
     * If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier
     * Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep
     * Archive Access tier, before you can retrieve the object you must first restore a copy using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this
     * operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to
     * store newly created objects. Unsupported storage class values won't write a destination object and will respond
     * with the HTTP status code <code>400 Bad Request</code>.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for the
     * <code>GetObject</code> requests, if your object uses server-side encryption with Amazon S3 managed encryption
     * keys (SSE-S3), server-side encryption with Key Management Service (KMS) keys (SSE-KMS), or dual-layer server-side
     * encryption with Amazon Web Services KMS keys (DSSE-KMS). If you include the header in your <code>GetObject</code>
     * requests for the object that uses these types of keys, you’ll get an HTTP <code>400 Bad Request</code> error.
     * </p>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Overriding response header values through the request</dt>
     * <dd>
     * <p>
     * There are times when you want to override certain response header values of a <code>GetObject</code> response.
     * For example, you might override the <code>Content-Disposition</code> response header value through your
     * <code>GetObject</code> request.
     * </p>
     * <p>
     * You can override values for a set of response headers. These modified response header values are included only in
     * a successful response, that is, when the HTTP status code <code>200 OK</code> is returned. The headers you can
     * override using the following query parameters in the request are a subset of the headers that Amazon S3 accepts
     * when you create an object.
     * </p>
     * <p>
     * The response headers that you can override for the <code>GetObject</code> response are <code>Cache-Control</code>, <code>Content-Disposition</code>, <code>Content-Encoding</code>, <code>Content-Language</code>,
     * <code>Content-Type</code>, and <code>Expires</code>.
     * </p>
     * <p>
     * To override values for a set of response headers in the <code>GetObject</code> response, you can use the
     * following query parameters in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>response-cache-control</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-disposition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-encoding</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-language</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-expires</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you use these parameters, you must sign the request by using either an Authorization header or a presigned
     * URL. These parameters cannot be used with an unsigned (anonymous) request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled GetObjectResponse and
     *        an InputStream to the response content are provided as parameters to the callback. The callback may return
     *        a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        Object data.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws InvalidObjectStateException
     *         Object is archived and inaccessible until restored.</p>
     *         <p>
     *         If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3
     *         Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3
     *         Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a
     *         copy using <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.
     *         Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about
     *         restoring archived objects, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived
     *         Objects</a> in the <i>Amazon S3 User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     */
    default <ReturnT> ReturnT getObject(GetObjectRequest getObjectRequest,
            ResponseTransformer<GetObjectResponse, ReturnT> responseTransformer) throws NoSuchKeyException,
            InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an object from Amazon S3.
     * </p>
     * <p>
     * In the <code>GetObject</code> request, specify the full key name for the object.
     * </p>
     * <p>
     * <b>General purpose buckets</b> - Both the virtual-hosted-style requests and the path-style requests are
     * supported. For a virtual hosted-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the object
     * key name as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request
     * types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host
     * Header Bucket Specification</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - Only virtual-hosted-style requests are supported. For a virtual hosted-style request
     * example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named
     * <code>examplebucket--use1-az5--x-s3</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. Also, when you make requests to this API operation, your requests
     * are sent to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the required permissions in a policy. To use
     * <code>GetObject</code>, you must have the <code>READ</code> access to the object (or version). If you grant
     * <code>READ</code> access to the anonymous user, the <code>GetObject</code> operation returns the object without
     * using an authorization header. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying permissions in a
     * policy</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you include a <code>versionId</code> in your request header, you must have the
     * <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The
     * <code>s3:GetObject</code> permission is not required in this scenario.
     * </p>
     * <p>
     * If you request the current version of an object without a specific <code>versionId</code> in the request header,
     * only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not
     * required in this scenario.
     * </p>
     * <p>
     * If the object that you request doesn’t exist, the error that Amazon S3 returns depends on whether you also have
     * the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Access Denied</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted using SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Storage classes</dt>
     * <dd>
     * <p>
     * If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier
     * Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep
     * Archive Access tier, before you can retrieve the object you must first restore a copy using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this
     * operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to
     * store newly created objects. Unsupported storage class values won't write a destination object and will respond
     * with the HTTP status code <code>400 Bad Request</code>.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for the
     * <code>GetObject</code> requests, if your object uses server-side encryption with Amazon S3 managed encryption
     * keys (SSE-S3), server-side encryption with Key Management Service (KMS) keys (SSE-KMS), or dual-layer server-side
     * encryption with Amazon Web Services KMS keys (DSSE-KMS). If you include the header in your <code>GetObject</code>
     * requests for the object that uses these types of keys, you’ll get an HTTP <code>400 Bad Request</code> error.
     * </p>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Overriding response header values through the request</dt>
     * <dd>
     * <p>
     * There are times when you want to override certain response header values of a <code>GetObject</code> response.
     * For example, you might override the <code>Content-Disposition</code> response header value through your
     * <code>GetObject</code> request.
     * </p>
     * <p>
     * You can override values for a set of response headers. These modified response header values are included only in
     * a successful response, that is, when the HTTP status code <code>200 OK</code> is returned. The headers you can
     * override using the following query parameters in the request are a subset of the headers that Amazon S3 accepts
     * when you create an object.
     * </p>
     * <p>
     * The response headers that you can override for the <code>GetObject</code> response are <code>Cache-Control</code>, <code>Content-Disposition</code>, <code>Content-Encoding</code>, <code>Content-Language</code>,
     * <code>Content-Type</code>, and <code>Expires</code>.
     * </p>
     * <p>
     * To override values for a set of response headers in the <code>GetObject</code> response, you can use the
     * following query parameters in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>response-cache-control</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-disposition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-encoding</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-language</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-expires</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you use these parameters, you must sign the request by using either an Authorization header or a presigned
     * URL. These parameters cannot be used with an unsigned (anonymous) request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetObjectRequest#builder()}
     * </p>
     *
     * @param getObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectRequest.Builder} to create a request.
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled GetObjectResponse and
     *        an InputStream to the response content are provided as parameters to the callback. The callback may return
     *        a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        Object data.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws InvalidObjectStateException
     *         Object is archived and inaccessible until restored.</p>
     *         <p>
     *         If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3
     *         Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3
     *         Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a
     *         copy using <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.
     *         Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about
     *         restoring archived objects, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived
     *         Objects</a> in the <i>Amazon S3 User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     */
    default <ReturnT> ReturnT getObject(Consumer<GetObjectRequest.Builder> getObjectRequest,
            ResponseTransformer<GetObjectResponse, ReturnT> responseTransformer) throws NoSuchKeyException,
            InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        return getObject(GetObjectRequest.builder().applyMutation(getObjectRequest).build(), responseTransformer);
    }

    /**
     * <p>
     * Retrieves an object from Amazon S3.
     * </p>
     * <p>
     * In the <code>GetObject</code> request, specify the full key name for the object.
     * </p>
     * <p>
     * <b>General purpose buckets</b> - Both the virtual-hosted-style requests and the path-style requests are
     * supported. For a virtual hosted-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the object
     * key name as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request
     * types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host
     * Header Bucket Specification</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - Only virtual-hosted-style requests are supported. For a virtual hosted-style request
     * example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named
     * <code>examplebucket--use1-az5--x-s3</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. Also, when you make requests to this API operation, your requests
     * are sent to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the required permissions in a policy. To use
     * <code>GetObject</code>, you must have the <code>READ</code> access to the object (or version). If you grant
     * <code>READ</code> access to the anonymous user, the <code>GetObject</code> operation returns the object without
     * using an authorization header. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying permissions in a
     * policy</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you include a <code>versionId</code> in your request header, you must have the
     * <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The
     * <code>s3:GetObject</code> permission is not required in this scenario.
     * </p>
     * <p>
     * If you request the current version of an object without a specific <code>versionId</code> in the request header,
     * only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not
     * required in this scenario.
     * </p>
     * <p>
     * If the object that you request doesn’t exist, the error that Amazon S3 returns depends on whether you also have
     * the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Access Denied</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted using SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Storage classes</dt>
     * <dd>
     * <p>
     * If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier
     * Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep
     * Archive Access tier, before you can retrieve the object you must first restore a copy using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this
     * operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to
     * store newly created objects. Unsupported storage class values won't write a destination object and will respond
     * with the HTTP status code <code>400 Bad Request</code>.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for the
     * <code>GetObject</code> requests, if your object uses server-side encryption with Amazon S3 managed encryption
     * keys (SSE-S3), server-side encryption with Key Management Service (KMS) keys (SSE-KMS), or dual-layer server-side
     * encryption with Amazon Web Services KMS keys (DSSE-KMS). If you include the header in your <code>GetObject</code>
     * requests for the object that uses these types of keys, you’ll get an HTTP <code>400 Bad Request</code> error.
     * </p>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Overriding response header values through the request</dt>
     * <dd>
     * <p>
     * There are times when you want to override certain response header values of a <code>GetObject</code> response.
     * For example, you might override the <code>Content-Disposition</code> response header value through your
     * <code>GetObject</code> request.
     * </p>
     * <p>
     * You can override values for a set of response headers. These modified response header values are included only in
     * a successful response, that is, when the HTTP status code <code>200 OK</code> is returned. The headers you can
     * override using the following query parameters in the request are a subset of the headers that Amazon S3 accepts
     * when you create an object.
     * </p>
     * <p>
     * The response headers that you can override for the <code>GetObject</code> response are <code>Cache-Control</code>, <code>Content-Disposition</code>, <code>Content-Encoding</code>, <code>Content-Language</code>,
     * <code>Content-Type</code>, and <code>Expires</code>.
     * </p>
     * <p>
     * To override values for a set of response headers in the <code>GetObject</code> response, you can use the
     * following query parameters in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>response-cache-control</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-disposition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-encoding</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-language</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-expires</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you use these parameters, you must sign the request by using either an Authorization header or a presigned
     * URL. These parameters cannot be used with an unsigned (anonymous) request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        Object data.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws InvalidObjectStateException
     *         Object is archived and inaccessible until restored.</p>
     *         <p>
     *         If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3
     *         Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3
     *         Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a
     *         copy using <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.
     *         Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about
     *         restoring archived objects, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived
     *         Objects</a> in the <i>Amazon S3 User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(GetObjectRequest, ResponseTransformer)
     */
    default GetObjectResponse getObject(GetObjectRequest getObjectRequest, Path destinationPath) throws NoSuchKeyException,
            InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        return getObject(getObjectRequest, ResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Retrieves an object from Amazon S3.
     * </p>
     * <p>
     * In the <code>GetObject</code> request, specify the full key name for the object.
     * </p>
     * <p>
     * <b>General purpose buckets</b> - Both the virtual-hosted-style requests and the path-style requests are
     * supported. For a virtual hosted-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the object
     * key name as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request
     * types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host
     * Header Bucket Specification</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - Only virtual-hosted-style requests are supported. For a virtual hosted-style request
     * example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named
     * <code>examplebucket--use1-az5--x-s3</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. Also, when you make requests to this API operation, your requests
     * are sent to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the required permissions in a policy. To use
     * <code>GetObject</code>, you must have the <code>READ</code> access to the object (or version). If you grant
     * <code>READ</code> access to the anonymous user, the <code>GetObject</code> operation returns the object without
     * using an authorization header. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying permissions in a
     * policy</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you include a <code>versionId</code> in your request header, you must have the
     * <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The
     * <code>s3:GetObject</code> permission is not required in this scenario.
     * </p>
     * <p>
     * If you request the current version of an object without a specific <code>versionId</code> in the request header,
     * only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not
     * required in this scenario.
     * </p>
     * <p>
     * If the object that you request doesn’t exist, the error that Amazon S3 returns depends on whether you also have
     * the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Access Denied</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted using SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Storage classes</dt>
     * <dd>
     * <p>
     * If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier
     * Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep
     * Archive Access tier, before you can retrieve the object you must first restore a copy using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this
     * operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to
     * store newly created objects. Unsupported storage class values won't write a destination object and will respond
     * with the HTTP status code <code>400 Bad Request</code>.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for the
     * <code>GetObject</code> requests, if your object uses server-side encryption with Amazon S3 managed encryption
     * keys (SSE-S3), server-side encryption with Key Management Service (KMS) keys (SSE-KMS), or dual-layer server-side
     * encryption with Amazon Web Services KMS keys (DSSE-KMS). If you include the header in your <code>GetObject</code>
     * requests for the object that uses these types of keys, you’ll get an HTTP <code>400 Bad Request</code> error.
     * </p>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Overriding response header values through the request</dt>
     * <dd>
     * <p>
     * There are times when you want to override certain response header values of a <code>GetObject</code> response.
     * For example, you might override the <code>Content-Disposition</code> response header value through your
     * <code>GetObject</code> request.
     * </p>
     * <p>
     * You can override values for a set of response headers. These modified response header values are included only in
     * a successful response, that is, when the HTTP status code <code>200 OK</code> is returned. The headers you can
     * override using the following query parameters in the request are a subset of the headers that Amazon S3 accepts
     * when you create an object.
     * </p>
     * <p>
     * The response headers that you can override for the <code>GetObject</code> response are <code>Cache-Control</code>, <code>Content-Disposition</code>, <code>Content-Encoding</code>, <code>Content-Language</code>,
     * <code>Content-Type</code>, and <code>Expires</code>.
     * </p>
     * <p>
     * To override values for a set of response headers in the <code>GetObject</code> response, you can use the
     * following query parameters in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>response-cache-control</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-disposition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-encoding</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-language</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-expires</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you use these parameters, you must sign the request by using either an Authorization header or a presigned
     * URL. These parameters cannot be used with an unsigned (anonymous) request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetObjectRequest#builder()}
     * </p>
     *
     * @param getObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectRequest.Builder} to create a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        Object data.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws InvalidObjectStateException
     *         Object is archived and inaccessible until restored.</p>
     *         <p>
     *         If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3
     *         Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3
     *         Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a
     *         copy using <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.
     *         Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about
     *         restoring archived objects, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived
     *         Objects</a> in the <i>Amazon S3 User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(GetObjectRequest, ResponseTransformer)
     */
    default GetObjectResponse getObject(Consumer<GetObjectRequest.Builder> getObjectRequest, Path destinationPath)
            throws NoSuchKeyException, InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        return getObject(GetObjectRequest.builder().applyMutation(getObjectRequest).build(), destinationPath);
    }

    /**
     * <p>
     * Retrieves an object from Amazon S3.
     * </p>
     * <p>
     * In the <code>GetObject</code> request, specify the full key name for the object.
     * </p>
     * <p>
     * <b>General purpose buckets</b> - Both the virtual-hosted-style requests and the path-style requests are
     * supported. For a virtual hosted-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the object
     * key name as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request
     * types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host
     * Header Bucket Specification</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - Only virtual-hosted-style requests are supported. For a virtual hosted-style request
     * example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named
     * <code>examplebucket--use1-az5--x-s3</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. Also, when you make requests to this API operation, your requests
     * are sent to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the required permissions in a policy. To use
     * <code>GetObject</code>, you must have the <code>READ</code> access to the object (or version). If you grant
     * <code>READ</code> access to the anonymous user, the <code>GetObject</code> operation returns the object without
     * using an authorization header. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying permissions in a
     * policy</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you include a <code>versionId</code> in your request header, you must have the
     * <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The
     * <code>s3:GetObject</code> permission is not required in this scenario.
     * </p>
     * <p>
     * If you request the current version of an object without a specific <code>versionId</code> in the request header,
     * only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not
     * required in this scenario.
     * </p>
     * <p>
     * If the object that you request doesn’t exist, the error that Amazon S3 returns depends on whether you also have
     * the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Access Denied</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted using SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Storage classes</dt>
     * <dd>
     * <p>
     * If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier
     * Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep
     * Archive Access tier, before you can retrieve the object you must first restore a copy using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this
     * operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to
     * store newly created objects. Unsupported storage class values won't write a destination object and will respond
     * with the HTTP status code <code>400 Bad Request</code>.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for the
     * <code>GetObject</code> requests, if your object uses server-side encryption with Amazon S3 managed encryption
     * keys (SSE-S3), server-side encryption with Key Management Service (KMS) keys (SSE-KMS), or dual-layer server-side
     * encryption with Amazon Web Services KMS keys (DSSE-KMS). If you include the header in your <code>GetObject</code>
     * requests for the object that uses these types of keys, you’ll get an HTTP <code>400 Bad Request</code> error.
     * </p>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Overriding response header values through the request</dt>
     * <dd>
     * <p>
     * There are times when you want to override certain response header values of a <code>GetObject</code> response.
     * For example, you might override the <code>Content-Disposition</code> response header value through your
     * <code>GetObject</code> request.
     * </p>
     * <p>
     * You can override values for a set of response headers. These modified response header values are included only in
     * a successful response, that is, when the HTTP status code <code>200 OK</code> is returned. The headers you can
     * override using the following query parameters in the request are a subset of the headers that Amazon S3 accepts
     * when you create an object.
     * </p>
     * <p>
     * The response headers that you can override for the <code>GetObject</code> response are <code>Cache-Control</code>, <code>Content-Disposition</code>, <code>Content-Encoding</code>, <code>Content-Language</code>,
     * <code>Content-Type</code>, and <code>Expires</code>.
     * </p>
     * <p>
     * To override values for a set of response headers in the <code>GetObject</code> response, you can use the
     * following query parameters in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>response-cache-control</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-disposition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-encoding</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-language</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-expires</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you use these parameters, you must sign the request by using either an Authorization header or a presigned
     * URL. These parameters cannot be used with an unsigned (anonymous) request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         Object data.
     *         </p>
     *         '.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws InvalidObjectStateException
     *         Object is archived and inaccessible until restored.</p>
     *         <p>
     *         If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3
     *         Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3
     *         Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a
     *         copy using <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.
     *         Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about
     *         restoring archived objects, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived
     *         Objects</a> in the <i>Amazon S3 User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(getObject, ResponseTransformer)
     */
    default ResponseInputStream<GetObjectResponse> getObject(GetObjectRequest getObjectRequest) throws NoSuchKeyException,
            InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        return getObject(getObjectRequest, ResponseTransformer.toInputStream());
    }

    /**
     * <p>
     * Retrieves an object from Amazon S3.
     * </p>
     * <p>
     * In the <code>GetObject</code> request, specify the full key name for the object.
     * </p>
     * <p>
     * <b>General purpose buckets</b> - Both the virtual-hosted-style requests and the path-style requests are
     * supported. For a virtual hosted-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the object
     * key name as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request
     * types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host
     * Header Bucket Specification</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - Only virtual-hosted-style requests are supported. For a virtual hosted-style request
     * example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named
     * <code>examplebucket--use1-az5--x-s3</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. Also, when you make requests to this API operation, your requests
     * are sent to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the required permissions in a policy. To use
     * <code>GetObject</code>, you must have the <code>READ</code> access to the object (or version). If you grant
     * <code>READ</code> access to the anonymous user, the <code>GetObject</code> operation returns the object without
     * using an authorization header. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying permissions in a
     * policy</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you include a <code>versionId</code> in your request header, you must have the
     * <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The
     * <code>s3:GetObject</code> permission is not required in this scenario.
     * </p>
     * <p>
     * If you request the current version of an object without a specific <code>versionId</code> in the request header,
     * only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not
     * required in this scenario.
     * </p>
     * <p>
     * If the object that you request doesn’t exist, the error that Amazon S3 returns depends on whether you also have
     * the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Access Denied</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted using SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Storage classes</dt>
     * <dd>
     * <p>
     * If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier
     * Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep
     * Archive Access tier, before you can retrieve the object you must first restore a copy using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this
     * operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to
     * store newly created objects. Unsupported storage class values won't write a destination object and will respond
     * with the HTTP status code <code>400 Bad Request</code>.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for the
     * <code>GetObject</code> requests, if your object uses server-side encryption with Amazon S3 managed encryption
     * keys (SSE-S3), server-side encryption with Key Management Service (KMS) keys (SSE-KMS), or dual-layer server-side
     * encryption with Amazon Web Services KMS keys (DSSE-KMS). If you include the header in your <code>GetObject</code>
     * requests for the object that uses these types of keys, you’ll get an HTTP <code>400 Bad Request</code> error.
     * </p>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Overriding response header values through the request</dt>
     * <dd>
     * <p>
     * There are times when you want to override certain response header values of a <code>GetObject</code> response.
     * For example, you might override the <code>Content-Disposition</code> response header value through your
     * <code>GetObject</code> request.
     * </p>
     * <p>
     * You can override values for a set of response headers. These modified response header values are included only in
     * a successful response, that is, when the HTTP status code <code>200 OK</code> is returned. The headers you can
     * override using the following query parameters in the request are a subset of the headers that Amazon S3 accepts
     * when you create an object.
     * </p>
     * <p>
     * The response headers that you can override for the <code>GetObject</code> response are <code>Cache-Control</code>, <code>Content-Disposition</code>, <code>Content-Encoding</code>, <code>Content-Language</code>,
     * <code>Content-Type</code>, and <code>Expires</code>.
     * </p>
     * <p>
     * To override values for a set of response headers in the <code>GetObject</code> response, you can use the
     * following query parameters in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>response-cache-control</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-disposition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-encoding</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-language</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-expires</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you use these parameters, you must sign the request by using either an Authorization header or a presigned
     * URL. These parameters cannot be used with an unsigned (anonymous) request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetObjectRequest#builder()}
     * </p>
     *
     * @param getObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectRequest.Builder} to create a request.
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         Object data.
     *         </p>
     *         '.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws InvalidObjectStateException
     *         Object is archived and inaccessible until restored.</p>
     *         <p>
     *         If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3
     *         Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3
     *         Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a
     *         copy using <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.
     *         Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about
     *         restoring archived objects, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived
     *         Objects</a> in the <i>Amazon S3 User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(getObject, ResponseTransformer)
     */
    default ResponseInputStream<GetObjectResponse> getObject(Consumer<GetObjectRequest.Builder> getObjectRequest)
            throws NoSuchKeyException, InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        return getObject(GetObjectRequest.builder().applyMutation(getObjectRequest).build());
    }

    /**
     * <p>
     * Retrieves an object from Amazon S3.
     * </p>
     * <p>
     * In the <code>GetObject</code> request, specify the full key name for the object.
     * </p>
     * <p>
     * <b>General purpose buckets</b> - Both the virtual-hosted-style requests and the path-style requests are
     * supported. For a virtual hosted-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the object
     * key name as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request
     * types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host
     * Header Bucket Specification</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - Only virtual-hosted-style requests are supported. For a virtual hosted-style request
     * example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named
     * <code>examplebucket--use1-az5--x-s3</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. Also, when you make requests to this API operation, your requests
     * are sent to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the required permissions in a policy. To use
     * <code>GetObject</code>, you must have the <code>READ</code> access to the object (or version). If you grant
     * <code>READ</code> access to the anonymous user, the <code>GetObject</code> operation returns the object without
     * using an authorization header. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying permissions in a
     * policy</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you include a <code>versionId</code> in your request header, you must have the
     * <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The
     * <code>s3:GetObject</code> permission is not required in this scenario.
     * </p>
     * <p>
     * If you request the current version of an object without a specific <code>versionId</code> in the request header,
     * only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not
     * required in this scenario.
     * </p>
     * <p>
     * If the object that you request doesn’t exist, the error that Amazon S3 returns depends on whether you also have
     * the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Access Denied</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted using SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Storage classes</dt>
     * <dd>
     * <p>
     * If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier
     * Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep
     * Archive Access tier, before you can retrieve the object you must first restore a copy using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this
     * operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to
     * store newly created objects. Unsupported storage class values won't write a destination object and will respond
     * with the HTTP status code <code>400 Bad Request</code>.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for the
     * <code>GetObject</code> requests, if your object uses server-side encryption with Amazon S3 managed encryption
     * keys (SSE-S3), server-side encryption with Key Management Service (KMS) keys (SSE-KMS), or dual-layer server-side
     * encryption with Amazon Web Services KMS keys (DSSE-KMS). If you include the header in your <code>GetObject</code>
     * requests for the object that uses these types of keys, you’ll get an HTTP <code>400 Bad Request</code> error.
     * </p>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Overriding response header values through the request</dt>
     * <dd>
     * <p>
     * There are times when you want to override certain response header values of a <code>GetObject</code> response.
     * For example, you might override the <code>Content-Disposition</code> response header value through your
     * <code>GetObject</code> request.
     * </p>
     * <p>
     * You can override values for a set of response headers. These modified response header values are included only in
     * a successful response, that is, when the HTTP status code <code>200 OK</code> is returned. The headers you can
     * override using the following query parameters in the request are a subset of the headers that Amazon S3 accepts
     * when you create an object.
     * </p>
     * <p>
     * The response headers that you can override for the <code>GetObject</code> response are <code>Cache-Control</code>, <code>Content-Disposition</code>, <code>Content-Encoding</code>, <code>Content-Language</code>,
     * <code>Content-Type</code>, and <code>Expires</code>.
     * </p>
     * <p>
     * To override values for a set of response headers in the <code>GetObject</code> response, you can use the
     * following query parameters in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>response-cache-control</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-disposition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-encoding</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-language</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-expires</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you use these parameters, you must sign the request by using either an Authorization header or a presigned
     * URL. These parameters cannot be used with an unsigned (anonymous) request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         Object data.
     *         </p>
     *         '.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws InvalidObjectStateException
     *         Object is archived and inaccessible until restored.</p>
     *         <p>
     *         If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3
     *         Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3
     *         Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a
     *         copy using <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.
     *         Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about
     *         restoring archived objects, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived
     *         Objects</a> in the <i>Amazon S3 User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(getObject, ResponseTransformer)
     */
    default ResponseBytes<GetObjectResponse> getObjectAsBytes(GetObjectRequest getObjectRequest) throws NoSuchKeyException,
            InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        return getObject(getObjectRequest, ResponseTransformer.toBytes());
    }

    /**
     * <p>
     * Retrieves an object from Amazon S3.
     * </p>
     * <p>
     * In the <code>GetObject</code> request, specify the full key name for the object.
     * </p>
     * <p>
     * <b>General purpose buckets</b> - Both the virtual-hosted-style requests and the path-style requests are
     * supported. For a virtual hosted-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object
     * <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the object
     * key name as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request
     * types, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host
     * Header Bucket Specification</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - Only virtual-hosted-style requests are supported. For a virtual hosted-style request
     * example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named
     * <code>examplebucket--use1-az5--x-s3</code>, specify the object key name as
     * <code>/photos/2006/February/sample.jpg</code>. Also, when you make requests to this API operation, your requests
     * are sent to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - You must have the required permissions in a policy. To use
     * <code>GetObject</code>, you must have the <code>READ</code> access to the object (or version). If you grant
     * <code>READ</code> access to the anonymous user, the <code>GetObject</code> operation returns the object without
     * using an authorization header. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying permissions in a
     * policy</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you include a <code>versionId</code> in your request header, you must have the
     * <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The
     * <code>s3:GetObject</code> permission is not required in this scenario.
     * </p>
     * <p>
     * If you request the current version of an object without a specific <code>versionId</code> in the request header,
     * only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not
     * required in this scenario.
     * </p>
     * <p>
     * If the object that you request doesn’t exist, the error that Amazon S3 returns depends on whether you also have
     * the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Access Denied</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted using SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Storage classes</dt>
     * <dd>
     * <p>
     * If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier
     * Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep
     * Archive Access tier, before you can retrieve the object you must first restore a copy using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this
     * operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to
     * store newly created objects. Unsupported storage class values won't write a destination object and will respond
     * with the HTTP status code <code>400 Bad Request</code>.
     * </p>
     * </dd>
     * <dt>Encryption</dt>
     * <dd>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for the
     * <code>GetObject</code> requests, if your object uses server-side encryption with Amazon S3 managed encryption
     * keys (SSE-S3), server-side encryption with Key Management Service (KMS) keys (SSE-KMS), or dual-layer server-side
     * encryption with Amazon Web Services KMS keys (DSSE-KMS). If you include the header in your <code>GetObject</code>
     * requests for the object that uses these types of keys, you’ll get an HTTP <code>400 Bad Request</code> error.
     * </p>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>Overriding response header values through the request</dt>
     * <dd>
     * <p>
     * There are times when you want to override certain response header values of a <code>GetObject</code> response.
     * For example, you might override the <code>Content-Disposition</code> response header value through your
     * <code>GetObject</code> request.
     * </p>
     * <p>
     * You can override values for a set of response headers. These modified response header values are included only in
     * a successful response, that is, when the HTTP status code <code>200 OK</code> is returned. The headers you can
     * override using the following query parameters in the request are a subset of the headers that Amazon S3 accepts
     * when you create an object.
     * </p>
     * <p>
     * The response headers that you can override for the <code>GetObject</code> response are <code>Cache-Control</code>, <code>Content-Disposition</code>, <code>Content-Encoding</code>, <code>Content-Language</code>,
     * <code>Content-Type</code>, and <code>Expires</code>.
     * </p>
     * <p>
     * To override values for a set of response headers in the <code>GetObject</code> response, you can use the
     * following query parameters in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>response-cache-control</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-disposition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-encoding</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-language</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-content-type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>response-expires</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When you use these parameters, you must sign the request by using either an Authorization header or a presigned
     * URL. These parameters cannot be used with an unsigned (anonymous) request.
     * </p>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>GetObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetObjectRequest#builder()}
     * </p>
     *
     * @param getObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectRequest.Builder} to create a request.
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         Object data.
     *         </p>
     *         '.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws InvalidObjectStateException
     *         Object is archived and inaccessible until restored.</p>
     *         <p>
     *         If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3
     *         Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3
     *         Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a
     *         copy using <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.
     *         Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about
     *         restoring archived objects, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived
     *         Objects</a> in the <i>Amazon S3 User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(getObject, ResponseTransformer)
     */
    default ResponseBytes<GetObjectResponse> getObjectAsBytes(Consumer<GetObjectRequest.Builder> getObjectRequest)
            throws NoSuchKeyException, InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        return getObjectAsBytes(GetObjectRequest.builder().applyMutation(getObjectRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the access control list (ACL) of an object. To use this operation, you must have
     * <code>s3:GetObjectAcl</code> permissions or <code>READ_ACP</code> access to the object. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#acl-access-policy-permission-mapping"
     * >Mapping of ACL permissions and access policy permissions</a> in the <i>Amazon S3 User Guide</i>
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * By default, GET returns ACL information about the current version of an object. To return ACL information about a
     * different version, use the versionId subresource.
     * </p>
     * <note>
     * <p>
     * If your bucket uses the bucket owner enforced setting for S3 Object Ownership, requests to read ACLs are still
     * supported and return the <code>bucket-owner-full-control</code> ACL with the owner being the account that created
     * the bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html"> Controlling object
     * ownership and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The following operations are related to <code>GetObjectAcl</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectAclRequest
     * @return Result of the GetObjectAcl operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectAcl
     */
    default GetObjectAclResponse getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws NoSuchKeyException,
            AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the access control list (ACL) of an object. To use this operation, you must have
     * <code>s3:GetObjectAcl</code> permissions or <code>READ_ACP</code> access to the object. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#acl-access-policy-permission-mapping"
     * >Mapping of ACL permissions and access policy permissions</a> in the <i>Amazon S3 User Guide</i>
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * By default, GET returns ACL information about the current version of an object. To return ACL information about a
     * different version, use the versionId subresource.
     * </p>
     * <note>
     * <p>
     * If your bucket uses the bucket owner enforced setting for S3 Object Ownership, requests to read ACLs are still
     * supported and return the <code>bucket-owner-full-control</code> ACL with the owner being the account that created
     * the bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html"> Controlling object
     * ownership and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The following operations are related to <code>GetObjectAcl</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectAclRequest.Builder} avoiding the need to
     * create one manually via {@link GetObjectAclRequest#builder()}
     * </p>
     *
     * @param getObjectAclRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectAclRequest.Builder} to create a request.
     * @return Result of the GetObjectAcl operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectAcl
     */
    default GetObjectAclResponse getObjectAcl(Consumer<GetObjectAclRequest.Builder> getObjectAclRequest)
            throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        return getObjectAcl(GetObjectAclRequest.builder().applyMutation(getObjectAclRequest).build());
    }

    /**
     * <p>
     * Retrieves all the metadata from an object without returning the object itself. This operation is useful if you're
     * interested only in an object's metadata.
     * </p>
     * <p>
     * <code>GetObjectAttributes</code> combines the functionality of <code>HeadObject</code> and <code>ListParts</code>
     * . All of the data returned with each of those individual calls can be returned with a single call to
     * <code>GetObjectAttributes</code>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To use <code>GetObjectAttributes</code>, you must have READ access to
     * the object. The permissions that you need to use this operation depend on whether the bucket is versioned. If the
     * bucket is versioned, you need both the <code>s3:GetObjectVersion</code> and
     * <code>s3:GetObjectVersionAttributes</code> permissions for this operation. If the bucket is not versioned, you
     * need the <code>s3:GetObject</code> and <code>s3:GetObjectAttributes</code> permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a
     * Policy</a> in the <i>Amazon S3 User Guide</i>. If the object that you request does not exist, the error Amazon S3
     * returns depends on whether you also have the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> ("no such key") error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Forbidden</code> ("access denied") error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Encryption</dt>
     * <dd><note>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for
     * <code>HEAD</code> requests if your object uses server-side encryption with Key Management Service (KMS) keys
     * (SSE-KMS), dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), or server-side
     * encryption with Amazon S3 managed encryption keys (SSE-S3). The <code>x-amz-server-side-encryption</code> header
     * is used when you <code>PUT</code> an object to S3 and want to specify the encryption method. If you include this
     * header in a <code>GET</code> request for an object that uses these types of keys, you’ll get an HTTP
     * <code>400 Bad Request</code> error. It's because the encryption method can't be changed when you retrieve the
     * object.
     * </p>
     * </note>
     * <p>
     * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you
     * store the object in Amazon S3, then when you retrieve the metadata from the object, you must use the following
     * headers to provide the encryption key for the server to be able to retrieve the object's metadata. The headers
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key-MD5</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SSE-C, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side
     * Encryption (Using Customer-Provided Encryption Keys)</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory bucket permissions</b> - For directory buckets, there are only two supported options for server-side
     * encryption: server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) and server-side
     * encryption with KMS keys (SSE-KMS) (<code>aws:kms</code>). We recommend that the bucket's default encryption uses
     * the desired encryption configuration and you don't override the bucket default encryption in your
     * <code>CreateSession</code> requests or <code>PUT</code> object requests. Then, new objects are automatically
     * encrypted with the desired encryption settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>. For more information about the encryption
     * overriding behaviors in directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-specifying-kms-encryption.html">Specifying
     * server-side encryption with KMS for new object uploads</a>.
     * </p>
     * </note></dd>
     * <dt>Versioning</dt>
     * <dd>
     * <p>
     * <b>Directory buckets</b> - S3 Versioning isn't enabled and supported for directory buckets. For this API
     * operation, only the <code>null</code> value of the version ID is supported by directory buckets. You can only
     * specify <code>null</code> to the <code>versionId</code> query parameter in the request.
     * </p>
     * </dd>
     * <dt>Conditional request headers</dt>
     * <dd>
     * <p>
     * Consider the following when using request headers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as
     * follows, then Amazon S3 returns the HTTP status code <code>200 OK</code> and the data requested:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>If-Match</code> condition evaluates to <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>If-Unmodified-Since</code> condition evaluates to <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request
     * as follows, then Amazon S3 returns the HTTP status code <code>304 Not Modified</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>If-None-Match</code> condition evaluates to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>If-Modified-Since</code> condition evaluates to <code>true</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following actions are related to <code>GetObjectAttributes</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLegalHold.html">GetObjectLegalHold</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLockConfiguration.html">
     * GetObjectLockConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectRetention.html">GetObjectRetention</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html">GetObjectTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_HeadObject.html">HeadObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectAttributesRequest
     * @return Result of the GetObjectAttributes operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectAttributes
     */
    default GetObjectAttributesResponse getObjectAttributes(GetObjectAttributesRequest getObjectAttributesRequest)
            throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all the metadata from an object without returning the object itself. This operation is useful if you're
     * interested only in an object's metadata.
     * </p>
     * <p>
     * <code>GetObjectAttributes</code> combines the functionality of <code>HeadObject</code> and <code>ListParts</code>
     * . All of the data returned with each of those individual calls can be returned with a single call to
     * <code>GetObjectAttributes</code>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To use <code>GetObjectAttributes</code>, you must have READ access to
     * the object. The permissions that you need to use this operation depend on whether the bucket is versioned. If the
     * bucket is versioned, you need both the <code>s3:GetObjectVersion</code> and
     * <code>s3:GetObjectVersionAttributes</code> permissions for this operation. If the bucket is not versioned, you
     * need the <code>s3:GetObject</code> and <code>s3:GetObjectAttributes</code> permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a
     * Policy</a> in the <i>Amazon S3 User Guide</i>. If the object that you request does not exist, the error Amazon S3
     * returns depends on whether you also have the <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> ("no such key") error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Forbidden</code> ("access denied") error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Encryption</dt>
     * <dd><note>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for
     * <code>HEAD</code> requests if your object uses server-side encryption with Key Management Service (KMS) keys
     * (SSE-KMS), dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), or server-side
     * encryption with Amazon S3 managed encryption keys (SSE-S3). The <code>x-amz-server-side-encryption</code> header
     * is used when you <code>PUT</code> an object to S3 and want to specify the encryption method. If you include this
     * header in a <code>GET</code> request for an object that uses these types of keys, you’ll get an HTTP
     * <code>400 Bad Request</code> error. It's because the encryption method can't be changed when you retrieve the
     * object.
     * </p>
     * </note>
     * <p>
     * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you
     * store the object in Amazon S3, then when you retrieve the metadata from the object, you must use the following
     * headers to provide the encryption key for the server to be able to retrieve the object's metadata. The headers
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key-MD5</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SSE-C, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side
     * Encryption (Using Customer-Provided Encryption Keys)</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory bucket permissions</b> - For directory buckets, there are only two supported options for server-side
     * encryption: server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) and server-side
     * encryption with KMS keys (SSE-KMS) (<code>aws:kms</code>). We recommend that the bucket's default encryption uses
     * the desired encryption configuration and you don't override the bucket default encryption in your
     * <code>CreateSession</code> requests or <code>PUT</code> object requests. Then, new objects are automatically
     * encrypted with the desired encryption settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>. For more information about the encryption
     * overriding behaviors in directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-specifying-kms-encryption.html">Specifying
     * server-side encryption with KMS for new object uploads</a>.
     * </p>
     * </note></dd>
     * <dt>Versioning</dt>
     * <dd>
     * <p>
     * <b>Directory buckets</b> - S3 Versioning isn't enabled and supported for directory buckets. For this API
     * operation, only the <code>null</code> value of the version ID is supported by directory buckets. You can only
     * specify <code>null</code> to the <code>versionId</code> query parameter in the request.
     * </p>
     * </dd>
     * <dt>Conditional request headers</dt>
     * <dd>
     * <p>
     * Consider the following when using request headers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as
     * follows, then Amazon S3 returns the HTTP status code <code>200 OK</code> and the data requested:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>If-Match</code> condition evaluates to <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>If-Unmodified-Since</code> condition evaluates to <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request
     * as follows, then Amazon S3 returns the HTTP status code <code>304 Not Modified</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>If-None-Match</code> condition evaluates to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>If-Modified-Since</code> condition evaluates to <code>true</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following actions are related to <code>GetObjectAttributes</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLegalHold.html">GetObjectLegalHold</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLockConfiguration.html">
     * GetObjectLockConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectRetention.html">GetObjectRetention</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html">GetObjectTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_HeadObject.html">HeadObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetObjectAttributesRequest#builder()}
     * </p>
     *
     * @param getObjectAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectAttributesRequest.Builder} to create a request.
     * @return Result of the GetObjectAttributes operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectAttributes
     */
    default GetObjectAttributesResponse getObjectAttributes(
            Consumer<GetObjectAttributesRequest.Builder> getObjectAttributesRequest) throws NoSuchKeyException,
            AwsServiceException, SdkClientException, S3Exception {
        return getObjectAttributes(GetObjectAttributesRequest.builder().applyMutation(getObjectAttributesRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets an object's current legal hold status. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectLegalHold</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectLegalHoldRequest
     * @return Result of the GetObjectLegalHold operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectLegalHold
     */
    default GetObjectLegalHoldResponse getObjectLegalHold(GetObjectLegalHoldRequest getObjectLegalHoldRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets an object's current legal hold status. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectLegalHold</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectLegalHoldRequest.Builder} avoiding the
     * need to create one manually via {@link GetObjectLegalHoldRequest#builder()}
     * </p>
     *
     * @param getObjectLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectLegalHoldRequest.Builder} to create a request.
     * @return Result of the GetObjectLegalHold operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectLegalHold
     */
    default GetObjectLegalHoldResponse getObjectLegalHold(Consumer<GetObjectLegalHoldRequest.Builder> getObjectLegalHoldRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getObjectLegalHold(GetObjectLegalHoldRequest.builder().applyMutation(getObjectLegalHoldRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets the Object Lock configuration for a bucket. The rule specified in the Object Lock configuration will be
     * applied by default to every new object placed in the specified bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectLockConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectLockConfigurationRequest
     * @return Result of the GetObjectLockConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectLockConfiguration
     */
    default GetObjectLockConfigurationResponse getObjectLockConfiguration(
            GetObjectLockConfigurationRequest getObjectLockConfigurationRequest) throws AwsServiceException, SdkClientException,
            S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets the Object Lock configuration for a bucket. The rule specified in the Object Lock configuration will be
     * applied by default to every new object placed in the specified bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectLockConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectLockConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetObjectLockConfigurationRequest#builder()}
     * </p>
     *
     * @param getObjectLockConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetObjectLockConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectLockConfiguration
     */
    default GetObjectLockConfigurationResponse getObjectLockConfiguration(
            Consumer<GetObjectLockConfigurationRequest.Builder> getObjectLockConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getObjectLockConfiguration(GetObjectLockConfigurationRequest.builder()
                .applyMutation(getObjectLockConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves an object's retention settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectRetention</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectRetentionRequest
     * @return Result of the GetObjectRetention operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectRetention
     */
    default GetObjectRetentionResponse getObjectRetention(GetObjectRetentionRequest getObjectRetentionRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves an object's retention settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectRetention</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectRetentionRequest.Builder} avoiding the
     * need to create one manually via {@link GetObjectRetentionRequest#builder()}
     * </p>
     *
     * @param getObjectRetentionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectRetentionRequest.Builder} to create a request.
     * @return Result of the GetObjectRetention operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectRetention
     */
    default GetObjectRetentionResponse getObjectRetention(Consumer<GetObjectRetentionRequest.Builder> getObjectRetentionRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getObjectRetention(GetObjectRetentionRequest.builder().applyMutation(getObjectRetentionRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the tag-set of an object. You send the GET request against the tagging subresource associated with the
     * object.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:GetObjectTagging</code> action. By
     * default, the GET action returns information about current version of an object. For a versioned bucket, you can
     * have multiple versions of an object in your bucket. To retrieve tags of any other version, use the versionId
     * query parameter. You also need permission for the <code>s3:GetObjectVersionTagging</code> action.
     * </p>
     * <p>
     * By default, the bucket owner has this permission and can grant this permission to others.
     * </p>
     * <p>
     * For information about the Amazon S3 object tagging feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html">Object Tagging</a>.
     * </p>
     * <p>
     * The following actions are related to <code>GetObjectTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html">DeleteObjectTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html">PutObjectTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectTaggingRequest
     * @return Result of the GetObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTagging
     */
    default GetObjectTaggingResponse getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the tag-set of an object. You send the GET request against the tagging subresource associated with the
     * object.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:GetObjectTagging</code> action. By
     * default, the GET action returns information about current version of an object. For a versioned bucket, you can
     * have multiple versions of an object in your bucket. To retrieve tags of any other version, use the versionId
     * query parameter. You also need permission for the <code>s3:GetObjectVersionTagging</code> action.
     * </p>
     * <p>
     * By default, the bucket owner has this permission and can grant this permission to others.
     * </p>
     * <p>
     * For information about the Amazon S3 object tagging feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html">Object Tagging</a>.
     * </p>
     * <p>
     * The following actions are related to <code>GetObjectTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html">DeleteObjectTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html">PutObjectTagging</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectTaggingRequest.Builder} avoiding the need
     * to create one manually via {@link GetObjectTaggingRequest#builder()}
     * </p>
     *
     * @param getObjectTaggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest.Builder} to create a request.
     * @return Result of the GetObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTagging
     */
    default GetObjectTaggingResponse getObjectTagging(Consumer<GetObjectTaggingRequest.Builder> getObjectTaggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getObjectTagging(GetObjectTaggingRequest.builder().applyMutation(getObjectTaggingRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files.
     * </p>
     * <note>
     * <p>
     * You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using
     * server-side encryption with a customer-provided encryption key.
     * </p>
     * </note>
     * <p>
     * To use GET, you must have READ access to the object.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectTorrent</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectTorrentRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        GetObjectTorrentResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        A Bencoded dictionary as defined by the BitTorrent specification
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     */
    default <ReturnT> ReturnT getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest,
            ResponseTransformer<GetObjectTorrentResponse, ReturnT> responseTransformer) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files.
     * </p>
     * <note>
     * <p>
     * You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using
     * server-side encryption with a customer-provided encryption key.
     * </p>
     * </note>
     * <p>
     * To use GET, you must have READ access to the object.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectTorrent</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectTorrentRequest.Builder} avoiding the need
     * to create one manually via {@link GetObjectTorrentRequest#builder()}
     * </p>
     *
     * @param getObjectTorrentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest.Builder} to create a request.
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        GetObjectTorrentResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        A Bencoded dictionary as defined by the BitTorrent specification
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     */
    default <ReturnT> ReturnT getObjectTorrent(Consumer<GetObjectTorrentRequest.Builder> getObjectTorrentRequest,
            ResponseTransformer<GetObjectTorrentResponse, ReturnT> responseTransformer) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getObjectTorrent(GetObjectTorrentRequest.builder().applyMutation(getObjectTorrentRequest).build(),
                responseTransformer);
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files.
     * </p>
     * <note>
     * <p>
     * You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using
     * server-side encryption with a customer-provided encryption key.
     * </p>
     * </note>
     * <p>
     * To use GET, you must have READ access to the object.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectTorrent</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectTorrentRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        A Bencoded dictionary as defined by the BitTorrent specification
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObjectTorrent(GetObjectTorrentRequest, ResponseTransformer)
     */
    default GetObjectTorrentResponse getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest, Path destinationPath)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getObjectTorrent(getObjectTorrentRequest, ResponseTransformer.toFile(destinationPath));
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files.
     * </p>
     * <note>
     * <p>
     * You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using
     * server-side encryption with a customer-provided encryption key.
     * </p>
     * </note>
     * <p>
     * To use GET, you must have READ access to the object.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectTorrent</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectTorrentRequest.Builder} avoiding the need
     * to create one manually via {@link GetObjectTorrentRequest#builder()}
     * </p>
     *
     * @param getObjectTorrentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest.Builder} to create a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        A Bencoded dictionary as defined by the BitTorrent specification
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObjectTorrent(GetObjectTorrentRequest, ResponseTransformer)
     */
    default GetObjectTorrentResponse getObjectTorrent(Consumer<GetObjectTorrentRequest.Builder> getObjectTorrentRequest,
            Path destinationPath) throws AwsServiceException, SdkClientException, S3Exception {
        return getObjectTorrent(GetObjectTorrentRequest.builder().applyMutation(getObjectTorrentRequest).build(), destinationPath);
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files.
     * </p>
     * <note>
     * <p>
     * You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using
     * server-side encryption with a customer-provided encryption key.
     * </p>
     * </note>
     * <p>
     * To use GET, you must have READ access to the object.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectTorrent</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectTorrentRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         A Bencoded dictionary as defined by the BitTorrent specification
     *         </p>
     *         '.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObject(getObjectTorrent, ResponseTransformer)
     */
    default ResponseInputStream<GetObjectTorrentResponse> getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getObjectTorrent(getObjectTorrentRequest, ResponseTransformer.toInputStream());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files.
     * </p>
     * <note>
     * <p>
     * You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using
     * server-side encryption with a customer-provided encryption key.
     * </p>
     * </note>
     * <p>
     * To use GET, you must have READ access to the object.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectTorrent</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectTorrentRequest.Builder} avoiding the need
     * to create one manually via {@link GetObjectTorrentRequest#builder()}
     * </p>
     *
     * @param getObjectTorrentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest.Builder} to create a request.
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         A Bencoded dictionary as defined by the BitTorrent specification
     *         </p>
     *         '.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObject(getObjectTorrent, ResponseTransformer)
     */
    default ResponseInputStream<GetObjectTorrentResponse> getObjectTorrent(
            Consumer<GetObjectTorrentRequest.Builder> getObjectTorrentRequest) throws AwsServiceException, SdkClientException,
            S3Exception {
        return getObjectTorrent(GetObjectTorrentRequest.builder().applyMutation(getObjectTorrentRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files.
     * </p>
     * <note>
     * <p>
     * You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using
     * server-side encryption with a customer-provided encryption key.
     * </p>
     * </note>
     * <p>
     * To use GET, you must have READ access to the object.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectTorrent</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getObjectTorrentRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         A Bencoded dictionary as defined by the BitTorrent specification
     *         </p>
     *         '.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObject(getObjectTorrent, ResponseTransformer)
     */
    default ResponseBytes<GetObjectTorrentResponse> getObjectTorrentAsBytes(GetObjectTorrentRequest getObjectTorrentRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return getObjectTorrent(getObjectTorrentRequest, ResponseTransformer.toBytes());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files.
     * </p>
     * <note>
     * <p>
     * You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using
     * server-side encryption with a customer-provided encryption key.
     * </p>
     * </note>
     * <p>
     * To use GET, you must have READ access to the object.
     * </p>
     * <p>
     * This functionality is not supported for Amazon S3 on Outposts.
     * </p>
     * <p>
     * The following action is related to <code>GetObjectTorrent</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectTorrentRequest.Builder} avoiding the need
     * to create one manually via {@link GetObjectTorrentRequest#builder()}
     * </p>
     *
     * @param getObjectTorrentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest.Builder} to create a request.
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         A Bencoded dictionary as defined by the BitTorrent specification
     *         </p>
     *         '.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObject(getObjectTorrent, ResponseTransformer)
     */
    default ResponseBytes<GetObjectTorrentResponse> getObjectTorrentAsBytes(
            Consumer<GetObjectTorrentRequest.Builder> getObjectTorrentRequest) throws AwsServiceException, SdkClientException,
            S3Exception {
        return getObjectTorrentAsBytes(GetObjectTorrentRequest.builder().applyMutation(getObjectTorrentRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you
     * must have the <code>s3:GetBucketPublicAccessBlock</code> permission. For more information about Amazon S3
     * permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying
     * Permissions in a Policy</a>.
     * </p>
     * <important>
     * <p>
     * When Amazon S3 evaluates the <code>PublicAccessBlock</code> configuration for a bucket or an object, it checks
     * the <code>PublicAccessBlock</code> configuration for both the bucket (or the bucket that contains the object) and
     * the bucket owner's account. If the <code>PublicAccessBlock</code> settings are different between the bucket and
     * the account, Amazon S3 uses the most restrictive combination of the bucket-level and account-level settings.
     * </p>
     * </important>
     * <p>
     * For more information about when Amazon S3 considers a bucket or an object public, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status"
     * >The Meaning of "Public"</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetPublicAccessBlock</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3
     * Block Public Access</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html">DeletePublicAccessBlock
     * </a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getPublicAccessBlockRequest
     * @return Result of the GetPublicAccessBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetPublicAccessBlock
     */
    default GetPublicAccessBlockResponse getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you
     * must have the <code>s3:GetBucketPublicAccessBlock</code> permission. For more information about Amazon S3
     * permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying
     * Permissions in a Policy</a>.
     * </p>
     * <important>
     * <p>
     * When Amazon S3 evaluates the <code>PublicAccessBlock</code> configuration for a bucket or an object, it checks
     * the <code>PublicAccessBlock</code> configuration for both the bucket (or the bucket that contains the object) and
     * the bucket owner's account. If the <code>PublicAccessBlock</code> settings are different between the bucket and
     * the account, Amazon S3 uses the most restrictive combination of the bucket-level and account-level settings.
     * </p>
     * </important>
     * <p>
     * For more information about when Amazon S3 considers a bucket or an object public, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status"
     * >The Meaning of "Public"</a>.
     * </p>
     * <p>
     * The following operations are related to <code>GetPublicAccessBlock</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3
     * Block Public Access</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html">DeletePublicAccessBlock
     * </a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPublicAccessBlockRequest.Builder} avoiding the
     * need to create one manually via {@link GetPublicAccessBlockRequest#builder()}
     * </p>
     *
     * @param getPublicAccessBlockRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.GetPublicAccessBlockRequest.Builder} to create a request.
     * @return Result of the GetPublicAccessBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetPublicAccessBlock
     */
    default GetPublicAccessBlockResponse getPublicAccessBlock(
            Consumer<GetPublicAccessBlockRequest.Builder> getPublicAccessBlockRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return getPublicAccessBlock(GetPublicAccessBlockRequest.builder().applyMutation(getPublicAccessBlockRequest).build());
    }

    /**
     * <p>
     * You can use this operation to determine if a bucket exists and if you have permission to access it. The action
     * returns a <code>200 OK</code> if the bucket exists and you have permission to access it.
     * </p>
     * <note>
     * <p>
     * If the bucket does not exist or you do not have permission to access it, the <code>HEAD</code> request returns a
     * generic <code>400 Bad Request</code>, <code>403 Forbidden</code> or <code>404 Not Found</code> code. A message
     * body is not included, so you cannot determine the exception beyond these HTTP response codes.
     * </p>
     * </note>
     * <dl>
     * <dt>Authentication and authorization</dt>
     * <dd>
     * <p>
     * <b>General purpose buckets</b> - Request to public buckets that grant the s3:ListBucket permission publicly do
     * not need to be signed. All other <code>HeadBucket</code> requests must be authenticated and signed by using IAM
     * credentials (access key ID and secret access key for the IAM identities). All headers with the
     * <code>x-amz-</code> prefix, including <code>x-amz-copy-source</code>, must be signed. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - You must use IAM credentials to authenticate and authorize your access to the
     * <code>HeadBucket</code> API operation, instead of using the temporary security credentials through the
     * <code>CreateSession</code> API operation.
     * </p>
     * <p>
     * Amazon Web Services CLI or SDKs handles authentication and authorization on your behalf.
     * </p>
     * </dd>
     * <dt>Permissions</dt>
     * <dd>
     * <p/>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To use this operation, you must have permissions to perform the
     * <code>s3:ListBucket</code> action. The bucket owner has this permission by default and can grant this permission
     * to others. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions
     * to your Amazon S3 resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <b> <code>s3express:CreateSession</code> </b> permission
     * in the <code>Action</code> element of a policy. By default, the session is in the <code>ReadWrite</code> mode. If
     * you want to restrict the access, you can explicitly set the <code>s3express:SessionMode</code> condition key to
     * <code>ReadOnly</code> on the bucket.
     * </p>
     * <p>
     * For more information about example bucket policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-identity-policies.html"
     * >Amazon Web Services Identity and Access Management (IAM) identity-based policies for S3 Express One Zone</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * <note>
     * <p>
     * You must make requests for this API operation to the Zonal endpoint. These endpoints support virtual-hosted-style
     * requests in the format <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>
     * . Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></dd>
     * </dl>
     *
     * @param headBucketRequest
     * @return Result of the HeadBucket operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.HeadBucket
     */
    default HeadBucketResponse headBucket(HeadBucketRequest headBucketRequest) throws NoSuchBucketException, AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can use this operation to determine if a bucket exists and if you have permission to access it. The action
     * returns a <code>200 OK</code> if the bucket exists and you have permission to access it.
     * </p>
     * <note>
     * <p>
     * If the bucket does not exist or you do not have permission to access it, the <code>HEAD</code> request returns a
     * generic <code>400 Bad Request</code>, <code>403 Forbidden</code> or <code>404 Not Found</code> code. A message
     * body is not included, so you cannot determine the exception beyond these HTTP response codes.
     * </p>
     * </note>
     * <dl>
     * <dt>Authentication and authorization</dt>
     * <dd>
     * <p>
     * <b>General purpose buckets</b> - Request to public buckets that grant the s3:ListBucket permission publicly do
     * not need to be signed. All other <code>HeadBucket</code> requests must be authenticated and signed by using IAM
     * credentials (access key ID and secret access key for the IAM identities). All headers with the
     * <code>x-amz-</code> prefix, including <code>x-amz-copy-source</code>, must be signed. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.
     * </p>
     * <p>
     * <b>Directory buckets</b> - You must use IAM credentials to authenticate and authorize your access to the
     * <code>HeadBucket</code> API operation, instead of using the temporary security credentials through the
     * <code>CreateSession</code> API operation.
     * </p>
     * <p>
     * Amazon Web Services CLI or SDKs handles authentication and authorization on your behalf.
     * </p>
     * </dd>
     * <dt>Permissions</dt>
     * <dd>
     * <p/>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To use this operation, you must have permissions to perform the
     * <code>s3:ListBucket</code> action. The bucket owner has this permission by default and can grant this permission
     * to others. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions
     * to your Amazon S3 resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <b> <code>s3express:CreateSession</code> </b> permission
     * in the <code>Action</code> element of a policy. By default, the session is in the <code>ReadWrite</code> mode. If
     * you want to restrict the access, you can explicitly set the <code>s3express:SessionMode</code> condition key to
     * <code>ReadOnly</code> on the bucket.
     * </p>
     * <p>
     * For more information about example bucket policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-identity-policies.html"
     * >Amazon Web Services Identity and Access Management (IAM) identity-based policies for S3 Express One Zone</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * <note>
     * <p>
     * You must make requests for this API operation to the Zonal endpoint. These endpoints support virtual-hosted-style
     * requests in the format <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>
     * . Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link HeadBucketRequest.Builder} avoiding the need to
     * create one manually via {@link HeadBucketRequest#builder()}
     * </p>
     *
     * @param headBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.HeadBucketRequest.Builder} to create a request.
     * @return Result of the HeadBucket operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.HeadBucket
     */
    default HeadBucketResponse headBucket(Consumer<HeadBucketRequest.Builder> headBucketRequest) throws NoSuchBucketException,
            AwsServiceException, SdkClientException, S3Exception {
        return headBucket(HeadBucketRequest.builder().applyMutation(headBucketRequest).build());
    }

    /**
     * <p>
     * The <code>HEAD</code> operation retrieves metadata from an object without returning the object itself. This
     * operation is useful if you're interested only in an object's metadata.
     * </p>
     * <note>
     * <p>
     * A <code>HEAD</code> request has the same options as a <code>GET</code> operation on an object. The response is
     * identical to the <code>GET</code> response except that there is no response body. Because of this, if the
     * <code>HEAD</code> request generates an error, it returns a generic code, such as <code>400 Bad Request</code>,
     * <code>403 Forbidden</code>, <code>404 Not Found</code>, <code>405 Method Not Allowed</code>,
     * <code>412 Precondition Failed</code>, or <code>304 Not Modified</code>. It's not possible to retrieve the exact
     * exception of these error codes.
     * </p>
     * </note>
     * <p>
     * Request headers are limited to 8 KB in size. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html">Common Request Headers</a>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p/>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To use <code>HEAD</code>, you must have the <code>s3:GetObject</code>
     * permission. You need the relevant read object (or version) permission for this operation. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and
     * condition keys for Amazon S3</a> in the <i>Amazon S3 User Guide</i>. For more information about the permissions
     * to S3 API operations by S3 resource types, see <a
     * href="/AmazonS3/latest/userguide/using-with-s3-policy-actions.html">Required permissions for Amazon S3 API
     * operations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If the object you request doesn't exist, the error that Amazon S3 returns depends on whether you also have the
     * <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Forbidden</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If you enable <code>x-amz-checksum-mode</code> in the request and the object is encrypted with Amazon Web
     * Services Key Management Service (Amazon Web Services KMS), you must also have the
     * <code>kms:GenerateDataKey</code> and <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS
     * key policies for the KMS key to retrieve the checksum of the object.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Encryption</dt>
     * <dd><note>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for
     * <code>HEAD</code> requests if your object uses server-side encryption with Key Management Service (KMS) keys
     * (SSE-KMS), dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), or server-side
     * encryption with Amazon S3 managed encryption keys (SSE-S3). The <code>x-amz-server-side-encryption</code> header
     * is used when you <code>PUT</code> an object to S3 and want to specify the encryption method. If you include this
     * header in a <code>HEAD</code> request for an object that uses these types of keys, you’ll get an HTTP
     * <code>400 Bad Request</code> error. It's because the encryption method can't be changed when you retrieve the
     * object.
     * </p>
     * </note>
     * <p>
     * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you
     * store the object in Amazon S3, then when you retrieve the metadata from the object, you must use the following
     * headers to provide the encryption key for the server to be able to retrieve the object's metadata. The headers
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key-MD5</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SSE-C, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side
     * Encryption (Using Customer-Provided Encryption Keys)</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory bucket </b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></dd>
     * <dt>Versioning</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * If the current version of the object is a delete marker, Amazon S3 behaves as if the object was deleted and
     * includes <code>x-amz-delete-marker: true</code> in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the specified version is a delete marker, the response returns a <code>405 Method Not Allowed</code> error and
     * the <code>Last-Modified: timestamp</code> response header.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets</b> - Delete marker is not supported for directory buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - S3 Versioning isn't enabled and supported for directory buckets. For this API
     * operation, only the <code>null</code> value of the version ID is supported by directory buckets. You can only
     * specify <code>null</code> to the <code>versionId</code> query parameter in the request.
     * </p>
     * </li>
     * </ul>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * <note>
     * <p>
     * For directory buckets, you must make requests for this API operation to the Zonal endpoint. These endpoints
     * support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></dd>
     * </dl>
     * <p>
     * The following actions are related to <code>HeadObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param headObjectRequest
     * @return Result of the HeadObject operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.HeadObject
     */
    default HeadObjectResponse headObject(HeadObjectRequest headObjectRequest) throws NoSuchKeyException, AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>HEAD</code> operation retrieves metadata from an object without returning the object itself. This
     * operation is useful if you're interested only in an object's metadata.
     * </p>
     * <note>
     * <p>
     * A <code>HEAD</code> request has the same options as a <code>GET</code> operation on an object. The response is
     * identical to the <code>GET</code> response except that there is no response body. Because of this, if the
     * <code>HEAD</code> request generates an error, it returns a generic code, such as <code>400 Bad Request</code>,
     * <code>403 Forbidden</code>, <code>404 Not Found</code>, <code>405 Method Not Allowed</code>,
     * <code>412 Precondition Failed</code>, or <code>304 Not Modified</code>. It's not possible to retrieve the exact
     * exception of these error codes.
     * </p>
     * </note>
     * <p>
     * Request headers are limited to 8 KB in size. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html">Common Request Headers</a>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p/>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To use <code>HEAD</code>, you must have the <code>s3:GetObject</code>
     * permission. You need the relevant read object (or version) permission for this operation. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and
     * condition keys for Amazon S3</a> in the <i>Amazon S3 User Guide</i>. For more information about the permissions
     * to S3 API operations by S3 resource types, see <a
     * href="/AmazonS3/latest/userguide/using-with-s3-policy-actions.html">Required permissions for Amazon S3 API
     * operations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If the object you request doesn't exist, the error that Amazon S3 returns depends on whether you also have the
     * <code>s3:ListBucket</code> permission.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code
     * <code>404 Not Found</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code
     * <code>403 Forbidden</code> error.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If you enable <code>x-amz-checksum-mode</code> in the request and the object is encrypted with Amazon Web
     * Services Key Management Service (Amazon Web Services KMS), you must also have the
     * <code>kms:GenerateDataKey</code> and <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS
     * key policies for the KMS key to retrieve the checksum of the object.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Encryption</dt>
     * <dd><note>
     * <p>
     * Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for
     * <code>HEAD</code> requests if your object uses server-side encryption with Key Management Service (KMS) keys
     * (SSE-KMS), dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), or server-side
     * encryption with Amazon S3 managed encryption keys (SSE-S3). The <code>x-amz-server-side-encryption</code> header
     * is used when you <code>PUT</code> an object to S3 and want to specify the encryption method. If you include this
     * header in a <code>HEAD</code> request for an object that uses these types of keys, you’ll get an HTTP
     * <code>400 Bad Request</code> error. It's because the encryption method can't be changed when you retrieve the
     * object.
     * </p>
     * </note>
     * <p>
     * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you
     * store the object in Amazon S3, then when you retrieve the metadata from the object, you must use the following
     * headers to provide the encryption key for the server to be able to retrieve the object's metadata. The headers
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-amz-server-side-encryption-customer-key-MD5</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SSE-C, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side
     * Encryption (Using Customer-Provided Encryption Keys)</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory bucket </b> - For directory buckets, there are only two supported options for server-side
     * encryption: SSE-S3 and SSE-KMS. SSE-C isn't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-serv-side-encryption.html">Protecting data
     * with server-side encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></dd>
     * <dt>Versioning</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * If the current version of the object is a delete marker, Amazon S3 behaves as if the object was deleted and
     * includes <code>x-amz-delete-marker: true</code> in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the specified version is a delete marker, the response returns a <code>405 Method Not Allowed</code> error and
     * the <code>Last-Modified: timestamp</code> response header.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>Directory buckets</b> - Delete marker is not supported for directory buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - S3 Versioning isn't enabled and supported for directory buckets. For this API
     * operation, only the <code>null</code> value of the version ID is supported by directory buckets. You can only
     * specify <code>null</code> to the <code>versionId</code> query parameter in the request.
     * </p>
     * </li>
     * </ul>
     * </note></dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * <note>
     * <p>
     * For directory buckets, you must make requests for this API operation to the Zonal endpoint. These endpoints
     * support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></dd>
     * </dl>
     * <p>
     * The following actions are related to <code>HeadObject</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link HeadObjectRequest.Builder} avoiding the need to
     * create one manually via {@link HeadObjectRequest#builder()}
     * </p>
     *
     * @param headObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.HeadObjectRequest.Builder} to create a request.
     * @return Result of the HeadObject operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.HeadObject
     */
    default HeadObjectResponse headObject(Consumer<HeadObjectRequest.Builder> headObjectRequest) throws NoSuchKeyException,
            AwsServiceException, SdkClientException, S3Exception {
        return headObject(HeadObjectRequest.builder().applyMutation(headObjectRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Lists the analytics configurations for the bucket. You can have up to 1,000 analytics configurations per bucket.
     * </p>
     * <p>
     * This action supports list pagination and does not return more than 100 configurations at a time. You should
     * always check the <code>IsTruncated</code> element in the response. If there are no more configurations to list,
     * <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is
     * set to true, and there will be a value in <code>NextContinuationToken</code>. You use the
     * <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in
     * continuation-token in the request to <code>GET</code> the next page.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetAnalyticsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about Amazon S3 analytics feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage
     * Class Analysis</a>.
     * </p>
     * <p>
     * The following operations are related to <code>ListBucketAnalyticsConfigurations</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">
     * GetBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">
     * DeleteBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">
     * PutBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listBucketAnalyticsConfigurationsRequest
     * @return Result of the ListBucketAnalyticsConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketAnalyticsConfigurations
     */
    default ListBucketAnalyticsConfigurationsResponse listBucketAnalyticsConfigurations(
            ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Lists the analytics configurations for the bucket. You can have up to 1,000 analytics configurations per bucket.
     * </p>
     * <p>
     * This action supports list pagination and does not return more than 100 configurations at a time. You should
     * always check the <code>IsTruncated</code> element in the response. If there are no more configurations to list,
     * <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is
     * set to true, and there will be a value in <code>NextContinuationToken</code>. You use the
     * <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in
     * continuation-token in the request to <code>GET</code> the next page.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetAnalyticsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about Amazon S3 analytics feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage
     * Class Analysis</a>.
     * </p>
     * <p>
     * The following operations are related to <code>ListBucketAnalyticsConfigurations</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">
     * GetBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">
     * DeleteBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">
     * PutBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBucketAnalyticsConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBucketAnalyticsConfigurationsRequest#builder()}
     * </p>
     *
     * @param listBucketAnalyticsConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListBucketAnalyticsConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketAnalyticsConfigurations
     */
    default ListBucketAnalyticsConfigurationsResponse listBucketAnalyticsConfigurations(
            Consumer<ListBucketAnalyticsConfigurationsRequest.Builder> listBucketAnalyticsConfigurationsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest.builder()
                .applyMutation(listBucketAnalyticsConfigurationsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Lists the S3 Intelligent-Tiering configuration from the specified bucket.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to
     * the most cost-effective storage access tier, without performance impact or operational overhead. S3
     * Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get
     * the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional
     * archiving capabilities.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or
     * unpredictable access patterns, independent of object size or retention period. If the size of an object is less
     * than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are
     * always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage
     * class for automatically optimizing frequently and infrequently accessed objects</a>.
     * </p>
     * <p>
     * Operations related to <code>ListBucketIntelligentTieringConfigurations</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">
     * DeleteBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">
     * PutBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">
     * GetBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listBucketIntelligentTieringConfigurationsRequest
     * @return Result of the ListBucketIntelligentTieringConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketIntelligentTieringConfigurations
     */
    default ListBucketIntelligentTieringConfigurationsResponse listBucketIntelligentTieringConfigurations(
            ListBucketIntelligentTieringConfigurationsRequest listBucketIntelligentTieringConfigurationsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Lists the S3 Intelligent-Tiering configuration from the specified bucket.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to
     * the most cost-effective storage access tier, without performance impact or operational overhead. S3
     * Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get
     * the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional
     * archiving capabilities.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or
     * unpredictable access patterns, independent of object size or retention period. If the size of an object is less
     * than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are
     * always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage
     * class for automatically optimizing frequently and infrequently accessed objects</a>.
     * </p>
     * <p>
     * Operations related to <code>ListBucketIntelligentTieringConfigurations</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">
     * DeleteBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">
     * PutBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">
     * GetBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBucketIntelligentTieringConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBucketIntelligentTieringConfigurationsRequest#builder()}
     * </p>
     *
     * @param listBucketIntelligentTieringConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBucketIntelligentTieringConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketIntelligentTieringConfigurations
     */
    default ListBucketIntelligentTieringConfigurationsResponse listBucketIntelligentTieringConfigurations(
            Consumer<ListBucketIntelligentTieringConfigurationsRequest.Builder> listBucketIntelligentTieringConfigurationsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return listBucketIntelligentTieringConfigurations(ListBucketIntelligentTieringConfigurationsRequest.builder()
                .applyMutation(listBucketIntelligentTieringConfigurationsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns a list of inventory configurations for the bucket. You can have up to 1,000 analytics configurations per
     * bucket.
     * </p>
     * <p>
     * This action supports list pagination and does not return more than 100 configurations at a time. Always check the
     * <code>IsTruncated</code> element in the response. If there are no more configurations to list,
     * <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is
     * set to true, and there is a value in <code>NextContinuationToken</code>. You use the
     * <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in
     * continuation-token in the request to <code>GET</code> the next page.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetInventoryConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about the Amazon S3 inventory feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>
     * </p>
     * <p>
     * The following operations are related to <code>ListBucketInventoryConfigurations</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">
     * GetBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">
     * DeleteBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">
     * PutBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listBucketInventoryConfigurationsRequest
     * @return Result of the ListBucketInventoryConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketInventoryConfigurations
     */
    default ListBucketInventoryConfigurationsResponse listBucketInventoryConfigurations(
            ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns a list of inventory configurations for the bucket. You can have up to 1,000 analytics configurations per
     * bucket.
     * </p>
     * <p>
     * This action supports list pagination and does not return more than 100 configurations at a time. Always check the
     * <code>IsTruncated</code> element in the response. If there are no more configurations to list,
     * <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is
     * set to true, and there is a value in <code>NextContinuationToken</code>. You use the
     * <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in
     * continuation-token in the request to <code>GET</code> the next page.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetInventoryConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about the Amazon S3 inventory feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>
     * </p>
     * <p>
     * The following operations are related to <code>ListBucketInventoryConfigurations</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">
     * GetBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">
     * DeleteBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">
     * PutBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBucketInventoryConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBucketInventoryConfigurationsRequest#builder()}
     * </p>
     *
     * @param listBucketInventoryConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListBucketInventoryConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketInventoryConfigurations
     */
    default ListBucketInventoryConfigurationsResponse listBucketInventoryConfigurations(
            Consumer<ListBucketInventoryConfigurationsRequest.Builder> listBucketInventoryConfigurationsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest.builder()
                .applyMutation(listBucketInventoryConfigurationsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Lists the metrics configurations for the bucket. The metrics configurations are only for the request metrics of
     * the bucket and do not provide information on daily storage metrics. You can have up to 1,000 configurations per
     * bucket.
     * </p>
     * <p>
     * This action supports list pagination and does not return more than 100 configurations at a time. Always check the
     * <code>IsTruncated</code> element in the response. If there are no more configurations to list,
     * <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is
     * set to true, and there is a value in <code>NextContinuationToken</code>. You use the
     * <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in
     * <code>continuation-token</code> in the request to <code>GET</code> the next page.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetMetricsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For more information about metrics configurations and CloudWatch request metrics, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon
     * CloudWatch</a>.
     * </p>
     * <p>
     * The following operations are related to <code>ListBucketMetricsConfigurations</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">
     * PutBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">
     * GetBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">
     * DeleteBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listBucketMetricsConfigurationsRequest
     * @return Result of the ListBucketMetricsConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketMetricsConfigurations
     */
    default ListBucketMetricsConfigurationsResponse listBucketMetricsConfigurations(
            ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Lists the metrics configurations for the bucket. The metrics configurations are only for the request metrics of
     * the bucket and do not provide information on daily storage metrics. You can have up to 1,000 configurations per
     * bucket.
     * </p>
     * <p>
     * This action supports list pagination and does not return more than 100 configurations at a time. Always check the
     * <code>IsTruncated</code> element in the response. If there are no more configurations to list,
     * <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is
     * set to true, and there is a value in <code>NextContinuationToken</code>. You use the
     * <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in
     * <code>continuation-token</code> in the request to <code>GET</code> the next page.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:GetMetricsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For more information about metrics configurations and CloudWatch request metrics, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon
     * CloudWatch</a>.
     * </p>
     * <p>
     * The following operations are related to <code>ListBucketMetricsConfigurations</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">
     * PutBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">
     * GetBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">
     * DeleteBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBucketMetricsConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBucketMetricsConfigurationsRequest#builder()}
     * </p>
     *
     * @param listBucketMetricsConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListBucketMetricsConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketMetricsConfigurations
     */
    default ListBucketMetricsConfigurationsResponse listBucketMetricsConfigurations(
            Consumer<ListBucketMetricsConfigurationsRequest.Builder> listBucketMetricsConfigurationsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest.builder()
                .applyMutation(listBucketMetricsConfigurationsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns a list of all buckets owned by the authenticated sender of the request. To grant IAM permission to use
     * this operation, you must add the <code>s3:ListAllMyBuckets</code> policy action.
     * </p>
     * <p>
     * For information about Amazon S3 buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and
     * working with Amazon S3 buckets</a>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated <code>ListBuckets</code> requests. Unpaginated
     * <code>ListBuckets</code> requests are only supported for Amazon Web Services accounts set to the default general
     * purpose bucket quota of 10,000. If you have an approved general purpose bucket quota above 10,000, you must send
     * paginated <code>ListBuckets</code> requests to list your account’s buckets. All unpaginated
     * <code>ListBuckets</code> requests will be rejected for Amazon Web Services accounts with a general purpose bucket
     * quota greater than 10,000.
     * </p>
     * </important>
     *
     * @param listBucketsRequest
     * @return Result of the ListBuckets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     */
    default ListBucketsResponse listBuckets(ListBucketsRequest listBucketsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns a list of all buckets owned by the authenticated sender of the request. To grant IAM permission to use
     * this operation, you must add the <code>s3:ListAllMyBuckets</code> policy action.
     * </p>
     * <p>
     * For information about Amazon S3 buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and
     * working with Amazon S3 buckets</a>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated <code>ListBuckets</code> requests. Unpaginated
     * <code>ListBuckets</code> requests are only supported for Amazon Web Services accounts set to the default general
     * purpose bucket quota of 10,000. If you have an approved general purpose bucket quota above 10,000, you must send
     * paginated <code>ListBuckets</code> requests to list your account’s buckets. All unpaginated
     * <code>ListBuckets</code> requests will be rejected for Amazon Web Services accounts with a general purpose bucket
     * quota greater than 10,000.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBucketsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBucketsRequest#builder()}
     * </p>
     *
     * @param listBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListBucketsRequest.Builder} to create a request.
     * @return Result of the ListBuckets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     */
    default ListBucketsResponse listBuckets(Consumer<ListBucketsRequest.Builder> listBucketsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return listBuckets(ListBucketsRequest.builder().applyMutation(listBucketsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns a list of all buckets owned by the authenticated sender of the request. To grant IAM permission to use
     * this operation, you must add the <code>s3:ListAllMyBuckets</code> policy action.
     * </p>
     * <p>
     * For information about Amazon S3 buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and
     * working with Amazon S3 buckets</a>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated <code>ListBuckets</code> requests. Unpaginated
     * <code>ListBuckets</code> requests are only supported for Amazon Web Services accounts set to the default general
     * purpose bucket quota of 10,000. If you have an approved general purpose bucket quota above 10,000, you must send
     * paginated <code>ListBuckets</code> requests to list your account’s buckets. All unpaginated
     * <code>ListBuckets</code> requests will be rejected for Amazon Web Services accounts with a general purpose bucket
     * quota greater than 10,000.
     * </p>
     * </important>
     *
     * @return Result of the ListBuckets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     * @see #listBuckets(ListBucketsRequest)
     */
    default ListBucketsResponse listBuckets() throws AwsServiceException, SdkClientException, S3Exception {
        return listBuckets(ListBucketsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBuckets(software.amazon.awssdk.services.s3.model.ListBucketsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuckets(software.amazon.awssdk.services.s3.model.ListBucketsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     * @see #listBucketsPaginator(ListBucketsRequest)
     */
    default ListBucketsIterable listBucketsPaginator() throws AwsServiceException, SdkClientException, S3Exception {
        return listBucketsPaginator(ListBucketsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBuckets(software.amazon.awssdk.services.s3.model.ListBucketsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuckets(software.amazon.awssdk.services.s3.model.ListBucketsRequest)} operation.</b>
     * </p>
     *
     * @param listBucketsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     */
    default ListBucketsIterable listBucketsPaginator(ListBucketsRequest listBucketsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return new ListBucketsIterable(this, listBucketsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listBuckets(software.amazon.awssdk.services.s3.model.ListBucketsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListBucketsIterable responses = client.listBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuckets(software.amazon.awssdk.services.s3.model.ListBucketsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBucketsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBucketsRequest#builder()}
     * </p>
     *
     * @param listBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListBucketsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     */
    default ListBucketsIterable listBucketsPaginator(Consumer<ListBucketsRequest.Builder> listBucketsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return listBucketsPaginator(ListBucketsRequest.builder().applyMutation(listBucketsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all Amazon S3 directory buckets owned by the authenticated sender of the request. For more
     * information about directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
     * buckets</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3express:ListAllMyDirectoryBuckets</code> permission in an IAM identity-based policy
     * instead of a bucket policy. Cross-account access to this API operation isn't supported. This operation can only
     * be performed by the Amazon Web Services account that owns the resource. For more information about directory
     * bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <note>
     * <p>
     * The <code>BucketRegion</code> response element is not part of the <code>ListDirectoryBuckets</code> Response
     * Syntax.
     * </p>
     * </note>
     *
     * @param listDirectoryBucketsRequest
     * @return Result of the ListDirectoryBuckets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListDirectoryBuckets
     */
    default ListDirectoryBucketsResponse listDirectoryBuckets(ListDirectoryBucketsRequest listDirectoryBucketsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all Amazon S3 directory buckets owned by the authenticated sender of the request. For more
     * information about directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
     * buckets</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3express:ListAllMyDirectoryBuckets</code> permission in an IAM identity-based policy
     * instead of a bucket policy. Cross-account access to this API operation isn't supported. This operation can only
     * be performed by the Amazon Web Services account that owns the resource. For more information about directory
     * bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <note>
     * <p>
     * The <code>BucketRegion</code> response element is not part of the <code>ListDirectoryBuckets</code> Response
     * Syntax.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDirectoryBucketsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDirectoryBucketsRequest#builder()}
     * </p>
     *
     * @param listDirectoryBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest.Builder} to create a request.
     * @return Result of the ListDirectoryBuckets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListDirectoryBuckets
     */
    default ListDirectoryBucketsResponse listDirectoryBuckets(
            Consumer<ListDirectoryBucketsRequest.Builder> listDirectoryBucketsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return listDirectoryBuckets(ListDirectoryBucketsRequest.builder().applyMutation(listDirectoryBucketsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDirectoryBuckets(software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListDirectoryBucketsIterable responses = client.listDirectoryBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListDirectoryBucketsIterable responses = client
     *             .listDirectoryBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListDirectoryBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListDirectoryBucketsIterable responses = client.listDirectoryBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxDirectoryBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDirectoryBuckets(software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDirectoryBucketsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListDirectoryBuckets
     */
    default ListDirectoryBucketsIterable listDirectoryBucketsPaginator(ListDirectoryBucketsRequest listDirectoryBucketsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return new ListDirectoryBucketsIterable(this, listDirectoryBucketsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDirectoryBuckets(software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListDirectoryBucketsIterable responses = client.listDirectoryBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListDirectoryBucketsIterable responses = client
     *             .listDirectoryBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListDirectoryBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListDirectoryBucketsIterable responses = client.listDirectoryBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxDirectoryBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDirectoryBuckets(software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDirectoryBucketsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDirectoryBucketsRequest#builder()}
     * </p>
     *
     * @param listDirectoryBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListDirectoryBuckets
     */
    default ListDirectoryBucketsIterable listDirectoryBucketsPaginator(
            Consumer<ListDirectoryBucketsRequest.Builder> listDirectoryBucketsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return listDirectoryBucketsPaginator(ListDirectoryBucketsRequest.builder().applyMutation(listDirectoryBucketsRequest)
                .build());
    }

    /**
     * <p>
     * This operation lists in-progress multipart uploads in a bucket. An in-progress multipart upload is a multipart
     * upload that has been initiated by the <code>CreateMultipartUpload</code> request, but has not yet been completed
     * or aborted.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - If multipart uploads in a directory bucket are in progress, you can't delete the
     * bucket until all the in-progress multipart uploads are aborted or completed. To delete these in-progress
     * multipart uploads, use the <code>ListMultipartUploads</code> operation to list the in-progress multipart uploads
     * in the bucket and use the <code>AbortMultipartUpload</code> operation to abort all the in-progress multipart
     * uploads.
     * </p>
     * </note>
     * <p>
     * The <code>ListMultipartUploads</code> operation returns a maximum of 1,000 multipart uploads in the response. The
     * limit of 1,000 multipart uploads is also the default value. You can further limit the number of uploads in a
     * response by specifying the <code>max-uploads</code> request parameter. If there are more than 1,000 multipart
     * uploads that satisfy your <code>ListMultipartUploads</code> request, the response returns an
     * <code>IsTruncated</code> element with the value of <code>true</code>, a <code>NextKeyMarker</code> element, and a
     * <code>NextUploadIdMarker</code> element. To list the remaining multipart uploads, you need to make subsequent
     * <code>ListMultipartUploads</code> requests. In these requests, include two query parameters:
     * <code>key-marker</code> and <code>upload-id-marker</code>. Set the value of <code>key-marker</code> to the
     * <code>NextKeyMarker</code> value from the previous response. Similarly, set the value of
     * <code>upload-id-marker</code> to the <code>NextUploadIdMarker</code> value from the previous response.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - The <code>upload-id-marker</code> element and the <code>NextUploadIdMarker</code>
     * element aren't supported by directory buckets. To list the additional multipart uploads, you only need to set the
     * value of <code>key-marker</code> to the <code>NextKeyMarker</code> value from the previous response.
     * </p>
     * </note>
     * <p>
     * For more information about multipart uploads, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart
     * Upload</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - For information about permissions required to use the multipart
     * upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload
     * and Permissions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Sorting of multipart uploads in response</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - In the <code>ListMultipartUploads</code> response, the multipart uploads are
     * sorted based on two criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key-based sorting - Multipart uploads are initially sorted in ascending order based on their object keys.
     * </p>
     * </li>
     * <li>
     * <p>
     * Time-based sorting - For uploads that share the same object key, they are further sorted in ascending order based
     * on the upload initiation time. Among uploads with the same key, the one that was initiated first will appear
     * before the ones that were initiated later.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - In the <code>ListMultipartUploads</code> response, the multipart uploads aren't sorted
     * lexicographically based on the object keys.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>ListMultipartUploads</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listMultipartUploadsRequest
     * @return Result of the ListMultipartUploads operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListMultipartUploads
     */
    default ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists in-progress multipart uploads in a bucket. An in-progress multipart upload is a multipart
     * upload that has been initiated by the <code>CreateMultipartUpload</code> request, but has not yet been completed
     * or aborted.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - If multipart uploads in a directory bucket are in progress, you can't delete the
     * bucket until all the in-progress multipart uploads are aborted or completed. To delete these in-progress
     * multipart uploads, use the <code>ListMultipartUploads</code> operation to list the in-progress multipart uploads
     * in the bucket and use the <code>AbortMultipartUpload</code> operation to abort all the in-progress multipart
     * uploads.
     * </p>
     * </note>
     * <p>
     * The <code>ListMultipartUploads</code> operation returns a maximum of 1,000 multipart uploads in the response. The
     * limit of 1,000 multipart uploads is also the default value. You can further limit the number of uploads in a
     * response by specifying the <code>max-uploads</code> request parameter. If there are more than 1,000 multipart
     * uploads that satisfy your <code>ListMultipartUploads</code> request, the response returns an
     * <code>IsTruncated</code> element with the value of <code>true</code>, a <code>NextKeyMarker</code> element, and a
     * <code>NextUploadIdMarker</code> element. To list the remaining multipart uploads, you need to make subsequent
     * <code>ListMultipartUploads</code> requests. In these requests, include two query parameters:
     * <code>key-marker</code> and <code>upload-id-marker</code>. Set the value of <code>key-marker</code> to the
     * <code>NextKeyMarker</code> value from the previous response. Similarly, set the value of
     * <code>upload-id-marker</code> to the <code>NextUploadIdMarker</code> value from the previous response.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - The <code>upload-id-marker</code> element and the <code>NextUploadIdMarker</code>
     * element aren't supported by directory buckets. To list the additional multipart uploads, you only need to set the
     * value of <code>key-marker</code> to the <code>NextKeyMarker</code> value from the previous response.
     * </p>
     * </note>
     * <p>
     * For more information about multipart uploads, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart
     * Upload</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - For information about permissions required to use the multipart
     * upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload
     * and Permissions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Sorting of multipart uploads in response</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - In the <code>ListMultipartUploads</code> response, the multipart uploads are
     * sorted based on two criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key-based sorting - Multipart uploads are initially sorted in ascending order based on their object keys.
     * </p>
     * </li>
     * <li>
     * <p>
     * Time-based sorting - For uploads that share the same object key, they are further sorted in ascending order based
     * on the upload initiation time. Among uploads with the same key, the one that was initiated first will appear
     * before the ones that were initiated later.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - In the <code>ListMultipartUploads</code> response, the multipart uploads aren't sorted
     * lexicographically based on the object keys.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>ListMultipartUploads</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultipartUploadsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultipartUploadsRequest#builder()}
     * </p>
     *
     * @param listMultipartUploadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest.Builder} to create a request.
     * @return Result of the ListMultipartUploads operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListMultipartUploads
     */
    default ListMultipartUploadsResponse listMultipartUploads(
            Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return listMultipartUploads(ListMultipartUploadsRequest.builder().applyMutation(listMultipartUploadsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultipartUploads(software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client.listMultipartUploadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client
     *             .listMultipartUploadsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client.listMultipartUploadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxUploads won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultipartUploads(software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultipartUploadsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListMultipartUploads
     */
    default ListMultipartUploadsIterable listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return new ListMultipartUploadsIterable(this, listMultipartUploadsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultipartUploads(software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client.listMultipartUploadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client
     *             .listMultipartUploadsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client.listMultipartUploadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxUploads won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultipartUploads(software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultipartUploadsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultipartUploadsRequest#builder()}
     * </p>
     *
     * @param listMultipartUploadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListMultipartUploads
     */
    default ListMultipartUploadsIterable listMultipartUploadsPaginator(
            Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return listMultipartUploadsPaginator(ListMultipartUploadsRequest.builder().applyMutation(listMultipartUploadsRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns metadata about all versions of the objects in a bucket. You can also use request parameters as selection
     * criteria to return metadata about a subset of all the object versions.
     * </p>
     * <important>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:ListBucketVersions</code> action. Be
     * aware of the name difference.
     * </p>
     * </important> <note>
     * <p>
     * A <code>200 OK</code> response can contain valid or invalid XML. Make sure to design your application to parse
     * the contents of the response and handle it appropriately.
     * </p>
     * </note>
     * <p>
     * To use this operation, you must have READ access to the bucket.
     * </p>
     * <p>
     * The following operations are related to <code>ListObjectVersions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listObjectVersionsRequest
     * @return Result of the ListObjectVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectVersions
     */
    default ListObjectVersionsResponse listObjectVersions(ListObjectVersionsRequest listObjectVersionsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns metadata about all versions of the objects in a bucket. You can also use request parameters as selection
     * criteria to return metadata about a subset of all the object versions.
     * </p>
     * <important>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:ListBucketVersions</code> action. Be
     * aware of the name difference.
     * </p>
     * </important> <note>
     * <p>
     * A <code>200 OK</code> response can contain valid or invalid XML. Make sure to design your application to parse
     * the contents of the response and handle it appropriately.
     * </p>
     * </note>
     * <p>
     * To use this operation, you must have READ access to the bucket.
     * </p>
     * <p>
     * The following operations are related to <code>ListObjectVersions</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectVersionsRequest#builder()}
     * </p>
     *
     * @param listObjectVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest.Builder} to create a request.
     * @return Result of the ListObjectVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectVersions
     */
    default ListObjectVersionsResponse listObjectVersions(Consumer<ListObjectVersionsRequest.Builder> listObjectVersionsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return listObjectVersions(ListObjectVersionsRequest.builder().applyMutation(listObjectVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listObjectVersions(software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client.listObjectVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client
     *             .listObjectVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client.listObjectVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxKeys won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectVersions(software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listObjectVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectVersions
     */
    default ListObjectVersionsIterable listObjectVersionsPaginator(ListObjectVersionsRequest listObjectVersionsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return new ListObjectVersionsIterable(this, listObjectVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listObjectVersions(software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client.listObjectVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client
     *             .listObjectVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client.listObjectVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxKeys won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectVersions(software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectVersionsRequest#builder()}
     * </p>
     *
     * @param listObjectVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectVersions
     */
    default ListObjectVersionsIterable listObjectVersionsPaginator(
            Consumer<ListObjectVersionsRequest.Builder> listObjectVersionsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return listObjectVersionsPaginator(ListObjectVersionsRequest.builder().applyMutation(listObjectVersionsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns some or all (up to 1,000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket. A 200 OK response can contain valid or invalid XML. Be
     * sure to design your application to parse the contents of the response and handle it appropriately.
     * </p>
     * <important>
     * <p>
     * This action has been revised. We recommend that you use the newer version, <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a>, when developing
     * applications. For backward compatibility, Amazon S3 continues to support <code>ListObjects</code>.
     * </p>
     * </important>
     * <p>
     * The following operations are related to <code>ListObjects</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listObjectsRequest
     * @return Result of the ListObjects operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjects
     */
    default ListObjectsResponse listObjects(ListObjectsRequest listObjectsRequest) throws NoSuchBucketException,
            AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns some or all (up to 1,000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket. A 200 OK response can contain valid or invalid XML. Be
     * sure to design your application to parse the contents of the response and handle it appropriately.
     * </p>
     * <important>
     * <p>
     * This action has been revised. We recommend that you use the newer version, <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a>, when developing
     * applications. For backward compatibility, Amazon S3 continues to support <code>ListObjects</code>.
     * </p>
     * </important>
     * <p>
     * The following operations are related to <code>ListObjects</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListObjectsRequest#builder()}
     * </p>
     *
     * @param listObjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListObjectsRequest.Builder} to create a request.
     * @return Result of the ListObjects operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjects
     */
    default ListObjectsResponse listObjects(Consumer<ListObjectsRequest.Builder> listObjectsRequest)
            throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        return listObjects(ListObjectsRequest.builder().applyMutation(listObjectsRequest).build());
    }

    /**
     * <p>
     * Returns some or all (up to 1,000) of the objects in a bucket with each request. You can use the request
     * parameters as selection criteria to return a subset of the objects in a bucket. A <code>200 OK</code> response
     * can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and
     * handle it appropriately. For more information about listing objects, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ListingKeysUsingAPIs.html">Listing object keys
     * programmatically</a> in the <i>Amazon S3 User Guide</i>. To get a list of your buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - For general purpose buckets, <code>ListObjectsV2</code> doesn't return prefixes
     * that are related only to in-progress multipart uploads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, <code>ListObjectsV2</code> response includes the prefixes that
     * are related only to in-progress multipart uploads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To use this operation, you must have READ access to the bucket. You
     * must have permission to perform the <code>s3:ListBucket</code> action. The bucket owner has this permission by
     * default and can grant this permission to others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Sorting order of returned objects</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - For general purpose buckets, <code>ListObjectsV2</code> returns objects in
     * lexicographical order based on their key names.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - For directory buckets, <code>ListObjectsV2</code> does not return objects in
     * lexicographical order.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <important>
     * <p>
     * This section describes the latest revision of this action. We recommend that you use this revised API operation
     * for application development. For backward compatibility, Amazon S3 continues to support the prior version of this
     * API operation, <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a>.
     * </p>
     * </important>
     * <p>
     * The following operations are related to <code>ListObjectsV2</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listObjectsV2Request
     * @return Result of the ListObjectsV2 operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectsV2
     */
    default ListObjectsV2Response listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws NoSuchBucketException,
            AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns some or all (up to 1,000) of the objects in a bucket with each request. You can use the request
     * parameters as selection criteria to return a subset of the objects in a bucket. A <code>200 OK</code> response
     * can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and
     * handle it appropriately. For more information about listing objects, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ListingKeysUsingAPIs.html">Listing object keys
     * programmatically</a> in the <i>Amazon S3 User Guide</i>. To get a list of your buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - For general purpose buckets, <code>ListObjectsV2</code> doesn't return prefixes
     * that are related only to in-progress multipart uploads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, <code>ListObjectsV2</code> response includes the prefixes that
     * are related only to in-progress multipart uploads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - To use this operation, you must have READ access to the bucket. You
     * must have permission to perform the <code>s3:ListBucket</code> action. The bucket owner has this permission by
     * default and can grant this permission to others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Sorting order of returned objects</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - For general purpose buckets, <code>ListObjectsV2</code> returns objects in
     * lexicographical order based on their key names.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - For directory buckets, <code>ListObjectsV2</code> does not return objects in
     * lexicographical order.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <important>
     * <p>
     * This section describes the latest revision of this action. We recommend that you use this revised API operation
     * for application development. For backward compatibility, Amazon S3 continues to support the prior version of this
     * API operation, <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a>.
     * </p>
     * </important>
     * <p>
     * The following operations are related to <code>ListObjectsV2</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectsV2Request.Builder} avoiding the need to
     * create one manually via {@link ListObjectsV2Request#builder()}
     * </p>
     *
     * @param listObjectsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListObjectsV2Request.Builder} to create a request.
     * @return Result of the ListObjectsV2 operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectsV2
     */
    default ListObjectsV2Response listObjectsV2(Consumer<ListObjectsV2Request.Builder> listObjectsV2Request)
            throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        return listObjectsV2(ListObjectsV2Request.builder().applyMutation(listObjectsV2Request).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listObjectsV2(software.amazon.awssdk.services.s3.model.ListObjectsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListObjectsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxKeys won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectsV2(software.amazon.awssdk.services.s3.model.ListObjectsV2Request)} operation.</b>
     * </p>
     *
     * @param listObjectsV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectsV2
     */
    default ListObjectsV2Iterable listObjectsV2Paginator(ListObjectsV2Request listObjectsV2Request) throws NoSuchBucketException,
            AwsServiceException, SdkClientException, S3Exception {
        return new ListObjectsV2Iterable(this, listObjectsV2Request);
    }

    /**
     * <p>
     * This is a variant of {@link #listObjectsV2(software.amazon.awssdk.services.s3.model.ListObjectsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListObjectsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxKeys won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectsV2(software.amazon.awssdk.services.s3.model.ListObjectsV2Request)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectsV2Request.Builder} avoiding the need to
     * create one manually via {@link ListObjectsV2Request#builder()}
     * </p>
     *
     * @param listObjectsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListObjectsV2Request.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectsV2
     */
    default ListObjectsV2Iterable listObjectsV2Paginator(Consumer<ListObjectsV2Request.Builder> listObjectsV2Request)
            throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        return listObjectsV2Paginator(ListObjectsV2Request.builder().applyMutation(listObjectsV2Request).build());
    }

    /**
     * <p>
     * Lists the parts that have been uploaded for a specific multipart upload.
     * </p>
     * <p>
     * To use this operation, you must provide the <code>upload ID</code> in the request. You obtain this uploadID by
     * sending the initiate multipart upload request through <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>.
     * </p>
     * <p>
     * The <code>ListParts</code> request returns a maximum of 1,000 uploaded parts. The limit of 1,000 parts is also
     * the default value. You can restrict the number of parts in a response by specifying the <code>max-parts</code>
     * request parameter. If your multipart upload consists of more than 1,000 parts, the response returns an
     * <code>IsTruncated</code> field with the value of <code>true</code>, and a <code>NextPartNumberMarker</code>
     * element. To list remaining uploaded parts, in subsequent <code>ListParts</code> requests, include the
     * <code>part-number-marker</code> query string parameter and set its value to the <code>NextPartNumberMarker</code>
     * field value from the previous response.
     * </p>
     * <p>
     * For more information on multipart uploads, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart
     * Upload</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - For information about permissions required to use the multipart
     * upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload
     * and Permissions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If the upload was created using server-side encryption with Key Management Service (KMS) keys (SSE-KMS) or
     * dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), you must have permission to the
     * <code>kms:Decrypt</code> action for the <code>ListParts</code> request to succeed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>ListParts</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listPartsRequest
     * @return Result of the ListParts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListParts
     */
    default ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws AwsServiceException, SdkClientException,
            S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the parts that have been uploaded for a specific multipart upload.
     * </p>
     * <p>
     * To use this operation, you must provide the <code>upload ID</code> in the request. You obtain this uploadID by
     * sending the initiate multipart upload request through <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>.
     * </p>
     * <p>
     * The <code>ListParts</code> request returns a maximum of 1,000 uploaded parts. The limit of 1,000 parts is also
     * the default value. You can restrict the number of parts in a response by specifying the <code>max-parts</code>
     * request parameter. If your multipart upload consists of more than 1,000 parts, the response returns an
     * <code>IsTruncated</code> field with the value of <code>true</code>, and a <code>NextPartNumberMarker</code>
     * element. To list remaining uploaded parts, in subsequent <code>ListParts</code> requests, include the
     * <code>part-number-marker</code> query string parameter and set its value to the <code>NextPartNumberMarker</code>
     * field value from the previous response.
     * </p>
     * <p>
     * For more information on multipart uploads, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart
     * Upload</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - For information about permissions required to use the multipart
     * upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload
     * and Permissions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If the upload was created using server-side encryption with Key Management Service (KMS) keys (SSE-KMS) or
     * dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), you must have permission to the
     * <code>kms:Decrypt</code> action for the <code>ListParts</code> request to succeed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>ListParts</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html">GetObjectAttributes</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPartsRequest#builder()}
     * </p>
     *
     * @param listPartsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListPartsRequest.Builder} to create a request.
     * @return Result of the ListParts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListParts
     */
    default ListPartsResponse listParts(Consumer<ListPartsRequest.Builder> listPartsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return listParts(ListPartsRequest.builder().applyMutation(listPartsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listParts(software.amazon.awssdk.services.s3.model.ListPartsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListPartsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxParts won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParts(software.amazon.awssdk.services.s3.model.ListPartsRequest)} operation.</b>
     * </p>
     *
     * @param listPartsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListParts
     */
    default ListPartsIterable listPartsPaginator(ListPartsRequest listPartsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return new ListPartsIterable(this, listPartsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listParts(software.amazon.awssdk.services.s3.model.ListPartsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListPartsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxParts won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParts(software.amazon.awssdk.services.s3.model.ListPartsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPartsRequest#builder()}
     * </p>
     *
     * @param listPartsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.ListPartsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListParts
     */
    default ListPartsIterable listPartsPaginator(Consumer<ListPartsRequest.Builder> listPartsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return listPartsPaginator(ListPartsRequest.builder().applyMutation(listPartsRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the accelerate configuration of an existing bucket. Amazon S3 Transfer Acceleration is a bucket-level
     * feature that enables you to perform faster data transfers to Amazon S3.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:PutAccelerateConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * The Transfer Acceleration state of a bucket can be set to one of the following two values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enabled – Enables accelerated data transfers to the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * Suspended – Disables accelerated data transfers to the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html">
     * GetBucketAccelerateConfiguration</a> action returns the transfer acceleration state of a bucket.
     * </p>
     * <p>
     * After setting the Transfer Acceleration state of a bucket to Enabled, it might take up to thirty minutes before
     * the data transfer rates to the bucket increase.
     * </p>
     * <p>
     * The name of the bucket used for Transfer Acceleration must be DNS-compliant and must not contain periods (".").
     * </p>
     * <p>
     * For more information about transfer acceleration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketAccelerateConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html">
     * GetBucketAccelerateConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketAccelerateConfigurationRequest
     * @return Result of the PutBucketAccelerateConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAccelerateConfiguration
     */
    default PutBucketAccelerateConfigurationResponse putBucketAccelerateConfiguration(
            PutBucketAccelerateConfigurationRequest putBucketAccelerateConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the accelerate configuration of an existing bucket. Amazon S3 Transfer Acceleration is a bucket-level
     * feature that enables you to perform faster data transfers to Amazon S3.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:PutAccelerateConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * The Transfer Acceleration state of a bucket can be set to one of the following two values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enabled – Enables accelerated data transfers to the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * Suspended – Disables accelerated data transfers to the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html">
     * GetBucketAccelerateConfiguration</a> action returns the transfer acceleration state of a bucket.
     * </p>
     * <p>
     * After setting the Transfer Acceleration state of a bucket to Enabled, it might take up to thirty minutes before
     * the data transfer rates to the bucket increase.
     * </p>
     * <p>
     * The name of the bucket used for Transfer Acceleration must be DNS-compliant and must not contain periods (".").
     * </p>
     * <p>
     * For more information about transfer acceleration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketAccelerateConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html">
     * GetBucketAccelerateConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketAccelerateConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBucketAccelerateConfigurationRequest#builder()}
     * </p>
     *
     * @param putBucketAccelerateConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the PutBucketAccelerateConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAccelerateConfiguration
     */
    default PutBucketAccelerateConfigurationResponse putBucketAccelerateConfiguration(
            Consumer<PutBucketAccelerateConfigurationRequest.Builder> putBucketAccelerateConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketAccelerateConfiguration(PutBucketAccelerateConfigurationRequest.builder()
                .applyMutation(putBucketAccelerateConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the permissions on an existing bucket using access control lists (ACL). For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. To set the ACL of a
     * bucket, you must have the <code>WRITE_ACP</code> permission.
     * </p>
     * <p>
     * You can use one of the following two ways to set a bucket's permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the ACL in the request body
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify permissions using request headers
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You cannot specify access permission using both the body and the request headers.
     * </p>
     * </note>
     * <p>
     * Depending on your application needs, you may choose to set the ACL on a bucket using either the request body or
     * the headers. For example, if you have an existing application that updates a bucket ACL using the request body,
     * then you can continue to use that approach.
     * </p>
     * <important>
     * <p>
     * If your bucket uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer
     * affect permissions. You must use policies to grant access to your bucket and the objects in it. Requests to set
     * ACLs or update ACLs fail and return the <code>AccessControlListNotSupported</code> error code. Requests to read
     * ACLs are still supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling object
     * ownership</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You can set access permissions by using one of the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify a canned ACL with the <code>x-amz-acl</code> request header. Amazon S3 supports a set of predefined ACLs,
     * known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. Specify the canned
     * ACL name as the value of <code>x-amz-acl</code>. If you use this header, you cannot use other access
     * control-specific headers in your request. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify access permissions explicitly with the <code>x-amz-grant-read</code>, <code>x-amz-grant-read-acp</code>,
     * <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. When using these headers,
     * you specify explicit access permissions and grantees (Amazon Web Services accounts or Amazon S3 groups) who will
     * receive the permission. If you use these ACL-specific headers, you cannot use the <code>x-amz-acl</code> header
     * to set a canned ACL. These parameters map to the set of permissions that Amazon S3 supports in an ACL. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List
     * (ACL) Overview</a>.
     * </p>
     * <p>
     * You specify each grantee as a type=value pair, where the type is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>uri</code> – if you are granting permissions to a predefined group
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account
     * </p>
     * <note>
     * <p>
     * Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * US East (N. Virginia)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (N. California)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (Oregon)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Singapore)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Sydney)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Tokyo)
     * </p>
     * </li>
     * <li>
     * <p>
     * Europe (Ireland)
     * </p>
     * </li>
     * <li>
     * <p>
     * South America (São Paulo)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of all the Amazon S3 supported Regions and endpoints, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon
     * Web Services General Reference.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * For example, the following <code>x-amz-grant-write</code> header grants create, overwrite, and delete objects
     * permission to LogDelivery group predefined by Amazon S3 and two Amazon Web Services accounts identified by their
     * email addresses.
     * </p>
     * <p>
     * <code>x-amz-grant-write: uri="http://acs.amazonaws.com/groups/s3/LogDelivery", id="111122223333", id="555566667777" </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can use either a canned ACL or specify access permissions explicitly. You cannot do both.
     * </p>
     * </dd>
     * <dt>Grantee Values</dt>
     * <dd>
     * <p>
     * You can specify the person (grantee) to whom you're assigning access rights (using request elements) in the
     * following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * By the person's ID:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"&gt;&lt;ID&gt;&lt;&gt;ID&lt;&gt;&lt;/ID&gt;&lt;DisplayName&gt;&lt;&gt;GranteesEmail&lt;&gt;&lt;/DisplayName&gt; &lt;/Grantee&gt;</code>
     * </p>
     * <p>
     * DisplayName is optional and ignored in the request
     * </p>
     * </li>
     * <li>
     * <p>
     * By URI:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"&gt;&lt;URI&gt;&lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;&lt;/URI&gt;&lt;/Grantee&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * By Email address:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"&gt;&lt;EmailAddress&gt;&lt;&gt;Grantees@email.com&lt;&gt;&lt;/EmailAddress&gt;&amp;&lt;/Grantee&gt;</code>
     * </p>
     * <p>
     * The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the
     * CanonicalUser.
     * </p>
     * <note>
     * <p>
     * Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * US East (N. Virginia)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (N. California)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (Oregon)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Singapore)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Sydney)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Tokyo)
     * </p>
     * </li>
     * <li>
     * <p>
     * Europe (Ireland)
     * </p>
     * </li>
     * <li>
     * <p>
     * South America (São Paulo)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of all the Amazon S3 supported Regions and endpoints, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon
     * Web Services General Reference.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketAcl</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketAclRequest
     * @return Result of the PutBucketAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAcl
     */
    default PutBucketAclResponse putBucketAcl(PutBucketAclRequest putBucketAclRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the permissions on an existing bucket using access control lists (ACL). For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. To set the ACL of a
     * bucket, you must have the <code>WRITE_ACP</code> permission.
     * </p>
     * <p>
     * You can use one of the following two ways to set a bucket's permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the ACL in the request body
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify permissions using request headers
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You cannot specify access permission using both the body and the request headers.
     * </p>
     * </note>
     * <p>
     * Depending on your application needs, you may choose to set the ACL on a bucket using either the request body or
     * the headers. For example, if you have an existing application that updates a bucket ACL using the request body,
     * then you can continue to use that approach.
     * </p>
     * <important>
     * <p>
     * If your bucket uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer
     * affect permissions. You must use policies to grant access to your bucket and the objects in it. Requests to set
     * ACLs or update ACLs fail and return the <code>AccessControlListNotSupported</code> error code. Requests to read
     * ACLs are still supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling object
     * ownership</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You can set access permissions by using one of the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify a canned ACL with the <code>x-amz-acl</code> request header. Amazon S3 supports a set of predefined ACLs,
     * known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. Specify the canned
     * ACL name as the value of <code>x-amz-acl</code>. If you use this header, you cannot use other access
     * control-specific headers in your request. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify access permissions explicitly with the <code>x-amz-grant-read</code>, <code>x-amz-grant-read-acp</code>,
     * <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. When using these headers,
     * you specify explicit access permissions and grantees (Amazon Web Services accounts or Amazon S3 groups) who will
     * receive the permission. If you use these ACL-specific headers, you cannot use the <code>x-amz-acl</code> header
     * to set a canned ACL. These parameters map to the set of permissions that Amazon S3 supports in an ACL. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List
     * (ACL) Overview</a>.
     * </p>
     * <p>
     * You specify each grantee as a type=value pair, where the type is one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>uri</code> – if you are granting permissions to a predefined group
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account
     * </p>
     * <note>
     * <p>
     * Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * US East (N. Virginia)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (N. California)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (Oregon)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Singapore)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Sydney)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Tokyo)
     * </p>
     * </li>
     * <li>
     * <p>
     * Europe (Ireland)
     * </p>
     * </li>
     * <li>
     * <p>
     * South America (São Paulo)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of all the Amazon S3 supported Regions and endpoints, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon
     * Web Services General Reference.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * For example, the following <code>x-amz-grant-write</code> header grants create, overwrite, and delete objects
     * permission to LogDelivery group predefined by Amazon S3 and two Amazon Web Services accounts identified by their
     * email addresses.
     * </p>
     * <p>
     * <code>x-amz-grant-write: uri="http://acs.amazonaws.com/groups/s3/LogDelivery", id="111122223333", id="555566667777" </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can use either a canned ACL or specify access permissions explicitly. You cannot do both.
     * </p>
     * </dd>
     * <dt>Grantee Values</dt>
     * <dd>
     * <p>
     * You can specify the person (grantee) to whom you're assigning access rights (using request elements) in the
     * following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * By the person's ID:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"&gt;&lt;ID&gt;&lt;&gt;ID&lt;&gt;&lt;/ID&gt;&lt;DisplayName&gt;&lt;&gt;GranteesEmail&lt;&gt;&lt;/DisplayName&gt; &lt;/Grantee&gt;</code>
     * </p>
     * <p>
     * DisplayName is optional and ignored in the request
     * </p>
     * </li>
     * <li>
     * <p>
     * By URI:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"&gt;&lt;URI&gt;&lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;&lt;/URI&gt;&lt;/Grantee&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * By Email address:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"&gt;&lt;EmailAddress&gt;&lt;&gt;Grantees@email.com&lt;&gt;&lt;/EmailAddress&gt;&amp;&lt;/Grantee&gt;</code>
     * </p>
     * <p>
     * The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the
     * CanonicalUser.
     * </p>
     * <note>
     * <p>
     * Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * US East (N. Virginia)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (N. California)
     * </p>
     * </li>
     * <li>
     * <p>
     * US West (Oregon)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Singapore)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Sydney)
     * </p>
     * </li>
     * <li>
     * <p>
     * Asia Pacific (Tokyo)
     * </p>
     * </li>
     * <li>
     * <p>
     * Europe (Ireland)
     * </p>
     * </li>
     * <li>
     * <p>
     * South America (São Paulo)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of all the Amazon S3 supported Regions and endpoints, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon
     * Web Services General Reference.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketAcl</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketAclRequest.Builder} avoiding the need to
     * create one manually via {@link PutBucketAclRequest#builder()}
     * </p>
     *
     * @param putBucketAclRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketAclRequest.Builder} to create a request.
     * @return Result of the PutBucketAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAcl
     */
    default PutBucketAclResponse putBucketAcl(Consumer<PutBucketAclRequest.Builder> putBucketAclRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketAcl(PutBucketAclRequest.builder().applyMutation(putBucketAclRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets an analytics configuration for the bucket (specified by the analytics configuration ID). You can have up to
     * 1,000 analytics configurations per bucket.
     * </p>
     * <p>
     * You can choose to have storage class analysis export analysis reports sent to a comma-separated values (CSV) flat
     * file. See the <code>DataExport</code> request element. Reports are updated daily and are based on the object
     * filters that you configure. When selecting data export, you specify a destination bucket and an optional
     * destination prefix where the file is written. You can export the data to a destination bucket in a different
     * account. However, the destination bucket must be in the same Region as the bucket that you are making the PUT
     * analytics configuration to. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage
     * Class Analysis</a>.
     * </p>
     * <important>
     * <p>
     * You must create a bucket policy on the destination bucket where the exported file is written to grant permissions
     * to Amazon S3 to write objects to the bucket. For an example policy, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9"
     * >Granting Permissions for Amazon S3 Inventory and Storage Class Analysis</a>.
     * </p>
     * </important>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutAnalyticsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * <code>PutBucketAnalyticsConfiguration</code> has the following special errors:
     * </p>
     * <ul>
     * <li>
     * <ul>
     * <li>
     * <p>
     * <i>HTTP Error: HTTP 400 Bad Request</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Code: InvalidArgument</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Cause: Invalid argument.</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <ul>
     * <li>
     * <p>
     * <i>HTTP Error: HTTP 400 Bad Request</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Code: TooManyConfigurations</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Cause: You are attempting to create a new configuration but have already reached the 1,000-configuration
     * limit.</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <ul>
     * <li>
     * <p>
     * <i>HTTP Error: HTTP 403 Forbidden</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Code: AccessDenied</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Cause: You are not the owner of the specified bucket, or you do not have the s3:PutAnalyticsConfiguration
     * bucket permission to set the configuration on the bucket.</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following operations are related to <code>PutBucketAnalyticsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">
     * GetBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">
     * DeleteBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">
     * ListBucketAnalyticsConfigurations</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketAnalyticsConfigurationRequest
     * @return Result of the PutBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAnalyticsConfiguration
     */
    default PutBucketAnalyticsConfigurationResponse putBucketAnalyticsConfiguration(
            PutBucketAnalyticsConfigurationRequest putBucketAnalyticsConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets an analytics configuration for the bucket (specified by the analytics configuration ID). You can have up to
     * 1,000 analytics configurations per bucket.
     * </p>
     * <p>
     * You can choose to have storage class analysis export analysis reports sent to a comma-separated values (CSV) flat
     * file. See the <code>DataExport</code> request element. Reports are updated daily and are based on the object
     * filters that you configure. When selecting data export, you specify a destination bucket and an optional
     * destination prefix where the file is written. You can export the data to a destination bucket in a different
     * account. However, the destination bucket must be in the same Region as the bucket that you are making the PUT
     * analytics configuration to. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage
     * Class Analysis</a>.
     * </p>
     * <important>
     * <p>
     * You must create a bucket policy on the destination bucket where the exported file is written to grant permissions
     * to Amazon S3 to write objects to the bucket. For an example policy, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9"
     * >Granting Permissions for Amazon S3 Inventory and Storage Class Analysis</a>.
     * </p>
     * </important>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutAnalyticsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * <code>PutBucketAnalyticsConfiguration</code> has the following special errors:
     * </p>
     * <ul>
     * <li>
     * <ul>
     * <li>
     * <p>
     * <i>HTTP Error: HTTP 400 Bad Request</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Code: InvalidArgument</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Cause: Invalid argument.</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <ul>
     * <li>
     * <p>
     * <i>HTTP Error: HTTP 400 Bad Request</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Code: TooManyConfigurations</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Cause: You are attempting to create a new configuration but have already reached the 1,000-configuration
     * limit.</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <ul>
     * <li>
     * <p>
     * <i>HTTP Error: HTTP 403 Forbidden</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Code: AccessDenied</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Cause: You are not the owner of the specified bucket, or you do not have the s3:PutAnalyticsConfiguration
     * bucket permission to set the configuration on the bucket.</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following operations are related to <code>PutBucketAnalyticsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">
     * GetBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">
     * DeleteBucketAnalyticsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">
     * ListBucketAnalyticsConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketAnalyticsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBucketAnalyticsConfigurationRequest#builder()}
     * </p>
     *
     * @param putBucketAnalyticsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the PutBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAnalyticsConfiguration
     */
    default PutBucketAnalyticsConfigurationResponse putBucketAnalyticsConfiguration(
            Consumer<PutBucketAnalyticsConfigurationRequest.Builder> putBucketAnalyticsConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketAnalyticsConfiguration(PutBucketAnalyticsConfigurationRequest.builder()
                .applyMutation(putBucketAnalyticsConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the <code>cors</code> configuration for your bucket. If the configuration exists, Amazon S3 replaces it.
     * </p>
     * <p>
     * To use this operation, you must be allowed to perform the <code>s3:PutBucketCORS</code> action. By default, the
     * bucket owner has this permission and can grant it to others.
     * </p>
     * <p>
     * You set this configuration on a bucket so that the bucket can service cross-origin requests. For example, you
     * might want to enable a request whose origin is <code>http://www.example.com</code> to access your Amazon S3
     * bucket at <code>my.example.bucket.com</code> by using the browser's <code>XMLHttpRequest</code> capability.
     * </p>
     * <p>
     * To enable cross-origin resource sharing (CORS) on a bucket, you add the <code>cors</code> subresource to the
     * bucket. The <code>cors</code> subresource is an XML document in which you configure rules that identify origins
     * and the HTTP methods that can be executed on your bucket. The document is limited to 64 KB in size.
     * </p>
     * <p>
     * When Amazon S3 receives a cross-origin request (or a pre-flight OPTIONS request) against a bucket, it evaluates
     * the <code>cors</code> configuration on the bucket and uses the first <code>CORSRule</code> rule that matches the
     * incoming browser request to enable a cross-origin request. For a rule to match, the following conditions must be
     * met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The request's <code>Origin</code> header must match <code>AllowedOrigin</code> elements.
     * </p>
     * </li>
     * <li>
     * <p>
     * The request method (for example, GET, PUT, HEAD, and so on) or the <code>Access-Control-Request-Method</code>
     * header in case of a pre-flight <code>OPTIONS</code> request must be one of the <code>AllowedMethod</code>
     * elements.
     * </p>
     * </li>
     * <li>
     * <p>
     * Every header specified in the <code>Access-Control-Request-Headers</code> request header of a pre-flight request
     * must match an <code>AllowedHeader</code> element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CORS, go to <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketCors</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html">GetBucketCors</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html">DeleteBucketCors</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html">RESTOPTIONSobject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketCorsRequest
     * @return Result of the PutBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketCors
     */
    default PutBucketCorsResponse putBucketCors(PutBucketCorsRequest putBucketCorsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the <code>cors</code> configuration for your bucket. If the configuration exists, Amazon S3 replaces it.
     * </p>
     * <p>
     * To use this operation, you must be allowed to perform the <code>s3:PutBucketCORS</code> action. By default, the
     * bucket owner has this permission and can grant it to others.
     * </p>
     * <p>
     * You set this configuration on a bucket so that the bucket can service cross-origin requests. For example, you
     * might want to enable a request whose origin is <code>http://www.example.com</code> to access your Amazon S3
     * bucket at <code>my.example.bucket.com</code> by using the browser's <code>XMLHttpRequest</code> capability.
     * </p>
     * <p>
     * To enable cross-origin resource sharing (CORS) on a bucket, you add the <code>cors</code> subresource to the
     * bucket. The <code>cors</code> subresource is an XML document in which you configure rules that identify origins
     * and the HTTP methods that can be executed on your bucket. The document is limited to 64 KB in size.
     * </p>
     * <p>
     * When Amazon S3 receives a cross-origin request (or a pre-flight OPTIONS request) against a bucket, it evaluates
     * the <code>cors</code> configuration on the bucket and uses the first <code>CORSRule</code> rule that matches the
     * incoming browser request to enable a cross-origin request. For a rule to match, the following conditions must be
     * met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The request's <code>Origin</code> header must match <code>AllowedOrigin</code> elements.
     * </p>
     * </li>
     * <li>
     * <p>
     * The request method (for example, GET, PUT, HEAD, and so on) or the <code>Access-Control-Request-Method</code>
     * header in case of a pre-flight <code>OPTIONS</code> request must be one of the <code>AllowedMethod</code>
     * elements.
     * </p>
     * </li>
     * <li>
     * <p>
     * Every header specified in the <code>Access-Control-Request-Headers</code> request header of a pre-flight request
     * must match an <code>AllowedHeader</code> element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CORS, go to <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketCors</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html">GetBucketCors</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html">DeleteBucketCors</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html">RESTOPTIONSobject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketCorsRequest.Builder} avoiding the need to
     * create one manually via {@link PutBucketCorsRequest#builder()}
     * </p>
     *
     * @param putBucketCorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketCorsRequest.Builder} to create a request.
     * @return Result of the PutBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketCors
     */
    default PutBucketCorsResponse putBucketCors(Consumer<PutBucketCorsRequest.Builder> putBucketCorsRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketCors(PutBucketCorsRequest.builder().applyMutation(putBucketCorsRequest).build());
    }

    /**
     * <p>
     * This operation configures default encryption and Amazon S3 Bucket Keys for an existing bucket.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <p>
     * By default, all buckets have a default encryption configuration that uses server-side encryption with Amazon S3
     * managed keys (SSE-S3).
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can optionally configure default encryption for a bucket by using server-side encryption with Key Management
     * Service (KMS) keys (SSE-KMS) or dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS).
     * If you specify default encryption by using SSE-KMS, you can also configure <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a>. For information
     * about the bucket default encryption feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Bucket Default
     * Encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use PutBucketEncryption to set your <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">default bucket encryption</a> to
     * SSE-KMS, you should verify that your KMS key ID is correct. Amazon S3 doesn't validate the KMS key ID provided in
     * PutBucketEncryption requests.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - You can optionally configure default encryption for a bucket by using server-side
     * encryption with Key Management Service (KMS) keys (SSE-KMS).
     * </p>
     * <ul>
     * <li>
     * <p>
     * We recommend that the bucket's default encryption uses the desired encryption configuration and you don't
     * override the bucket default encryption in your <code>CreateSession</code> requests or <code>PUT</code> object
     * requests. Then, new objects are automatically encrypted with the desired encryption settings. For more
     * information about the encryption overriding behaviors in directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-specifying-kms-encryption.html">Specifying
     * server-side encryption with KMS for new object uploads</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your SSE-KMS configuration can only support 1 <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a>
     * per directory bucket for the lifetime of the bucket. The <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services
     * managed key</a> (<code>aws/s3</code>) isn't supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3 Bucket Keys are always enabled for <code>GET</code> and <code>PUT</code> operations in a directory bucket and
     * can’t be disabled. S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose
     * buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets,
     * through <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>, <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>, <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops">the Copy
     * operation in Batch Operations</a>, or <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-import-job">the import jobs</a>. In this case,
     * Amazon S3 makes a call to KMS every time a copy request is made for a KMS-encrypted object.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you specify an <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">KMS customer managed
     * key</a> for encryption in your directory bucket, only use the key ID or key ARN. The key alias format of the KMS
     * key isn't supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * For directory buckets, if you use PutBucketEncryption to set your <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">default bucket encryption</a> to
     * SSE-KMS, Amazon S3 validates the KMS key ID provided in PutBucketEncryption requests.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note> <important>
     * <p>
     * If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a
     * KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data
     * that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
     * </p>
     * <p>
     * Also, this action requires Amazon Web Services Signature Version 4. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html"> Authenticating
     * Requests (Amazon Web Services Signature Version 4)</a>.
     * </p>
     * </important>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:PutEncryptionConfiguration</code> permission is required
     * in a policy. The bucket owner has this permission by default. The bucket owner can grant this permission to
     * others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:PutEncryptionConfiguration</code> permission in an IAM identity-based policy instead of a bucket
     * policy. Cross-account access to this API operation isn't supported. This operation can only be performed by the
     * Amazon Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To set a directory bucket default encryption with SSE-KMS, you must also have the
     * <code>kms:GenerateDataKey</code> and the <code>kms:Decrypt</code> permissions in IAM identity-based policies and
     * KMS key policies for the target KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketEncryption</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html">GetBucketEncryption</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html">DeleteBucketEncryption</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketEncryptionRequest
     * @return Result of the PutBucketEncryption operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketEncryption
     */
    default PutBucketEncryptionResponse putBucketEncryption(PutBucketEncryptionRequest putBucketEncryptionRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation configures default encryption and Amazon S3 Bucket Keys for an existing bucket.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <p>
     * By default, all buckets have a default encryption configuration that uses server-side encryption with Amazon S3
     * managed keys (SSE-S3).
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose buckets</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can optionally configure default encryption for a bucket by using server-side encryption with Key Management
     * Service (KMS) keys (SSE-KMS) or dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS).
     * If you specify default encryption by using SSE-KMS, you can also configure <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a>. For information
     * about the bucket default encryption feature, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Bucket Default
     * Encryption</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use PutBucketEncryption to set your <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">default bucket encryption</a> to
     * SSE-KMS, you should verify that your KMS key ID is correct. Amazon S3 doesn't validate the KMS key ID provided in
     * PutBucketEncryption requests.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets </b> - You can optionally configure default encryption for a bucket by using server-side
     * encryption with Key Management Service (KMS) keys (SSE-KMS).
     * </p>
     * <ul>
     * <li>
     * <p>
     * We recommend that the bucket's default encryption uses the desired encryption configuration and you don't
     * override the bucket default encryption in your <code>CreateSession</code> requests or <code>PUT</code> object
     * requests. Then, new objects are automatically encrypted with the desired encryption settings. For more
     * information about the encryption overriding behaviors in directory buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-specifying-kms-encryption.html">Specifying
     * server-side encryption with KMS for new object uploads</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your SSE-KMS configuration can only support 1 <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a>
     * per directory bucket for the lifetime of the bucket. The <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services
     * managed key</a> (<code>aws/s3</code>) isn't supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3 Bucket Keys are always enabled for <code>GET</code> and <code>PUT</code> operations in a directory bucket and
     * can’t be disabled. S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose
     * buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets,
     * through <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>, <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a>, <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops">the Copy
     * operation in Batch Operations</a>, or <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-import-job">the import jobs</a>. In this case,
     * Amazon S3 makes a call to KMS every time a copy request is made for a KMS-encrypted object.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you specify an <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">KMS customer managed
     * key</a> for encryption in your directory bucket, only use the key ID or key ARN. The key alias format of the KMS
     * key isn't supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * For directory buckets, if you use PutBucketEncryption to set your <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">default bucket encryption</a> to
     * SSE-KMS, Amazon S3 validates the KMS key ID provided in PutBucketEncryption requests.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note> <important>
     * <p>
     * If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a
     * KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data
     * that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
     * </p>
     * <p>
     * Also, this action requires Amazon Web Services Signature Version 4. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html"> Authenticating
     * Requests (Amazon Web Services Signature Version 4)</a>.
     * </p>
     * </important>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:PutEncryptionConfiguration</code> permission is required
     * in a policy. The bucket owner has this permission by default. The bucket owner can grant this permission to
     * others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:PutEncryptionConfiguration</code> permission in an IAM identity-based policy instead of a bucket
     * policy. Cross-account access to this API operation isn't supported. This operation can only be performed by the
     * Amazon Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To set a directory bucket default encryption with SSE-KMS, you must also have the
     * <code>kms:GenerateDataKey</code> and the <code>kms:Decrypt</code> permissions in IAM identity-based policies and
     * KMS key policies for the target KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketEncryption</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html">GetBucketEncryption</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html">DeleteBucketEncryption</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketEncryptionRequest.Builder} avoiding the
     * need to create one manually via {@link PutBucketEncryptionRequest#builder()}
     * </p>
     *
     * @param putBucketEncryptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest.Builder} to create a request.
     * @return Result of the PutBucketEncryption operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketEncryption
     */
    default PutBucketEncryptionResponse putBucketEncryption(
            Consumer<PutBucketEncryptionRequest.Builder> putBucketEncryptionRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return putBucketEncryption(PutBucketEncryptionRequest.builder().applyMutation(putBucketEncryptionRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Puts a S3 Intelligent-Tiering configuration to the specified bucket. You can have up to 1,000 S3
     * Intelligent-Tiering configurations per bucket.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to
     * the most cost-effective storage access tier, without performance impact or operational overhead. S3
     * Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get
     * the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional
     * archiving capabilities.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or
     * unpredictable access patterns, independent of object size or retention period. If the size of an object is less
     * than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are
     * always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage
     * class for automatically optimizing frequently and infrequently accessed objects</a>.
     * </p>
     * <p>
     * Operations related to <code>PutBucketIntelligentTieringConfiguration</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">
     * DeleteBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">
     * GetBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">
     * ListBucketIntelligentTieringConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You only need S3 Intelligent-Tiering enabled on a bucket if you want to automatically move objects stored in the
     * S3 Intelligent-Tiering storage class to the Archive Access or Deep Archive Access tier.
     * </p>
     * </note>
     * <p>
     * <code>PutBucketIntelligentTieringConfiguration</code> has the following special errors:
     * </p>
     * <dl>
     * <dt>HTTP 400 Bad Request Error</dt>
     * <dd>
     * <p>
     * <i>Code:</i> InvalidArgument
     * </p>
     * <p>
     * <i>Cause:</i> Invalid Argument
     * </p>
     * </dd>
     * <dt>HTTP 400 Bad Request Error</dt>
     * <dd>
     * <p>
     * <i>Code:</i> TooManyConfigurations
     * </p>
     * <p>
     * <i>Cause:</i> You are attempting to create a new configuration but have already reached the 1,000-configuration
     * limit.
     * </p>
     * </dd>
     * <dt>HTTP 403 Forbidden Error</dt>
     * <dd>
     * <p>
     * <i>Cause:</i> You are not the owner of the specified bucket, or you do not have the
     * <code>s3:PutIntelligentTieringConfiguration</code> bucket permission to set the configuration on the bucket.
     * </p>
     * </dd>
     * </dl>
     *
     * @param putBucketIntelligentTieringConfigurationRequest
     * @return Result of the PutBucketIntelligentTieringConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketIntelligentTieringConfiguration
     */
    default PutBucketIntelligentTieringConfigurationResponse putBucketIntelligentTieringConfiguration(
            PutBucketIntelligentTieringConfigurationRequest putBucketIntelligentTieringConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Puts a S3 Intelligent-Tiering configuration to the specified bucket. You can have up to 1,000 S3
     * Intelligent-Tiering configurations per bucket.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to
     * the most cost-effective storage access tier, without performance impact or operational overhead. S3
     * Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get
     * the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional
     * archiving capabilities.
     * </p>
     * <p>
     * The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or
     * unpredictable access patterns, independent of object size or retention period. If the size of an object is less
     * than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are
     * always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage
     * class for automatically optimizing frequently and infrequently accessed objects</a>.
     * </p>
     * <p>
     * Operations related to <code>PutBucketIntelligentTieringConfiguration</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">
     * DeleteBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">
     * GetBucketIntelligentTieringConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">
     * ListBucketIntelligentTieringConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You only need S3 Intelligent-Tiering enabled on a bucket if you want to automatically move objects stored in the
     * S3 Intelligent-Tiering storage class to the Archive Access or Deep Archive Access tier.
     * </p>
     * </note>
     * <p>
     * <code>PutBucketIntelligentTieringConfiguration</code> has the following special errors:
     * </p>
     * <dl>
     * <dt>HTTP 400 Bad Request Error</dt>
     * <dd>
     * <p>
     * <i>Code:</i> InvalidArgument
     * </p>
     * <p>
     * <i>Cause:</i> Invalid Argument
     * </p>
     * </dd>
     * <dt>HTTP 400 Bad Request Error</dt>
     * <dd>
     * <p>
     * <i>Code:</i> TooManyConfigurations
     * </p>
     * <p>
     * <i>Cause:</i> You are attempting to create a new configuration but have already reached the 1,000-configuration
     * limit.
     * </p>
     * </dd>
     * <dt>HTTP 403 Forbidden Error</dt>
     * <dd>
     * <p>
     * <i>Cause:</i> You are not the owner of the specified bucket, or you do not have the
     * <code>s3:PutIntelligentTieringConfiguration</code> bucket permission to set the configuration on the bucket.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutBucketIntelligentTieringConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutBucketIntelligentTieringConfigurationRequest#builder()}
     * </p>
     *
     * @param putBucketIntelligentTieringConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the PutBucketIntelligentTieringConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketIntelligentTieringConfiguration
     */
    default PutBucketIntelligentTieringConfigurationResponse putBucketIntelligentTieringConfiguration(
            Consumer<PutBucketIntelligentTieringConfigurationRequest.Builder> putBucketIntelligentTieringConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketIntelligentTieringConfiguration(PutBucketIntelligentTieringConfigurationRequest.builder()
                .applyMutation(putBucketIntelligentTieringConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This implementation of the <code>PUT</code> action adds an inventory configuration (identified by the inventory
     * ID) to the bucket. You can have up to 1,000 inventory configurations per bucket.
     * </p>
     * <p>
     * Amazon S3 inventory generates inventories of the objects in the bucket on a daily or weekly basis, and the
     * results are published to a flat file. The bucket that is inventoried is called the <i>source</i> bucket, and the
     * bucket where the inventory flat file is stored is called the <i>destination</i> bucket. The <i>destination</i>
     * bucket must be in the same Amazon Web Services Region as the <i>source</i> bucket.
     * </p>
     * <p>
     * When you configure an inventory for a <i>source</i> bucket, you specify the <i>destination</i> bucket where you
     * want the inventory to be stored, and whether to generate the inventory daily or weekly. You can also configure
     * what object metadata to include and whether to inventory all object versions or only current versions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3
     * Inventory</a> in the Amazon S3 User Guide.
     * </p>
     * <important>
     * <p>
     * You must create a bucket policy on the <i>destination</i> bucket to grant permissions to Amazon S3 to write
     * objects to the bucket in the defined location. For an example policy, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9"
     * > Granting Permissions for Amazon S3 Inventory and Storage Class Analysis</a>.
     * </p>
     * </important>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:PutInventoryConfiguration</code> action.
     * The bucket owner has this permission by default and can grant this permission to others.
     * </p>
     * <p>
     * The <code>s3:PutInventoryConfiguration</code> permission allows a user to create an <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-inventory.html">S3 Inventory</a> report that
     * includes all object metadata fields available and to specify the destination bucket to store the inventory. A
     * user with read access to objects in the destination bucket can also access all object metadata fields that are
     * available in the inventory report.
     * </p>
     * <p>
     * To restrict access to an inventory report, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html#example-bucket-policies-use-case-10"
     * >Restricting access to an Amazon S3 Inventory report</a> in the <i>Amazon S3 User Guide</i>. For more information
     * about the metadata fields available in S3 Inventory, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-inventory.html#storage-inventory-contents"
     * >Amazon S3 Inventory lists</a> in the <i>Amazon S3 User Guide</i>. For more information about permissions, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions related to bucket subresource operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Identity and access
     * management in Amazon S3</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <code>PutBucketInventoryConfiguration</code> has the following special errors:
     * </p>
     * <dl>
     * <dt>HTTP 400 Bad Request Error</dt>
     * <dd>
     * <p>
     * <i>Code:</i> InvalidArgument
     * </p>
     * <p>
     * <i>Cause:</i> Invalid Argument
     * </p>
     * </dd>
     * <dt>HTTP 400 Bad Request Error</dt>
     * <dd>
     * <p>
     * <i>Code:</i> TooManyConfigurations
     * </p>
     * <p>
     * <i>Cause:</i> You are attempting to create a new configuration but have already reached the 1,000-configuration
     * limit.
     * </p>
     * </dd>
     * <dt>HTTP 403 Forbidden Error</dt>
     * <dd>
     * <p>
     * <i>Cause:</i> You are not the owner of the specified bucket, or you do not have the
     * <code>s3:PutInventoryConfiguration</code> bucket permission to set the configuration on the bucket.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketInventoryConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">
     * GetBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">
     * DeleteBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">
     * ListBucketInventoryConfigurations</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketInventoryConfigurationRequest
     * @return Result of the PutBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketInventoryConfiguration
     */
    default PutBucketInventoryConfigurationResponse putBucketInventoryConfiguration(
            PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * This implementation of the <code>PUT</code> action adds an inventory configuration (identified by the inventory
     * ID) to the bucket. You can have up to 1,000 inventory configurations per bucket.
     * </p>
     * <p>
     * Amazon S3 inventory generates inventories of the objects in the bucket on a daily or weekly basis, and the
     * results are published to a flat file. The bucket that is inventoried is called the <i>source</i> bucket, and the
     * bucket where the inventory flat file is stored is called the <i>destination</i> bucket. The <i>destination</i>
     * bucket must be in the same Amazon Web Services Region as the <i>source</i> bucket.
     * </p>
     * <p>
     * When you configure an inventory for a <i>source</i> bucket, you specify the <i>destination</i> bucket where you
     * want the inventory to be stored, and whether to generate the inventory daily or weekly. You can also configure
     * what object metadata to include and whether to inventory all object versions or only current versions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3
     * Inventory</a> in the Amazon S3 User Guide.
     * </p>
     * <important>
     * <p>
     * You must create a bucket policy on the <i>destination</i> bucket to grant permissions to Amazon S3 to write
     * objects to the bucket in the defined location. For an example policy, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9"
     * > Granting Permissions for Amazon S3 Inventory and Storage Class Analysis</a>.
     * </p>
     * </important>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3:PutInventoryConfiguration</code> action.
     * The bucket owner has this permission by default and can grant this permission to others.
     * </p>
     * <p>
     * The <code>s3:PutInventoryConfiguration</code> permission allows a user to create an <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-inventory.html">S3 Inventory</a> report that
     * includes all object metadata fields available and to specify the destination bucket to store the inventory. A
     * user with read access to objects in the destination bucket can also access all object metadata fields that are
     * available in the inventory report.
     * </p>
     * <p>
     * To restrict access to an inventory report, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html#example-bucket-policies-use-case-10"
     * >Restricting access to an Amazon S3 Inventory report</a> in the <i>Amazon S3 User Guide</i>. For more information
     * about the metadata fields available in S3 Inventory, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-inventory.html#storage-inventory-contents"
     * >Amazon S3 Inventory lists</a> in the <i>Amazon S3 User Guide</i>. For more information about permissions, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions related to bucket subresource operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Identity and access
     * management in Amazon S3</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <code>PutBucketInventoryConfiguration</code> has the following special errors:
     * </p>
     * <dl>
     * <dt>HTTP 400 Bad Request Error</dt>
     * <dd>
     * <p>
     * <i>Code:</i> InvalidArgument
     * </p>
     * <p>
     * <i>Cause:</i> Invalid Argument
     * </p>
     * </dd>
     * <dt>HTTP 400 Bad Request Error</dt>
     * <dd>
     * <p>
     * <i>Code:</i> TooManyConfigurations
     * </p>
     * <p>
     * <i>Cause:</i> You are attempting to create a new configuration but have already reached the 1,000-configuration
     * limit.
     * </p>
     * </dd>
     * <dt>HTTP 403 Forbidden Error</dt>
     * <dd>
     * <p>
     * <i>Cause:</i> You are not the owner of the specified bucket, or you do not have the
     * <code>s3:PutInventoryConfiguration</code> bucket permission to set the configuration on the bucket.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketInventoryConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">
     * GetBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">
     * DeleteBucketInventoryConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">
     * ListBucketInventoryConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketInventoryConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBucketInventoryConfigurationRequest#builder()}
     * </p>
     *
     * @param putBucketInventoryConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the PutBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketInventoryConfiguration
     */
    default PutBucketInventoryConfigurationResponse putBucketInventoryConfiguration(
            Consumer<PutBucketInventoryConfigurationRequest.Builder> putBucketInventoryConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketInventoryConfiguration(PutBucketInventoryConfigurationRequest.builder()
                .applyMutation(putBucketInventoryConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new lifecycle configuration for the bucket or replaces an existing lifecycle configuration. Keep in
     * mind that this will overwrite an existing lifecycle configuration, so if you want to retain any configuration
     * details, they must be included in the new lifecycle configuration. For information about lifecycle configuration,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html">Managing your
     * storage lifecycle</a>.
     * </p>
     * <dl>
     * <dt>Rules</dt>
     * <dt>Permissions</dt>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * You specify the lifecycle configuration in your request body. The lifecycle configuration is specified as XML
     * consisting of one or more rules. An Amazon S3 Lifecycle configuration can have up to 1,000 rules. This limit is
     * not adjustable.
     * </p>
     * <p>
     * Bucket lifecycle configuration supports specifying a lifecycle rule using an object key name prefix, one or more
     * object tags, object size, or any combination of these. Accordingly, this section describes the latest API. The
     * previous version of the API supported filtering based only on an object key name prefix, which is supported for
     * backward compatibility for general purpose buckets. For the related API description, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html">PutBucketLifecycle</a>.
     * </p>
     * <note>
     * <p>
     * Lifecyle configurations for directory buckets only support expiring objects and cancelling multipart uploads.
     * Expiring of versioned objects,transitions and tag filters are not supported.
     * </p>
     * </note>
     * <p>
     * A lifecycle rule consists of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A filter identifying a subset of objects to which the rule applies. The filter can be based on a key name prefix,
     * object tags, object size, or any combination of these.
     * </p>
     * </li>
     * <li>
     * <p>
     * A status indicating whether the rule is in effect.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more lifecycle transition and expiration actions that you want Amazon S3 to perform on the objects
     * identified by the filter. If the state of your bucket is versioning-enabled or versioning-suspended, you can have
     * many versions of the same object (one current version and zero or more noncurrent versions). Amazon S3 provides
     * predefined actions that you can specify for current and noncurrent object versions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a>
     * and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html">Lifecycle Configuration
     * Elements</a>.
     * </p>
     * </dd>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - By default, all Amazon S3 resources are private, including buckets,
     * objects, and related subresources (for example, lifecycle configuration and website configuration). Only the
     * resource owner (that is, the Amazon Web Services account that created it) can access the resource. The resource
     * owner can optionally grant access permissions to others by writing an access policy. For this operation, a user
     * must have the <code>s3:PutLifecycleConfiguration</code> permission.
     * </p>
     * <p>
     * You can also explicitly deny permissions. An explicit deny also supersedes any other permissions. If you want to
     * block users or accounts from removing or deleting objects from your bucket, you must deny them permissions for
     * the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3:DeleteObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteObjectVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutLifecycleConfiguration</code>
     * </p>
     * <p>
     * For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:PutLifecycleConfiguration</code>
     * permission in an IAM identity-based policy to use this operation. Cross-account access to this API operation
     * isn't supported. The resource owner can optionally grant access permissions to others by creating a role or user
     * for them as long as they are within the same account as the owner and resource.
     * </p>
     * <p>
     * For more information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Authorizing Regional
     * endpoint APIs with IAM</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketLifecycleConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">
     * GetBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     *
     * @param putBucketLifecycleConfigurationRequest
     * @return Result of the PutBucketLifecycleConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLifecycleConfiguration
     */
    default PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(
            PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new lifecycle configuration for the bucket or replaces an existing lifecycle configuration. Keep in
     * mind that this will overwrite an existing lifecycle configuration, so if you want to retain any configuration
     * details, they must be included in the new lifecycle configuration. For information about lifecycle configuration,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html">Managing your
     * storage lifecycle</a>.
     * </p>
     * <dl>
     * <dt>Rules</dt>
     * <dt>Permissions</dt>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * You specify the lifecycle configuration in your request body. The lifecycle configuration is specified as XML
     * consisting of one or more rules. An Amazon S3 Lifecycle configuration can have up to 1,000 rules. This limit is
     * not adjustable.
     * </p>
     * <p>
     * Bucket lifecycle configuration supports specifying a lifecycle rule using an object key name prefix, one or more
     * object tags, object size, or any combination of these. Accordingly, this section describes the latest API. The
     * previous version of the API supported filtering based only on an object key name prefix, which is supported for
     * backward compatibility for general purpose buckets. For the related API description, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html">PutBucketLifecycle</a>.
     * </p>
     * <note>
     * <p>
     * Lifecyle configurations for directory buckets only support expiring objects and cancelling multipart uploads.
     * Expiring of versioned objects,transitions and tag filters are not supported.
     * </p>
     * </note>
     * <p>
     * A lifecycle rule consists of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A filter identifying a subset of objects to which the rule applies. The filter can be based on a key name prefix,
     * object tags, object size, or any combination of these.
     * </p>
     * </li>
     * <li>
     * <p>
     * A status indicating whether the rule is in effect.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more lifecycle transition and expiration actions that you want Amazon S3 to perform on the objects
     * identified by the filter. If the state of your bucket is versioning-enabled or versioning-suspended, you can have
     * many versions of the same object (one current version and zero or more noncurrent versions). Amazon S3 provides
     * predefined actions that you can specify for current and noncurrent object versions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a>
     * and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html">Lifecycle Configuration
     * Elements</a>.
     * </p>
     * </dd>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - By default, all Amazon S3 resources are private, including buckets,
     * objects, and related subresources (for example, lifecycle configuration and website configuration). Only the
     * resource owner (that is, the Amazon Web Services account that created it) can access the resource. The resource
     * owner can optionally grant access permissions to others by writing an access policy. For this operation, a user
     * must have the <code>s3:PutLifecycleConfiguration</code> permission.
     * </p>
     * <p>
     * You can also explicitly deny permissions. An explicit deny also supersedes any other permissions. If you want to
     * block users or accounts from removing or deleting objects from your bucket, you must deny them permissions for
     * the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3:DeleteObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteObjectVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutLifecycleConfiguration</code>
     * </p>
     * <p>
     * For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - You must have the <code>s3express:PutLifecycleConfiguration</code>
     * permission in an IAM identity-based policy to use this operation. Cross-account access to this API operation
     * isn't supported. The resource owner can optionally grant access permissions to others by creating a role or user
     * for them as long as they are within the same account as the owner and resource.
     * </p>
     * <p>
     * For more information about directory bucket policies and permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Authorizing Regional
     * endpoint APIs with IAM</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note></li>
     * </ul>
     * </dd>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketLifecycleConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">
     * GetBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketLifecycleConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBucketLifecycleConfigurationRequest#builder()}
     * </p>
     *
     * @param putBucketLifecycleConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the PutBucketLifecycleConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLifecycleConfiguration
     */
    default PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(
            Consumer<PutBucketLifecycleConfigurationRequest.Builder> putBucketLifecycleConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest.builder()
                .applyMutation(putBucketLifecycleConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging
     * parameters. All logs are saved to buckets in the same Amazon Web Services Region as the source bucket. To set the
     * logging status of a bucket, you must be the bucket owner.
     * </p>
     * <p>
     * The bucket owner is automatically granted FULL_CONTROL to all logs. You use the <code>Grantee</code> request
     * element to grant access to other people. The <code>Permissions</code> request element specifies the kind of
     * access the grantee has to the logs.
     * </p>
     * <important>
     * <p>
     * If the target bucket for log delivery uses the bucket owner enforced setting for S3 Object Ownership, you can't
     * use the <code>Grantee</code> request element to grant access to others. Permissions can only be granted using
     * policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general"
     * >Permissions for server access log delivery</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important>
     * <dl>
     * <dt>Grantee Values</dt>
     * <dd>
     * <p>
     * You can specify the person (grantee) to whom you're assigning access rights (by using request elements) in the
     * following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * By the person's ID:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"&gt;&lt;ID&gt;&lt;&gt;ID&lt;&gt;&lt;/ID&gt;&lt;DisplayName&gt;&lt;&gt;GranteesEmail&lt;&gt;&lt;/DisplayName&gt; &lt;/Grantee&gt;</code>
     * </p>
     * <p>
     * <code>DisplayName</code> is optional and ignored in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * By Email address:
     * </p>
     * <p>
     * <code> &lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"&gt;&lt;EmailAddress&gt;&lt;&gt;Grantees@email.com&lt;&gt;&lt;/EmailAddress&gt;&lt;/Grantee&gt;</code>
     * </p>
     * <p>
     * The grantee is resolved to the <code>CanonicalUser</code> and, in a response to a <code>GETObjectAcl</code>
     * request, appears as the CanonicalUser.
     * </p>
     * </li>
     * <li>
     * <p>
     * By URI:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"&gt;&lt;URI&gt;&lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;&lt;/URI&gt;&lt;/Grantee&gt;</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * To enable logging, you use <code>LoggingEnabled</code> and its children request elements. To disable logging, you
     * use an empty <code>BucketLoggingStatus</code> request element:
     * </p>
     * <p>
     * <code>&lt;BucketLoggingStatus xmlns="http://doc.s3.amazonaws.com/2006-03-01" /&gt;</code>
     * </p>
     * <p>
     * For more information about server access logging, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html">Server Access Logging</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * For more information about creating a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>. For more
     * information about returning the logging status of a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html">GetBucketLogging</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketLogging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html">GetBucketLogging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketLoggingRequest
     * @return Result of the PutBucketLogging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLogging
     */
    default PutBucketLoggingResponse putBucketLogging(PutBucketLoggingRequest putBucketLoggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging
     * parameters. All logs are saved to buckets in the same Amazon Web Services Region as the source bucket. To set the
     * logging status of a bucket, you must be the bucket owner.
     * </p>
     * <p>
     * The bucket owner is automatically granted FULL_CONTROL to all logs. You use the <code>Grantee</code> request
     * element to grant access to other people. The <code>Permissions</code> request element specifies the kind of
     * access the grantee has to the logs.
     * </p>
     * <important>
     * <p>
     * If the target bucket for log delivery uses the bucket owner enforced setting for S3 Object Ownership, you can't
     * use the <code>Grantee</code> request element to grant access to others. Permissions can only be granted using
     * policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general"
     * >Permissions for server access log delivery</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important>
     * <dl>
     * <dt>Grantee Values</dt>
     * <dd>
     * <p>
     * You can specify the person (grantee) to whom you're assigning access rights (by using request elements) in the
     * following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * By the person's ID:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"&gt;&lt;ID&gt;&lt;&gt;ID&lt;&gt;&lt;/ID&gt;&lt;DisplayName&gt;&lt;&gt;GranteesEmail&lt;&gt;&lt;/DisplayName&gt; &lt;/Grantee&gt;</code>
     * </p>
     * <p>
     * <code>DisplayName</code> is optional and ignored in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * By Email address:
     * </p>
     * <p>
     * <code> &lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"&gt;&lt;EmailAddress&gt;&lt;&gt;Grantees@email.com&lt;&gt;&lt;/EmailAddress&gt;&lt;/Grantee&gt;</code>
     * </p>
     * <p>
     * The grantee is resolved to the <code>CanonicalUser</code> and, in a response to a <code>GETObjectAcl</code>
     * request, appears as the CanonicalUser.
     * </p>
     * </li>
     * <li>
     * <p>
     * By URI:
     * </p>
     * <p>
     * <code>&lt;Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"&gt;&lt;URI&gt;&lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;&lt;/URI&gt;&lt;/Grantee&gt;</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * To enable logging, you use <code>LoggingEnabled</code> and its children request elements. To disable logging, you
     * use an empty <code>BucketLoggingStatus</code> request element:
     * </p>
     * <p>
     * <code>&lt;BucketLoggingStatus xmlns="http://doc.s3.amazonaws.com/2006-03-01" /&gt;</code>
     * </p>
     * <p>
     * For more information about server access logging, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html">Server Access Logging</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * For more information about creating a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>. For more
     * information about returning the logging status of a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html">GetBucketLogging</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketLogging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html">GetBucketLogging</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketLoggingRequest.Builder} avoiding the need
     * to create one manually via {@link PutBucketLoggingRequest#builder()}
     * </p>
     *
     * @param putBucketLoggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest.Builder} to create a request.
     * @return Result of the PutBucketLogging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLogging
     */
    default PutBucketLoggingResponse putBucketLogging(Consumer<PutBucketLoggingRequest.Builder> putBucketLoggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketLogging(PutBucketLoggingRequest.builder().applyMutation(putBucketLoggingRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets a metrics configuration (specified by the metrics configuration ID) for the bucket. You can have up to 1,000
     * metrics configurations per bucket. If you're updating an existing metrics configuration, note that this is a full
     * replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are
     * erased.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutMetricsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about CloudWatch request metrics for Amazon S3, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon
     * CloudWatch</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketMetricsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">
     * DeleteBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">
     * GetBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">
     * ListBucketMetricsConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>PutBucketMetricsConfiguration</code> has the following special error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>TooManyConfigurations</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: You are attempting to create a new configuration but have already reached the 1,000-configuration
     * limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: HTTP 400 Bad Request
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param putBucketMetricsConfigurationRequest
     * @return Result of the PutBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketMetricsConfiguration
     */
    default PutBucketMetricsConfigurationResponse putBucketMetricsConfiguration(
            PutBucketMetricsConfigurationRequest putBucketMetricsConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets a metrics configuration (specified by the metrics configuration ID) for the bucket. You can have up to 1,000
     * metrics configurations per bucket. If you're updating an existing metrics configuration, note that this is a full
     * replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are
     * erased.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutMetricsConfiguration</code> action.
     * The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * For information about CloudWatch request metrics for Amazon S3, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon
     * CloudWatch</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketMetricsConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">
     * DeleteBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">
     * GetBucketMetricsConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">
     * ListBucketMetricsConfigurations</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>PutBucketMetricsConfiguration</code> has the following special error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>TooManyConfigurations</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: You are attempting to create a new configuration but have already reached the 1,000-configuration
     * limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: HTTP 400 Bad Request
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketMetricsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBucketMetricsConfigurationRequest#builder()}
     * </p>
     *
     * @param putBucketMetricsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the PutBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketMetricsConfiguration
     */
    default PutBucketMetricsConfigurationResponse putBucketMetricsConfiguration(
            Consumer<PutBucketMetricsConfigurationRequest.Builder> putBucketMetricsConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketMetricsConfiguration(PutBucketMetricsConfigurationRequest.builder()
                .applyMutation(putBucketMetricsConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Enables notifications of specified events for a bucket. For more information about event notifications, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event
     * Notifications</a>.
     * </p>
     * <p>
     * Using this API, you can replace an existing notification configuration. The configuration is an XML file that
     * defines the event types that you want Amazon S3 to publish and the destination where you want Amazon S3 to
     * publish an event notification when it detects an event of the specified type.
     * </p>
     * <p>
     * By default, your bucket has no event notifications configured. That is, the notification configuration will be an
     * empty <code>NotificationConfiguration</code>.
     * </p>
     * <p>
     * <code>&lt;NotificationConfiguration&gt;</code>
     * </p>
     * <p>
     * <code>&lt;/NotificationConfiguration&gt;</code>
     * </p>
     * <p>
     * This action replaces the existing notification configuration with the configuration you include in the request
     * body.
     * </p>
     * <p>
     * After Amazon S3 receives this request, it first verifies that any Amazon Simple Notification Service (Amazon SNS)
     * or Amazon Simple Queue Service (Amazon SQS) destination exists, and that the bucket owner has permission to
     * publish to it by sending a test notification. In the case of Lambda destinations, Amazon S3 verifies that the
     * Lambda function permissions grant Amazon S3 permission to invoke the function from the Amazon S3 bucket. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring
     * Notifications for Amazon S3 Events</a>.
     * </p>
     * <p>
     * You can disable notifications by adding the empty NotificationConfiguration element.
     * </p>
     * <p>
     * For more information about the number of event notification configurations that you can create per bucket, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/s3.html#limits_s3">Amazon S3 service quotas</a> in <i>Amazon
     * Web Services General Reference</i>.
     * </p>
     * <p>
     * By default, only the bucket owner can configure notifications on a bucket. However, bucket owners can use a
     * bucket policy to grant permission to other users to set this configuration with the required
     * <code>s3:PutBucketNotification</code> permission.
     * </p>
     * <note>
     * <p>
     * The PUT notification is an atomic operation. For example, suppose your notification configuration includes SNS
     * topic, SQS queue, and Lambda function configurations. When you send a PUT request with this configuration, Amazon
     * S3 sends test messages to your SNS topic. If the message fails, the entire PUT action will fail, and Amazon S3
     * will not add the configuration to your bucket.
     * </p>
     * </note>
     * <p>
     * If the configuration in the request body includes only one <code>TopicConfiguration</code> specifying only the
     * <code>s3:ReducedRedundancyLostObject</code> event type, the response will also include the
     * <code>x-amz-sns-test-message-id</code> header containing the message ID of the test notification sent to the
     * topic.
     * </p>
     * <p>
     * The following action is related to <code>PutBucketNotificationConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html">
     * GetBucketNotificationConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketNotificationConfigurationRequest
     * @return Result of the PutBucketNotificationConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketNotificationConfiguration
     */
    default PutBucketNotificationConfigurationResponse putBucketNotificationConfiguration(
            PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Enables notifications of specified events for a bucket. For more information about event notifications, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event
     * Notifications</a>.
     * </p>
     * <p>
     * Using this API, you can replace an existing notification configuration. The configuration is an XML file that
     * defines the event types that you want Amazon S3 to publish and the destination where you want Amazon S3 to
     * publish an event notification when it detects an event of the specified type.
     * </p>
     * <p>
     * By default, your bucket has no event notifications configured. That is, the notification configuration will be an
     * empty <code>NotificationConfiguration</code>.
     * </p>
     * <p>
     * <code>&lt;NotificationConfiguration&gt;</code>
     * </p>
     * <p>
     * <code>&lt;/NotificationConfiguration&gt;</code>
     * </p>
     * <p>
     * This action replaces the existing notification configuration with the configuration you include in the request
     * body.
     * </p>
     * <p>
     * After Amazon S3 receives this request, it first verifies that any Amazon Simple Notification Service (Amazon SNS)
     * or Amazon Simple Queue Service (Amazon SQS) destination exists, and that the bucket owner has permission to
     * publish to it by sending a test notification. In the case of Lambda destinations, Amazon S3 verifies that the
     * Lambda function permissions grant Amazon S3 permission to invoke the function from the Amazon S3 bucket. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring
     * Notifications for Amazon S3 Events</a>.
     * </p>
     * <p>
     * You can disable notifications by adding the empty NotificationConfiguration element.
     * </p>
     * <p>
     * For more information about the number of event notification configurations that you can create per bucket, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/s3.html#limits_s3">Amazon S3 service quotas</a> in <i>Amazon
     * Web Services General Reference</i>.
     * </p>
     * <p>
     * By default, only the bucket owner can configure notifications on a bucket. However, bucket owners can use a
     * bucket policy to grant permission to other users to set this configuration with the required
     * <code>s3:PutBucketNotification</code> permission.
     * </p>
     * <note>
     * <p>
     * The PUT notification is an atomic operation. For example, suppose your notification configuration includes SNS
     * topic, SQS queue, and Lambda function configurations. When you send a PUT request with this configuration, Amazon
     * S3 sends test messages to your SNS topic. If the message fails, the entire PUT action will fail, and Amazon S3
     * will not add the configuration to your bucket.
     * </p>
     * </note>
     * <p>
     * If the configuration in the request body includes only one <code>TopicConfiguration</code> specifying only the
     * <code>s3:ReducedRedundancyLostObject</code> event type, the response will also include the
     * <code>x-amz-sns-test-message-id</code> header containing the message ID of the test notification sent to the
     * topic.
     * </p>
     * <p>
     * The following action is related to <code>PutBucketNotificationConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html">
     * GetBucketNotificationConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBucketNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param putBucketNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutBucketNotificationConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketNotificationConfiguration
     */
    default PutBucketNotificationConfigurationResponse putBucketNotificationConfiguration(
            Consumer<PutBucketNotificationConfigurationRequest.Builder> putBucketNotificationConfigurationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketNotificationConfiguration(PutBucketNotificationConfigurationRequest.builder()
                .applyMutation(putBucketNotificationConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates or modifies <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have
     * the <code>s3:PutBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/using-with-s3-actions.html">Specifying
     * permissions in a policy</a>.
     * </p>
     * <p>
     * For information about Amazon S3 Object Ownership, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/about-object-ownership.html">Using object
     * ownership</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketOwnershipControls</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GetBucketOwnershipControls</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteBucketOwnershipControls</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketOwnershipControlsRequest
     * @return Result of the PutBucketOwnershipControls operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketOwnershipControls
     */
    default PutBucketOwnershipControlsResponse putBucketOwnershipControls(
            PutBucketOwnershipControlsRequest putBucketOwnershipControlsRequest) throws AwsServiceException, SdkClientException,
            S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates or modifies <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have
     * the <code>s3:PutBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/using-with-s3-actions.html">Specifying
     * permissions in a policy</a>.
     * </p>
     * <p>
     * For information about Amazon S3 Object Ownership, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/about-object-ownership.html">Using object
     * ownership</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketOwnershipControls</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GetBucketOwnershipControls</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteBucketOwnershipControls</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketOwnershipControlsRequest.Builder} avoiding
     * the need to create one manually via {@link PutBucketOwnershipControlsRequest#builder()}
     * </p>
     *
     * @param putBucketOwnershipControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest.Builder} to create a
     *        request.
     * @return Result of the PutBucketOwnershipControls operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketOwnershipControls
     */
    default PutBucketOwnershipControlsResponse putBucketOwnershipControls(
            Consumer<PutBucketOwnershipControlsRequest.Builder> putBucketOwnershipControlsRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return putBucketOwnershipControls(PutBucketOwnershipControlsRequest.builder()
                .applyMutation(putBucketOwnershipControlsRequest).build());
    }

    /**
     * <p>
     * Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket,
     * the calling identity must both have the <code>PutBucketPolicy</code> permissions on the specified bucket and
     * belong to the bucket owner's account in order to use this operation.
     * </p>
     * <p>
     * If you don't have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code>
     * error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's
     * account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.
     * </p>
     * <important>
     * <p>
     * To ensure that bucket owners don't inadvertently lock themselves out of their own buckets, the root principal in
     * a bucket owner's Amazon Web Services account can perform the <code>GetBucketPolicy</code>,
     * <code>PutBucketPolicy</code>, and <code>DeleteBucketPolicy</code> API actions, even if their bucket policy
     * explicitly denies the root principal's access. Bucket owner root principals can only be blocked from performing
     * these API actions by VPC endpoint policies and Amazon Web Services Organizations policies.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:PutBucketPolicy</code> permission is required in a
     * policy. For more information about general purpose buckets bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:PutBucketPolicy</code> permission in an IAM identity-based policy instead of a bucket policy.
     * Cross-account access to this API operation isn't supported. This operation can only be performed by the Amazon
     * Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Example bucket policies</dt>
     * <dd>
     * <p>
     * <b>General purpose buckets example bucket policies</b> - See <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html">Bucket policy
     * examples</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory bucket example bucket policies</b> - See <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketPolicyRequest
     * @return Result of the PutBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketPolicy
     */
    default PutBucketPolicyResponse putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Regional
     * endpoint. These endpoints support path-style requests in the format
     * <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style
     * requests aren't supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket,
     * the calling identity must both have the <code>PutBucketPolicy</code> permissions on the specified bucket and
     * belong to the bucket owner's account in order to use this operation.
     * </p>
     * <p>
     * If you don't have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code>
     * error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's
     * account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.
     * </p>
     * <important>
     * <p>
     * To ensure that bucket owners don't inadvertently lock themselves out of their own buckets, the root principal in
     * a bucket owner's Amazon Web Services account can perform the <code>GetBucketPolicy</code>,
     * <code>PutBucketPolicy</code>, and <code>DeleteBucketPolicy</code> API actions, even if their bucket policy
     * explicitly denies the root principal's access. Bucket owner root principals can only be blocked from performing
     * these API actions by VPC endpoint policies and Amazon Web Services Organizations policies.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The <code>s3:PutBucketPolicy</code> permission is required in a
     * policy. For more information about general purpose buckets bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation, you must have the
     * <code>s3express:PutBucketPolicy</code> permission in an IAM identity-based policy instead of a bucket policy.
     * Cross-account access to this API operation isn't supported. This operation can only be performed by the Amazon
     * Web Services account that owns the resource. For more information about directory bucket policies and
     * permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam.html">Amazon Web Services
     * Identity and Access Management (IAM) for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Example bucket policies</dt>
     * <dd>
     * <p>
     * <b>General purpose buckets example bucket policies</b> - See <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html">Bucket policy
     * examples</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Directory bucket example bucket policies</b> - See <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
     * >Example bucket policies for S3 Express One Zone</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code>s3express-control.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutBucketPolicyRequest#builder()}
     * </p>
     *
     * @param putBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest.Builder} to create a request.
     * @return Result of the PutBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketPolicy
     */
    default PutBucketPolicyResponse putBucketPolicy(Consumer<PutBucketPolicyRequest.Builder> putBucketPolicyRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketPolicy(PutBucketPolicyRequest.builder().applyMutation(putBucketPolicyRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates a replication configuration or replaces an existing one. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * <p>
     * Specify the replication configuration in the request body. In the replication configuration, you provide the name
     * of the destination bucket or buckets where you want Amazon S3 to replicate objects, the IAM role that Amazon S3
     * can assume to replicate objects on your behalf, and other relevant information. You can invoke this request for a
     * specific Amazon Web Services Region by using the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requestedregion"
     * > <code>aws:RequestedRegion</code> </a> condition key.
     * </p>
     * <p>
     * A replication configuration must include at least one rule, and can contain a maximum of 1,000. Each rule
     * identifies a subset of objects to replicate by filtering the objects in the source bucket. To choose additional
     * subsets of objects to replicate, add a rule for each subset.
     * </p>
     * <p>
     * To specify a subset of the objects in the source bucket to apply a replication rule to, add the Filter element as
     * a child of the Rule element. You can filter objects based on an object key prefix, one or more object tags, or
     * both. When you add the Filter element in the configuration, you must also add the following elements:
     * <code>DeleteMarkerReplication</code>, <code>Status</code>, and <code>Priority</code>.
     * </p>
     * <note>
     * <p>
     * If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete
     * markers differently. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations"
     * >Backward Compatibility</a>.
     * </p>
     * </note>
     * <p>
     * For information about enabling versioning on a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html">Using Versioning</a>.
     * </p>
     * <dl>
     * <dt>Handling Replication of Encrypted Objects</dt>
     * <dd>
     * <p>
     * By default, Amazon S3 doesn't replicate objects that are stored at rest using server-side encryption with KMS
     * keys. To replicate Amazon Web Services KMS-encrypted objects, add the following:
     * <code>SourceSelectionCriteria</code>, <code>SseKmsEncryptedObjects</code>, <code>Status</code>,
     * <code>EncryptionConfiguration</code>, and <code>ReplicaKmsKeyID</code>. For information about replication
     * configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-config-for-kms-objects.html">Replicating
     * Objects Created with SSE Using KMS keys</a>.
     * </p>
     * <p>
     * For information on <code>PutBucketReplication</code> errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList">List of
     * replication-related error codes</a>
     * </p>
     * </dd>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To create a <code>PutBucketReplication</code> request, you must have <code>s3:PutReplicationConfiguration</code>
     * permissions for the bucket.
     * </p>
     * <p>
     * By default, a resource owner, in this case the Amazon Web Services account that created the bucket, can perform
     * this operation. The resource owner can also grant others permissions to perform the operation. For more
     * information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a
     * Policy</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing
     * Access Permissions to Your Amazon S3 Resources</a>.
     * </p>
     * <note>
     * <p>
     * To perform this operation, the user or role performing the action must have the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">iam:PassRole</a> permission.
     * </p>
     * </note></dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html">GetBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html">DeleteBucketReplication
     * </a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketReplicationRequest
     * @return Result of the PutBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketReplication
     */
    default PutBucketReplicationResponse putBucketReplication(PutBucketReplicationRequest putBucketReplicationRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates a replication configuration or replaces an existing one. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * <p>
     * Specify the replication configuration in the request body. In the replication configuration, you provide the name
     * of the destination bucket or buckets where you want Amazon S3 to replicate objects, the IAM role that Amazon S3
     * can assume to replicate objects on your behalf, and other relevant information. You can invoke this request for a
     * specific Amazon Web Services Region by using the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requestedregion"
     * > <code>aws:RequestedRegion</code> </a> condition key.
     * </p>
     * <p>
     * A replication configuration must include at least one rule, and can contain a maximum of 1,000. Each rule
     * identifies a subset of objects to replicate by filtering the objects in the source bucket. To choose additional
     * subsets of objects to replicate, add a rule for each subset.
     * </p>
     * <p>
     * To specify a subset of the objects in the source bucket to apply a replication rule to, add the Filter element as
     * a child of the Rule element. You can filter objects based on an object key prefix, one or more object tags, or
     * both. When you add the Filter element in the configuration, you must also add the following elements:
     * <code>DeleteMarkerReplication</code>, <code>Status</code>, and <code>Priority</code>.
     * </p>
     * <note>
     * <p>
     * If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete
     * markers differently. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations"
     * >Backward Compatibility</a>.
     * </p>
     * </note>
     * <p>
     * For information about enabling versioning on a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html">Using Versioning</a>.
     * </p>
     * <dl>
     * <dt>Handling Replication of Encrypted Objects</dt>
     * <dd>
     * <p>
     * By default, Amazon S3 doesn't replicate objects that are stored at rest using server-side encryption with KMS
     * keys. To replicate Amazon Web Services KMS-encrypted objects, add the following:
     * <code>SourceSelectionCriteria</code>, <code>SseKmsEncryptedObjects</code>, <code>Status</code>,
     * <code>EncryptionConfiguration</code>, and <code>ReplicaKmsKeyID</code>. For information about replication
     * configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-config-for-kms-objects.html">Replicating
     * Objects Created with SSE Using KMS keys</a>.
     * </p>
     * <p>
     * For information on <code>PutBucketReplication</code> errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList">List of
     * replication-related error codes</a>
     * </p>
     * </dd>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To create a <code>PutBucketReplication</code> request, you must have <code>s3:PutReplicationConfiguration</code>
     * permissions for the bucket.
     * </p>
     * <p>
     * By default, a resource owner, in this case the Amazon Web Services account that created the bucket, can perform
     * this operation. The resource owner can also grant others permissions to perform the operation. For more
     * information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a
     * Policy</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing
     * Access Permissions to Your Amazon S3 Resources</a>.
     * </p>
     * <note>
     * <p>
     * To perform this operation, the user or role performing the action must have the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">iam:PassRole</a> permission.
     * </p>
     * </note></dd>
     * </dl>
     * <p>
     * The following operations are related to <code>PutBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html">GetBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html">DeleteBucketReplication
     * </a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link PutBucketReplicationRequest#builder()}
     * </p>
     *
     * @param putBucketReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest.Builder} to create a request.
     * @return Result of the PutBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketReplication
     */
    default PutBucketReplicationResponse putBucketReplication(
            Consumer<PutBucketReplicationRequest.Builder> putBucketReplicationRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return putBucketReplication(PutBucketReplicationRequest.builder().applyMutation(putBucketReplicationRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the request payment configuration for a bucket. By default, the bucket owner pays for downloads from the
     * bucket. This configuration parameter enables the bucket owner (only) to specify that the person requesting the
     * download will be charged for the download. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketRequestPayment</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketRequestPayment.html">GetBucketRequestPayment
     * </a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketRequestPaymentRequest
     * @return Result of the PutBucketRequestPayment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketRequestPayment
     */
    default PutBucketRequestPaymentResponse putBucketRequestPayment(PutBucketRequestPaymentRequest putBucketRequestPaymentRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the request payment configuration for a bucket. By default, the bucket owner pays for downloads from the
     * bucket. This configuration parameter enables the bucket owner (only) to specify that the person requesting the
     * download will be charged for the download. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketRequestPayment</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketRequestPayment.html">GetBucketRequestPayment
     * </a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketRequestPaymentRequest.Builder} avoiding
     * the need to create one manually via {@link PutBucketRequestPaymentRequest#builder()}
     * </p>
     *
     * @param putBucketRequestPaymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest.Builder} to create a
     *        request.
     * @return Result of the PutBucketRequestPayment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketRequestPayment
     */
    default PutBucketRequestPaymentResponse putBucketRequestPayment(
            Consumer<PutBucketRequestPaymentRequest.Builder> putBucketRequestPaymentRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return putBucketRequestPayment(PutBucketRequestPaymentRequest.builder().applyMutation(putBucketRequestPaymentRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the tags for a bucket.
     * </p>
     * <p>
     * Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get
     * your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources,
     * organize your billing information according to resources with the same tag key values. For example, you can tag
     * several resources with a specific application name, and then organize your billing information to see the total
     * cost of that application across several services. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost Allocation and
     * Tagging</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html">Using Cost
     * Allocation in Amazon S3 Bucket Tags</a>.
     * </p>
     * <note>
     * <p>
     * When this operation sets the tags for a bucket, it will overwrite any current tags the bucket already has. You
     * cannot use this operation to add tags to an existing list of tags.
     * </p>
     * </note>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutBucketTagging</code> action. The
     * bucket owner has this permission by default and can grant this permission to others. For more information about
     * permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * <code>PutBucketTagging</code> has the following special errors. For more Amazon S3 errors see, <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>InvalidTag</code> - The tag provided was not a valid tag. This error can occur if the tag did not pass
     * input validation. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html">Using Cost Allocation in
     * Amazon S3 Bucket Tags</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MalformedXML</code> - The XML provided does not match the schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OperationAborted</code> - A conflicting conditional action is currently in progress against this resource.
     * Please try again.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InternalError</code> - The service was unable to apply the provided tag to the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following operations are related to <code>PutBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketTaggingRequest
     * @return Result of the PutBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketTagging
     */
    default PutBucketTaggingResponse putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the tags for a bucket.
     * </p>
     * <p>
     * Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get
     * your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources,
     * organize your billing information according to resources with the same tag key values. For example, you can tag
     * several resources with a specific application name, and then organize your billing information to see the total
     * cost of that application across several services. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost Allocation and
     * Tagging</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html">Using Cost
     * Allocation in Amazon S3 Bucket Tags</a>.
     * </p>
     * <note>
     * <p>
     * When this operation sets the tags for a bucket, it will overwrite any current tags the bucket already has. You
     * cannot use this operation to add tags to an existing list of tags.
     * </p>
     * </note>
     * <p>
     * To use this operation, you must have permissions to perform the <code>s3:PutBucketTagging</code> action. The
     * bucket owner has this permission by default and can grant this permission to others. For more information about
     * permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * <code>PutBucketTagging</code> has the following special errors. For more Amazon S3 errors see, <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>InvalidTag</code> - The tag provided was not a valid tag. This error can occur if the tag did not pass
     * input validation. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html">Using Cost Allocation in
     * Amazon S3 Bucket Tags</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MalformedXML</code> - The XML provided does not match the schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OperationAborted</code> - A conflicting conditional action is currently in progress against this resource.
     * Please try again.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InternalError</code> - The service was unable to apply the provided tag to the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following operations are related to <code>PutBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketTaggingRequest.Builder} avoiding the need
     * to create one manually via {@link PutBucketTaggingRequest#builder()}
     * </p>
     *
     * @param putBucketTaggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest.Builder} to create a request.
     * @return Result of the PutBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketTagging
     */
    default PutBucketTaggingResponse putBucketTagging(Consumer<PutBucketTaggingRequest.Builder> putBucketTaggingRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketTagging(PutBucketTaggingRequest.builder().applyMutation(putBucketTaggingRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note> <note>
     * <p>
     * When you enable versioning on a bucket for the first time, it might take a short amount of time for the change to
     * be fully propagated. We recommend that you wait for 15 minutes after enabling versioning before issuing write
     * operations (<code>PUT</code> or <code>DELETE</code>) on objects in the bucket.
     * </p>
     * </note>
     * <p>
     * Sets the versioning state of an existing bucket.
     * </p>
     * <p>
     * You can set the versioning state with one of the following values:
     * </p>
     * <p>
     * <b>Enabled</b>—Enables versioning for the objects in the bucket. All objects added to the bucket receive a unique
     * version ID.
     * </p>
     * <p>
     * <b>Suspended</b>—Disables versioning for the objects in the bucket. All objects added to the bucket receive the
     * version ID null.
     * </p>
     * <p>
     * If the versioning state has never been set on a bucket, it has no versioning state; a <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>
     * request does not return a versioning state value.
     * </p>
     * <p>
     * In order to enable MFA Delete, you must be the bucket owner. If you are the bucket owner and want to enable MFA
     * Delete in the bucket versioning configuration, you must include the <code>x-amz-mfa request</code> header and the
     * <code>Status</code> and the <code>MfaDelete</code> request elements in a request to set the versioning state of
     * the bucket.
     * </p>
     * <important>
     * <p>
     * If you have an object expiration lifecycle configuration in your non-versioned bucket and you want to maintain
     * the same permanent delete behavior when you enable versioning, you must add a noncurrent expiration policy. The
     * noncurrent expiration lifecycle configuration will manage the deletes of the noncurrent object versions in the
     * version-enabled bucket. (A version-enabled bucket maintains one current and zero or more noncurrent object
     * versions.) For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-and-other-bucket-config"
     * >Lifecycle and Versioning</a>.
     * </p>
     * </important>
     * <p>
     * The following operations are related to <code>PutBucketVersioning</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketVersioningRequest
     * @return Result of the PutBucketVersioning operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketVersioning
     */
    default PutBucketVersioningResponse putBucketVersioning(PutBucketVersioningRequest putBucketVersioningRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note> <note>
     * <p>
     * When you enable versioning on a bucket for the first time, it might take a short amount of time for the change to
     * be fully propagated. We recommend that you wait for 15 minutes after enabling versioning before issuing write
     * operations (<code>PUT</code> or <code>DELETE</code>) on objects in the bucket.
     * </p>
     * </note>
     * <p>
     * Sets the versioning state of an existing bucket.
     * </p>
     * <p>
     * You can set the versioning state with one of the following values:
     * </p>
     * <p>
     * <b>Enabled</b>—Enables versioning for the objects in the bucket. All objects added to the bucket receive a unique
     * version ID.
     * </p>
     * <p>
     * <b>Suspended</b>—Disables versioning for the objects in the bucket. All objects added to the bucket receive the
     * version ID null.
     * </p>
     * <p>
     * If the versioning state has never been set on a bucket, it has no versioning state; a <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>
     * request does not return a versioning state value.
     * </p>
     * <p>
     * In order to enable MFA Delete, you must be the bucket owner. If you are the bucket owner and want to enable MFA
     * Delete in the bucket versioning configuration, you must include the <code>x-amz-mfa request</code> header and the
     * <code>Status</code> and the <code>MfaDelete</code> request elements in a request to set the versioning state of
     * the bucket.
     * </p>
     * <important>
     * <p>
     * If you have an object expiration lifecycle configuration in your non-versioned bucket and you want to maintain
     * the same permanent delete behavior when you enable versioning, you must add a noncurrent expiration policy. The
     * noncurrent expiration lifecycle configuration will manage the deletes of the noncurrent object versions in the
     * version-enabled bucket. (A version-enabled bucket maintains one current and zero or more noncurrent object
     * versions.) For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-and-other-bucket-config"
     * >Lifecycle and Versioning</a>.
     * </p>
     * </important>
     * <p>
     * The following operations are related to <code>PutBucketVersioning</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketVersioningRequest.Builder} avoiding the
     * need to create one manually via {@link PutBucketVersioningRequest#builder()}
     * </p>
     *
     * @param putBucketVersioningRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest.Builder} to create a request.
     * @return Result of the PutBucketVersioning operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketVersioning
     */
    default PutBucketVersioningResponse putBucketVersioning(
            Consumer<PutBucketVersioningRequest.Builder> putBucketVersioningRequest) throws AwsServiceException,
            SdkClientException, S3Exception {
        return putBucketVersioning(PutBucketVersioningRequest.builder().applyMutation(putBucketVersioningRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the configuration of the website that is specified in the <code>website</code> subresource. To configure a
     * bucket as a website, you can add this subresource on the bucket with website configuration information such as
     * the file name of the index document and any redirect rules. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>.
     * </p>
     * <p>
     * This PUT action requires the <code>S3:PutBucketWebsite</code> permission. By default, only the bucket owner can
     * configure the website attached to a bucket; however, bucket owners can allow other users to set the website
     * configuration by writing a bucket policy that grants them the <code>S3:PutBucketWebsite</code> permission.
     * </p>
     * <p>
     * To redirect all website requests sent to the bucket's website endpoint, you add a website configuration with the
     * following elements. Because all requests are sent to another website, you don't need to provide index document
     * name for the bucket.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WebsiteConfiguration</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RedirectAllRequestsTo</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HostName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Protocol</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want granular control over redirects, you can use the following elements to add routing rules that
     * describe conditions for redirecting requests and information about the redirect destination. In this case, the
     * website configuration must provide an index document for the bucket, because some requests might not be
     * redirected.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WebsiteConfiguration</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IndexDocument</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Suffix</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ErrorDocument</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoutingRules</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoutingRule</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Condition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HttpErrorCodeReturnedEquals</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeyPrefixEquals</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redirect</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Protocol</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HostName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceKeyPrefixWith</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceKeyWith</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HttpRedirectCode</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon S3 has a limitation of 50 routing rules per website configuration. If you require more than 50 routing
     * rules, you can use object redirect. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">Configuring an Object
     * Redirect</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The maximum request length is limited to 128 KB.
     * </p>
     *
     * @param putBucketWebsiteRequest
     * @return Result of the PutBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketWebsite
     */
    default PutBucketWebsiteResponse putBucketWebsite(PutBucketWebsiteRequest putBucketWebsiteRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is not supported for directory buckets.
     * </p>
     * </note>
     * <p>
     * Sets the configuration of the website that is specified in the <code>website</code> subresource. To configure a
     * bucket as a website, you can add this subresource on the bucket with website configuration information such as
     * the file name of the index document and any redirect rules. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>.
     * </p>
     * <p>
     * This PUT action requires the <code>S3:PutBucketWebsite</code> permission. By default, only the bucket owner can
     * configure the website attached to a bucket; however, bucket owners can allow other users to set the website
     * configuration by writing a bucket policy that grants them the <code>S3:PutBucketWebsite</code> permission.
     * </p>
     * <p>
     * To redirect all website requests sent to the bucket's website endpoint, you add a website configuration with the
     * following elements. Because all requests are sent to another website, you don't need to provide index document
     * name for the bucket.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WebsiteConfiguration</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RedirectAllRequestsTo</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HostName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Protocol</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want granular control over redirects, you can use the following elements to add routing rules that
     * describe conditions for redirecting requests and information about the redirect destination. In this case, the
     * website configuration must provide an index document for the bucket, because some requests might not be
     * redirected.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WebsiteConfiguration</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IndexDocument</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Suffix</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ErrorDocument</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoutingRules</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoutingRule</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Condition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HttpErrorCodeReturnedEquals</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeyPrefixEquals</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redirect</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Protocol</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HostName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceKeyPrefixWith</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceKeyWith</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HttpRedirectCode</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon S3 has a limitation of 50 routing rules per website configuration. If you require more than 50 routing
     * rules, you can use object redirect. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">Configuring an Object
     * Redirect</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The maximum request length is limited to 128 KB.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBucketWebsiteRequest.Builder} avoiding the need
     * to create one manually via {@link PutBucketWebsiteRequest#builder()}
     * </p>
     *
     * @param putBucketWebsiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest.Builder} to create a request.
     * @return Result of the PutBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketWebsite
     */
    default PutBucketWebsiteResponse putBucketWebsite(Consumer<PutBucketWebsiteRequest.Builder> putBucketWebsiteRequest)
            throws AwsServiceException, SdkClientException, S3Exception {
        return putBucketWebsite(PutBucketWebsiteRequest.builder().applyMutation(putBucketWebsiteRequest).build());
    }

    /**
     * <p>
     * Adds an object to a bucket.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Amazon S3 never adds partial objects; if you receive a success response, Amazon S3 added the entire object to the
     * bucket. You cannot use <code>PutObject</code> to only update a single piece of metadata for an existing object.
     * You must put the entire object with updated metadata if you want to update some values.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your bucket uses the bucket owner enforced setting for Object Ownership, ACLs are disabled and no longer
     * affect permissions. All objects written to the bucket by any account will be owned by the bucket owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Amazon S3 is a distributed system. If it receives multiple write requests for the same object simultaneously, it
     * overwrites all but the last object written. However, Amazon S3 provides features that can modify this behavior:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>S3 Object Lock</b> - To prevent objects from being deleted or overwritten, you can use <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Amazon S3 Object Lock</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This functionality is not supported for directory buckets.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b>S3 Versioning</b> - When you enable versioning for a bucket, if Amazon S3 receives multiple write requests for
     * the same object simultaneously, it stores all versions of the objects. For each write request that is made to the
     * same object, Amazon S3 automatically generates a unique version ID of that object being stored in Amazon S3. You
     * can retrieve, replace, or delete any version of the object. For more information about versioning, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html">Adding
     * Objects to Versioning-Enabled Buckets</a> in the <i>Amazon S3 User Guide</i>. For information about returning the
     * versioning state of a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>.
     * </p>
     * <note>
     * <p>
     * This functionality is not supported for directory buckets.
     * </p>
     * </note></li>
     * </ul>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The following permissions are required in your policies when your
     * <code>PutObject</code> request includes specific headers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>s3:PutObject</code> </b> - To successfully complete the <code>PutObject</code> request, you must always
     * have the <code>s3:PutObject</code> permission on a bucket to add an object to it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:PutObjectAcl</code> </b> - To successfully change the objects ACL of your <code>PutObject</code>
     * request, you must have the <code>s3:PutObjectAcl</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:PutObjectTagging</code> </b> - To successfully set the tag-set with your <code>PutObject</code>
     * request, you must have the <code>s3:PutObjectTagging</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Data integrity with Content-MD5</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - To ensure that data is not corrupted traversing the network, use the
     * <code>Content-MD5</code> header. When you use this header, Amazon S3 checks the object against the provided MD5
     * value and, if they do not match, Amazon S3 returns an error. Alternatively, when the object's ETag is its MD5
     * digest, you can calculate the MD5 while putting the object to Amazon S3 and compare the returned ETag to the
     * calculated MD5 value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - This functionality is not supported for directory buckets.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For more information about related Amazon S3 APIs, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putObjectRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows '
     *        <p>
     *        Object data.
     *        </p>
     *        '
     * @return Result of the PutObject operation returned by the service.
     * @throws InvalidRequestException
     *         You may receive this error in multiple cases. Depending on the reason for the error, you may receive one
     *         of the messages below:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cannot specify both a write offset value and user-defined object metadata for existing objects.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Checksum Type mismatch occurred, expected checksum Type: sha1, actual checksum Type: crc32c.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Request body cannot be empty when 'write offset' is specified.
     *         </p>
     *         </li>
     * @throws InvalidWriteOffsetException
     *         The write offset value that you specified does not match the current object size.
     * @throws TooManyPartsException
     *         You have attempted to add more parts than the maximum of 10000 that are allowed for this object. You can
     *         use the CopyObject operation to copy this object to another and then add more data to the newly copied
     *         object.
     * @throws EncryptionTypeMismatchException
     *         The existing object was created with a different encryption type. Subsequent write requests must include
     *         the appropriate encryption parameters in the request or while creating the session.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObject
     */
    default PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody)
            throws InvalidRequestException, InvalidWriteOffsetException, TooManyPartsException, EncryptionTypeMismatchException,
            AwsServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an object to a bucket.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Amazon S3 never adds partial objects; if you receive a success response, Amazon S3 added the entire object to the
     * bucket. You cannot use <code>PutObject</code> to only update a single piece of metadata for an existing object.
     * You must put the entire object with updated metadata if you want to update some values.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your bucket uses the bucket owner enforced setting for Object Ownership, ACLs are disabled and no longer
     * affect permissions. All objects written to the bucket by any account will be owned by the bucket owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Amazon S3 is a distributed system. If it receives multiple write requests for the same object simultaneously, it
     * overwrites all but the last object written. However, Amazon S3 provides features that can modify this behavior:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>S3 Object Lock</b> - To prevent objects from being deleted or overwritten, you can use <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Amazon S3 Object Lock</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This functionality is not supported for directory buckets.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b>S3 Versioning</b> - When you enable versioning for a bucket, if Amazon S3 receives multiple write requests for
     * the same object simultaneously, it stores all versions of the objects. For each write request that is made to the
     * same object, Amazon S3 automatically generates a unique version ID of that object being stored in Amazon S3. You
     * can retrieve, replace, or delete any version of the object. For more information about versioning, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html">Adding
     * Objects to Versioning-Enabled Buckets</a> in the <i>Amazon S3 User Guide</i>. For information about returning the
     * versioning state of a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>.
     * </p>
     * <note>
     * <p>
     * This functionality is not supported for directory buckets.
     * </p>
     * </note></li>
     * </ul>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The following permissions are required in your policies when your
     * <code>PutObject</code> request includes specific headers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>s3:PutObject</code> </b> - To successfully complete the <code>PutObject</code> request, you must always
     * have the <code>s3:PutObject</code> permission on a bucket to add an object to it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:PutObjectAcl</code> </b> - To successfully change the objects ACL of your <code>PutObject</code>
     * request, you must have the <code>s3:PutObjectAcl</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:PutObjectTagging</code> </b> - To successfully set the tag-set with your <code>PutObject</code>
     * request, you must have the <code>s3:PutObjectTagging</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Data integrity with Content-MD5</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - To ensure that data is not corrupted traversing the network, use the
     * <code>Content-MD5</code> header. When you use this header, Amazon S3 checks the object against the provided MD5
     * value and, if they do not match, Amazon S3 returns an error. Alternatively, when the object's ETag is its MD5
     * digest, you can calculate the MD5 while putting the object to Amazon S3 and compare the returned ETag to the
     * calculated MD5 value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - This functionality is not supported for directory buckets.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For more information about related Amazon S3 APIs, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutObjectRequest.Builder} avoiding the need to
     * create one manually via {@link PutObjectRequest#builder()}
     * </p>
     *
     * @param putObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3.model.PutObjectRequest.Builder} to create a request.
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows '
     *        <p>
     *        Object data.
     *        </p>
     *        '
     * @return Result of the PutObject operation returned by the service.
     * @throws InvalidRequestException
     *         You may receive this error in multiple cases. Depending on the reason for the error, you may receive one
     *         of the messages below:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cannot specify both a write offset value and user-defined object metadata for existing objects.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Checksum Type mismatch occurred, expected checksum Type: sha1, actual checksum Type: crc32c.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Request body cannot be empty when 'write offset' is specified.
     *         </p>
     *         </li>
     * @throws InvalidWriteOffsetException
     *         The write offset value that you specified does not match the current object size.
     * @throws TooManyPartsException
     *         You have attempted to add more parts than the maximum of 10000 that are allowed for this object. You can
     *         use the CopyObject operation to copy this object to another and then add more data to the newly copied
     *         object.
     * @throws EncryptionTypeMismatchException
     *         The existing object was created with a different encryption type. Subsequent write requests must include
     *         the appropriate encryption parameters in the request or while creating the session.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObject
     */
    default PutObjectResponse putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, RequestBody requestBody)
            throws InvalidRequestException, InvalidWriteOffsetException, TooManyPartsException, EncryptionTypeMismatchException,
            AwsServiceException, SdkClientException, S3Exception {
        return putObject(PutObjectRequest.builder().applyMutation(putObjectRequest).build(), requestBody);
    }

    /**
     * <p>
     * Adds an object to a bucket.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Amazon S3 never adds partial objects; if you receive a success response, Amazon S3 added the entire object to the
     * bucket. You cannot use <code>PutObject</code> to only update a single piece of metadata for an existing object.
     * You must put the entire object with updated metadata if you want to update some values.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your bucket uses the bucket owner enforced setting for Object Ownership, ACLs are disabled and no longer
     * affect permissions. All objects written to the bucket by any account will be owned by the bucket owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Amazon S3 is a distributed system. If it receives multiple write requests for the same object simultaneously, it
     * overwrites all but the last object written. However, Amazon S3 provides features that can modify this behavior:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>S3 Object Lock</b> - To prevent objects from being deleted or overwritten, you can use <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Amazon S3 Object Lock</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This functionality is not supported for directory buckets.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b>S3 Versioning</b> - When you enable versioning for a bucket, if Amazon S3 receives multiple write requests for
     * the same object simultaneously, it stores all versions of the objects. For each write request that is made to the
     * same object, Amazon S3 automatically generates a unique version ID of that object being stored in Amazon S3. You
     * can retrieve, replace, or delete any version of the object. For more information about versioning, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html">Adding
     * Objects to Versioning-Enabled Buckets</a> in the <i>Amazon S3 User Guide</i>. For information about returning the
     * versioning state of a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>.
     * </p>
     * <note>
     * <p>
     * This functionality is not supported for directory buckets.
     * </p>
     * </note></li>
     * </ul>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The following permissions are required in your policies when your
     * <code>PutObject</code> request includes specific headers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>s3:PutObject</code> </b> - To successfully complete the <code>PutObject</code> request, you must always
     * have the <code>s3:PutObject</code> permission on a bucket to add an object to it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:PutObjectAcl</code> </b> - To successfully change the objects ACL of your <code>PutObject</code>
     * request, you must have the <code>s3:PutObjectAcl</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:PutObjectTagging</code> </b> - To successfully set the tag-set with your <code>PutObject</code>
     * request, you must have the <code>s3:PutObjectTagging</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Data integrity with Content-MD5</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - To ensure that data is not corrupted traversing the network, use the
     * <code>Content-MD5</code> header. When you use this header, Amazon S3 checks the object against the provided MD5
     * value and, if they do not match, Amazon S3 returns an error. Alternatively, when the object's ETag is its MD5
     * digest, you can calculate the MD5 while putting the object to Amazon S3 and compare the returned ETag to the
     * calculated MD5 value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket</b> - This functionality is not supported for directory buckets.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>HTTP Host header syntax</dt>
     * <dd>
     * <p>
     * <b>Directory buckets </b> - The HTTP Host header syntax is
     * <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For more information about related Amazon S3 APIs, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putObjectRequest
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        Object data.
     *        </p>
     *        '
     * @return Result of the PutObject operation returned by the service.
     * @throws InvalidRequestException
     *         You may receive this error in multiple cases. Depending on the reason for the error, you may receive one
     *         of the messages below:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cannot specify both a write offset value and user-defined object metadata for existing objects.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Checksum Type mismatch occurred, expected checksum Type: sha1, actual checksum Type: crc32c.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Request body cannot be empty when 'write offset' is specified.
     *         </p>
     *         </li>
     * @throws InvalidWriteOffsetException
     *         The write offset value that you specified does not match the current object size.
     * @throws TooManyPartsException
     *         You have attempted to add more parts than the maximum of 10000 that are allowed for this object. You can
     *         use the CopyObject operation to copy this object to another and then add more data to the newly copied
     *         object.
     * @throws EncryptionTypeMismatchException
     *         The existing object was created with a different encryption type. Subsequent write requests must include
     *         the appropriate encryption parameters in the request or while creating the session.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObject
     * @see #putObject(PutObjectRequest, RequestBody)
     */
    default PutObjectResponse putObject(PutObjectRequest putObjectRequest, Path sourcePath) throws InvalidRequestException,
            InvalidWriteOffsetException, TooManyPartsException, EncryptionTypeMismatchException, AwsServiceException,
            SdkClientException, S3Exception {
        return putObject(putObjectRequest, RequestBody.fromFile(sourcePath));
    }

    /**
     * <p>
     * Adds an object to a bucket.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Amazon S3 never adds partial objects; if you receive a success response, Amazon S3 added the entire object to the
     * bucket. You cannot use <code>PutObject</code> to only update a single piece of metadata for an existing object.
     * You must put the entire object with updated metadata if you want to update some values.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your bucket uses the bucket owner enforced setting for Object Ownership, ACLs are disabled and no longer
     * affect permissions. All objects written to the bucket by any account will be owned by the bucket owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Directory buckets</b> - For directory buckets, you must make requests for this API operation to the Zonal
     * endpoint. These endpoints support virtual-hosted-style requests in the format
     * <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>.
     * Path-style requests are not supported. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal
     * endpoints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Amazon S3 is a distributed system. If it receives multiple write requests for the same object simultaneously, it
     * overwrites all but the last object written. However, Amazon S3 provides features that can modify this behavior:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>S3 Object Lock</b> - To prevent objects from being deleted or overwritten, you can use <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Amazon S3 Object Lock</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This functionality is not supported for directory buckets.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b>S3 Versioning</b> - When you enable versioning for a bucket, if Amazon S3 receives multiple write requests for
     * the same object simultaneously, it stores all versions of the objects. For each write request that is made to the
     * same object, Amazon S3 automatically generates a unique version ID of that object being stored in Amazon S3. You
     * can retrieve, replace, or delete any version of the object. For more information about versioning, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html">Adding
     * Objects to Versioning-Enabled Buckets</a> in the <i>Amazon S3 User Guide</i>. For information about returning the
     * versioning state of a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>.
     * </p>
     * <note>
     * <p>
     * This functionality is not supported for directory buckets.
     * </p>
     * </note></li>
     * </ul>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket permissions</b> - The following permissions are required in your policies when your
     * <code>PutObject</code> request includes specific headers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>s3:PutObject</code> </b> - To successfully complete the <code>PutObject</code> request, you must always
     * have the <code>s3:PutObject</code> permission on a bucket to add an object to it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:PutObjectAcl</code> </b> - To successfully change the objects ACL of your <code>PutObject</code>
     * request, you must have the <code>s3:PutObjectAcl</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>s3:PutObjectTagging</code> </b> - To successfully set the tag-set with your <code>PutObject</code>
     * request, you must have the <code>s3:PutObjectTagging</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend
     * that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html">
     * <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the
     * <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM
     * identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session
     * token. With the session token in your request header, you can make API requests to this operation. After the
     * session token expires, you make another <code>CreateSession</code> API call to generate a new session token for
     * use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service
     * interruptions when a session expires. For more information about authorization, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.
     * </p>
     * <p>
     * If the object is encrypted with SSE-KMS, you must also have the <code>kms:GenerateDataKey</code> and
     * <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Data integrity with Content-MD5</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <b>General purpose bucket</b> - To ensure that data is not corrupted traversing the network, use the
     * <code>Content-MD5</code> header. When you use this header, Amazon S3 checks the object against the provided MD5
     * value and, if they do not match, Amazon S3