/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.listener.PublisherListener;
import software.amazon.awssdk.services.s3.internal.multipart.CancelledSubscriber;
import software.amazon.awssdk.services.s3.internal.multipart.MpuRequestContext;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartUploadHelper;
import software.amazon.awssdk.services.s3.internal.multipart.SdkPojoConversionUtils;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.multipart.S3MultipartExecutionAttribute;
import software.amazon.awssdk.services.s3.multipart.S3ResumeToken;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class KnownContentLengthAsyncRequestBodySubscriber
implements Subscriber<AsyncRequestBody> {
    private static final Logger log = Logger.loggerFor(KnownContentLengthAsyncRequestBodySubscriber.class);
    private final AtomicInteger asyncRequestBodyInFlight = new AtomicInteger(0);
    private final AtomicBoolean failureActionInitiated = new AtomicBoolean(false);
    private final AtomicInteger partNumber = new AtomicInteger(1);
    private final MultipartUploadHelper multipartUploadHelper;
    private final long partSize;
    private final int partCount;
    private final int numExistingParts;
    private final String uploadId;
    private final Collection<CompletableFuture<CompletedPart>> futures = new ConcurrentLinkedQueue<CompletableFuture<CompletedPart>>();
    private final PutObjectRequest putObjectRequest;
    private final CompletableFuture<PutObjectResponse> returnFuture;
    private final AtomicReferenceArray<CompletedPart> completedParts;
    private final Map<Integer, CompletedPart> existingParts;
    private final PublisherListener<Long> progressListener;
    private Subscription subscription;
    private volatile boolean isDone;
    private volatile boolean isPaused;
    private final AtomicBoolean completedMultipartInitiated = new AtomicBoolean(false);
    private volatile CompletableFuture<CompleteMultipartUploadResponse> completeMpuFuture;

    KnownContentLengthAsyncRequestBodySubscriber(MpuRequestContext mpuRequestContext, CompletableFuture<PutObjectResponse> returnFuture, MultipartUploadHelper multipartUploadHelper) {
        this.partSize = mpuRequestContext.partSize();
        this.partCount = this.determinePartCount(mpuRequestContext.contentLength(), this.partSize);
        this.putObjectRequest = (PutObjectRequest)((Object)mpuRequestContext.request().left());
        this.returnFuture = returnFuture;
        this.uploadId = mpuRequestContext.uploadId();
        this.existingParts = mpuRequestContext.existingParts() == null ? new HashMap() : mpuRequestContext.existingParts();
        this.numExistingParts = NumericUtils.saturatedCast((long)mpuRequestContext.numPartsCompleted());
        this.completedParts = new AtomicReferenceArray(this.partCount);
        this.multipartUploadHelper = multipartUploadHelper;
        this.progressListener = this.putObjectRequest.overrideConfiguration().map(c -> (PublisherListener)c.executionAttributes().getAttribute(S3MultipartExecutionAttribute.JAVA_PROGRESS_LISTENER)).orElseGet(PublisherListener::noOp);
    }

    private int determinePartCount(long contentLength, long partSize) {
        return (int)Math.ceil((double)contentLength / (double)partSize);
    }

    public S3ResumeToken pause() {
        this.isPaused = true;
        if (this.completeMpuFuture != null && this.completeMpuFuture.isDone()) {
            return null;
        }
        if (this.completeMpuFuture != null && !this.completeMpuFuture.isDone()) {
            this.completeMpuFuture.cancel(true);
        }
        long numPartsCompleted = 0L;
        for (CompletableFuture<CompletedPart> cf : this.futures) {
            if (!cf.isDone()) {
                cf.cancel(true);
                continue;
            }
            ++numPartsCompleted;
        }
        return S3ResumeToken.builder().uploadId(this.uploadId).partSize(this.partSize).totalNumParts(Long.valueOf(this.partCount)).numPartsCompleted(numPartsCompleted + (long)this.numExistingParts).build();
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription != null) {
            log.warn(() -> "The subscriber has already been subscribed. Cancelling the incoming subscription");
            this.subscription.cancel();
            return;
        }
        this.subscription = s;
        s.request(1L);
        this.returnFuture.whenComplete((r, t) -> {
            if (t != null) {
                s.cancel();
                if (this.shouldFailRequest()) {
                    this.multipartUploadHelper.failRequestsElegantly(this.futures, (Throwable)t, this.uploadId, this.returnFuture, this.putObjectRequest);
                }
            }
        });
    }

    public void onNext(AsyncRequestBody asyncRequestBody) {
        if (this.isPaused) {
            return;
        }
        if (this.existingParts.containsKey(this.partNumber.get())) {
            this.partNumber.getAndIncrement();
            asyncRequestBody.subscribe(new CancelledSubscriber());
            this.subscription.request(1L);
            asyncRequestBody.contentLength().ifPresent(arg_0 -> this.progressListener.subscriberOnNext(arg_0));
            return;
        }
        this.asyncRequestBodyInFlight.incrementAndGet();
        UploadPartRequest uploadRequest = SdkPojoConversionUtils.toUploadPartRequest(this.putObjectRequest, this.partNumber.getAndIncrement(), this.uploadId);
        Consumer<CompletedPart> completedPartConsumer = completedPart -> this.completedParts.set(completedPart.partNumber() - 1, (CompletedPart)completedPart);
        this.multipartUploadHelper.sendIndividualUploadPartRequest(this.uploadId, completedPartConsumer, this.futures, (Pair<UploadPartRequest, AsyncRequestBody>)Pair.of((Object)((Object)uploadRequest), (Object)asyncRequestBody), this.progressListener).whenComplete((r, t) -> {
            if (t != null) {
                if (this.shouldFailRequest()) {
                    this.multipartUploadHelper.failRequestsElegantly(this.futures, (Throwable)t, this.uploadId, this.returnFuture, this.putObjectRequest);
                }
            } else {
                this.completeMultipartUploadIfFinished(this.asyncRequestBodyInFlight.decrementAndGet());
            }
        });
        this.subscription.request(1L);
    }

    private boolean shouldFailRequest() {
        return this.failureActionInitiated.compareAndSet(false, true) && !this.isPaused;
    }

    public void onError(Throwable t) {
        log.debug(() -> "Received onError ", t);
        if (this.failureActionInitiated.compareAndSet(false, true)) {
            this.multipartUploadHelper.failRequestsElegantly(this.futures, t, this.uploadId, this.returnFuture, this.putObjectRequest);
        }
    }

    public void onComplete() {
        log.debug(() -> "Received onComplete()");
        this.isDone = true;
        if (!this.isPaused) {
            this.completeMultipartUploadIfFinished(this.asyncRequestBodyInFlight.get());
        }
    }

    private void completeMultipartUploadIfFinished(int requestsInFlight) {
        if (this.isDone && requestsInFlight == 0 && this.completedMultipartInitiated.compareAndSet(false, true)) {
            CompletedPart[] parts = this.existingParts.isEmpty() ? (CompletedPart[])IntStream.range(0, this.completedParts.length()).mapToObj(this.completedParts::get).toArray(CompletedPart[]::new) : this.mergeCompletedParts();
            this.completeMpuFuture = this.multipartUploadHelper.completeMultipartUpload(this.returnFuture, this.uploadId, parts, this.putObjectRequest);
        }
    }

    private CompletedPart[] mergeCompletedParts() {
        CompletedPart[] merged = new CompletedPart[this.partCount];
        for (int currPart = 1; currPart < this.partCount + 1; ++currPart) {
            CompletedPart completedPart;
            merged[currPart - 1] = completedPart = this.existingParts.containsKey(currPart) ? this.existingParts.get(currPart) : this.completedParts.get(currPart - 1);
        }
        return merged;
    }
}

