/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.listener.PublisherListener;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.s3.S3FinishedResponseContext;
import software.amazon.awssdk.crt.s3.S3MetaRequestProgress;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandler;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.services.s3.internal.crt.S3MetaRequestWrapper;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public final class S3CrtResponseHandlerAdapter
implements S3MetaRequestResponseHandler {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(S3CrtResponseHandlerAdapter.class);
    private final CompletableFuture<Void> resultFuture;
    private final SdkAsyncHttpResponseHandler responseHandler;
    private final SimplePublisher<ByteBuffer> responsePublisher = new SimplePublisher();
    private final SdkHttpResponse.Builder initialHeadersResponse = SdkHttpResponse.builder();
    private final CompletableFuture<S3MetaRequestWrapper> metaRequestFuture;
    private final PublisherListener<S3MetaRequestProgress> progressListener;
    private volatile boolean responseHandlingInitiated;

    public S3CrtResponseHandlerAdapter(CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler, PublisherListener<S3MetaRequestProgress> progressListener, CompletableFuture<S3MetaRequestWrapper> metaRequestFuture) {
        this.resultFuture = executeFuture;
        this.metaRequestFuture = metaRequestFuture;
        this.resultFuture.whenComplete((r, t) -> {
            S3MetaRequestWrapper s3MetaRequest = this.s3MetaRequest();
            if (s3MetaRequest == null) {
                return;
            }
            if (t != null) {
                s3MetaRequest.cancel();
            }
            s3MetaRequest.close();
        });
        this.responseHandler = responseHandler;
        this.progressListener = progressListener == null ? new NoOpPublisherListener() : progressListener;
    }

    private S3MetaRequestWrapper s3MetaRequest() {
        if (!this.metaRequestFuture.isDone()) {
            return null;
        }
        return this.metaRequestFuture.join();
    }

    public void onResponseHeaders(int statusCode, HttpHeader[] headers) {
        S3CrtResponseHandlerAdapter.populateSdkHttpResponse(this.initialHeadersResponse, statusCode, headers);
    }

    public int onResponseBody(ByteBuffer bodyBytesIn, long objectRangeStart, long objectRangeEnd) {
        this.initiateResponseHandling((SdkHttpResponse)this.initialHeadersResponse.build());
        if (bodyBytesIn == null) {
            this.failResponseHandlerAndFuture(new IllegalStateException("ByteBuffer delivered is null"));
            return 0;
        }
        int bytesReceived = bodyBytesIn.remaining();
        CompletableFuture writeFuture = this.responsePublisher.send((Object)bodyBytesIn);
        writeFuture.whenComplete((result, failure) -> {
            if (failure != null) {
                this.failResponseHandlerAndFuture((Throwable)failure);
                return;
            }
            S3MetaRequestWrapper metaRequest = this.s3MetaRequest();
            if (metaRequest == null) {
                this.failResponseHandlerAndFuture((Throwable)SdkClientException.create((String)"Unexpected exception occurred: s3metaRequest is not initialized yet"));
                return;
            }
            metaRequest.incrementReadWindow(bytesReceived);
        });
        return 0;
    }

    public void onFinished(S3FinishedResponseContext context) {
        int crtCode = context.getErrorCode();
        if (crtCode != 0) {
            this.handleError(context);
        } else {
            this.initiateResponseHandling((SdkHttpResponse)this.initialHeadersResponse.build());
            this.onSuccessfulResponseComplete();
        }
    }

    private void onSuccessfulResponseComplete() {
        this.responsePublisher.complete().whenComplete((result, failure) -> {
            if (failure != null) {
                this.failResponseHandlerAndFuture((Throwable)failure);
                return;
            }
            this.progressListener.subscriberOnComplete();
            this.resultFuture.complete(null);
        });
    }

    private void handleError(S3FinishedResponseContext context) {
        int crtCode = context.getErrorCode();
        HttpHeader[] headers = context.getErrorHeaders();
        int responseStatus = context.getResponseStatus();
        byte[] errorPayload = context.getErrorPayload();
        if (S3CrtResponseHandlerAdapter.isErrorResponse(responseStatus) && errorPayload != null) {
            SdkHttpResponse.Builder errorResponse = S3CrtResponseHandlerAdapter.populateSdkHttpResponse((SdkHttpResponse.Builder)SdkHttpResponse.builder(), responseStatus, headers);
            this.initiateResponseHandling((SdkHttpResponse)errorResponse.build());
            this.onErrorResponseComplete(errorPayload);
        } else {
            Throwable cause = context.getCause();
            SdkClientException sdkClientException = SdkClientException.create((String)("Failed to send the request: " + CRT.awsErrorString((int)crtCode)), (Throwable)cause);
            this.failResponseHandlerAndFuture((Throwable)sdkClientException);
        }
    }

    private void initiateResponseHandling(SdkHttpResponse response) {
        if (!this.responseHandlingInitiated) {
            this.responseHandlingInitiated = true;
            this.responseHandler.onHeaders(response);
            this.responseHandler.onStream(this.responsePublisher);
        }
    }

    private void onErrorResponseComplete(byte[] errorPayload) {
        ((CompletableFuture)this.responsePublisher.send((Object)ByteBuffer.wrap(errorPayload)).thenRun(() -> this.responsePublisher.complete())).handle((ignore, throwable) -> {
            if (throwable != null) {
                this.failResponseHandlerAndFuture((Throwable)throwable);
                return null;
            }
            this.resultFuture.complete(null);
            return null;
        });
    }

    private void failResponseHandlerAndFuture(Throwable exception) {
        FunctionalUtils.runAndLogError((Logger)log.logger(), (String)"Exception thrown in SdkAsyncHttpResponseHandler#onError, ignoring", () -> this.responseHandler.onError(exception));
        this.resultFuture.completeExceptionally(exception);
    }

    private static boolean isErrorResponse(int responseStatus) {
        return responseStatus != 0;
    }

    public void onProgress(S3MetaRequestProgress progress) {
        this.progressListener.subscriberOnNext((Object)progress);
    }

    private static SdkHttpResponse.Builder populateSdkHttpResponse(SdkHttpResponse.Builder respBuilder, int statusCode, HttpHeader[] headers) {
        if (headers != null) {
            for (HttpHeader h : headers) {
                respBuilder.appendHeader(h.getName(), h.getValue());
            }
        }
        respBuilder.statusCode(statusCode);
        return respBuilder;
    }

    private static class NoOpPublisherListener
    implements PublisherListener<S3MetaRequestProgress> {
        private NoOpPublisherListener() {
        }
    }
}

