/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeParams;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;
import software.amazon.awssdk.services.s3.auth.scheme.internal.ModeledS3AuthSchemeProvider;
import software.amazon.awssdk.services.s3.auth.scheme.internal.S3EndpointResolverAware;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointParams;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;
import software.amazon.awssdk.services.s3.endpoints.authscheme.S3ExpressEndpointAuthScheme;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3AuthSchemeProvider
implements S3AuthSchemeProvider {
    private static final DefaultS3AuthSchemeProvider DEFAULT = new DefaultS3AuthSchemeProvider();
    private static final S3AuthSchemeProvider MODELED_RESOLVER = ModeledS3AuthSchemeProvider.create();
    private static final S3EndpointProvider DELEGATE = S3EndpointProvider.defaultProvider();

    private DefaultS3AuthSchemeProvider() {
    }

    public static S3AuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(S3AuthSchemeParams params) {
        S3EndpointParams endpointParameters = S3EndpointParams.builder().bucket(params.bucket()).region(params.region()).useFips(params.useFips()).useDualStack(params.useDualStack()).endpoint(params.endpoint()).forcePathStyle(params.forcePathStyle()).accelerate(params.accelerate()).useGlobalEndpoint(params.useGlobalEndpoint()).useObjectLambdaEndpoint(params.useObjectLambdaEndpoint()).key(params.key()).prefix(params.prefix()).disableAccessPoints(params.disableAccessPoints()).disableMultiRegionAccessPoints(params.disableMultiRegionAccessPoints()).useArnRegion(params.useArnRegion()).useS3ExpressControlEndpoint(params.useS3ExpressControlEndpoint()).disableS3ExpressSessionAuth(params.disableS3ExpressSessionAuth()).build();
        Endpoint endpoint = (Endpoint)CompletableFutureUtils.joinLikeSync(this.endpointProvider(params).resolveEndpoint(endpointParameters));
        List authSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
        if (authSchemes == null) {
            return MODELED_RESOLVER.resolveAuthScheme(params);
        }
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        block10: for (EndpointAuthScheme authScheme : authSchemes) {
            String name;
            switch (name = authScheme.name()) {
                case "sigv4": {
                    SigV4AuthScheme sigv4AuthScheme = (SigV4AuthScheme)Validate.isInstanceOf(SigV4AuthScheme.class, (Object)authScheme, (String)"Expecting auth scheme of class SigV4AuthScheme, got instead object of class %s", (Object[])new Object[]{authScheme.getClass().getName()});
                    options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)sigv4AuthScheme.signingName()).putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)sigv4AuthScheme.signingRegion()).putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!sigv4AuthScheme.disableDoubleEncoding() ? 1 : 0)).build());
                    continue block10;
                }
                case "sigv4a": {
                    SigV4aAuthScheme sigv4aAuthScheme = (SigV4aAuthScheme)Validate.isInstanceOf(SigV4aAuthScheme.class, (Object)authScheme, (String)"Expecting auth scheme of class SigV4AuthScheme, got instead object of class %s", (Object[])new Object[]{authScheme.getClass().getName()});
                    RegionSet regionSet = RegionSet.create((Collection)sigv4aAuthScheme.signingRegionSet());
                    options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4a").putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)sigv4aAuthScheme.signingName()).putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet).putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!sigv4aAuthScheme.disableDoubleEncoding() ? 1 : 0)).build());
                    continue block10;
                }
                case "sigv4-s3express": {
                    S3ExpressEndpointAuthScheme s3ExpressAuthScheme = (S3ExpressEndpointAuthScheme)Validate.isInstanceOf(S3ExpressEndpointAuthScheme.class, (Object)authScheme, (String)"Expecting auth scheme of class S3ExpressAuthScheme, got instead object of class %s", (Object[])new Object[]{authScheme.getClass().getName()});
                    options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4-s3express").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)s3ExpressAuthScheme.signingName()).putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)s3ExpressAuthScheme.signingRegion()).putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!s3ExpressAuthScheme.disableDoubleEncoding() ? 1 : 0)).build());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unknown auth scheme: " + name);
        }
        return Collections.unmodifiableList(options);
    }

    private S3EndpointProvider endpointProvider(S3AuthSchemeParams params) {
        S3EndpointResolverAware endpointAwareParams;
        S3EndpointProvider endpointProvider;
        if (params instanceof S3EndpointResolverAware && (endpointProvider = (endpointAwareParams = (S3EndpointResolverAware)((Object)params)).endpointProvider()) != null) {
            return endpointProvider;
        }
        return DELEGATE;
    }
}

