/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import java.time.Duration;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.internal.s3express.CachedS3ExpressCredentials;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressIdentityKey;
import software.amazon.awssdk.services.s3.model.CreateSessionRequest;
import software.amazon.awssdk.services.s3.model.SessionCredentials;
import software.amazon.awssdk.services.s3.model.SessionMode;
import software.amazon.awssdk.services.s3.s3express.S3ExpressSessionCredentials;
import software.amazon.awssdk.utils.cache.lru.LruCache;

@SdkInternalApi
public class S3ExpressIdentityCache {
    private static final Integer DEFAULT_LRU_CACHE_SIZE = 25;
    private static final Duration DEFAULT_API_CALL_TIMEOUT = Duration.ofSeconds(10L);
    private final LruCache<S3ExpressIdentityKey, CachedS3ExpressCredentials> cache = this.initCache();

    private S3ExpressIdentityCache() {
    }

    public static S3ExpressIdentityCache create() {
        return new S3ExpressIdentityCache();
    }

    public S3ExpressSessionCredentials get(S3ExpressIdentityKey key) {
        CachedS3ExpressCredentials cachedCredentials = (CachedS3ExpressCredentials)this.cache.get((Object)key);
        return S3ExpressSessionCredentials.fromSessionResponse(cachedCredentials.get());
    }

    private LruCache<S3ExpressIdentityKey, CachedS3ExpressCredentials> initCache() {
        return LruCache.builder(this::getCachedCredentials).maxSize(DEFAULT_LRU_CACHE_SIZE).build();
    }

    private CachedS3ExpressCredentials getCachedCredentials(S3ExpressIdentityKey key) {
        AwsCredentials credentialsIdentity = CredentialUtils.toCredentials((AwsCredentialsIdentity)key.identity());
        StaticCredentialsProvider resolvedCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentialsIdentity);
        return CachedS3ExpressCredentials.builder(k -> this.getCredentials((S3ExpressIdentityKey)k, (IdentityProvider<AwsCredentialsIdentity>)resolvedCredentialsProvider)).key(key).build();
    }

    SessionCredentials getCredentials(S3ExpressIdentityKey key, IdentityProvider<AwsCredentialsIdentity> provider) {
        SdkClient client = key.client();
        String bucket = key.bucket();
        if (client instanceof S3AsyncClient) {
            return ((S3AsyncClient)client).createSession(S3ExpressIdentityCache.createSessionRequest(bucket, provider)).join().credentials();
        }
        if (client instanceof S3Client) {
            return ((S3Client)client).createSession(S3ExpressIdentityCache.createSessionRequest(bucket, provider)).credentials();
        }
        throw new UnsupportedOperationException("SdkClient must be either an S3Client or an S3AsyncClient, but was " + client.getClass());
    }

    private static Consumer<CreateSessionRequest.Builder> createSessionRequest(String bucket, IdentityProvider<AwsCredentialsIdentity> provider) {
        return r -> r.bucket(bucket).sessionMode(SessionMode.READ_WRITE).overrideConfiguration(o -> o.credentialsProvider(provider).apiCallTimeout(DEFAULT_API_CALL_TIMEOUT));
    }
}

