/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.defaultsmode.DefaultsMode;
import software.amazon.awssdk.awscore.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.awscore.endpoint.DualstackEnabledProvider;
import software.amazon.awssdk.awscore.endpoint.FipsEnabledProvider;
import software.amazon.awssdk.awscore.internal.defaultsmode.DefaultsModeConfiguration;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.PathMarshaller;
import software.amazon.awssdk.protocols.core.ProtocolUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadataAdvancedOption;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.endpoints.S3ClientContextParams;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;
import software.amazon.awssdk.services.s3.endpoints.internal.S3RequestSetEndpointInterceptor;
import software.amazon.awssdk.services.s3.endpoints.internal.S3ResolveEndpointInterceptor;
import software.amazon.awssdk.services.s3.internal.endpoints.UseGlobalEndpointResolver;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.Validate;

@Immutable
@SdkPublicApi
public final class S3Utilities {
    private static final String SERVICE_NAME = "s3";
    private final Region region;
    private final URI endpoint;
    private final S3Configuration s3Configuration;
    private final Supplier<ProfileFile> profileFile;
    private final String profileName;
    private final boolean fipsEnabled;
    private final ExecutionInterceptorChain interceptorChain;
    private final UseGlobalEndpointResolver useGlobalEndpointResolver;

    private S3Utilities(Builder builder) {
        this.region = (Region)Validate.paramNotNull((Object)builder.region, (String)"Region");
        this.endpoint = builder.endpoint;
        this.profileFile = builder.profileFile != null ? () -> builder.profileFile : () -> ((Lazy)new Lazy(ProfileFile::defaultProfileFile)).getValue();
        this.profileName = builder.profileName;
        this.s3Configuration = builder.s3Configuration == null ? (S3Configuration)S3Configuration.builder().dualstackEnabled(builder.dualstackEnabled).build() : (S3Configuration)((S3Configuration.Builder)builder.s3Configuration.toBuilder().applyMutation(b -> this.resolveDualstackSetting((S3Configuration.Builder)b, builder))).build();
        this.fipsEnabled = builder.fipsEnabled != null ? builder.fipsEnabled.booleanValue() : FipsEnabledProvider.builder().profileFile(this.profileFile).profileName(this.profileName).build().isFipsEnabled().orElse(false).booleanValue();
        this.interceptorChain = this.createEndpointInterceptorChain();
        this.useGlobalEndpointResolver = this.createUseGlobalEndpointResolver();
    }

    private void resolveDualstackSetting(S3Configuration.Builder s3ConfigBuilder, Builder s3UtiltiesBuilder) {
        Validate.validState((s3ConfigBuilder.dualstackEnabled() == null || s3UtiltiesBuilder.dualstackEnabled == null ? 1 : 0) != 0, (String)"Only one of S3Configuration.Builder's dualstackEnabled or S3Utilities.Builder's dualstackEnabled should be set.", (Object[])new Object[0]);
        if (s3ConfigBuilder.dualstackEnabled() != null) {
            return;
        }
        if (s3UtiltiesBuilder.dualstackEnabled != null) {
            s3ConfigBuilder.dualstackEnabled(s3UtiltiesBuilder.dualstackEnabled);
            return;
        }
        s3ConfigBuilder.dualstackEnabled(DualstackEnabledProvider.builder().profileFile(this.profileFile).profileName(this.profileName).build().isDualstackEnabled().orElse(false));
    }

    public static Builder builder() {
        return new Builder();
    }

    @SdkInternalApi
    static S3Utilities create(SdkClientConfiguration clientConfiguration) {
        Builder builder = S3Utilities.builder().region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).s3Configuration((S3Configuration)clientConfiguration.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION)).profileFile((ProfileFile)clientConfiguration.option((ClientOption)SdkClientOption.PROFILE_FILE)).profileName((String)clientConfiguration.option((ClientOption)SdkClientOption.PROFILE_NAME));
        if (Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            builder.endpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT));
        }
        return builder.build();
    }

    public URL getUrl(Consumer<GetUrlRequest.Builder> getUrlRequest) {
        return this.getUrl((GetUrlRequest)((GetUrlRequest.Builder)GetUrlRequest.builder().applyMutation(getUrlRequest)).build());
    }

    public URL getUrl(GetUrlRequest getUrlRequest) {
        Region resolvedRegion = this.resolveRegionForGetUrl(getUrlRequest);
        URI endpointOverride = this.getEndpointOverride(getUrlRequest);
        URI resolvedEndpoint = this.resolveEndpoint(endpointOverride, resolvedRegion);
        SdkHttpFullRequest marshalledRequest = this.createMarshalledRequest(getUrlRequest, resolvedEndpoint);
        GetObjectRequest getObjectRequest = (GetObjectRequest)((Object)GetObjectRequest.builder().bucket(getUrlRequest.bucket()).key(getUrlRequest.key()).versionId(getUrlRequest.versionId()).build());
        InterceptorContext interceptorContext = InterceptorContext.builder().httpRequest((SdkHttpRequest)marshalledRequest).request((SdkRequest)getObjectRequest).build();
        ExecutionAttributes executionAttributes = this.createExecutionAttributes(resolvedEndpoint, resolvedRegion, endpointOverride != null);
        SdkHttpRequest modifiedRequest = this.runInterceptors(interceptorContext, executionAttributes).httpRequest();
        try {
            return modifiedRequest.getUri().toURL();
        }
        catch (MalformedURLException exception) {
            throw SdkException.create((String)("Generated URI is malformed: " + modifiedRequest.getUri()), (Throwable)exception);
        }
    }

    private Region resolveRegionForGetUrl(GetUrlRequest getUrlRequest) {
        if (getUrlRequest.region() == null && this.region == null) {
            throw new IllegalArgumentException("Region should be provided either in GetUrlRequest object or S3Utilities object");
        }
        return getUrlRequest.region() != null ? getUrlRequest.region() : this.region;
    }

    private URI resolveEndpoint(URI overrideEndpoint, Region region) {
        return overrideEndpoint != null ? overrideEndpoint : new DefaultServiceEndpointBuilder(SERVICE_NAME, "https").withRegion(region).withProfileFile(this.profileFile).withProfileName(this.profileName).withDualstackEnabled(Boolean.valueOf(this.s3Configuration.dualstackEnabled())).withFipsEnabled(Boolean.valueOf(this.fipsEnabled)).getServiceEndpoint();
    }

    private URI getEndpointOverride(GetUrlRequest request) {
        URI requestOverrideEndpoint = request.endpoint();
        return requestOverrideEndpoint != null ? requestOverrideEndpoint : this.endpoint;
    }

    private SdkHttpFullRequest createMarshalledRequest(GetUrlRequest getUrlRequest, URI endpoint) {
        OperationInfo operationInfo = OperationInfo.builder().requestUri("/{Key+}").httpMethod(SdkHttpMethod.HEAD).build();
        SdkHttpFullRequest.Builder builder = ProtocolUtils.createSdkHttpRequest((OperationInfo)operationInfo, (URI)endpoint);
        builder.encodedPath(PathMarshaller.NON_GREEDY.marshall(builder.encodedPath(), "Bucket", getUrlRequest.bucket()));
        builder.encodedPath(PathMarshaller.GREEDY.marshall(builder.encodedPath(), "Key", getUrlRequest.key()));
        if (getUrlRequest.versionId() != null) {
            builder.appendRawQueryParameter("versionId", getUrlRequest.versionId());
        }
        return builder.build();
    }

    private ExecutionAttributes createExecutionAttributes(URI clientEndpoint, Region region, boolean isEndpointOverridden) {
        ExecutionAttributes executionAttributes = new ExecutionAttributes().putAttribute(AwsExecutionAttribute.AWS_REGION, (Object)region).putAttribute(SdkExecutionAttribute.CLIENT_TYPE, (Object)ClientType.SYNC).putAttribute(SdkExecutionAttribute.SERVICE_NAME, (Object)SERVICE_NAME).putAttribute(SdkExecutionAttribute.OPERATION_NAME, (Object)"GetObject").putAttribute(SdkExecutionAttribute.SERVICE_CONFIG, (Object)this.s3Configuration).putAttribute(AwsExecutionAttribute.FIPS_ENDPOINT_ENABLED, (Object)this.fipsEnabled).putAttribute(AwsExecutionAttribute.DUALSTACK_ENDPOINT_ENABLED, (Object)this.s3Configuration.dualstackEnabled()).putAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER, (Object)S3EndpointProvider.defaultProvider()).putAttribute(SdkInternalExecutionAttribute.CLIENT_CONTEXT_PARAMS, (Object)this.createClientContextParams()).putAttribute(SdkExecutionAttribute.CLIENT_ENDPOINT, (Object)clientEndpoint).putAttribute(AwsExecutionAttribute.USE_GLOBAL_ENDPOINT, (Object)this.useGlobalEndpointResolver.resolve(region));
        if (isEndpointOverridden) {
            executionAttributes.putAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN, (Object)true);
        }
        return executionAttributes;
    }

    private AttributeMap createClientContextParams() {
        AttributeMap.Builder params = AttributeMap.builder();
        params.put(S3ClientContextParams.USE_ARN_REGION, (Object)this.s3Configuration.useArnRegionEnabled());
        params.put(S3ClientContextParams.DISABLE_MULTI_REGION_ACCESS_POINTS, (Object)(!this.s3Configuration.multiRegionEnabled() ? 1 : 0));
        params.put(S3ClientContextParams.FORCE_PATH_STYLE, (Object)this.s3Configuration.pathStyleAccessEnabled());
        params.put(S3ClientContextParams.ACCELERATE, (Object)this.s3Configuration.accelerateModeEnabled());
        return params.build();
    }

    private InterceptorContext runInterceptors(InterceptorContext context, ExecutionAttributes executionAttributes) {
        context = this.interceptorChain.modifyRequest(context, executionAttributes);
        return this.interceptorChain.modifyHttpRequestAndHttpContent(context, executionAttributes);
    }

    private ExecutionInterceptorChain createEndpointInterceptorChain() {
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(new S3ResolveEndpointInterceptor());
        interceptors.add(new S3RequestSetEndpointInterceptor());
        return new ExecutionInterceptorChain(interceptors);
    }

    private UseGlobalEndpointResolver createUseGlobalEndpointResolver() {
        String standardOption = (String)DefaultsModeConfiguration.defaultConfig((DefaultsMode)DefaultsMode.LEGACY).get((AttributeMap.Key)ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT);
        SdkClientConfiguration config = SdkClientConfiguration.builder().option((ClientOption)ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, (Object)standardOption).option((ClientOption)SdkClientOption.PROFILE_FILE, (Object)this.profileFile.get()).option((ClientOption)SdkClientOption.PROFILE_NAME, (Object)this.profileName).build();
        return new UseGlobalEndpointResolver(config);
    }

    public static final class Builder {
        private Region region;
        private URI endpoint;
        private S3Configuration s3Configuration;
        private ProfileFile profileFile;
        private String profileName;
        private Boolean dualstackEnabled;
        private Boolean fipsEnabled;

        private Builder() {
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder endpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder dualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled = dualstackEnabled;
            return this;
        }

        public Builder fipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        public Builder s3Configuration(S3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        private Builder profileFile(ProfileFile profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        private Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public S3Utilities build() {
            return new S3Utilities(this);
        }
    }
}

