/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventnotifications.s3.model;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.eventnotifications.s3.model.S3Bucket;
import software.amazon.awssdk.eventnotifications.s3.model.S3Object;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public class S3 {
    private final String configurationId;
    private final S3Bucket bucket;
    private final S3Object object;
    private final String s3SchemaVersion;

    public S3(String configurationId, S3Bucket bucket, S3Object object, String s3SchemaVersion) {
        this.configurationId = configurationId;
        this.bucket = bucket;
        this.object = object;
        this.s3SchemaVersion = s3SchemaVersion;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public S3Bucket getBucket() {
        return this.bucket;
    }

    public S3Object getObject() {
        return this.object;
    }

    public String getS3SchemaVersion() {
        return this.s3SchemaVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3 s3 = (S3)o;
        if (!Objects.equals(this.configurationId, s3.configurationId)) {
            return false;
        }
        if (!Objects.equals(this.bucket, s3.bucket)) {
            return false;
        }
        if (!Objects.equals(this.object, s3.object)) {
            return false;
        }
        return Objects.equals(this.s3SchemaVersion, s3.s3SchemaVersion);
    }

    public int hashCode() {
        int result = this.configurationId != null ? this.configurationId.hashCode() : 0;
        result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        result = 31 * result + (this.s3SchemaVersion != null ? this.s3SchemaVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"S3").add("configurationId", (Object)this.configurationId).add("bucket", (Object)this.bucket).add("object", (Object)this.object).add("s3SchemaVersion", (Object)this.s3SchemaVersion).build();
    }
}

