/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventnotifications.s3.model;

import java.time.Instant;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.eventnotifications.s3.model.GlacierEventData;
import software.amazon.awssdk.eventnotifications.s3.model.IntelligentTieringEventData;
import software.amazon.awssdk.eventnotifications.s3.model.LifecycleEventData;
import software.amazon.awssdk.eventnotifications.s3.model.ReplicationEventData;
import software.amazon.awssdk.eventnotifications.s3.model.RequestParameters;
import software.amazon.awssdk.eventnotifications.s3.model.ResponseElements;
import software.amazon.awssdk.eventnotifications.s3.model.S3;
import software.amazon.awssdk.eventnotifications.s3.model.UserIdentity;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public class S3EventNotificationRecord {
    private String awsRegion;
    private String eventName;
    private String eventSource;
    private String eventVersion;
    private RequestParameters requestParameters;
    private ResponseElements responseElements;
    private S3 s3;
    private UserIdentity userIdentity;
    private GlacierEventData glacierEventData;
    private LifecycleEventData lifecycleEventData;
    private IntelligentTieringEventData intelligentTieringEventData;
    private ReplicationEventData replicationEventData;
    private Instant eventTime;

    public S3EventNotificationRecord() {
    }

    @SdkTestInternalApi
    S3EventNotificationRecord(String awsRegion, String eventName, String eventSource, String eventTime, String eventVersion, RequestParameters requestParameters, ResponseElements responseElements, S3 s3, UserIdentity userIdentity) {
        this(awsRegion, eventName, eventSource, eventTime, eventVersion, requestParameters, responseElements, s3, userIdentity, null, null, null, null);
    }

    @SdkTestInternalApi
    S3EventNotificationRecord(String awsRegion, String eventName, String eventSource, String eventTime, String eventVersion, RequestParameters requestParameters, ResponseElements responseElements, S3 s3, UserIdentity userIdentity, GlacierEventData glacierEventData, LifecycleEventData lifecycleEventData, IntelligentTieringEventData intelligentTieringEventData, ReplicationEventData replicationEventData) {
        this.awsRegion = awsRegion;
        this.eventName = eventName;
        this.eventSource = eventSource;
        this.eventTime = eventName != null ? Instant.parse(eventTime) : null;
        this.eventVersion = eventVersion;
        this.requestParameters = requestParameters;
        this.responseElements = responseElements;
        this.s3 = s3;
        this.userIdentity = userIdentity;
        this.glacierEventData = glacierEventData;
        this.lifecycleEventData = lifecycleEventData;
        this.intelligentTieringEventData = intelligentTieringEventData;
        this.replicationEventData = replicationEventData;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public Instant getEventTime() {
        return this.eventTime;
    }

    public String getEventVersion() {
        return this.eventVersion;
    }

    public RequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public ResponseElements getResponseElements() {
        return this.responseElements;
    }

    public S3 getS3() {
        return this.s3;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public GlacierEventData getGlacierEventData() {
        return this.glacierEventData;
    }

    public LifecycleEventData getLifecycleEventData() {
        return this.lifecycleEventData;
    }

    public IntelligentTieringEventData getIntelligentTieringEventData() {
        return this.intelligentTieringEventData;
    }

    public ReplicationEventData getReplicationEventData() {
        return this.replicationEventData;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public void setEventVersion(String eventVersion) {
        this.eventVersion = eventVersion;
    }

    public void setRequestParameters(RequestParameters requestParameters) {
        this.requestParameters = requestParameters;
    }

    public void setResponseElements(ResponseElements responseElements) {
        this.responseElements = responseElements;
    }

    public void setS3(S3 s3) {
        this.s3 = s3;
    }

    public void setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public void setGlacierEventData(GlacierEventData glacierEventData) {
        this.glacierEventData = glacierEventData;
    }

    public void setLifecycleEventData(LifecycleEventData lifecycleEventData) {
        this.lifecycleEventData = lifecycleEventData;
    }

    public void setIntelligentTieringEventData(IntelligentTieringEventData intelligentTieringEventData) {
        this.intelligentTieringEventData = intelligentTieringEventData;
    }

    public void setReplicationEventData(ReplicationEventData replicationEventData) {
        this.replicationEventData = replicationEventData;
    }

    public void setEventTime(Instant eventTime) {
        this.eventTime = eventTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3EventNotificationRecord that = (S3EventNotificationRecord)o;
        if (!Objects.equals(this.awsRegion, that.awsRegion)) {
            return false;
        }
        if (!Objects.equals(this.eventName, that.eventName)) {
            return false;
        }
        if (!Objects.equals(this.eventSource, that.eventSource)) {
            return false;
        }
        if (!Objects.equals(this.eventVersion, that.eventVersion)) {
            return false;
        }
        if (!Objects.equals(this.requestParameters, that.requestParameters)) {
            return false;
        }
        if (!Objects.equals(this.responseElements, that.responseElements)) {
            return false;
        }
        if (!Objects.equals(this.s3, that.s3)) {
            return false;
        }
        if (!Objects.equals(this.userIdentity, that.userIdentity)) {
            return false;
        }
        if (!Objects.equals(this.glacierEventData, that.glacierEventData)) {
            return false;
        }
        if (!Objects.equals(this.lifecycleEventData, that.lifecycleEventData)) {
            return false;
        }
        if (!Objects.equals(this.intelligentTieringEventData, that.intelligentTieringEventData)) {
            return false;
        }
        if (!Objects.equals(this.replicationEventData, that.replicationEventData)) {
            return false;
        }
        return Objects.equals(this.eventTime, that.eventTime);
    }

    public int hashCode() {
        int result = this.awsRegion != null ? this.awsRegion.hashCode() : 0;
        result = 31 * result + (this.eventName != null ? this.eventName.hashCode() : 0);
        result = 31 * result + (this.eventSource != null ? this.eventSource.hashCode() : 0);
        result = 31 * result + (this.eventVersion != null ? this.eventVersion.hashCode() : 0);
        result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
        result = 31 * result + (this.responseElements != null ? this.responseElements.hashCode() : 0);
        result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
        result = 31 * result + (this.userIdentity != null ? this.userIdentity.hashCode() : 0);
        result = 31 * result + (this.glacierEventData != null ? this.glacierEventData.hashCode() : 0);
        result = 31 * result + (this.lifecycleEventData != null ? this.lifecycleEventData.hashCode() : 0);
        result = 31 * result + (this.intelligentTieringEventData != null ? this.intelligentTieringEventData.hashCode() : 0);
        result = 31 * result + (this.replicationEventData != null ? this.replicationEventData.hashCode() : 0);
        result = 31 * result + (this.eventTime != null ? this.eventTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"S3EventNotificationRecord").add("awsRegion", (Object)this.awsRegion).add("eventName", (Object)this.eventName).add("eventSource", (Object)this.eventSource).add("eventVersion", (Object)this.eventVersion).add("requestParameters", (Object)this.requestParameters).add("responseElements", (Object)this.responseElements).add("s3", (Object)this.s3).add("userIdentity", (Object)this.userIdentity).add("glacierEventData", (Object)this.glacierEventData).add("lifecycleEventData", (Object)this.lifecycleEventData).add("intelligentTieringEventData", (Object)this.intelligentTieringEventData).add("replicationEventData", (Object)this.replicationEventData).add("eventTime", (Object)this.eventTime).build();
    }
}

