/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rum.RumAsyncClient;
import software.amazon.awssdk.services.rum.internal.UserAgentUtils;
import software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest;
import software.amazon.awssdk.services.rum.model.GetAppMonitorDataResponse;

public class GetAppMonitorDataPublisher
implements SdkPublisher<GetAppMonitorDataResponse> {
    private final RumAsyncClient client;
    private final GetAppMonitorDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAppMonitorDataPublisher(RumAsyncClient client, GetAppMonitorDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAppMonitorDataPublisher(RumAsyncClient client, GetAppMonitorDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAppMonitorDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAppMonitorDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> events() {
        Function<GetAppMonitorDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAppMonitorDataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAppMonitorDataResponseFetcher
    implements AsyncPageFetcher<GetAppMonitorDataResponse> {
        private GetAppMonitorDataResponseFetcher() {
        }

        public boolean hasNextPage(GetAppMonitorDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAppMonitorDataResponse> nextPage(GetAppMonitorDataResponse previousPage) {
            if (previousPage == null) {
                return GetAppMonitorDataPublisher.this.client.getAppMonitorData(GetAppMonitorDataPublisher.this.firstRequest);
            }
            return GetAppMonitorDataPublisher.this.client.getAppMonitorData((GetAppMonitorDataRequest)((Object)GetAppMonitorDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

